/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.ogcapi;

import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.wicket.util.string.Strings;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.PublishedInfo;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.config.GeoServer;
import org.geoserver.config.ServiceInfo;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.platform.Service;
import org.geoserver.util.InternationalStringUtils;
import org.geoserver.web.ServiceDescription;
import org.geoserver.web.ServiceDescriptionProvider;
import org.geoserver.web.ServiceLinkDescription;
import org.geotools.api.util.InternationalString;
import org.geotools.util.GrowableInternationalString;
import org.springframework.web.util.UriUtils;

public class OgcApiServiceDescriptionProvider<SERVICEINFOTYPE extends ServiceInfo, SERVICETYPE>
extends ServiceDescriptionProvider {
    String specificServiceType;
    String serviceName;
    Class<SERVICEINFOTYPE> infoClass;
    Class<SERVICETYPE> serviceClass;
    GeoServer geoserver;
    Catalog catalog;

    public OgcApiServiceDescriptionProvider(GeoServer gs, String serviceType, String serviceName, String specificServiceType) {
        super(serviceType);
        Class serviceClass;
        Class infoClass;
        this.geoserver = gs;
        this.catalog = gs.getCatalog();
        this.serviceName = serviceName;
        this.specificServiceType = specificServiceType;
        this.infoClass = infoClass = (Class)((ParameterizedType)((Object)((Object)this)).getClass().getGenericSuperclass()).getActualTypeArguments()[0];
        this.serviceClass = serviceClass = (Class)((ParameterizedType)((Object)((Object)this)).getClass().getGenericSuperclass()).getActualTypeArguments()[1];
    }

    public List<String> getServiceTypes() {
        return Collections.unmodifiableList(Arrays.asList(this.serviceType, this.specificServiceType));
    }

    protected SERVICEINFOTYPE info(WorkspaceInfo workspaceInfo, PublishedInfo layerInfo) {
        ServiceInfo info = null;
        if (workspaceInfo != null) {
            info = this.geoserver.getService(workspaceInfo, this.infoClass);
        }
        if (info == null) {
            info = this.geoserver.getService(this.infoClass);
        }
        return (SERVICEINFOTYPE)info;
    }

    public List<ServiceDescription> getServices(WorkspaceInfo workspaceInfo, PublishedInfo layerInfo) {
        ArrayList<ServiceDescription> descriptions = new ArrayList<ServiceDescription>();
        SERVICEINFOTYPE info = this.info(workspaceInfo, layerInfo);
        if (info != null) {
            if (workspaceInfo != null || this.geoserver.getGlobal().isGlobalServices().booleanValue()) {
                descriptions.add(this.description(this.serviceType, (ServiceInfo)info, workspaceInfo, layerInfo));
            }
        } else {
            return descriptions;
        }
        return descriptions;
    }

    protected ServiceDescription description(String serviceType, ServiceInfo info, WorkspaceInfo workspaceInfo, PublishedInfo layerInfo) {
        boolean available = this.isAvailable(serviceType, info, layerInfo);
        GrowableInternationalString title = InternationalStringUtils.growable((InternationalString)info.getInternationalTitle(), (String)(Strings.isEmpty((String)info.getTitle()) ? info.getName() : info.getTitle()));
        GrowableInternationalString description = InternationalStringUtils.growable((InternationalString)info.getInternationalAbstract(), (String)(Strings.isEmpty((String)info.getAbstract()) ? null : info.getAbstract()));
        ServiceDescription serviceDesc = new ServiceDescription(serviceType, (InternationalString)title, (InternationalString)description, available, false, workspaceInfo != null ? workspaceInfo.getName() : null, layerInfo != null ? layerInfo.getName() : null);
        serviceDesc.setDescriptionPriority(10.0);
        return serviceDesc;
    }

    public List<ServiceLinkDescription> getServiceLinks(WorkspaceInfo workspaceInfo, PublishedInfo layerInfo) {
        ArrayList<ServiceLinkDescription> links = new ArrayList<ServiceLinkDescription>();
        if (workspaceInfo == null && !this.geoserver.getGlobal().isGlobalServices().booleanValue()) {
            return links;
        }
        List extensions = GeoServerExtensions.extensions(Service.class);
        for (Service service : extensions) {
            if (service.getService().getClass() != this.serviceClass) continue;
            String link = null;
            if (service.getCustomCapabilitiesLink() != null) {
                link = this.ogcApiCustomCapabilitiesLinkMangler(service.getCustomCapabilitiesLink(), workspaceInfo, layerInfo);
            }
            if (link == null) continue;
            links.add(new ServiceLinkDescription(this.serviceType, service.getVersion(), link, workspaceInfo != null ? workspaceInfo.getName() : null, layerInfo != null ? layerInfo.getName() : null, this.serviceName, this.specificServiceType));
        }
        return links;
    }

    public String ogcApiCustomCapabilitiesLinkMangler(String customLink, WorkspaceInfo workspaceInfo, PublishedInfo layerInfo) {
        if (workspaceInfo == null) {
            return customLink;
        }
        String wsName = UriUtils.encodePath((String)workspaceInfo.getName(), (String)"UTF-8");
        customLink = customLink.replace("/ogc/", "/" + wsName + "/ogc/");
        if (layerInfo != null) {
            String layerName = UriUtils.encodePath((String)layerInfo.getName(), (String)"UTF-8");
            customLink = customLink.replace("/ogc/", "/" + layerName + "/ogc/");
        }
        return customLink;
    }

    public String getServiceType() {
        return this.serviceType;
    }

    public String getSpecificServiceType() {
        return this.specificServiceType;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public Class<SERVICEINFOTYPE> getInfoClass() {
        return this.infoClass;
    }

    public Class<SERVICETYPE> getServiceClass() {
        return this.serviceClass;
    }
}

