/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wps.web;

import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.Session;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.panel.Fragment;
import org.apache.wicket.model.IModel;
import org.geoserver.web.GeoServerApplication;
import org.geoserver.web.GeoServerSecuredPage;
import org.geoserver.web.wicket.GeoServerDataProvider;
import org.geoserver.web.wicket.GeoServerDialog;
import org.geoserver.web.wicket.GeoServerTablePanel;
import org.geoserver.web.wicket.ParamResourceModel;
import org.geoserver.wps.executor.ExecutionStatus;
import org.geoserver.wps.executor.WPSExecutionManager;
import org.geoserver.wps.web.ProcessStatusProvider;

public class ProcessStatusPage
extends GeoServerSecuredPage {
    private GeoServerTablePanel<ExecutionStatus> table;
    private AjaxLink<Void> dismissSelected;
    private GeoServerDialog dialog;

    public ProcessStatusPage() {
        ProcessStatusProvider provider = new ProcessStatusProvider();
        this.table = new GeoServerTablePanel<ExecutionStatus>("table", (GeoServerDataProvider)provider, true){

            protected Component getComponentForProperty(String id, IModel<ExecutionStatus> itemModel, GeoServerDataProvider.Property<ExecutionStatus> property) {
                Object value = property.getPropertyValue((Object)((ExecutionStatus)itemModel.getObject()));
                if (value instanceof Date) {
                    SimpleDateFormat gmtFrmt = new SimpleDateFormat("E, d MMM yyyy HH:mm:ss.SSS 'GMT'", Session.get().getLocale());
                    gmtFrmt.setTimeZone(TimeZone.getTimeZone("GMT"));
                    return new Label(id, (Serializable)((Object)gmtFrmt.format((Date)value)));
                }
                return null;
            }

            protected void onSelectionUpdate(AjaxRequestTarget target) {
                ProcessStatusPage.this.dismissSelected.setEnabled(!ProcessStatusPage.this.table.getSelection().isEmpty());
                target.add(new Component[]{ProcessStatusPage.this.dismissSelected});
            }
        };
        this.table.setOutputMarkupId(true);
        this.table.setSelectable(true);
        this.add(new Component[]{this.table});
        Component[] componentArray = new Component[1];
        this.dialog = new GeoServerDialog("dialog");
        componentArray[0] = this.dialog;
        this.add(componentArray);
        this.setHeaderPanel(this.headerPanel());
    }

    protected Component headerPanel() {
        Fragment header = new Fragment("headerPanel", "header", (MarkupContainer)this);
        Component[] componentArray = new Component[1];
        this.dismissSelected = new ProcessDismissLink("dismissSelected");
        componentArray[0] = this.dismissSelected;
        header.add(componentArray);
        this.dismissSelected.setOutputMarkupId(true);
        this.dismissSelected.setEnabled(false);
        return header;
    }

    protected final class ProcessDismissLink
    extends AjaxLink<Void> {
        protected ProcessDismissLink(String id) {
            super(id);
        }

        public void onClick(AjaxRequestTarget target) {
            final List selection = ProcessStatusPage.this.table.getSelection();
            if (selection.isEmpty()) {
                return;
            }
            ProcessStatusPage.this.dialog.setTitle((IModel)new ParamResourceModel("confirmDismissal", (Component)this, new Object[0]));
            ProcessStatusPage.this.dialog.showOkCancel(target, new GeoServerDialog.DialogDelegate(){

                protected Component getContents(String id) {
                    return new Label(id, (IModel)new ParamResourceModel("confirmDismissProcesses", (Component)ProcessStatusPage.this, new Object[0]));
                }

                protected boolean onSubmit(AjaxRequestTarget target, Component contents) {
                    WPSExecutionManager executor = (WPSExecutionManager)GeoServerApplication.get().getBeanOfType(WPSExecutionManager.class);
                    for (ExecutionStatus status : selection) {
                        try {
                            executor.cancel(status.getExecutionId());
                        }
                        catch (Exception e) {
                            LOGGER.severe("Failed to cancel process: " + status.getExecutionId());
                            ProcessDismissLink.this.error((Serializable)((Object)("Failed to cancel process: " + status.getExecutionId() + " with error: " + e.getMessage())));
                        }
                    }
                    return true;
                }

                public void onClose(AjaxRequestTarget target) {
                    if (ProcessStatusPage.this.table.getSelection().isEmpty()) {
                        ProcessDismissLink.this.setEnabled(false);
                    }
                    target.add(new Component[]{ProcessDismissLink.this});
                    target.add(new Component[]{ProcessStatusPage.this.table});
                }
            });
        }
    }
}

