/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wps.web;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import org.apache.wicket.extensions.markup.html.repeater.util.SortParam;
import org.geoserver.catalog.Predicates;
import org.geoserver.web.GeoServerApplication;
import org.geoserver.web.wicket.GeoServerDataProvider;
import org.geoserver.wps.ProcessStatusStore;
import org.geoserver.wps.executor.ExecutionStatus;
import org.geoserver.wps.executor.ProcessStatusTracker;
import org.geotools.api.data.Query;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.FilterFactory;
import org.geotools.api.filter.IncludeFilter;
import org.geotools.api.filter.PropertyIsLike;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.filter.sort.SortBy;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.util.logging.Logging;

public class ProcessStatusProvider
extends GeoServerDataProvider<ExecutionStatus> {
    private static Logger LOGGER = Logging.getLogger(ProcessStatusProvider.class);
    private static final FilterFactory FF = CommonFactoryFinder.getFilterFactory();
    static final GeoServerDataProvider.Property<ExecutionStatus> TYPE = new GeoServerDataProvider.AbstractProperty<ExecutionStatus>("type"){

        public Object getPropertyValue(ExecutionStatus item) {
            return item.isAsynchronous() ? "A" : "S";
        }

        public boolean isSearchable() {
            return false;
        }
    };
    static final GeoServerDataProvider.Property<ExecutionStatus> NODE = new GeoServerDataProvider.BeanProperty("node", "nodeId");
    static final GeoServerDataProvider.Property<ExecutionStatus> USER = new GeoServerDataProvider.BeanProperty("user", "userName");
    static final GeoServerDataProvider.Property<ExecutionStatus> PROCESS = new GeoServerDataProvider.BeanProperty("processName", "processName");
    static final GeoServerDataProvider.Property<ExecutionStatus> CREATED = new GeoServerDataProvider.BeanProperty("creationTime", "creationTime");
    static final GeoServerDataProvider.Property<ExecutionStatus> PHASE = new GeoServerDataProvider.BeanProperty("phase", "phase");
    static final GeoServerDataProvider.Property<ExecutionStatus> PROGRESS = new GeoServerDataProvider.BeanProperty("progress", "progress");
    static final GeoServerDataProvider.Property<ExecutionStatus> EXPIRATION = new GeoServerDataProvider.BeanProperty("expirationDate", "expirationDate");
    static final GeoServerDataProvider.Property<ExecutionStatus> COMPLETION = new GeoServerDataProvider.BeanProperty("estimatedCompletion", "estimatedCompletion");
    static final GeoServerDataProvider.Property<ExecutionStatus> NEXT_POLL = new GeoServerDataProvider.BeanProperty("nextPoll", "nextPoll");
    static final GeoServerDataProvider.Property<ExecutionStatus> TASK = new GeoServerDataProvider.BeanProperty("task", "task");
    static final List<GeoServerDataProvider.Property<ExecutionStatus>> PROPERTIES = Arrays.asList(TYPE, NODE, USER, PROCESS, CREATED, PHASE, PROGRESS, EXPIRATION, COMPLETION, NEXT_POLL, TASK);
    private long first;
    private long count;

    protected List<ExecutionStatus> getItems() {
        ProcessStatusTracker tracker = (ProcessStatusTracker)GeoServerApplication.get().getBeanOfType(ProcessStatusTracker.class);
        return tracker.getStore().list(Query.ALL);
    }

    protected List<GeoServerDataProvider.Property<ExecutionStatus>> getProperties() {
        return PROPERTIES;
    }

    protected Filter getFilter() {
        String[] keywords = this.getKeywords();
        Filter filter = Predicates.acceptAll();
        if (null != keywords) {
            Filter propContains = this.getFullSearch(keywords);
            filter = Filter.INCLUDE == filter ? propContains : Predicates.or((Filter)filter, (Filter)propContains);
        }
        return filter;
    }

    private Filter getFullSearch(String[] keywords) {
        ProcessStatusTracker tracker = (ProcessStatusTracker)GeoServerApplication.get().getBeanOfType(ProcessStatusTracker.class);
        ProcessStatusStore store = tracker.getStore();
        IncludeFilter ret = Filter.INCLUDE;
        if (store.supportsPredicate()) {
            for (String keyword : keywords) {
                Filter propContains = Predicates.fullTextSearch((String)keyword);
                ret = Filter.INCLUDE == ret ? propContains : Predicates.or((Filter)ret, (Filter)propContains);
            }
        } else if (keywords.length > 0) {
            ArrayList<PropertyIsLike> likes = new ArrayList<PropertyIsLike>();
            for (String word : keywords) {
                for (GeoServerDataProvider.Property<ExecutionStatus> prop : this.getProperties()) {
                    if (!prop.isSearchable() || !prop.equals(NODE) && !prop.equals(PHASE) && !prop.equals(TASK) && !prop.equals(USER) && !prop.equals(PROCESS)) continue;
                    likes.add(FF.like((Expression)FF.property(prop.getName()), "*" + word + "*"));
                }
            }
            ret = FF.or(likes);
        }
        return ret;
    }

    protected List<ExecutionStatus> getFilteredItems() {
        GeoServerDataProvider.Property property;
        ProcessStatusTracker tracker = (ProcessStatusTracker)GeoServerApplication.get().getBeanOfType(ProcessStatusTracker.class);
        ProcessStatusStore store = tracker.getStore();
        Query query = new Query("status", this.getFilter());
        if (this.count > 0L) {
            query.setStartIndex(Integer.valueOf((int)this.first));
            query.setMaxFeatures((int)this.count);
        }
        SortParam sort = this.getSort();
        SortBy sortOrder = null;
        if (sort != null && (property = this.getProperty(sort)).isSearchable()) {
            String sortProperty = ((GeoServerDataProvider.BeanProperty)property).getPropertyPath();
            sortOrder = Predicates.sortBy((String)sortProperty, (boolean)sort.isAscending());
            query.setSortBy(new SortBy[]{sortOrder});
        }
        LOGGER.fine("built query " + query + " to filter statuses");
        return store.list(query);
    }

    public Iterator<ExecutionStatus> iterator(long first, long count) {
        this.first = first;
        this.count = count;
        Iterator it = super.iterator(first, count);
        this.first = 0L;
        this.count = -1L;
        return it;
    }
}

