/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wps.web;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.extensions.ajax.markup.html.autocomplete.AutoCompleteSettings;
import org.apache.wicket.extensions.ajax.markup.html.autocomplete.IAutoCompleteRenderer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.Button;
import org.apache.wicket.markup.html.form.CheckBox;
import org.apache.wicket.markup.html.form.ChoiceRenderer;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.markup.html.form.RadioChoice;
import org.apache.wicket.markup.html.form.SubmitLink;
import org.apache.wicket.markup.html.form.TextArea;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.markup.html.link.Link;
import org.apache.wicket.markup.html.panel.Fragment;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.model.StringResourceModel;
import org.apache.wicket.request.component.IRequestablePage;
import org.apache.wicket.util.convert.IConverter;
import org.apache.wicket.validation.IValidator;
import org.apache.wicket.validation.validator.RangeValidator;
import org.geoserver.config.ServiceInfo;
import org.geoserver.security.CatalogMode;
import org.geoserver.security.GeoServerRoleService;
import org.geoserver.security.impl.GeoServerRole;
import org.geoserver.security.web.AbstractSecurityPage;
import org.geoserver.web.wicket.GeoServerDataProvider;
import org.geoserver.web.wicket.GeoServerTablePanel;
import org.geoserver.web.wicket.ParamResourceModel;
import org.geoserver.wps.ProcessGroupInfo;
import org.geoserver.wps.WPSInfo;
import org.geoserver.wps.web.ProcessFactoryInfoProvider;
import org.geoserver.wps.web.ProcessSelectionPage;
import org.geoserver.wps.web.RolesAutoCompleteBehavior;
import org.geoserver.wps.web.RolesConverter;
import org.geoserver.wps.web.RolesRenderer;

public class WPSAccessRulePage
extends AbstractSecurityPage {
    static final List<CatalogMode> CATALOG_MODES = Arrays.asList(CatalogMode.HIDE, CatalogMode.MIXED, CatalogMode.CHALLENGE);
    private List<ProcessGroupInfo> processFactories;
    private WPSInfo wpsInfo;
    private RadioChoice catalogModeChoice;
    private List<String> availableRoles = new ArrayList<String>();

    public WPSAccessRulePage() {
        this.wpsInfo = (WPSInfo)this.getGeoServer().getService(WPSInfo.class);
        Form form = new Form("form", (IModel)new CompoundPropertyModel((Object)this.wpsInfo));
        this.processFactories = this.cloneFactoryInfos(this.wpsInfo.getProcessGroups());
        ProcessFactoryInfoProvider provider = new ProcessFactoryInfoProvider(this.processFactories, this.getLocale());
        GeoServerRoleService roleService = this.getSecurityManager().getActiveRoleService();
        try {
            for (GeoServerRole r : roleService.getRoles()) {
                this.availableRoles.add(r.getAuthority());
            }
        }
        catch (IOException e1) {
            LOGGER.log(Level.FINER, e1.getMessage(), e1);
        }
        TextField maxComplexInputSize = new TextField("maxComplexInputSize", Integer.class);
        maxComplexInputSize.add((IValidator)RangeValidator.minimum((Comparable)Integer.valueOf(0)));
        form.add(new Component[]{maxComplexInputSize});
        form.add(new Component[]{new CheckBox("remoteInputDisabled")});
        final AutoCompleteSettings settings = new AutoCompleteSettings();
        settings.setShowCompleteListOnFocusGain(false);
        settings.setShowListOnEmptyInput(true);
        settings.setShowListOnFocusGain(true);
        settings.setMaxHeightInPx(100);
        GeoServerTablePanel<ProcessGroupInfo> processFilterEditor = new GeoServerTablePanel<ProcessGroupInfo>("processFilterTable", (GeoServerDataProvider)provider){

            protected Component getComponentForProperty(String id, final IModel<ProcessGroupInfo> itemModel, GeoServerDataProvider.Property<ProcessGroupInfo> property) {
                if (property.getName().equals("enabled")) {
                    Fragment fragment = new Fragment(id, "enabledFragment", (MarkupContainer)WPSAccessRulePage.this);
                    IModel pm = property.getModel(itemModel);
                    CheckBox enabled = new CheckBox("enabled", pm);
                    enabled.setOutputMarkupId(true);
                    fragment.add(new Component[]{enabled});
                    return fragment;
                }
                if (property.getName().equals("prefix")) {
                    return new Label(id, property.getModel(itemModel));
                }
                if (property.getName().equals("title")) {
                    return new Label(id, property.getModel(itemModel));
                }
                if (property.getName().equals("summary")) {
                    return new Label(id, property.getModel(itemModel));
                }
                if (property.getName().equals("roles")) {
                    Fragment fragment = new Fragment(id, "rolesFragment", (MarkupContainer)WPSAccessRulePage.this);
                    IModel pm = property.getModel(itemModel);
                    TextArea<String> roles = new TextArea<String>("roles", pm){

                        public <C> IConverter<C> getConverter(Class<C> type) {
                            return new RolesConverter(WPSAccessRulePage.this.availableRoles);
                        }
                    };
                    StringBuilder selectedRoles = new StringBuilder();
                    RolesRenderer roleRenderer = new RolesRenderer(selectedRoles);
                    RolesAutoCompleteBehavior b = new RolesAutoCompleteBehavior((IAutoCompleteRenderer<String>)roleRenderer, settings, selectedRoles, WPSAccessRulePage.this.availableRoles);
                    roles.setOutputMarkupId(true);
                    roles.add(new Behavior[]{b});
                    fragment.add(new Component[]{roles});
                    return fragment;
                }
                if (property.getName().equals("edit")) {
                    Fragment fragment = new Fragment(id, "linkFragment", (MarkupContainer)WPSAccessRulePage.this);
                    Link<Object> link = new Link<Object>("link"){

                        public void onClick() {
                            ProcessGroupInfo pfi = (ProcessGroupInfo)itemModel.getObject();
                            this.setResponsePage((IRequestablePage)new ProcessSelectionPage(WPSAccessRulePage.this, pfi));
                        }
                    };
                    fragment.add(new Component[]{link});
                    return fragment;
                }
                return null;
            }
        };
        processFilterEditor.setFilterable(false);
        processFilterEditor.setPageable(false);
        processFilterEditor.setOutputMarkupId(true);
        form.add(new Component[]{processFilterEditor});
        form.add(new Component[]{new AjaxLink<Object>("processAccessModeHelp"){

            public void onClick(AjaxRequestTarget target) {
                WPSAccessRulePage.this.dialog.showInfo(target, (IModel)new StringResourceModel("processAccessModeHelp.title", (Component)this.getPage(), null), new IModel[]{new StringResourceModel("processAccessModeHelp.message", (Component)this.getPage(), null)});
            }
        }});
        this.catalogModeChoice = new RadioChoice("processAccessMode", (IModel)new PropertyModel((Object)this.wpsInfo, "catalogMode"), CATALOG_MODES, (IChoiceRenderer)new CatalogModeRenderer());
        this.catalogModeChoice.setSuffix(" ");
        form.add(new Component[]{this.catalogModeChoice});
        SubmitLink submit = new SubmitLink("submit", (IModel)new StringResourceModel("save", null, null)){

            public void onSubmit() {
                WPSAccessRulePage.this.saveProcessFactories(true);
            }
        };
        form.add(new Component[]{submit});
        Button apply = new Button("apply"){

            public void onSubmit() {
                WPSAccessRulePage.this.saveProcessFactories(false);
            }
        };
        form.add(new Component[]{apply});
        Button cancel = new Button("cancel"){

            public void onSubmit() {
                WPSAccessRulePage.this.doReturn();
            }
        };
        form.add(new Component[]{cancel});
        this.add(new Component[]{form});
    }

    private void saveProcessFactories(boolean doReturn) {
        try {
            List factories = this.wpsInfo.getProcessGroups();
            factories.clear();
            factories.addAll(this.processFactories);
            this.getGeoServer().save((ServiceInfo)this.wpsInfo);
            if (doReturn) {
                this.doReturn();
            }
        }
        catch (Exception e) {
            this.error(e);
        }
    }

    private List<ProcessGroupInfo> cloneFactoryInfos(List<ProcessGroupInfo> processFactories) {
        ArrayList<ProcessGroupInfo> result = new ArrayList<ProcessGroupInfo>();
        for (ProcessGroupInfo pfi : processFactories) {
            result.add(pfi.clone());
        }
        return result;
    }

    class CatalogModeRenderer
    extends ChoiceRenderer<CatalogMode> {
        CatalogModeRenderer() {
        }

        public Object getDisplayValue(CatalogMode object) {
            return new ParamResourceModel(object.name(), (Component)WPSAccessRulePage.this.getPage(), new Object[0]).getObject();
        }

        public String getIdValue(CatalogMode object, int index) {
            return object.name();
        }
    }
}

