/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wps.web;

import org.apache.wicket.Page;
import org.apache.wicket.markup.html.form.CheckBox;
import org.apache.wicket.util.tester.FormTester;
import org.geoserver.web.wicket.GeoServerTablePanel;
import org.geoserver.wps.ProcessGroupInfo;
import org.geoserver.wps.WPSInfo;
import org.geoserver.wps.web.ProcessFactoryInfoProvider;
import org.geoserver.wps.web.ProcessSelectionPage;
import org.geoserver.wps.web.WPSAccessRulePage;
import org.geoserver.wps.web.WPSPagesTestSupport;
import org.junit.Assert;
import org.junit.Test;

public class WPSAccessRulePageTest
extends WPSPagesTestSupport {
    @Test
    public void testGroupToWpsLink() throws Exception {
        this.login();
        tester.startPage((Page)new WPSAccessRulePage());
        tester.assertRenderedPage(WPSAccessRulePage.class);
        tester.clickLink("form:processFilterTable:listContainer:items:1:itemProperties:5:component:link", false);
        tester.assertRenderedPage(ProcessSelectionPage.class);
    }

    @Test
    public void testDisableWps() throws Exception {
        this.login();
        tester.startPage((Page)new WPSAccessRulePage());
        tester.assertRenderedPage(WPSAccessRulePage.class);
        tester.clickLink("form:processFilterTable:listContainer:items:1:itemProperties:5:component:link", false);
        FormTester ft = tester.newFormTester("form");
        ft.setValue("selectionTable:listContainer:items:1:itemProperties:0:component:enabled", "false");
        ft.submit("apply");
        GeoServerTablePanel processFilterTable = (GeoServerTablePanel)tester.getComponentFromLastRenderedPage("form:processFilterTable");
        ProcessFactoryInfoProvider dp = (ProcessFactoryInfoProvider)processFilterTable.getDataProvider();
        Assert.assertEquals((long)((ProcessGroupInfo)dp.getItems().get(0)).getFilteredProcesses().size(), (long)1L);
    }

    @Test
    public void testCheckGroup() throws Exception {
        this.login();
        tester.startPage((Page)new WPSAccessRulePage());
        tester.assertRenderedPage(WPSAccessRulePage.class);
        tester.assertComponent("form:processFilterTable", GeoServerTablePanel.class);
        GeoServerTablePanel processFilterTable = (GeoServerTablePanel)tester.getComponentFromLastRenderedPage("form:processFilterTable");
        ProcessFactoryInfoProvider dp = (ProcessFactoryInfoProvider)processFilterTable.getDataProvider();
        for (ProcessGroupInfo pgi : dp.getItems()) {
            Assert.assertTrue((boolean)pgi.isEnabled());
        }
        FormTester ft = tester.newFormTester("form");
        ft.setValue("processFilterTable:listContainer:items:1:itemProperties:0:component:enabled", "false");
        ft.setValue("processFilterTable:listContainer:items:4:itemProperties:0:component:enabled", "false");
        ft.submit();
        Assert.assertFalse((boolean)((ProcessGroupInfo)dp.getItems().get(0)).isEnabled());
        Assert.assertFalse((boolean)((ProcessGroupInfo)dp.getItems().get(3)).isEnabled());
    }

    @Test
    public void testDisableRemoteInputs() throws Exception {
        this.login();
        tester.startPage((Page)new WPSAccessRulePage());
        tester.assertRenderedPage(WPSAccessRulePage.class);
        tester.assertComponent("form:remoteInputDisabled", CheckBox.class);
        FormTester ft1 = tester.newFormTester("form");
        ft1.setValue("remoteInputDisabled", "false");
        ft1.submit("apply");
        Assert.assertFalse((boolean)((WPSInfo)this.getGeoServer().getService(WPSInfo.class)).isRemoteInputDisabled());
        FormTester ft2 = tester.newFormTester("form");
        ft2.setValue("remoteInputDisabled", "true");
        ft2.submit("apply");
        Assert.assertTrue((boolean)((WPSInfo)this.getGeoServer().getService(WPSInfo.class)).isRemoteInputDisabled());
    }
}

