/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wps.web;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.PropertyModel;
import org.geoserver.web.wicket.GeoServerDataProvider;
import org.geoserver.wps.ProcessGroupInfo;
import org.geoserver.wps.ProcessInfo;
import org.geoserver.wps.ProcessInfoImpl;
import org.geoserver.wps.process.GeoServerProcessors;
import org.geoserver.wps.validator.WPSInputValidator;
import org.geotools.api.feature.type.Name;
import org.geotools.api.util.InternationalString;
import org.geotools.process.ProcessFactory;

public class FilteredProcessesProvider
extends GeoServerDataProvider<FilteredProcess> {
    private List<FilteredProcess> selectableProcesses;

    public FilteredProcessesProvider(ProcessGroupInfo pfi, Locale locale) {
        ProcessFactory pf = GeoServerProcessors.getProcessFactory((Class)pfi.getFactoryClass(), (boolean)false);
        Set names = pf.getNames();
        this.selectableProcesses = new ArrayList<FilteredProcess>();
        List filteredProcesses = pfi.getFilteredProcesses();
        for (Name name : names) {
            InternationalString description = GeoServerProcessors.getProcessFactory((Class)pfi.getFactoryClass(), (boolean)false).getDescription(name);
            String des = "";
            if (description != null) {
                des = description.toString(locale);
            }
            FilteredProcess sp = new FilteredProcess(name, des);
            sp.setEnabled(true);
            for (ProcessInfo fp : filteredProcesses) {
                if (!sp.getName().equals((Object)fp.getName())) continue;
                sp.setEnabled(fp.isEnabled());
                sp.setRoles(fp.getRoles());
                sp.setValidators((Multimap<String, WPSInputValidator>)fp.getValidators());
            }
            this.selectableProcesses.add(sp);
        }
        Collections.sort(this.selectableProcesses);
    }

    protected List<GeoServerDataProvider.Property<FilteredProcess>> getProperties() {
        ArrayList<GeoServerDataProvider.Property<FilteredProcess>> props = new ArrayList<GeoServerDataProvider.Property<FilteredProcess>>();
        props.add((GeoServerDataProvider.Property<FilteredProcess>)new GeoServerDataProvider.BeanProperty("enabled", "enabled"));
        props.add((GeoServerDataProvider.Property<FilteredProcess>)new GeoServerDataProvider.BeanProperty("name", "name"));
        props.add((GeoServerDataProvider.Property<FilteredProcess>)new GeoServerDataProvider.BeanProperty("description", "description"));
        props.add((GeoServerDataProvider.Property<FilteredProcess>)new GeoServerDataProvider.AbstractProperty<FilteredProcess>("roles"){

            public Object getPropertyValue(FilteredProcess item) {
                return item.getRoles();
            }

            public IModel getModel(IModel itemModel) {
                return new PropertyModel((Object)itemModel, "roles");
            }
        });
        props.add((GeoServerDataProvider.Property<FilteredProcess>)new GeoServerDataProvider.PropertyPlaceholder("edit"));
        props.add((GeoServerDataProvider.Property<FilteredProcess>)new GeoServerDataProvider.BeanProperty("validated", "validated"));
        return props;
    }

    protected List<FilteredProcess> getItems() {
        return this.selectableProcesses;
    }

    static class FilteredProcess
    implements Serializable,
    Comparable<FilteredProcess> {
        private boolean enabled;
        private Name name;
        private String description;
        private List<String> roles;
        private Multimap<String, WPSInputValidator> validators = ArrayListMultimap.create();

        public FilteredProcess(Name name, String description) {
            this.name = name;
            this.description = description;
        }

        public Name getName() {
            return this.name;
        }

        public String getDescription() {
            return this.description;
        }

        public List<String> getRoles() {
            return this.roles;
        }

        public void setRoles(List<String> roles) {
            this.roles = roles;
        }

        public boolean getEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        @Override
        public int compareTo(FilteredProcess other) {
            if (this.name == null) {
                return other.getName() == null ? 0 : -1;
            }
            if (other.getName() == null) {
                return 1;
            }
            return this.name.getURI().compareTo(other.getName().getURI());
        }

        public ProcessInfo toProcessInfo() {
            ProcessInfoImpl pai = new ProcessInfoImpl();
            pai.setName(this.getName());
            pai.setEnabled(Boolean.valueOf(this.getEnabled()));
            if (this.getRoles() != null && !this.getRoles().isEmpty()) {
                pai.getRoles().addAll(this.getRoles());
            }
            if (this.validators != null && this.validators.size() > 0) {
                pai.getValidators().putAll(this.validators);
            }
            return pai;
        }

        public Multimap<String, WPSInputValidator> getValidators() {
            return this.validators;
        }

        public void setValidators(Multimap<String, WPSInputValidator> validators) {
            this.validators = validators;
        }

        public boolean isValidated() {
            return this.validators != null && this.validators.size() > 0;
        }
    }
}

