/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wps.web;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.geoserver.web.GeoServerApplication;
import org.geoserver.wps.ppio.ComplexPPIO;
import org.geoserver.wps.ppio.ProcessParameterIO;
import org.geoserver.wps.process.GeoServerProcessors;
import org.geotools.api.data.Parameter;
import org.geotools.api.feature.type.Name;
import org.geotools.process.ProcessFactory;
import org.springframework.context.ApplicationContext;

class OutputParameter
implements Serializable {
    Name processName;
    String paramName;
    String mimeType;
    boolean include = true;

    public OutputParameter(Name processName, String paramName) {
        this.processName = processName;
        this.paramName = paramName;
        this.mimeType = this.getDefaultMime();
    }

    String getDefaultMime() {
        if (!this.isComplex()) {
            return null;
        }
        return ((ComplexPPIO)this.getProcessParameterIO().get(0)).getMimeType();
    }

    public List<String> getSupportedMime() {
        ArrayList<String> results = new ArrayList<String>();
        for (ProcessParameterIO ppio : this.getProcessParameterIO()) {
            ComplexPPIO cp = (ComplexPPIO)ppio;
            results.add(cp.getMimeType());
        }
        return results;
    }

    public boolean isComplex() {
        List<ProcessParameterIO> ppios = this.getProcessParameterIO();
        return !ppios.isEmpty() && ppios.get(0) instanceof ComplexPPIO;
    }

    List<ProcessParameterIO> getProcessParameterIO() {
        return ProcessParameterIO.findAll(this.getParameter(), (ApplicationContext)GeoServerApplication.get().getApplicationContext());
    }

    ProcessFactory getProcessFactory() {
        return GeoServerProcessors.createProcessFactory((Name)this.processName, (boolean)false);
    }

    Parameter<?> getParameter() {
        return (Parameter)this.getProcessFactory().getResultInfo(this.processName, null).get(this.paramName);
    }
}

