/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wps.web;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.apache.wicket.model.PropertyModel;
import org.geoserver.web.wicket.GeoServerDataProvider;
import org.geoserver.web.wicket.ParamResourceModel;
import org.geoserver.wps.ProcessGroupInfo;
import org.geoserver.wps.ProcessInfo;
import org.geoserver.wps.process.GeoServerProcessors;
import org.geotools.api.feature.type.Name;
import org.geotools.process.ProcessFactory;

public class ProcessFactoryInfoProvider
extends GeoServerDataProvider<ProcessGroupInfo> {
    private List<ProcessGroupInfo> processFactories;
    private Locale locale;

    public ProcessFactoryInfoProvider(List<ProcessGroupInfo> processFactories, Locale locale) {
        this.processFactories = processFactories;
        this.locale = locale;
    }

    protected List<GeoServerDataProvider.Property<ProcessGroupInfo>> getProperties() {
        ArrayList<GeoServerDataProvider.Property<ProcessGroupInfo>> props = new ArrayList<GeoServerDataProvider.Property<ProcessGroupInfo>>();
        props.add((GeoServerDataProvider.Property<ProcessGroupInfo>)new GeoServerDataProvider.BeanProperty("enabled", "enabled"));
        props.add((GeoServerDataProvider.Property<ProcessGroupInfo>)new GeoServerDataProvider.AbstractProperty<ProcessGroupInfo>("prefix"){

            public Object getPropertyValue(ProcessGroupInfo item) {
                Class factoryClass = item.getFactoryClass();
                HashSet<String> prefixes = new HashSet<String>();
                ProcessFactory pf = GeoServerProcessors.getProcessFactory((Class)factoryClass, (boolean)false);
                if (pf != null) {
                    Set names = pf.getNames();
                    for (Name name : names) {
                        prefixes.add(name.getNamespaceURI());
                    }
                }
                if (prefixes.isEmpty()) {
                    return "";
                }
                ArrayList pl = new ArrayList(prefixes);
                Collections.sort(pl);
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i < pl.size(); ++i) {
                    sb.append((String)pl.get(i));
                    if (i >= pl.size() - 1) continue;
                    sb.append(", ");
                }
                return sb.toString();
            }
        });
        props.add((GeoServerDataProvider.Property<ProcessGroupInfo>)new GeoServerDataProvider.AbstractProperty<ProcessGroupInfo>("title"){

            public Object getPropertyValue(ProcessGroupInfo item) {
                Class factoryClass = item.getFactoryClass();
                String title = null;
                ProcessFactory pf = GeoServerProcessors.getProcessFactory((Class)factoryClass, (boolean)false);
                if (pf != null) {
                    title = pf.getTitle().toString(ProcessFactoryInfoProvider.this.locale);
                }
                if (title == null) {
                    title = factoryClass.getName();
                }
                return title;
            }
        });
        props.add((GeoServerDataProvider.Property<ProcessGroupInfo>)new GeoServerDataProvider.AbstractProperty<ProcessGroupInfo>("summary"){

            public Object getPropertyValue(final ProcessGroupInfo item) {
                return new LoadableDetachableModel<String>(){

                    protected String load() {
                        if (item.getFilteredProcesses().isEmpty()) {
                            return new ParamResourceModel("WPSAdminPage.filter.all", null, new Object[0]).getString();
                        }
                        Class factoryClass = item.getFactoryClass();
                        ProcessFactory pf = GeoServerProcessors.getProcessFactory((Class)factoryClass, (boolean)false);
                        if (pf != null) {
                            HashSet names = new HashSet(pf.getNames());
                            int total = names.size();
                            for (ProcessInfo toRemove : item.getFilteredProcesses()) {
                                if (toRemove.isEnabled()) continue;
                                names.remove(toRemove.getName());
                            }
                            int active = names.size();
                            if (active != total) {
                                return new ParamResourceModel("WPSAdminPage.filter.active", null, new Object[]{active, total}).getString();
                            }
                            return new ParamResourceModel("WPSAdminPage.filter.all", null, new Object[0]).getString();
                        }
                        return "?";
                    }
                };
            }
        });
        props.add((GeoServerDataProvider.Property<ProcessGroupInfo>)new GeoServerDataProvider.AbstractProperty<ProcessGroupInfo>("roles"){

            public Object getPropertyValue(ProcessGroupInfo item) {
                return item.getRoles();
            }

            public IModel getModel(IModel itemModel) {
                return new PropertyModel((Object)itemModel, "roles");
            }
        });
        props.add((GeoServerDataProvider.Property<ProcessGroupInfo>)new GeoServerDataProvider.PropertyPlaceholder("edit"));
        return props;
    }

    protected List<ProcessGroupInfo> getItems() {
        return this.processFactories;
    }
}

