/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wps.web;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.PublishedInfo;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.config.GeoServer;
import org.geoserver.config.ServiceInfo;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.platform.Service;
import org.geoserver.web.ServiceDescription;
import org.geoserver.web.ServiceDescriptionProvider;
import org.geoserver.web.ServiceLinkDescription;
import org.geoserver.wps.WPSInfo;
import org.geoserver.wps.WebProcessingService;
import org.geotools.util.logging.Logging;

public class WPSServiceDescriptionProvider
extends ServiceDescriptionProvider {
    static final Logger LOGGER = Logging.getLogger(WPSServiceDescriptionProvider.class);
    public static final String SERVICE_TYPE = "WPS";
    GeoServer geoserver;
    Catalog catalog;

    public WPSServiceDescriptionProvider(GeoServer gs) {
        super(SERVICE_TYPE);
        this.geoserver = gs;
        this.catalog = gs.getCatalog();
    }

    protected WPSInfo info(WorkspaceInfo workspaceInfo, PublishedInfo layerInfo) {
        WPSInfo info = null;
        if (workspaceInfo != null) {
            info = (WPSInfo)this.geoserver.getService(workspaceInfo, WPSInfo.class);
        }
        if (info == null) {
            info = (WPSInfo)this.geoserver.getService(WPSInfo.class);
        }
        return info;
    }

    public List<ServiceDescription> getServices(WorkspaceInfo workspaceInfo, PublishedInfo layerInfo) {
        ArrayList<ServiceDescription> descriptions = new ArrayList<ServiceDescription>();
        WPSInfo info = this.info(workspaceInfo, layerInfo);
        if (workspaceInfo != null || this.geoserver.getGlobal().isGlobalServices().booleanValue()) {
            descriptions.add(this.description(this.serviceType, (ServiceInfo)info, workspaceInfo, layerInfo));
        }
        return descriptions;
    }

    public List<ServiceLinkDescription> getServiceLinks(WorkspaceInfo workspaceInfo, PublishedInfo layerInfo) {
        ArrayList<ServiceLinkDescription> links = new ArrayList<ServiceLinkDescription>();
        if (workspaceInfo == null && !this.geoserver.getGlobal().isGlobalServices().booleanValue()) {
            return links;
        }
        List extensions = GeoServerExtensions.extensions(Service.class);
        for (Service service : extensions) {
            if (!(service.getService() instanceof WebProcessingService)) continue;
            String link = null;
            if (service.getOperations().contains("GetCapabilities")) {
                link = this.getCapabilitiesURL(workspaceInfo, layerInfo, service);
            } else if (service.getCustomCapabilitiesLink() != null) {
                link = service.getCustomCapabilitiesLink();
            }
            if (link == null) continue;
            links.add(new ServiceLinkDescription(this.serviceType, service.getVersion(), link, workspaceInfo != null ? workspaceInfo.getName() : null, layerInfo != null ? layerInfo.getName() : null));
        }
        return links;
    }
}

