/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wps.web;

import java.util.List;
import org.apache.wicket.Page;
import org.apache.wicket.markup.repeater.OddEvenItem;
import org.geoserver.config.ServiceInfo;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.wps.ProcessGroupInfo;
import org.geoserver.wps.ProcessInfo;
import org.geoserver.wps.ProcessInfoImpl;
import org.geoserver.wps.WPSInfo;
import org.geoserver.wps.validator.MaxSizeValidator;
import org.geoserver.wps.validator.MultiplicityValidator;
import org.geoserver.wps.validator.NumberRangeValidator;
import org.geoserver.wps.web.FilteredProcessesProvider;
import org.geoserver.wps.web.ProcessLimitsPage;
import org.geoserver.wps.web.ProcessSelectionPage;
import org.geoserver.wps.web.WPSAccessRulePage;
import org.geoserver.wps.web.WPSPagesTestSupport;
import org.geotools.api.feature.type.Name;
import org.geotools.feature.NameImpl;
import org.geotools.process.raster.RasterProcessFactory;
import org.geotools.util.NumberRange;
import org.junit.Assert;
import org.junit.Test;

public class ProcessLimitsPageTest
extends WPSPagesTestSupport {
    protected void onSetUp(SystemTestData testData) throws Exception {
        super.onSetUp(testData);
        WPSInfo wps = (WPSInfo)this.getGeoServer().getService(WPSInfo.class);
        ProcessGroupInfo rasterGroup = this.getRasterGroup(wps.getProcessGroups());
        ProcessInfoImpl contour = new ProcessInfoImpl();
        contour.setEnabled(Boolean.valueOf(true));
        contour.setName((Name)new NameImpl("ras", "Contour"));
        contour.getValidators().put((Object)"data", (Object)new MaxSizeValidator(1));
        contour.getValidators().put((Object)"levels", (Object)new NumberRangeValidator(new NumberRange(Double.class, (Number)-8000.0, (Number)8000.0)));
        contour.getValidators().put((Object)"levels", (Object)new MultiplicityValidator(3));
        rasterGroup.getFilteredProcesses().add(contour);
        this.getGeoServer().save((ServiceInfo)wps);
    }

    @Test
    public void test() throws Exception {
        this.login();
        WPSInfo wps = (WPSInfo)this.getGeoServerApplication().getGeoServer().getService(WPSInfo.class);
        ProcessGroupInfo rasterGroup = this.getRasterGroup(wps.getProcessGroups());
        ProcessInfo pi = this.getProcess(rasterGroup.getFilteredProcesses(), "Contour");
        WPSAccessRulePage accessRulePage = (WPSAccessRulePage)tester.startPage((Page)new WPSAccessRulePage());
        ProcessSelectionPage selectionPage = (ProcessSelectionPage)tester.startPage((Page)new ProcessSelectionPage(accessRulePage, rasterGroup));
        FilteredProcessesProvider.FilteredProcess filteredProcess = new FilteredProcessesProvider.FilteredProcess(pi.getName(), "");
        filteredProcess.setValidators(pi.getValidators());
        tester.startPage((Page)new ProcessLimitsPage((Page)selectionPage, filteredProcess));
        OddEvenItem item = (OddEvenItem)tester.getComponentFromLastRenderedPage("form:table:listContainer:items:1");
        ProcessLimitsPage.InputLimit il = (ProcessLimitsPage.InputLimit)item.getDefaultModelObject();
        Assert.assertEquals((Object)"data", (Object)il.getName());
        Assert.assertEquals((Object)1, (Object)item.get("itemProperties:2:component:text").getDefaultModelObject());
        item = (OddEvenItem)tester.getComponentFromLastRenderedPage("form:table:listContainer:items:3");
        il = (ProcessLimitsPage.InputLimit)item.getDefaultModelObject();
        Assert.assertEquals((Object)"levels", (Object)il.getName());
        Assert.assertEquals((Object)new NumberRange(Double.class, (Number)-8000.0, (Number)8000.0), (Object)item.get("itemProperties:2:component:range").getDefaultModelObject());
        item = (OddEvenItem)tester.getComponentFromLastRenderedPage("form:table:listContainer:items:4");
        il = (ProcessLimitsPage.InputLimit)item.getDefaultModelObject();
        Assert.assertEquals((Object)"levels", (Object)il.getName());
        Assert.assertEquals((Object)3, (Object)item.get("itemProperties:2:component:text").getDefaultModelObject());
    }

    private ProcessInfo getProcess(List<ProcessInfo> filteredProcesses, String name) {
        for (ProcessInfo pi : filteredProcesses) {
            if (!pi.getName().getLocalPart().equals(name)) continue;
            return pi;
        }
        return null;
    }

    private ProcessGroupInfo getRasterGroup(List<ProcessGroupInfo> processGroups) {
        for (ProcessGroupInfo pgi : processGroups) {
            if (!pgi.getFactoryClass().equals(RasterProcessFactory.class)) continue;
            return pgi;
        }
        return null;
    }
}

