/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wps.web;

import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.Page;
import org.apache.wicket.markup.repeater.OddEvenItem;
import org.apache.wicket.markup.repeater.data.DataView;
import org.geoserver.config.ServiceInfo;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.wps.ProcessGroupInfo;
import org.geoserver.wps.ProcessInfoImpl;
import org.geoserver.wps.WPSInfo;
import org.geoserver.wps.validator.MaxSizeValidator;
import org.geoserver.wps.validator.NumberRangeValidator;
import org.geoserver.wps.web.FilteredProcessesProvider;
import org.geoserver.wps.web.ProcessSelectionPage;
import org.geoserver.wps.web.WPSAccessRulePage;
import org.geoserver.wps.web.WPSPagesTestSupport;
import org.geotools.api.feature.type.Name;
import org.geotools.feature.NameImpl;
import org.geotools.process.geometry.GeometryProcessFactory;
import org.geotools.util.NumberRange;
import org.junit.Assert;
import org.junit.Test;

public class ProcessSelectionPageTest
extends WPSPagesTestSupport {
    protected void onSetUp(SystemTestData testData) throws Exception {
        super.onSetUp(testData);
        WPSInfo wps = (WPSInfo)this.getGeoServer().getService(WPSInfo.class);
        ProcessGroupInfo geoGroup = this.getGeoGroup(wps.getProcessGroups());
        ProcessInfoImpl buffer = new ProcessInfoImpl();
        buffer.setEnabled(Boolean.valueOf(true));
        buffer.setName((Name)new NameImpl("geo", "buffer"));
        buffer.getValidators().put((Object)"geom", (Object)new MaxSizeValidator(1));
        buffer.getValidators().put((Object)"distance", (Object)new NumberRangeValidator(new NumberRange(Double.class, (Number)0.0, (Number)100.0)));
        buffer.getValidators().put((Object)"quadrantSegments", (Object)new NumberRangeValidator(new NumberRange(Integer.class, (Number)2, (Number)20)));
        geoGroup.getFilteredProcesses().add(buffer);
        this.getGeoServer().save((ServiceInfo)wps);
    }

    @Test
    public void test() throws Exception {
        this.login();
        WPSInfo wps = (WPSInfo)this.getGeoServerApplication().getGeoServer().getService(WPSInfo.class);
        ProcessGroupInfo pgi = this.getGeoGroup(wps.getProcessGroups());
        WPSAccessRulePage accessRulePage = (WPSAccessRulePage)tester.startPage((Page)new WPSAccessRulePage());
        tester.startPage((Page)new ProcessSelectionPage(accessRulePage, pgi));
        DataView datas = (DataView)tester.getComponentFromLastRenderedPage("form:selectionTable:listContainer:items");
        for (Component c : datas) {
            OddEvenItem item = (OddEvenItem)c;
            FilteredProcessesProvider.FilteredProcess fp = (FilteredProcessesProvider.FilteredProcess)item.getDefaultModelObject();
            Component validatedLabel = item.get("itemProperties:5:component");
            if (fp.getName().getLocalPart().equals("buffer")) {
                Assert.assertEquals((Object)"*", (Object)validatedLabel.getDefaultModelObject());
                continue;
            }
            Assert.assertEquals((Object)"", (Object)validatedLabel.getDefaultModelObject());
        }
    }

    private ProcessGroupInfo getGeoGroup(List<ProcessGroupInfo> processGroups) {
        for (ProcessGroupInfo pgi : processGroups) {
            if (!pgi.getFactoryClass().equals(GeometryProcessFactory.class)) continue;
            return pgi;
        }
        return null;
    }
}

