/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wps.web;

import org.apache.wicket.Page;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.config.GeoServer;
import org.geoserver.config.ServiceInfo;
import org.geoserver.config.impl.ServiceInfoImpl;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.ows.util.OwsUtils;
import org.geoserver.web.wicket.KeywordsEditor;
import org.geoserver.wps.WPSInfo;
import org.geoserver.wps.web.WPSAdminPage;
import org.geoserver.wps.web.WPSPagesTestSupport;
import org.junit.Test;

public class WPSAdminPageTest
extends WPSPagesTestSupport {
    protected void onSetUp(SystemTestData testData) throws Exception {
        super.onSetUp(testData);
        WPSInfo wps = (WPSInfo)this.getGeoServer().getService(WPSInfo.class);
        wps.setMaxAsynchronousExecutionTime(600);
        wps.setMaxSynchronousExecutionTime(60);
        wps.setMaxSynchronousProcesses(16);
        wps.setMaxAsynchronousProcesses(16);
        this.getGeoServer().save((ServiceInfo)wps);
    }

    @Test
    public void test() throws Exception {
        this.login();
        tester.startPage((Page)new WPSAdminPage());
        WPSInfo wps = (WPSInfo)this.getGeoServer().getService(WPSInfo.class);
        wps.setMaxAsynchronousTotalTime(Integer.valueOf(6000));
        wps.setMaxSynchronousTotalTime(Integer.valueOf(120));
        wps.setExternalOutputDirectory("file:///foo/bar");
        this.getGeoServer().save((ServiceInfo)wps);
        tester.assertComponent("form:keywords", KeywordsEditor.class);
        tester.assertModelValue("form:keywords", (Object)wps.getKeywords());
        tester.assertModelValue("form:maxSynchronousProcesses:", (Object)16);
        tester.assertModelValue("form:maxAsynchronousProcesses:", (Object)16);
        tester.assertModelValue("form:maxSynchronousExecutionTime:", (Object)60);
        tester.assertModelValue("form:maxAsynchronousExecutionTime:", (Object)600);
        tester.assertModelValue("form:maxSynchronousTotalTime:", (Object)120);
        tester.assertModelValue("form:maxAsynchronousTotalTime:", (Object)6000);
        tester.assertModelValue("form:externalOutputDirectory:", (Object)"file:///foo/bar");
    }

    @Test
    public void testUpgrade() throws Exception {
        this.login();
        tester.startPage((Page)new WPSAdminPage());
        WPSInfo wps = (WPSInfo)this.getGeoServer().getService(WPSInfo.class);
        this.getGeoServer().save((ServiceInfo)wps);
        tester.assertModelValue("form:maxSynchronousExecutionTime:", (Object)60);
        tester.assertModelValue("form:maxAsynchronousExecutionTime:", (Object)600);
        tester.assertModelValue("form:maxSynchronousTotalTime:", (Object)60);
        tester.assertModelValue("form:maxAsynchronousTotalTime:", (Object)600);
    }

    @Test
    public void testWorkspace() throws Exception {
        GeoServer geoServer = this.getGeoServerApplication().getGeoServer();
        WPSInfo wps = (WPSInfo)geoServer.getService(WPSInfo.class);
        WorkspaceInfo defaultWs = this.getCatalog().getDefaultWorkspace();
        WPSInfo wps2 = (WPSInfo)geoServer.getFactory().create(WPSInfo.class);
        OwsUtils.copy((Object)wps, (Object)wps2, WPSInfo.class);
        ((ServiceInfoImpl)wps2).setId(null);
        wps2.setWorkspace(defaultWs);
        wps2.setMaintainer("TestMaintainer");
        geoServer.add((ServiceInfo)wps2);
        this.login();
        tester.startPage(WPSAdminPage.class, new PageParameters().add("workspace", (Object)defaultWs.getName()));
        tester.assertModelValue("form:maintainer", (Object)"TestMaintainer");
    }
}

