/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wps.web;

import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import org.custommonkey.xmlunit.NamespaceContext;
import org.custommonkey.xmlunit.SimpleNamespaceContext;
import org.custommonkey.xmlunit.XMLAssert;
import org.custommonkey.xmlunit.XMLUnit;
import org.easymock.EasyMock;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.NamespaceInfo;
import org.geoserver.web.GeoServerWicketTestSupport;
import org.geoserver.wps.web.ExecuteRequest;
import org.geoserver.wps.web.InputParameterValues;
import org.geoserver.wps.web.OutputParameter;
import org.geoserver.wps.web.RasterLayerConfiguration;
import org.geoserver.wps.web.VectorLayerConfiguration;
import org.geoserver.wps.web.WPSExecuteTransformer;
import org.geoserver.wps.xml.WPSConfiguration;
import org.geotools.api.feature.type.Name;
import org.geotools.api.referencing.FactoryException;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.feature.NameImpl;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.geotools.xsd.Configuration;
import org.geotools.xsd.Parser;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.w3c.dom.Document;
import org.xml.sax.SAXParseException;

public class WPSExecuteTransformerTest
extends GeoServerWicketTestSupport {
    @Before
    public void setUpInternal() throws Exception {
        HashMap<String, String> namespaces = new HashMap<String, String>();
        namespaces.put("wps", "http://www.opengis.net/wps/1.0.0");
        namespaces.put("ows", "http://www.opengis.net/ows/1.1");
        namespaces.put("gml", "http://www.opengis.net/gml");
        namespaces.put("wfs", "http://www.opengis.net/wfs");
        namespaces.put("xlink", "http://www.w3.org/1999/xlink");
        namespaces.put("xsi", "http://www.w3.org/2001/XMLSchema-instance");
        namespaces.put("feature", "http://geoserver.sf.net");
        XMLUnit.setXpathNamespaceContext((NamespaceContext)new SimpleNamespaceContext(namespaces));
        XMLUnit.setIgnoreWhitespace((boolean)true);
    }

    @Test
    public void testSingleProcessInputWKT() throws Exception {
        ExecuteRequest executeBuffer = this.getExecuteBuffer(true);
        WPSExecuteTransformer tx = new WPSExecuteTransformer();
        tx.setIndentation(2);
        String xml = tx.transform((Object)executeBuffer);
        String expected = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<wps:Execute version=\"1.0.0\" service=\"WPS\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns=\"http://www.opengis.net/wps/1.0.0\" xmlns:wfs=\"http://www.opengis.net/wfs\" xmlns:wps=\"http://www.opengis.net/wps/1.0.0\" xmlns:ows=\"http://www.opengis.net/ows/1.1\" xmlns:gml=\"http://www.opengis.net/gml\" xmlns:ogc=\"http://www.opengis.net/ogc\" xmlns:wcs=\"http://www.opengis.net/wcs/1.1.1\" xmlns:xlink=\"http://www.w3.org/1999/xlink\" xsi:schemaLocation=\"http://www.opengis.net/wps/1.0.0 http://schemas.opengis.net/wps/1.0.0/wpsAll.xsd\">\n  <ows:Identifier>JTS:buffer</ows:Identifier>\n  <wps:DataInputs>\n    <wps:Input>\n      <ows:Identifier>geom</ows:Identifier>\n      <wps:Data>\n        <wps:ComplexData mimeType=\"application/wkt\"><![CDATA[POINT(0 0)]]></wps:ComplexData>\n      </wps:Data>\n    </wps:Input>\n    <wps:Input>\n      <ows:Identifier>distance</ows:Identifier>\n      <wps:Data>\n        <wps:LiteralData>10</wps:LiteralData>\n      </wps:Data>\n    </wps:Input>\n  </wps:DataInputs>\n  <wps:ResponseForm>\n    <wps:RawDataOutput mimeType=\"text/xml; subtype=gml/3.1.1\">\n      <ows:Identifier>result</ows:Identifier>\n    </wps:RawDataOutput>\n  </wps:ResponseForm>\n</wps:Execute>";
        Document test = XMLUnit.buildTestDocument((String)xml);
        this.checkValidationErrors(test);
        Document control = XMLUnit.buildControlDocument((String)expected);
        XMLAssert.assertXMLEqual((Document)control, (Document)test);
    }

    @Test
    public void testSingleProcessInputGML() throws Exception {
        ExecuteRequest executeBuffer = this.getExecuteBuffer(false);
        WPSExecuteTransformer tx = new WPSExecuteTransformer();
        tx.setIndentation(2);
        String xml = tx.transform((Object)executeBuffer);
        String expected = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<wps:Execute version=\"1.0.0\" service=\"WPS\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns=\"http://www.opengis.net/wps/1.0.0\" xmlns:wfs=\"http://www.opengis.net/wfs\" xmlns:wps=\"http://www.opengis.net/wps/1.0.0\" xmlns:ows=\"http://www.opengis.net/ows/1.1\" xmlns:gml=\"http://www.opengis.net/gml\" xmlns:ogc=\"http://www.opengis.net/ogc\" xmlns:wcs=\"http://www.opengis.net/wcs/1.1.1\" xmlns:xlink=\"http://www.w3.org/1999/xlink\" xsi:schemaLocation=\"http://www.opengis.net/wps/1.0.0 http://schemas.opengis.net/wps/1.0.0/wpsAll.xsd\">\n  <ows:Identifier>JTS:buffer</ows:Identifier>\n  <wps:DataInputs>\n    <wps:Input>\n      <ows:Identifier>geom</ows:Identifier>\n      <wps:Data>\n        <wps:ComplexData mimeType=\"text/xml; subtype=gml/2.1.2\">\n          <gml:Point xmlns:gml=\"http://www.opengis.net/gml\">\n            <gml:coordinates>0,0</gml:coordinates>\n          </gml:Point>\n        </wps:ComplexData>\n      </wps:Data>\n    </wps:Input>\n    <wps:Input>\n      <ows:Identifier>distance</ows:Identifier>\n      <wps:Data>\n        <wps:LiteralData>10</wps:LiteralData>\n      </wps:Data>\n    </wps:Input>\n  </wps:DataInputs>\n  <wps:ResponseForm>\n    <wps:RawDataOutput mimeType=\"text/xml; subtype=gml/3.1.1\">\n      <ows:Identifier>result</ows:Identifier>\n    </wps:RawDataOutput>\n  </wps:ResponseForm>\n</wps:Execute>";
        Document test = XMLUnit.buildTestDocument((String)xml);
        this.checkValidationErrors(test);
        Document control = XMLUnit.buildControlDocument((String)expected);
        XMLAssert.assertXMLEqual((Document)control, (Document)test);
    }

    @Test
    public void testSubprocessInputWKT() throws Exception {
        NameImpl areaName = new NameImpl("JTS", "area");
        InputParameterValues areaGeomValues = new InputParameterValues((Name)areaName, "geom");
        InputParameterValues.ParameterValue geom = (InputParameterValues.ParameterValue)areaGeomValues.values.get(0);
        geom.setType(InputParameterValues.ParameterType.SUBPROCESS);
        geom.setValue((Serializable)this.getExecuteBuffer(true));
        OutputParameter bufferOutput = new OutputParameter((Name)areaName, "result");
        ExecuteRequest executeArea = new ExecuteRequest(areaName.getURI(), Arrays.asList(areaGeomValues), Arrays.asList(bufferOutput));
        WPSExecuteTransformer tx = new WPSExecuteTransformer();
        tx.setIndentation(2);
        String xml = tx.transform((Object)executeArea);
        String expected = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<wps:Execute version=\"1.0.0\" service=\"WPS\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns=\"http://www.opengis.net/wps/1.0.0\" xmlns:wfs=\"http://www.opengis.net/wfs\" xmlns:wps=\"http://www.opengis.net/wps/1.0.0\" xmlns:ows=\"http://www.opengis.net/ows/1.1\" xmlns:gml=\"http://www.opengis.net/gml\" xmlns:ogc=\"http://www.opengis.net/ogc\" xmlns:wcs=\"http://www.opengis.net/wcs/1.1.1\" xmlns:xlink=\"http://www.w3.org/1999/xlink\" xsi:schemaLocation=\"http://www.opengis.net/wps/1.0.0 http://schemas.opengis.net/wps/1.0.0/wpsAll.xsd\">\n  <ows:Identifier>JTS:area</ows:Identifier>\n  <wps:DataInputs>\n    <wps:Input>\n      <ows:Identifier>geom</ows:Identifier>\n      <wps:Reference mimeType=\"text/xml; subtype=gml/3.1.1\" xlink:href=\"http://geoserver/wps\" method=\"POST\">\n        <wps:Body>\n          <wps:Execute version=\"1.0.0\" service=\"WPS\">\n            <ows:Identifier>JTS:buffer</ows:Identifier>\n            <wps:DataInputs>\n              <wps:Input>\n                <ows:Identifier>geom</ows:Identifier>\n                <wps:Data>\n                  <wps:ComplexData mimeType=\"application/wkt\"><![CDATA[POINT(0 0)]]></wps:ComplexData>\n                </wps:Data>\n              </wps:Input>\n              <wps:Input>\n                <ows:Identifier>distance</ows:Identifier>\n                <wps:Data>\n                  <wps:LiteralData>10</wps:LiteralData>\n                </wps:Data>\n              </wps:Input>\n            </wps:DataInputs>\n            <wps:ResponseForm>\n              <wps:RawDataOutput mimeType=\"text/xml; subtype=gml/3.1.1\">\n                <ows:Identifier>result</ows:Identifier>\n              </wps:RawDataOutput>\n            </wps:ResponseForm>\n          </wps:Execute>\n        </wps:Body>\n      </wps:Reference>\n    </wps:Input>\n  </wps:DataInputs>\n  <wps:ResponseForm>\n    <wps:RawDataOutput>\n      <ows:Identifier>result</ows:Identifier>\n    </wps:RawDataOutput>\n  </wps:ResponseForm>\n</wps:Execute>";
        Document test = XMLUnit.buildTestDocument((String)xml);
        this.checkValidationErrors(test);
        Document control = XMLUnit.buildControlDocument((String)expected);
        XMLAssert.assertXMLEqual((Document)control, (Document)test);
    }

    @Test
    public void testSubprocessInputGML() throws Exception {
        NameImpl areaName = new NameImpl("JTS", "area");
        InputParameterValues areaGeomValues = new InputParameterValues((Name)areaName, "geom");
        InputParameterValues.ParameterValue geom = (InputParameterValues.ParameterValue)areaGeomValues.values.get(0);
        geom.setType(InputParameterValues.ParameterType.SUBPROCESS);
        geom.setValue((Serializable)this.getExecuteBuffer(false));
        OutputParameter bufferOutput = new OutputParameter((Name)areaName, "result");
        ExecuteRequest executeArea = new ExecuteRequest(areaName.getURI(), Arrays.asList(areaGeomValues), Arrays.asList(bufferOutput));
        WPSExecuteTransformer tx = new WPSExecuteTransformer();
        tx.setIndentation(2);
        String xml = tx.transform((Object)executeArea);
        String expected = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<wps:Execute version=\"1.0.0\" service=\"WPS\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns=\"http://www.opengis.net/wps/1.0.0\" xmlns:wfs=\"http://www.opengis.net/wfs\" xmlns:wps=\"http://www.opengis.net/wps/1.0.0\" xmlns:ows=\"http://www.opengis.net/ows/1.1\" xmlns:gml=\"http://www.opengis.net/gml\" xmlns:ogc=\"http://www.opengis.net/ogc\" xmlns:wcs=\"http://www.opengis.net/wcs/1.1.1\" xmlns:xlink=\"http://www.w3.org/1999/xlink\" xsi:schemaLocation=\"http://www.opengis.net/wps/1.0.0 http://schemas.opengis.net/wps/1.0.0/wpsAll.xsd\">\n  <ows:Identifier>JTS:area</ows:Identifier>\n  <wps:DataInputs>\n    <wps:Input>\n      <ows:Identifier>geom</ows:Identifier>\n      <wps:Reference mimeType=\"text/xml; subtype=gml/3.1.1\" xlink:href=\"http://geoserver/wps\" method=\"POST\">\n        <wps:Body>\n          <wps:Execute version=\"1.0.0\" service=\"WPS\">\n            <ows:Identifier>JTS:buffer</ows:Identifier>\n            <wps:DataInputs>\n              <wps:Input>\n                <ows:Identifier>geom</ows:Identifier>\n                <wps:Data>\n                  <wps:ComplexData mimeType=\"text/xml; subtype=gml/2.1.2\">\n                    <gml:Point xmlns:gml=\"http://www.opengis.net/gml\">\n                      <gml:coordinates>0,0</gml:coordinates>\n                    </gml:Point>\n                  </wps:ComplexData>\n                </wps:Data>\n              </wps:Input>\n              <wps:Input>\n                <ows:Identifier>distance</ows:Identifier>\n                <wps:Data>\n                  <wps:LiteralData>10</wps:LiteralData>\n                </wps:Data>\n              </wps:Input>\n            </wps:DataInputs>\n            <wps:ResponseForm>\n              <wps:RawDataOutput mimeType=\"text/xml; subtype=gml/3.1.1\">\n                <ows:Identifier>result</ows:Identifier>\n              </wps:RawDataOutput>\n            </wps:ResponseForm>\n          </wps:Execute>\n        </wps:Body>\n      </wps:Reference>\n    </wps:Input>\n  </wps:DataInputs>\n  <wps:ResponseForm>\n    <wps:RawDataOutput>\n      <ows:Identifier>result</ows:Identifier>\n    </wps:RawDataOutput>\n  </wps:ResponseForm>\n</wps:Execute>";
        Document test = XMLUnit.buildTestDocument((String)xml);
        this.checkValidationErrors(test);
        Document control = XMLUnit.buildControlDocument((String)expected);
        XMLAssert.assertXMLEqual((Document)control, (Document)test);
    }

    @Test
    public void testBoundingBoxEncoding() throws Exception {
        ExecuteRequest executeClipAndShip = this.getExecuteClipAndShip();
        WPSExecuteTransformer tx = new WPSExecuteTransformer();
        tx.setIndentation(2);
        String xml = tx.transform((Object)executeClipAndShip);
        String expected = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><wps:Execute version=\"1.0.0\" service=\"WPS\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns=\"http://www.opengis.net/wps/1.0.0\" xmlns:wfs=\"http://www.opengis.net/wfs\" xmlns:wps=\"http://www.opengis.net/wps/1.0.0\" xmlns:ows=\"http://www.opengis.net/ows/1.1\" xmlns:gml=\"http://www.opengis.net/gml\" xmlns:ogc=\"http://www.opengis.net/ogc\" xmlns:wcs=\"http://www.opengis.net/wcs/1.1.1\" xmlns:xlink=\"http://www.w3.org/1999/xlink\" xsi:schemaLocation=\"http://www.opengis.net/wps/1.0.0 http://schemas.opengis.net/wps/1.0.0/wpsAll.xsd\">\n  <ows:Identifier>gs:CropCoverage</ows:Identifier>\n  <wps:DataInputs>\n    <wps:Input>\n      <ows:Identifier>coverage</ows:Identifier>\n      <wps:Reference mimeType=\"image/tiff\" xlink:href=\"http://geoserver/wcs\" method=\"POST\">\n        <wps:Body>\n          <wcs:GetCoverage service=\"WCS\" version=\"1.1.1\">\n            <ows:Identifier>geosolutions:usa</ows:Identifier>\n            <wcs:DomainSubset>\n              <ows:BoundingBox crs=\"http://www.opengis.net/gml/srs/epsg.xml#4326\">\n                <ows:LowerCorner>-180.0 -90.000000000036</ows:LowerCorner>\n                <ows:UpperCorner>180.0 90.0</ows:UpperCorner>\n              </ows:BoundingBox>\n            </wcs:DomainSubset>\n            <wcs:Output format=\"image/tiff\"/>\n          </wcs:GetCoverage>\n        </wps:Body>\n      </wps:Reference>\n    </wps:Input>\n    <wps:Input>\n      <ows:Identifier>cropShape</ows:Identifier>\n      <wps:Reference mimeType=\"text/xml; subtype=gml/3.1.1\" xlink:href=\"http://geoserver/wps\" method=\"POST\">\n        <wps:Body>\n          <wps:Execute version=\"1.0.0\" service=\"WPS\">\n            <ows:Identifier>gs:CollectGeometries</ows:Identifier>\n            <wps:DataInputs>\n              <wps:Input>\n                <ows:Identifier>features</ows:Identifier>\n                <wps:Reference mimeType=\"text/xml; subtype=wfs-collection/1.0\" xlink:href=\"http://geoserver/wfs\" method=\"POST\">\n                  <wps:Body>\n                    <wfs:GetFeature service=\"WFS\" version=\"1.0.0\" outputFormat=\"GML2\">\n                      <wfs:Query typeName=\"geosolutions:states\"/>\n                    </wfs:GetFeature>\n                  </wps:Body>\n                </wps:Reference>\n              </wps:Input>\n            </wps:DataInputs>\n            <wps:ResponseForm>\n              <wps:RawDataOutput mimeType=\"text/xml; subtype=gml/3.1.1\">\n                <ows:Identifier>result</ows:Identifier>\n              </wps:RawDataOutput>\n            </wps:ResponseForm>\n          </wps:Execute>\n        </wps:Body>\n      </wps:Reference>\n    </wps:Input>\n  </wps:DataInputs>\n  <wps:ResponseForm>\n    <wps:RawDataOutput mimeType=\"image/tiff\">\n      <ows:Identifier>result</ows:Identifier>\n    </wps:RawDataOutput>\n  </wps:ResponseForm>\n</wps:Execute>";
        Document test = XMLUnit.buildTestDocument((String)xml);
        this.checkValidationErrors(test);
        Document control = XMLUnit.buildControlDocument((String)expected);
        XMLAssert.assertXMLEqual((Document)control, (Document)test);
    }

    private ExecuteRequest getExecuteClipAndShip() throws Exception {
        CoordinateReferenceSystem epsg4326 = CRS.decode((String)"EPSG:4326");
        NameImpl collectGeometriesName = new NameImpl("gs", "CollectGeometries");
        InputParameterValues collectGeometriesFeaturesValues = new InputParameterValues((Name)collectGeometriesName, "features");
        VectorLayerConfiguration geosolutionsStates = new VectorLayerConfiguration();
        geosolutionsStates.setLayerName("geosolutions:states");
        InputParameterValues.ParameterValue cgFeatures = (InputParameterValues.ParameterValue)collectGeometriesFeaturesValues.values.get(0);
        cgFeatures.setType(InputParameterValues.ParameterType.VECTOR_LAYER);
        cgFeatures.setValue((Serializable)geosolutionsStates);
        OutputParameter collectGeometriesOutput = new OutputParameter((Name)collectGeometriesName, "result");
        ExecuteRequest collectGeometriesRequest = new ExecuteRequest(collectGeometriesName.getURI(), Arrays.asList(collectGeometriesFeaturesValues), Arrays.asList(collectGeometriesOutput));
        NameImpl clipName = new NameImpl("gs", "CropCoverage");
        InputParameterValues clipFeaturesValues = new InputParameterValues((Name)clipName, "coverage");
        InputParameterValues.ParameterValue features = (InputParameterValues.ParameterValue)clipFeaturesValues.values.get(0);
        features.setType(InputParameterValues.ParameterType.RASTER_LAYER);
        RasterLayerConfiguration geosolutionsUsa = new RasterLayerConfiguration();
        geosolutionsUsa.setLayerName("geosolutions:usa");
        geosolutionsUsa.setSpatialDomain(new ReferencedEnvelope(-180.0, 180.0, -90.000000000036, 90.0, epsg4326));
        features.setValue((Serializable)geosolutionsUsa);
        InputParameterValues clipClipValues = new InputParameterValues((Name)clipName, "cropShape");
        InputParameterValues.ParameterValue clip = (InputParameterValues.ParameterValue)clipClipValues.values.get(0);
        clip.setType(InputParameterValues.ParameterType.SUBPROCESS);
        clip.setValue((Serializable)collectGeometriesRequest);
        OutputParameter clipOutput = new OutputParameter((Name)clipName, "result");
        ExecuteRequest executeBuffer = new ExecuteRequest(clipName.getURI(), Arrays.asList(clipFeaturesValues, clipClipValues), Arrays.asList(clipOutput));
        return executeBuffer;
    }

    private ExecuteRequest getExecuteBuffer(boolean wkt) {
        NameImpl bufferName = new NameImpl("JTS", "buffer");
        InputParameterValues bufferGeomValues = new InputParameterValues((Name)bufferName, "geom");
        InputParameterValues.ParameterValue geom = (InputParameterValues.ParameterValue)bufferGeomValues.values.get(0);
        geom.setMime(wkt ? "application/wkt" : "text/xml; subtype=gml/2.1.2");
        geom.setType(InputParameterValues.ParameterType.TEXT);
        geom.setValue((Serializable)((Object)(wkt ? "POINT(0 0)" : "<gml:Point xmlns:gml=\"http://www.opengis.net/gml\"><gml:coordinates>0,0</gml:coordinates></gml:Point>")));
        InputParameterValues bufferDistanceValues = new InputParameterValues((Name)bufferName, "distance");
        InputParameterValues.ParameterValue distance = (InputParameterValues.ParameterValue)bufferDistanceValues.values.get(0);
        distance.setType(InputParameterValues.ParameterType.LITERAL);
        distance.setValue((Serializable)((Object)"10"));
        OutputParameter bufferOutput = new OutputParameter((Name)bufferName, "result");
        ExecuteRequest executeBuffer = new ExecuteRequest(bufferName.getURI(), Arrays.asList(bufferGeomValues, bufferDistanceValues), Arrays.asList(bufferOutput));
        return executeBuffer;
    }

    protected void checkValidationErrors(Document dom) throws Exception {
        Parser p = new Parser((Configuration)new WPSConfiguration());
        p.setValidating(true);
        p.parse((Source)new DOMSource(dom));
        if (!p.getValidationErrors().isEmpty()) {
            for (Exception exception : p.getValidationErrors()) {
                SAXParseException ex = (SAXParseException)exception;
                LOGGER.warning(ex.getLineNumber() + "," + ex.getColumnNumber() + " -" + ex.toString());
            }
            Assert.fail((String)"Document did not validate.");
        }
    }

    @Test
    public void testIncludeNamespaceMapping() throws Exception {
        NameImpl centroidName = new NameImpl("gs", "Centroid");
        InputParameterValues inputValues = new InputParameterValues((Name)centroidName, "features");
        VectorLayerConfiguration layer = new VectorLayerConfiguration();
        layer.setLayerName("foo:myLayer");
        InputParameterValues.ParameterValue features = (InputParameterValues.ParameterValue)inputValues.values.get(0);
        features.setType(InputParameterValues.ParameterType.VECTOR_LAYER);
        features.setValue((Serializable)layer);
        OutputParameter output = new OutputParameter((Name)centroidName, "result");
        ExecuteRequest execute = new ExecuteRequest(centroidName.getURI(), Arrays.asList(inputValues), Arrays.asList(output));
        NamespaceInfo fooNs = (NamespaceInfo)EasyMock.createNiceMock(NamespaceInfo.class);
        EasyMock.expect((Object)fooNs.getURI()).andReturn((Object)"http://foo.org");
        EasyMock.replay((Object[])new Object[]{fooNs});
        Catalog cat = (Catalog)EasyMock.createNiceMock(Catalog.class);
        EasyMock.expect((Object)cat.getNamespaceByPrefix("foo")).andReturn((Object)fooNs);
        EasyMock.replay((Object[])new Object[]{cat});
        WPSExecuteTransformer tx = new WPSExecuteTransformer(cat);
        tx.setIndentation(2);
        String xml = tx.transform((Object)execute);
        Assert.assertTrue((boolean)xml.contains("xmlns:foo=\"http://foo.org\""));
    }

    @Test
    public void testEncodeBoundingBOXIAU() throws Exception {
        ExecuteRequest execute = this.getRectangularClipMars();
        WPSExecuteTransformer tx = new WPSExecuteTransformer();
        tx.setIndentation(2);
        String xml = tx.transform((Object)execute);
        String expected = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><wps:Execute version=\"1.0.0\" service=\"WPS\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns=\"http://www.opengis.net/wps/1.0.0\" xmlns:wfs=\"http://www.opengis.net/wfs\" xmlns:wps=\"http://www.opengis.net/wps/1.0.0\" xmlns:ows=\"http://www.opengis.net/ows/1.1\" xmlns:gml=\"http://www.opengis.net/gml\" xmlns:ogc=\"http://www.opengis.net/ogc\" xmlns:wcs=\"http://www.opengis.net/wcs/1.1.1\" xmlns:xlink=\"http://www.w3.org/1999/xlink\" xsi:schemaLocation=\"http://www.opengis.net/wps/1.0.0 http://schemas.opengis.net/wps/1.0.0/wpsAll.xsd\">\n  <ows:Identifier>gs:RectangularClip</ows:Identifier>\n  <wps:DataInputs>\n    <wps:Input>\n      <ows:Identifier>features</ows:Identifier>\n      <wps:Data>\n        <wps:ComplexData mimeType=\"application/json\"><![CDATA[{\"type\":\"FeatureCollection\",\"features\":[{\"type\":\"Feature\",\"properties\":{\"id\":1,\"value\":343},\"geometry\":{\"type\":\"Point\",\"coordinates\":[8,47]}}]}]]></wps:ComplexData>\n      </wps:Data>\n    </wps:Input>\n    <wps:Input>\n      <ows:Identifier>clip</ows:Identifier>\n      <wps:Data>\n        <wps:BoundingBoxData crs=\"IAU:49900\" dimensions=\"2\">\n          <ows:LowerCorner>0.0 0.0</ows:LowerCorner>\n          <ows:UpperCorner>10.0 10.0</ows:UpperCorner>\n        </wps:BoundingBoxData>\n      </wps:Data>\n    </wps:Input>\n  </wps:DataInputs>\n  <wps:ResponseForm>\n    <wps:RawDataOutput mimeType=\"text/xml; subtype=wfs-collection/1.0\">\n      <ows:Identifier>result</ows:Identifier>\n    </wps:RawDataOutput>\n  </wps:ResponseForm>\n</wps:Execute>";
        Document test = XMLUnit.buildTestDocument((String)xml);
        this.checkValidationErrors(test);
        Document control = XMLUnit.buildControlDocument((String)expected);
        XMLAssert.assertXMLEqual((Document)control, (Document)test);
    }

    private ExecuteRequest getRectangularClipMars() throws FactoryException {
        NameImpl processName = new NameImpl("gs", "RectangularClip");
        InputParameterValues features = new InputParameterValues((Name)processName, "features");
        InputParameterValues.ParameterValue geom = (InputParameterValues.ParameterValue)features.values.get(0);
        geom.setMime("application/json");
        geom.setType(InputParameterValues.ParameterType.TEXT);
        geom.setValue((Serializable)((Object)"{\"type\":\"FeatureCollection\",\"features\":[{\"type\":\"Feature\",\"properties\":{\"id\":1,\"value\":343},\"geometry\":{\"type\":\"Point\",\"coordinates\":[8,47]}}]}"));
        InputParameterValues clip = new InputParameterValues((Name)processName, "clip");
        InputParameterValues.ParameterValue bbox = (InputParameterValues.ParameterValue)clip.values.get(0);
        bbox.setType(InputParameterValues.ParameterType.LITERAL);
        bbox.setValue((Serializable)new ReferencedEnvelope(0.0, 10.0, 0.0, 10.0, CRS.decode((String)"IAU:49900", (boolean)true)));
        OutputParameter bufferOutput = new OutputParameter((Name)processName, "result");
        ExecuteRequest execute = new ExecuteRequest(processName.getURI(), Arrays.asList(features, clip), Arrays.asList(bufferOutput));
        return execute;
    }
}

