/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wps.web;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXResult;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.NamespaceInfo;
import org.geoserver.catalog.ResourcePool;
import org.geoserver.wps.web.ExecuteRequest;
import org.geoserver.wps.web.InputParameterValues;
import org.geoserver.wps.web.OutputParameter;
import org.geoserver.wps.web.RasterLayerConfiguration;
import org.geoserver.wps.web.ReferenceConfiguration;
import org.geoserver.wps.web.VectorLayerConfiguration;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.gml2.bindings.GML2EncodingUtils;
import org.geotools.util.Converters;
import org.geotools.util.logging.Logging;
import org.geotools.xml.transform.TransformerBase;
import org.geotools.xml.transform.Translator;
import org.w3c.dom.Document;
import org.xml.sax.ContentHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.SAXException;
import org.xml.sax.ext.EntityResolver2;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.AttributesImpl;

class WPSExecuteTransformer
extends TransformerBase {
    static final Logger LOGGER = Logging.getLogger(WPSExecuteTransformer.class);
    private EntityResolver2 entityResolver;
    Catalog catalog;

    public WPSExecuteTransformer() {
        this(null);
    }

    public WPSExecuteTransformer(Catalog catalog) {
        this.catalog = catalog;
    }

    public Translator createTranslator(ContentHandler handler) {
        return new ExecuteRequestTranslator(handler);
    }

    public void setEntityResolver(EntityResolver entityResolver) {
        this.entityResolver = (EntityResolver2)entityResolver;
    }

    public EntityResolver getEntityResolver() {
        return this.entityResolver;
    }

    public class ExecuteRequestTranslator
    extends TransformerBase.TranslatorSupport {
        protected static final String WFS_URI = "http://www.opengis.net/wfs";
        protected static final String WPS_URI = "http://www.opengis.net/wps/1.0.0";
        protected static final String WCS_URI = "http://www.opengis.net/wcs/1.1.1";
        protected static final String XSI_PREFIX = "xsi";
        protected static final String XSI_URI = "http://www.w3.org/2001/XMLSchema-instance";

        public ExecuteRequestTranslator(ContentHandler ch) {
            super(ch, null, null);
        }

        public void encode(Object o) throws IllegalArgumentException {
            ExecuteRequest request = (ExecuteRequest)o;
            this.encode(request, true);
        }

        private void encode(ExecuteRequest request, boolean mainProcess) {
            if (mainProcess) {
                AttributesImpl attributes = this.attributes("version", "1.0.0", "service", "WPS", "xmlns:xsi", XSI_URI, "xmlns", WPS_URI, "xmlns:wfs", WFS_URI, "xmlns:wps", WPS_URI, "xmlns:ows", "http://www.opengis.net/ows/1.1", "xmlns:gml", "http://www.opengis.net/gml", "xmlns:ogc", "http://www.opengis.net/ogc", "xmlns:wcs", WCS_URI, "xmlns:xlink", "http://www.w3.org/1999/xlink", "xsi:schemaLocation", "http://www.opengis.net/wps/1.0.0 http://schemas.opengis.net/wps/1.0.0/wpsAll.xsd");
                this.start("wps:Execute", attributes);
            } else {
                AttributesImpl attributes = this.attributes("version", "1.0.0", "service", "WPS");
                this.start("wps:Execute", attributes);
            }
            this.element("ows:Identifier", request.processName);
            this.handleInputs(request.inputs);
            this.handleOutputs(request.outputs);
            this.end("wps:Execute");
        }

        AttributesImpl attributes(String ... nameValues) {
            AttributesImpl atts = new AttributesImpl();
            for (int i = 0; i < nameValues.length; i += 2) {
                String name = nameValues[i];
                String valu = nameValues[i + 1];
                atts.addAttribute(null, null, name, null, valu);
            }
            return atts;
        }

        public void handleInputs(List<InputParameterValues> inputs) {
            this.start("wps:DataInputs");
            for (InputParameterValues pv : inputs) {
                for (InputParameterValues.ParameterValue value : pv.values) {
                    if (value == null || value.value == null) continue;
                    this.start("wps:Input");
                    this.element("ows:Identifier", pv.paramName);
                    if (pv.isBoundingBox()) {
                        ReferencedEnvelope env = (ReferencedEnvelope)value.value;
                        this.start("wps:Data");
                        String crsId = null;
                        CoordinateReferenceSystem crs = env.getCoordinateReferenceSystem();
                        if (crs != null) {
                            try {
                                crsId = ResourcePool.lookupIdentifier((CoordinateReferenceSystem)crs, (boolean)false);
                            }
                            catch (Exception e) {
                                LOGGER.log(Level.WARNING, "Could not get EPSG code for " + crsId);
                            }
                        }
                        if (crsId == null) {
                            this.start("wps:BoundingBoxData", this.attributes("dimensions", "2"));
                        } else {
                            this.start("wps:BoundingBoxData", this.attributes("crs", crsId, "dimensions", "2"));
                        }
                        this.element("ows:LowerCorner", env.getMinX() + " " + env.getMinY());
                        this.element("ows:UpperCorner", env.getMaxX() + " " + env.getMaxY());
                        this.end("wps:BoundingBoxData");
                        this.end("wps:Data");
                    } else if (pv.isComplex()) {
                        if (value.type == InputParameterValues.ParameterType.TEXT) {
                            this.handleTextInput(value);
                        } else if (value.type == InputParameterValues.ParameterType.VECTOR_LAYER) {
                            this.handleVectorInput(value);
                        } else if (value.type == InputParameterValues.ParameterType.RASTER_LAYER) {
                            this.handleRasterLayerInput(value);
                        } else if (value.type == InputParameterValues.ParameterType.REFERENCE) {
                            this.handleReferenceInput(value);
                        } else if (value.type == InputParameterValues.ParameterType.SUBPROCESS) {
                            this.handleSubprocessInput(value);
                        } else {
                            char[] comment = "Can't handle this data type yet".toCharArray();
                            try {
                                ((LexicalHandler)((Object)this.contentHandler)).comment(comment, 0, comment.length);
                            }
                            catch (SAXException se) {
                                throw new RuntimeException(se);
                            }
                        }
                    } else if (pv.isCoordinateReferenceSystem()) {
                        this.handleCoordinateReferenceSystem(value);
                    } else {
                        this.start("wps:Data");
                        this.element("wps:LiteralData", (String)Converters.convert((Object)value.value, String.class));
                        this.end("wps:Data");
                    }
                    this.end("wps:Input");
                }
            }
            this.end("wps:DataInputs");
        }

        private void handleCoordinateReferenceSystem(InputParameterValues.ParameterValue value) {
            try {
                this.start("wps:Data");
                CoordinateReferenceSystem crs = (CoordinateReferenceSystem)value.value;
                this.element("wps:LiteralData", ResourcePool.lookupIdentifier((CoordinateReferenceSystem)crs, (boolean)false));
                this.end("wps:Data");
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        private void handleRasterLayerInput(InputParameterValues.ParameterValue value) {
            RasterLayerConfiguration raster = (RasterLayerConfiguration)value.value;
            this.start("wps:Reference", this.attributes("mimeType", value.mime, "xlink:href", "http://geoserver/wcs", "method", "POST"));
            this.start("wps:Body");
            if (raster != null && raster.getLayerName() != null) {
                this.start("wcs:GetCoverage", this.attributes("service", "WCS", "version", "1.1.1"));
                this.element("ows:Identifier", raster.getLayerName());
                this.start("wcs:DomainSubset");
                ReferencedEnvelope bbox = raster.getSpatialDomain();
                String srsUri = GML2EncodingUtils.toURI((CoordinateReferenceSystem)bbox.getCoordinateReferenceSystem());
                this.start("ows:BoundingBox", this.attributes("crs", srsUri));
                this.element("ows:LowerCorner", bbox.getMinX() + " " + bbox.getMinY());
                this.element("ows:UpperCorner", bbox.getMaxX() + " " + bbox.getMaxY());
                this.end("ows:BoundingBox");
                this.end("wcs:DomainSubset");
                this.element("wcs:Output", null, this.attributes("format", "image/tiff"));
                this.end("wcs:GetCoverage");
            }
            this.end("wps:Body");
            this.end("wps:Reference");
        }

        private void handleVectorInput(InputParameterValues.ParameterValue value) {
            String prefix;
            NamespaceInfo ns;
            VectorLayerConfiguration vector = (VectorLayerConfiguration)value.value;
            this.start("wps:Reference", this.attributes("mimeType", value.mime, "xlink:href", "http://geoserver/wfs", "method", "POST"));
            this.start("wps:Body");
            AttributesImpl atts = this.attributes("service", "WFS", "version", "1.0.0", "outputFormat", "GML2");
            if (WPSExecuteTransformer.this.catalog != null && vector.layerName != null && vector.layerName.contains(":") && (ns = WPSExecuteTransformer.this.catalog.getNamespaceByPrefix(prefix = vector.layerName.split(":")[0])) != null) {
                atts.addAttribute("", "", "xmlns:" + prefix, null, ns.getURI());
            }
            this.start("wfs:GetFeature", atts);
            if (vector.layerName == null) {
                this.start("wfs:Query");
            } else {
                this.start("wfs:Query", this.attributes("typeName", vector.layerName));
            }
            this.end("wfs:Query");
            this.end("wfs:GetFeature");
            this.end("wps:Body");
            this.end("wps:Reference");
        }

        public void handleReferenceInput(InputParameterValues.ParameterValue value) {
            ReferenceConfiguration reference = (ReferenceConfiguration)value.value;
            if (reference.mime != null) {
                this.start("wps:Reference", this.attributes("mimeType", reference.mime, "xlink:href", reference.url, "method", reference.method.toString()));
            } else {
                this.start("wps:Reference", this.attributes("xlink:href", reference.url, "method", reference.method.toString()));
            }
            if (reference.method == ReferenceConfiguration.Method.POST) {
                this.start("wps:Body");
                this.cdata(reference.body);
                this.end("wps:Body");
            }
            this.end("wps:Reference");
        }

        private void handleSubprocessInput(InputParameterValues.ParameterValue value) {
            ExecuteRequest request = (ExecuteRequest)value.value;
            this.start("wps:Reference", this.attributes("mimeType", value.mime, "xlink:href", "http://geoserver/wps", "method", "POST"));
            this.start("wps:Body");
            this.encode(request, false);
            this.end("wps:Body");
            this.end("wps:Reference");
        }

        private void handleTextInput(InputParameterValues.ParameterValue value) {
            this.start("wps:Data");
            this.start("wps:ComplexData", this.attributes("mimeType", value.mime));
            String data = (String)Converters.convert((Object)value.value, String.class);
            if (data != null) {
                Document document = this.parseAsXML(data);
                if (document != null) {
                    this.dumpAsXML(document);
                } else {
                    try {
                        ((LexicalHandler)((Object)this.contentHandler)).startCDATA();
                        this.chars(data);
                        ((LexicalHandler)((Object)this.contentHandler)).endCDATA();
                    }
                    catch (SAXException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
            this.end("wps:ComplexData");
            this.end("wps:Data");
        }

        private void dumpAsXML(Document document) {
            try {
                TransformerFactory.newInstance().newTransformer().transform(new DOMSource(document), new SAXResult(this.contentHandler));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        private Document parseAsXML(String data) {
            if (!((String)data).matches("\\s*<.+/.*>\\s*")) {
                return null;
            }
            try {
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                factory.setNamespaceAware(true);
                DocumentBuilder builder = factory.newDocumentBuilder();
                builder.setEntityResolver(WPSExecuteTransformer.this.entityResolver);
                if (!((String)data).startsWith("<?xml")) {
                    data = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n" + (String)data;
                }
                return builder.parse(new ByteArrayInputStream(((String)data).getBytes()));
            }
            catch (IOException | ParserConfigurationException | SAXException t) {
                LOGGER.log(Level.FINE, "Failed to parse XML, assuming it's plain text", t);
                return null;
            }
        }

        public void handleOutputs(List<OutputParameter> outputs) {
            this.start("wps:ResponseForm");
            if (outputs.size() > 1) {
                this.start("wps:ResponseDocument");
                for (OutputParameter op : outputs) {
                    if (!op.isComplex()) continue;
                    if (op.isComplex()) {
                        this.start("wps:Output", this.attributes("mimeType", op.mimeType));
                    } else {
                        this.start("wps:Output");
                    }
                    this.element("ows:Identifier", op.paramName);
                    this.end("wps:Output");
                }
                this.end("wps:ResponseDocument");
            } else if (outputs.size() == 1) {
                OutputParameter op = outputs.get(0);
                if (op.isComplex()) {
                    this.start("wps:RawDataOutput", this.attributes("mimeType", op.mimeType));
                } else {
                    this.start("wps:RawDataOutput");
                }
                this.element("ows:Identifier", op.paramName);
                this.end("wps:RawDataOutput");
            }
            this.end("wps:ResponseForm");
        }
    }
}

