/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wps.hz;

import com.hazelcast.config.Config;
import com.hazelcast.config.MapConfig;
import com.hazelcast.config.XmlConfigBuilder;
import com.hazelcast.core.Hazelcast;
import com.hazelcast.core.HazelcastInstance;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Logger;
import org.apache.commons.io.IOUtils;
import org.geoserver.platform.resource.Resource;
import org.geoserver.platform.resource.ResourceStore;
import org.geotools.util.logging.Logging;
import org.geotools.xml.XMLUtils;
import org.springframework.beans.factory.DisposableBean;

public class HazelcastLoader
implements DisposableBean {
    private static final Logger LOGGER = Logging.getLogger(HazelcastLoader.class);
    public static final String HAZELCAST_NAME = "hazelcast.xml";
    private HazelcastInstance instance;

    public HazelcastLoader(ResourceStore store) throws IOException {
        Resource resource = store.get(HAZELCAST_NAME);
        if (resource.getType() == Resource.Type.UNDEFINED) {
            try (OutputStream os = resource.out();
                 InputStream is = HazelcastLoader.class.getResourceAsStream(HAZELCAST_NAME);){
                IOUtils.copy((InputStream)is, (OutputStream)os);
            }
        }
        try (InputStream is = resource.in();){
            Config config = new XmlConfigBuilder(is).build();
            this.validateConfiguration(config);
            this.instance = Hazelcast.newHazelcastInstance((Config)config);
        }
    }

    HazelcastLoader(HazelcastInstance instance) {
        this.instance = instance;
        this.validateConfiguration(instance.getConfig());
    }

    public HazelcastInstance getInstance() {
        return this.instance;
    }

    private void validateConfiguration(Config config) {
        LOGGER.fine("Checking configuration");
        if (config == null) {
            throw new IllegalArgumentException("Hazelcast configuration should not be null");
        }
        if (!config.getMapConfigs().containsKey("wpsExecutionStatusMap")) {
            throw new IllegalArgumentException("Hazelcast configuration is missing the status map, should be called: wpsExecutionStatusMap");
        }
        MapConfig mapConfig = config.getMapConfig("wpsExecutionStatusMap");
        if (mapConfig.getEvictionConfig().getSize() > 0) {
            LOGGER.warning("The WPS status map wpsExecutionStatusMap has a max size set, it should be unbounded so that no status is lost before the configured timeout");
        }
        if (mapConfig.getEvictionConfig().getEvictionPolicy() != MapConfig.DEFAULT_EVICTION_POLICY) {
            LOGGER.warning("The WPS status map wpsExecutionStatusMap has a eviction policy set, it should not automatically evict entries so that  no status is lost before the configured timeout");
        }
    }

    public void destroy() throws Exception {
        this.instance.shutdown();
    }

    static {
        if (System.getProperty("hazelcast.ignoreXxeProtectionFailures") == null) {
            try {
                XMLUtils.checkSupportForJAXP15Properties();
            }
            catch (IllegalStateException e) {
                LOGGER.warning("Disabling Hazelcast XXE protection because " + e.getMessage());
                System.setProperty("hazelcast.ignoreXxeProtectionFailures", "true");
            }
        }
    }
}

