/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wps;

import java.util.List;
import org.geoserver.config.ServiceInfo;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.wps.ChainedProcessListenerImpl;
import org.geoserver.wps.WPSInfo;
import org.geoserver.wps.WPSTestSupport;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.springframework.mock.web.MockHttpServletResponse;

public class ChainedProcessListenerTest
extends WPSTestSupport {
    ChainedProcessListenerImpl chainedListener;

    @Override
    protected void onSetUp(SystemTestData testData) throws Exception {
        super.onSetUp(testData);
    }

    protected void setUpSpring(List<String> springContextLocations) {
        super.setUpSpring(springContextLocations);
        springContextLocations.add("classpath*:/chainedProcessListenerContext.xml");
    }

    @Before
    public void retrieveListener() throws Exception {
        this.chainedListener = (ChainedProcessListenerImpl)applicationContext.getBean("chainedProcessListener", ChainedProcessListenerImpl.class);
        this.chainedListener.cleanup();
    }

    @Before
    public void oneTimeSetUp() throws Exception {
        WPSInfo wps = (WPSInfo)this.getGeoServer().getService(WPSInfo.class);
        wps.setMaxAsynchronousProcesses(Math.max(2, wps.getMaxAsynchronousProcesses()));
        wps.setMaxSynchronousExecutionTime(Integer.MAX_VALUE);
        wps.setMaxAsynchronousExecutionTime(Integer.MAX_VALUE);
        wps.setMaxSynchronousTotalTime(Integer.valueOf(Integer.MAX_VALUE));
        wps.setMaxAsynchronousTotalTime(Integer.valueOf(Integer.MAX_VALUE));
        this.getGeoServer().save((ServiceInfo)wps);
    }

    @Test
    public void testChainedRequest() throws Exception {
        String xml = "<wps:Execute service='WPS' version='1.0.0'  xmlns:wps='http://www.opengis.net/wps/1.0.0' xmlns:ows='http://www.opengis.net/ows/1.1' xmlns:xlink='http://www.w3.org/1999/xlink'>  <ows:Identifier>JTS:area</ows:Identifier>  <wps:DataInputs>    <wps:Input>      <ows:Identifier>geom</ows:Identifier>      <wps:Reference xlink:href='http://geoserver/wps' method='POST' mimeType='application/xml'>        <wps:Body>          <wps:Execute service='WPS' version='1.0.0'>            <ows:Identifier>JTS:union</ows:Identifier>            <wps:DataInputs>              <wps:Input>                <ows:Identifier>geom</ows:Identifier>                <wps:Reference xlink:href='http://geoserver/wps' method='POST' mimeType='application/xml'>                  <wps:Body>                    <wps:Execute service='WPS' version='1.0.0'>                      <ows:Identifier>JTS:buffer</ows:Identifier>                      <wps:DataInputs>                        <wps:Input>                          <ows:Identifier>geom</ows:Identifier>                          <wps:Data>                            <wps:ComplexData mimeType='application/wkt'>                              <![CDATA[POLYGON((10.0 10.0, 10.0 50.0, 50.0 50.0, 50.0 10.0, 10.0 10.0))]]>                            </wps:ComplexData>                          </wps:Data>                        </wps:Input>                        <wps:Input>                          <ows:Identifier>distance</ows:Identifier>                          <wps:Data>                            <wps:LiteralData>10.0</wps:LiteralData>                          </wps:Data>                        </wps:Input>                      </wps:DataInputs>                      <wps:ResponseForm>                        <wps:RawDataOutput mimeType='application/wkt'>                          <ows:Identifier>result</ows:Identifier>                        </wps:RawDataOutput>                      </wps:ResponseForm>                    </wps:Execute>                  </wps:Body>                </wps:Reference>              </wps:Input>              <wps:Input>                <ows:Identifier>geom</ows:Identifier>                <wps:Reference xlink:href='http://geoserver/wps' method='POST' mimeType='application/xml'>                  <wps:Body>                    <wps:Execute service='WPS' version='1.0.0'>                      <ows:Identifier>JTS:difference</ows:Identifier>                      <wps:DataInputs>                        <wps:Input>                          <ows:Identifier>a</ows:Identifier>                          <wps:Data>                            <wps:ComplexData mimeType='application/wkt'>                              <![CDATA[POLYGON((40.0 40.0, 40.0 100.0, 100.0 100.0, 100.0 40.0, 40.0 40.0))]]>                            </wps:ComplexData>                          </wps:Data>                        </wps:Input>                        <wps:Input>                          <ows:Identifier>b</ows:Identifier>                          <wps:Data>                            <wps:ComplexData mimeType='application/wkt'>                              <![CDATA[POLYGON((80.0 80.0, 80.0 120.0, 120.0 120.0, 120.0 80.0, 80.0 80.0))]]>                            </wps:ComplexData>                          </wps:Data>                        </wps:Input>                                          </wps:DataInputs>                      <wps:ResponseForm>                        <wps:RawDataOutput mimeType='application/wkt'>                          <ows:Identifier>result</ows:Identifier>                        </wps:RawDataOutput>                      </wps:ResponseForm>                    </wps:Execute>                  </wps:Body>                </wps:Reference>              </wps:Input>            </wps:DataInputs>            <wps:ResponseForm>              <wps:RawDataOutput mimeType='application/wkt'>                <ows:Identifier>result</ows:Identifier>              </wps:RawDataOutput>            </wps:ResponseForm>          </wps:Execute>        </wps:Body>      </wps:Reference>    </wps:Input>  </wps:DataInputs>  <wps:ResponseForm>    <wps:RawDataOutput mimeType='application/xml'>      <ows:Identifier>result</ows:Identifier>    </wps:RawDataOutput>  </wps:ResponseForm></wps:Execute>";
        MockHttpServletResponse resp = this.postAsServletResponse(this.root(), xml);
        Assert.assertEquals((Object)"text/plain", (Object)resp.getContentType());
        Assert.assertTrue((boolean)resp.getContentAsString().startsWith("6334.10838"));
        Object[] expectedNotifications = new String[]{"started JTS:area", "started JTS:union", "started JTS:buffer", "completed JTS:buffer", "started JTS:difference", "completed JTS:difference", "completed JTS:union", "completed JTS:area"};
        Assert.assertNotNull((Object)this.chainedListener);
        Assert.assertArrayEquals((Object[])expectedNotifications, (Object[])this.chainedListener.recorded.toArray());
    }

    @Test
    public void testErroringChainedRequest() throws Exception {
        String xml = "<wps:Execute service='WPS' version='1.0.0'  xmlns:wps='http://www.opengis.net/wps/1.0.0' xmlns:ows='http://www.opengis.net/ows/1.1' xmlns:xlink='http://www.w3.org/1999/xlink'>  <ows:Identifier>JTS:area</ows:Identifier>  <wps:DataInputs>    <wps:Input>      <ows:Identifier>geom</ows:Identifier>      <wps:Reference xlink:href='http://geoserver/wps' method='POST' mimeType='application/xml'>        <wps:Body>          <wps:Execute service='WPS' version='1.0.0'>            <ows:Identifier>JTS:union</ows:Identifier>            <wps:DataInputs>              <wps:Input>                <ows:Identifier>geom</ows:Identifier>                <wps:Reference xlink:href='http://geoserver/wps' method='POST' mimeType='application/xml'>                  <wps:Body>                    <wps:Execute service='WPS' version='1.0.0'>                      <ows:Identifier>JTS:buffer</ows:Identifier>                      <wps:DataInputs>                        <wps:Input>                          <ows:Identifier>geom</ows:Identifier>                          <wps:Data>                            <wps:ComplexData mimeType='application/wkt'>                              <![CDATA[POLYGON((10.0 10.0, 10.0 50.0, 50.0 50.0, 50.0 10.0, 10.0 10.0))]]>                            </wps:ComplexData>                          </wps:Data>                        </wps:Input>                        <wps:Input>                          <ows:Identifier>distance</ows:Identifier>                          <wps:Data>                            <wps:LiteralData>10.0</wps:LiteralData>                          </wps:Data>                        </wps:Input>                      </wps:DataInputs>                      <wps:ResponseForm>                        <wps:RawDataOutput mimeType='application/wkt'>                          <ows:Identifier>result</ows:Identifier>                        </wps:RawDataOutput>                      </wps:ResponseForm>                    </wps:Execute>                  </wps:Body>                </wps:Reference>              </wps:Input>              <wps:Input>                <ows:Identifier>geom</ows:Identifier>                <wps:Reference xlink:href='http://geoserver/wps' method='POST' mimeType='application/xml'>                  <wps:Body>                    <wps:Execute service='WPS' version='1.0.0'>                      <ows:Identifier>JTS:difference</ows:Identifier>                      <wps:DataInputs>                        <wps:Input>                          <ows:Identifier>a</ows:Identifier>                          <wps:Data>                            <wps:ComplexData mimeType='application/wkt'>                              <![CDATA[POLYGON((40.0 40.0, 40.0 100.0, 100.0 100.0, 100.0 40.0, 40.0 40.0))]]>                            </wps:ComplexData>                          </wps:Data>                        </wps:Input>                        <wps:Input>                          <ows:Identifier>b</ows:Identifier>                          <wps:Data>                            <wps:ComplexData mimeType='application/wkt'>                              This is a very very bad WKT                            </wps:ComplexData>                          </wps:Data>                        </wps:Input>                                          </wps:DataInputs>                      <wps:ResponseForm>                        <wps:RawDataOutput mimeType='application/wkt'>                          <ows:Identifier>result</ows:Identifier>                        </wps:RawDataOutput>                      </wps:ResponseForm>                    </wps:Execute>                  </wps:Body>                </wps:Reference>              </wps:Input>            </wps:DataInputs>            <wps:ResponseForm>              <wps:RawDataOutput mimeType='application/wkt'>                <ows:Identifier>result</ows:Identifier>              </wps:RawDataOutput>            </wps:ResponseForm>          </wps:Execute>        </wps:Body>      </wps:Reference>    </wps:Input>  </wps:DataInputs>  <wps:ResponseForm>    <wps:RawDataOutput mimeType='application/xml'>      <ows:Identifier>result</ows:Identifier>    </wps:RawDataOutput>  </wps:ResponseForm></wps:Execute>";
        MockHttpServletResponse resp = this.postAsServletResponse(this.root(), xml);
        Assert.assertEquals((Object)"text/xml", (Object)resp.getContentType());
        Object[] expectedNotifications = new String[]{"started JTS:area", "started JTS:union", "started JTS:buffer", "completed JTS:buffer", "started JTS:difference", "failed JTS:difference", "failed JTS:union", "failed JTS:area"};
        Assert.assertNotNull((Object)this.chainedListener);
        Assert.assertArrayEquals((Object[])expectedNotifications, (Object[])this.chainedListener.recorded.toArray());
    }
}

