/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wps;

import org.custommonkey.xmlunit.XMLAssert;
import org.geoserver.wps.WPSTestSupport;
import org.junit.Test;
import org.w3c.dom.Document;

public class DescribeProcessTest
extends WPSTestSupport {
    @Test
    public void testGetBuffer() throws Exception {
        Document d = this.getAsDOM(this.root() + "service=wps&request=describeprocess&identifier=JTS:buffer");
        this.testBufferDescription(d);
    }

    @Test
    public void testPostBuffer() throws Exception {
        String request = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<DescribeProcess xmlns=\"http://www.opengis.net/wps/1.0.0\" xmlns:ows=\"http://www.opengis.net/ows/1.1\" xmlns:xlink=\"http://www.w3.org/1999/xlink\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">\r\n    <ows:Identifier>JTS:buffer</ows:Identifier>\r\n</DescribeProcess>";
        Document d = this.postAsDOM(this.root(), request);
        this.testBufferDescription(d);
    }

    @Test
    public void testGetBufferFeatureCollection() throws Exception {
        Document d = this.getAsDOM(this.root() + "service=wps&request=describeprocess&identifier=gs:BufferFeatureCollection");
        this.print(d);
        String base = "/wps:ProcessDescriptions/ProcessDescription/DataInputs";
        XMLAssert.assertXpathExists((String)(base + "/Input[1]/ComplexData/Supported/Format[MimeType='application/zip']"), (Document)d);
        XMLAssert.assertXpathEvaluatesTo((String)"base64", (String)(base + "/Input[1]/ComplexData/Supported/Format[MimeType='application/zip']/Encoding"), (Document)d);
    }

    private void testBufferDescription(Document d) throws Exception {
        this.checkValidationErrors(d);
        XMLAssert.assertXpathExists((String)"/wps:ProcessDescriptions", (Document)d);
        XMLAssert.assertXpathEvaluatesTo((String)"true", (String)"//ProcessDescription/@storeSupported", (Document)d);
        XMLAssert.assertXpathEvaluatesTo((String)"true", (String)"//ProcessDescription/@statusSupported", (Document)d);
        String base = "/wps:ProcessDescriptions/ProcessDescription/DataInputs";
        XMLAssert.assertXpathExists((String)(base + "/Input[1]"), (Document)d);
        XMLAssert.assertXpathExists((String)(base + "/Input[1]/ComplexData"), (Document)d);
        XMLAssert.assertXpathEvaluatesTo((String)"text/xml; subtype=gml/3.1.1", (String)(base + "/Input[1]/ComplexData/Default/Format/MimeType/child::text()"), (Document)d);
        XMLAssert.assertXpathEvaluatesTo((String)"text/xml; subtype=gml/3.1.1", (String)(base + "/Input[1]/ComplexData/Supported/Format[1]/MimeType/child::text()"), (Document)d);
        XMLAssert.assertXpathEvaluatesTo((String)"text/xml; subtype=gml/2.1.2", (String)(base + "/Input[1]/ComplexData/Supported/Format[2]/MimeType/child::text()"), (Document)d);
        XMLAssert.assertXpathEvaluatesTo((String)"application/wkt", (String)(base + "/Input[1]/ComplexData/Supported/Format[3]/MimeType/child::text()"), (Document)d);
        XMLAssert.assertXpathExists((String)(base + "/Input[2]"), (Document)d);
        XMLAssert.assertXpathEvaluatesTo((String)"distance", (String)(base + "/Input[2]/ows:Identifier/child::text()"), (Document)d);
        XMLAssert.assertXpathExists((String)(base + "/Input[2]/LiteralData"), (Document)d);
        XMLAssert.assertXpathEvaluatesTo((String)"xs:double", (String)(base + "/Input[2]/LiteralData/ows:DataType/child::text()"), (Document)d);
        base = "/wps:ProcessDescriptions/ProcessDescription/ProcessOutputs";
        XMLAssert.assertXpathExists((String)(base + "/Output"), (Document)d);
        XMLAssert.assertXpathExists((String)(base + "/Output/ComplexOutput"), (Document)d);
    }

    @Test
    public void testBounds() throws Exception {
        Document d = this.getAsDOM(this.root() + "service=wps&request=describeprocess&identifier=gs:Bounds");
        this.checkValidationErrors(d);
        XMLAssert.assertXpathEvaluatesTo((String)"EPSG:4326", (String)"//Output[ows:Identifier='bounds']/BoundingBoxOutput/Default/CRS", (Document)d);
        XMLAssert.assertXpathEvaluatesTo((String)"EPSG:4326", (String)"//Output[ows:Identifier='bounds']/BoundingBoxOutput/Supported/CRS", (Document)d);
    }

    @Test
    public void testDefaultValues() throws Exception {
        Document d = this.getAsDOM(this.root() + "service=wps&request=describeprocess&identifier=gs:GeorectifyCoverage");
        this.checkValidationErrors(d);
        XMLAssert.assertXpathEvaluatesTo((String)"true", (String)"//Input[ows:Identifier='transparent']/LiteralData/DefaultValue", (Document)d);
        XMLAssert.assertXpathEvaluatesTo((String)"false", (String)"//Input[ows:Identifier='store']/LiteralData/DefaultValue", (Document)d);
    }

    @Test
    public void testMultiRaw() throws Exception {
        Document d = this.getAsDOM(this.root() + "service=wps&request=describeprocess&identifier=gs:MultiRaw");
        this.checkValidationErrors(d);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//Input)", (Document)d);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//Input[ows:Identifier='id']/LiteralData)", (Document)d);
        XMLAssert.assertXpathEvaluatesTo((String)"3", (String)"count(//Output)", (Document)d);
        XMLAssert.assertXpathEvaluatesTo((String)"text/plain", (String)"//Output[ows:Identifier='text']/ComplexOutput/Supported/Format/MimeType", (Document)d);
        XMLAssert.assertXpathEvaluatesTo((String)"application/zip", (String)"//Output[ows:Identifier='binary']/ComplexOutput/Supported/Format[1]/MimeType", (Document)d);
        XMLAssert.assertXpathEvaluatesTo((String)"image/png", (String)"//Output[ows:Identifier='binary']/ComplexOutput/Supported/Format[2]/MimeType", (Document)d);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//Output[ows:Identifier='literal']/LiteralOutput)", (Document)d);
    }
}

