/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wps;

import org.geoserver.wps.WPSTestSupport;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.mock.web.MockHttpServletResponse;

public class ExecuteInternalWFSTest
extends WPSTestSupport {
    private static final String WFS10_SchemaURI = "http://www.opengis.net/wfs";
    private static final String WFS20_SchemaURI = "http://www.opengis.net/wfs/2.0";

    @Test
    public void testGetVersion10() throws Exception {
        this.mockXmlPostRequest(this.xml("GET", "1.0"));
    }

    @Test
    public void testPostVersion10() throws Exception {
        this.mockXmlPostRequest(this.xml("POST", "1.0"));
    }

    @Test
    public void testPostVersion20() throws Exception {
        this.mockXmlPostRequest(this.xml("POST", "2.0"));
    }

    @Test
    public void testGetVersion20() throws Exception {
        this.mockXmlPostRequest(this.xml("GET", "2.0"));
    }

    private void mockXmlPostRequest(String xml) throws Exception {
        MockHttpServletResponse response = this.postAsServletResponse(this.root(), xml);
        double area = Double.parseDouble(response.getContentAsString());
        Assert.assertEquals((double)2.195E-6, (double)area, (double)1.0E-9);
    }

    private String xml(String method, String version) {
        String wfsReq = null;
        Object wfsUrl = "http://geoserver/wfs";
        if ("POST".equals(method) && "1.0".equals(version)) {
            wfsReq = "<wfs:GetFeature service=\"WFS\" version=\"1.0.0\" outputFormat=\"GML2\">\n     <wfs:Query typeName=\"cite:Lakes\">\n     </wfs:Query>\n</wfs:GetFeature>\n";
        } else if ("GET".equals(method) && "1.0".equals(version)) {
            wfsUrl = (String)wfsUrl + "?service=WFS&amp;version=1.0.0&amp;request=GetFeature&amp;outputFormat=GML2&amp;typeName=cite:Lakes";
        } else if ("POST".equals(method) && "2.0".equals(version)) {
            wfsReq = "<wfs:GetFeature service=\"WFS\" version=\"2.0.0\" outputFormat=\"GML2\">\n     <wfs:Query typeNames=\"cite:Lakes\">\n     </wfs:Query>\n</wfs:GetFeature>\n";
        } else if ("GET".equals(method) && "2.0".equals(version)) {
            wfsUrl = (String)wfsUrl + "?service=WFS&amp;version=2.0.0&amp;request=GetFeature&amp;outputFormat=GML2&amp;typeNames=cite:Lakes";
        }
        String featuresReference = wfsReq != null ? "                    <wps:Reference mimeType=\"text/xml\" xlink:href=\"" + (String)wfsUrl + "\" method=\"POST\">\n                        <wps:Body>\n" + wfsReq + "                        </wps:Body>\n                    </wps:Reference>\n" : "                    <wps:Reference mimeType=\"text/xml\" xlink:href=\"" + (String)wfsUrl + "\" />\n";
        return "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<wps:Execute version=\"1.0.0\" service=\"WPS\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:wps=\"http://www.opengis.net/wps/1.0.0\"  xmlns:wfs=\"" + ("1.0".equals(version) ? WFS10_SchemaURI : WFS20_SchemaURI) + "\" xmlns:ows=\"http://www.opengis.net/ows/1.1\" xmlns:cite=\"http://www.opengis.net/cite\" xmlns:xlink=\"http://www.w3.org/1999/xlink\" xsi:schemaLocation=\"http://www.opengis.net/wps/1.0.0 http://schemas.opengis.net/wps/1.0.0/wpsAll.xsd\">\n  <ows:Identifier>geo:area</ows:Identifier>\n  <wps:DataInputs>\n    <wps:Input>\n      <ows:Identifier>geom</ows:Identifier>\n      <wps:Reference mimeType=\"application/gml-3.1.1\" xlink:href=\"http://geoserver/wps\" method=\"POST\">\n        <wps:Body>\n          <wps:Execute version=\"1.0.0\" service=\"WPS\">\n            <ows:Identifier>vec:CollectGeometries</ows:Identifier>\n            <wps:DataInputs>\n                <wps:Input>\n                    <ows:Identifier>features</ows:Identifier>\n" + featuresReference + "                </wps:Input>\n            </wps:DataInputs>\n            <wps:ResponseForm>\n                <wps:RawDataOutput mimeType=\"application/gml-3.1.1\">\n                    <ows:Identifier>result</ows:Identifier>\n                </wps:RawDataOutput>\n            </wps:ResponseForm>\n          </wps:Execute>\n        </wps:Body>\n      </wps:Reference>\n    </wps:Input>\n  </wps:DataInputs>\n  <wps:ResponseForm>\n    <wps:RawDataOutput>\n      <ows:Identifier>result</ows:Identifier>\n    </wps:RawDataOutput>\n  </wps:ResponseForm>\n</wps:Execute>\n";
    }
}

