/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wps;

import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingQueue;
import org.geotools.api.util.InternationalString;
import org.geotools.api.util.ProgressListener;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.process.ProcessException;
import org.geotools.process.ProcessFactory;
import org.geotools.process.factory.AnnotatedBeanProcessFactory;
import org.geotools.process.factory.DescribeParameter;
import org.geotools.process.factory.DescribeProcess;
import org.geotools.process.factory.DescribeResult;
import org.geotools.util.SimpleInternationalString;

@DescribeProcess(title="Monkey", description="Process used to test asynch calls")
public class MonkeyProcess {
    static Map<String, BlockingQueue<Command>> commands = new ConcurrentHashMap<String, BlockingQueue<Command>>();

    public static void exit(String id, SimpleFeatureCollection value, boolean wait) throws InterruptedException {
        Command command = new Command(CommandType.Exit, value);
        MonkeyProcess.getCommandQueue(id).put(command);
        if (wait) {
            command.waitFor();
        }
    }

    private static synchronized BlockingQueue<Command> getCommandQueue(String id) {
        BlockingQueue<Command> queue = commands.get(id);
        if (queue == null) {
            queue = new LinkedBlockingQueue<Command>();
            commands.put(id, queue);
        }
        return queue;
    }

    public static void progress(String id, float progress, boolean wait) throws InterruptedException {
        Command command = new Command(CommandType.SetProgress, Float.valueOf(progress));
        MonkeyProcess.getCommandQueue(id).put(command);
        if (wait) {
            command.waitFor();
        }
    }

    public static void wait(String id, long wait) throws InterruptedException {
        MonkeyProcess.getCommandQueue(id).put(new Command(CommandType.Wait, wait));
    }

    public static void exception(String id, ProcessException exception, boolean wait) throws InterruptedException {
        MonkeyProcess.getCommandQueue(id).put(new Command(CommandType.Exception, exception));
        if (wait) {
            while (!MonkeyProcess.getCommandQueue(id).isEmpty()) {
                Thread.sleep(10L);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @DescribeResult(name="result")
    public SimpleFeatureCollection execute(@DescribeParameter(name="id") String id, @DescribeParameter(name="fc", min=0) SimpleFeatureCollection fc, @DescribeParameter(name="extra", min=0) String extra, ProgressListener listener) throws Exception {
        BlockingQueue<Command> queue = MonkeyProcess.getCommandQueue(id);
        while (true) {
            Command command = queue.take();
            try {
                if (command.type == CommandType.Exit) {
                    listener.progress(100.0f);
                    listener.complete();
                    commands.remove(id);
                    SimpleFeatureCollection simpleFeatureCollection = (SimpleFeatureCollection)command.value;
                    return simpleFeatureCollection;
                }
                if (command.type == CommandType.SetProgress) {
                    float progress = ((Number)command.value).floatValue();
                    listener.progress(progress);
                    listener.setTask((InternationalString)new SimpleInternationalString("Currently at " + progress));
                    continue;
                }
                if (command.type == CommandType.Wait) {
                    long wait = ((Number)command.value).longValue();
                    Thread.sleep(wait);
                    continue;
                }
                ProcessException exception = (ProcessException)command.value;
                listener.exceptionOccurred((Throwable)exception);
                throw exception;
            }
            finally {
                command.done();
                continue;
            }
            break;
        }
    }

    public static final ProcessFactory getFactory() {
        return new MonkeyProcessFactory();
    }

    public static void clearCommands() {
        for (Map.Entry<String, BlockingQueue<Command>> entry : commands.entrySet()) {
            if (entry.getValue().isEmpty()) continue;
            throw new IllegalStateException("The command queue is not clean, queue " + entry.getKey() + " still has commands in: " + entry.getValue());
        }
        commands.clear();
    }

    private static class MonkeyProcessFactory
    extends AnnotatedBeanProcessFactory {
        public MonkeyProcessFactory() {
            super((InternationalString)new SimpleInternationalString("Monkey process"), "gs", new Class[]{MonkeyProcess.class});
        }
    }

    private static class Command {
        CommandType type;
        Object value;
        CountDownLatch latch;

        public Command(CommandType type, Object value) {
            this.type = type;
            this.value = value;
            this.latch = new CountDownLatch(1);
        }

        public void done() {
            this.latch.countDown();
        }

        public void waitFor() throws InterruptedException {
            this.latch.await();
        }
    }

    static enum CommandType {
        Exit,
        SetProgress,
        Exception,
        Wait;

    }
}

