/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wps;

import java.util.Collections;
import java.util.List;
import javax.servlet.Filter;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CatalogInfo;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.data.test.MockData;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.security.AccessLimits;
import org.geoserver.security.CatalogMode;
import org.geoserver.security.TestResourceAccessManager;
import org.geoserver.security.VectorAccessLimits;
import org.geoserver.wps.WPSTestSupport;
import org.junit.Assert;
import org.junit.Test;
import org.w3c.dom.Document;

public class ResourceAccessManagerWPSTest
extends WPSTestSupport {
    protected List<Filter> getFilters() {
        return Collections.singletonList((Filter)GeoServerExtensions.bean((String)"filterChainProxy"));
    }

    protected void setUpSpring(List<String> springContextLocations) {
        super.setUpSpring(springContextLocations);
        springContextLocations.add("classpath:/org/geoserver/wps/ResourceAccessManagerContext.xml");
    }

    @Override
    protected void onSetUp(SystemTestData testData) throws Exception {
        super.onSetUp(testData);
        this.addUser("cite", "cite", null, Collections.singletonList("ROLE_DUMMY"));
        TestResourceAccessManager tam = (TestResourceAccessManager)applicationContext.getBean("testResourceAccessManager");
        Catalog catalog = this.getCatalog();
        FeatureTypeInfo buildings = catalog.getFeatureTypeByName(this.getLayerId(SystemTestData.BUILDINGS));
        tam.putLimits("cite", (CatalogInfo)buildings, (AccessLimits)new VectorAccessLimits(CatalogMode.HIDE, null, (org.geotools.api.filter.Filter)org.geotools.api.filter.Filter.INCLUDE, null, null));
        tam.putLimits("anonymous", (CatalogInfo)buildings, (AccessLimits)new VectorAccessLimits(CatalogMode.HIDE, null, (org.geotools.api.filter.Filter)org.geotools.api.filter.Filter.EXCLUDE, null, null));
    }

    @Test
    public void testDenyAccess() throws Exception {
        Document dom = this.runBuildingsRequest();
        Assert.assertEquals((Object)"1", (Object)xp.evaluate("count(//wps:ProcessFailed)", dom));
        Assert.assertEquals((Object)"0", (Object)xp.evaluate("count(//wps:ProcessSucceded)", dom));
    }

    @Test
    public void testAllowAccess() throws Exception {
        this.setRequestAuth("cite", "cite");
        Document dom = this.runBuildingsRequest();
        Assert.assertEquals((Object)"0", (Object)xp.evaluate("count(//wps:ProcessFailed)", dom));
        Assert.assertEquals((Object)"1", (Object)xp.evaluate("count(//wps:ProcessSucceeded)", dom));
        String[] lc = xp.evaluate("//wps:Output[ows:Identifier = 'bounds']/wps:Data/wps:BoundingBoxData/ows:LowerCorner", dom).split("\\s+");
        Assert.assertEquals((double)8.0E-4, (double)Double.parseDouble(lc[0]), (double)0.0);
        Assert.assertEquals((double)5.0E-4, (double)Double.parseDouble(lc[1]), (double)0.0);
        String[] uc = xp.evaluate("//wps:Output[ows:Identifier = 'bounds']/wps:Data/wps:BoundingBoxData/ows:UpperCorner", dom).split("\\s+");
        Assert.assertEquals((double)0.0024, (double)Double.parseDouble(uc[0]), (double)0.0);
        Assert.assertEquals((double)0.001, (double)Double.parseDouble(uc[1]), (double)0.0);
    }

    private Document runBuildingsRequest() throws Exception {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<wps:Execute version=\"1.0.0\" service=\"WPS\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns=\"http://www.opengis.net/wps/1.0.0\" xmlns:wfs=\"http://www.opengis.net/wfs\" xmlns:wps=\"http://www.opengis.net/wps/1.0.0\" xmlns:ows=\"http://www.opengis.net/ows/1.1\" xmlns:gml=\"http://www.opengis.net/gml\" xmlns:ogc=\"http://www.opengis.net/ogc\" xmlns:wcs=\"http://www.opengis.net/wcs/1.1.1\" xmlns:xlink=\"http://www.w3.org/1999/xlink\" xsi:schemaLocation=\"http://www.opengis.net/wps/1.0.0 http://schemas.opengis.net/wps/1.0.0/wpsAll.xsd\">\n  <ows:Identifier>gs:Bounds</ows:Identifier>\n  <wps:DataInputs>\n    <wps:Input>\n      <ows:Identifier>features</ows:Identifier>\n      <wps:Reference mimeType=\"text/xml; subtype=wfs-collection/1.0\" xlink:href=\"http://geoserver/wfs\" method=\"POST\">\n        <wps:Body>\n          <wfs:GetFeature service=\"WFS\" version=\"1.0.0\" outputFormat=\"GML2\">\n            <wfs:Query typeName=\"" + this.getLayerId(MockData.BUILDINGS) + "\"/>\n          </wfs:GetFeature>\n        </wps:Body>\n      </wps:Reference>\n    </wps:Input>\n  </wps:DataInputs>\n  <wps:ResponseForm>\n    <wps:Output>\n      <ows:Identifier>result</ows:Identifier>\n    </wps:Output>\n </wps:ResponseForm>\n</wps:Execute>";
        Document dom = this.postAsDOM("wps", xml);
        return dom;
    }
}

