/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wps;

import java.util.ArrayList;
import java.util.List;
import org.easymock.EasyMock;
import org.easymock.IArgumentMatcher;
import org.easymock.internal.LastControl;
import org.geoserver.config.ConfigurationListener;
import org.geoserver.config.GeoServer;
import org.geoserver.config.ServiceInfo;
import org.geoserver.platform.GeoServerResourceLoader;
import org.geoserver.wps.WPSInfo;
import org.geoserver.wps.WPSInitializer;
import org.geoserver.wps.WPSStorageCleaner;
import org.geoserver.wps.executor.DefaultProcessManager;
import org.geoserver.wps.executor.WPSExecutionManager;
import org.geoserver.wps.resource.ProcessArtifactsStore;
import org.geoserver.wps.resource.WPSResourceManager;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class WPSInitializerTest {
    WPSInitializer initer;

    @Before
    public void mockUp() {
        WPSExecutionManager execMgr = (WPSExecutionManager)EasyMock.createNiceMock(WPSExecutionManager.class);
        DefaultProcessManager procMgr = (DefaultProcessManager)EasyMock.createNiceMock(DefaultProcessManager.class);
        WPSStorageCleaner cleaner = (WPSStorageCleaner)EasyMock.createNiceMock(WPSStorageCleaner.class);
        WPSResourceManager resources = (WPSResourceManager)EasyMock.createNiceMock(WPSResourceManager.class);
        EasyMock.expect((Object)resources.getArtifactsStore()).andReturn((Object)((ProcessArtifactsStore)EasyMock.createNiceMock(ProcessArtifactsStore.class))).anyTimes();
        EasyMock.replay((Object[])new Object[]{resources});
        GeoServerResourceLoader loader = (GeoServerResourceLoader)EasyMock.createNiceMock(GeoServerResourceLoader.class);
        EasyMock.replay((Object[])new Object[]{execMgr, procMgr, cleaner});
        this.initer = new WPSInitializer(execMgr, procMgr, cleaner, resources, loader);
    }

    @Test
    public void testNoSave() throws Exception {
        GeoServer gs = (GeoServer)EasyMock.createMock(GeoServer.class);
        ArrayList<ConfigurationListener> listeners = new ArrayList<ConfigurationListener>();
        gs.addListener(this.capture(listeners));
        EasyMock.expectLastCall().atLeastOnce();
        List procGroups = WPSInitializer.lookupProcessGroups();
        WPSInfo wps = (WPSInfo)EasyMock.createNiceMock(WPSInfo.class);
        EasyMock.expect((Object)wps.getProcessGroups()).andReturn((Object)procGroups).anyTimes();
        EasyMock.replay((Object[])new Object[]{wps});
        EasyMock.expect((Object)((WPSInfo)gs.getService(WPSInfo.class))).andReturn((Object)wps).anyTimes();
        EasyMock.replay((Object[])new Object[]{gs});
        this.initer.initialize(gs);
        Assert.assertEquals((long)1L, (long)listeners.size());
        ConfigurationListener l = (ConfigurationListener)listeners.get(0);
        l.handleGlobalChange(null, null, null, null);
        l.handlePostGlobalChange(null);
        EasyMock.verify((Object[])new Object[]{gs});
    }

    @Test
    public void testSingleSave() throws Exception {
        GeoServer gs = (GeoServer)EasyMock.createMock(GeoServer.class);
        ArrayList<ConfigurationListener> listeners = new ArrayList<ConfigurationListener>();
        gs.addListener(this.capture(listeners));
        EasyMock.expectLastCall().atLeastOnce();
        ArrayList procGroups = new ArrayList();
        WPSInfo wps = (WPSInfo)EasyMock.createNiceMock(WPSInfo.class);
        EasyMock.expect((Object)wps.getProcessGroups()).andReturn(procGroups).anyTimes();
        EasyMock.replay((Object[])new Object[]{wps});
        EasyMock.expect((Object)((WPSInfo)gs.getService(WPSInfo.class))).andReturn((Object)wps).anyTimes();
        gs.save((ServiceInfo)wps);
        EasyMock.expectLastCall().once();
        EasyMock.replay((Object[])new Object[]{gs});
        this.initer.initialize(gs);
        Assert.assertEquals((long)1L, (long)listeners.size());
        ConfigurationListener l = (ConfigurationListener)listeners.get(0);
        l.handleGlobalChange(null, null, null, null);
        l.handlePostGlobalChange(null);
        EasyMock.verify((Object[])new Object[]{gs});
    }

    @Test
    public void testReloadSave() throws Exception {
        GeoServer gs = (GeoServer)EasyMock.createMock(GeoServer.class);
        ArrayList<ConfigurationListener> listeners = new ArrayList<ConfigurationListener>();
        gs.addListener(this.capture(listeners));
        EasyMock.expectLastCall().atLeastOnce();
        gs.removeListener(this.release(listeners));
        EasyMock.expectLastCall().atLeastOnce();
        List procGroups = WPSInitializer.lookupProcessGroups();
        WPSInfo wps = (WPSInfo)EasyMock.createNiceMock(WPSInfo.class);
        EasyMock.expect((Object)wps.getProcessGroups()).andReturn((Object)procGroups).anyTimes();
        EasyMock.replay((Object[])new Object[]{wps});
        EasyMock.expect((Object)((WPSInfo)gs.getService(WPSInfo.class))).andReturn((Object)wps).anyTimes();
        EasyMock.replay((Object[])new Object[]{gs});
        this.initer.initialize(gs);
        Assert.assertEquals((long)1L, (long)listeners.size());
        ConfigurationListener l = (ConfigurationListener)listeners.get(0);
        this.initer.beforeReinitialize(gs);
        Assert.assertEquals((long)0L, (long)listeners.size());
        l.handleGlobalChange(null, null, null, null);
        l.handlePostGlobalChange(null);
        this.initer.reinitialize(gs);
        Assert.assertEquals((long)1L, (long)listeners.size());
        EasyMock.verify((Object[])new Object[]{gs});
    }

    ConfigurationListener capture(List<ConfigurationListener> listeners) {
        LastControl.reportMatcher((IArgumentMatcher)new ListenerCapture(listeners, true));
        return null;
    }

    ConfigurationListener release(List<ConfigurationListener> listeners) {
        LastControl.reportMatcher((IArgumentMatcher)new ListenerCapture(listeners, false));
        return null;
    }

    static class ListenerCapture
    implements IArgumentMatcher {
        List<ConfigurationListener> listeners;
        boolean add;

        public ListenerCapture(List<ConfigurationListener> listeners, boolean add) {
            this.listeners = listeners;
            this.add = add;
        }

        public boolean matches(Object argument) {
            if (argument instanceof ConfigurationListener) {
                if (this.add) {
                    this.listeners.add((ConfigurationListener)argument);
                } else {
                    this.listeners.remove((ConfigurationListener)argument);
                }
                return true;
            }
            return false;
        }

        public void appendTo(StringBuffer buffer) {
            buffer.append("ListenerCapture");
        }
    }
}

