/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wps.executor;

import com.github.tomakehurst.wiremock.client.ResponseDefinitionBuilder;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.core.Options;
import com.github.tomakehurst.wiremock.core.WireMockConfiguration;
import com.github.tomakehurst.wiremock.http.ssl.SSLContextBuilder;
import com.github.tomakehurst.wiremock.http.ssl.TrustEverythingStrategy;
import com.github.tomakehurst.wiremock.http.ssl.TrustStrategy;
import com.github.tomakehurst.wiremock.junit.WireMockClassRule;
import com.github.tomakehurst.wiremock.matching.ContentPattern;
import com.github.tomakehurst.wiremock.matching.RequestPatternBuilder;
import com.github.tomakehurst.wiremock.matching.UrlPattern;
import com.google.common.base.MoreObjects;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Objects;
import javax.net.ssl.HostnameVerifier;
import net.opengis.wps10.BodyReferenceType;
import net.opengis.wps10.HeaderType;
import net.opengis.wps10.InputReferenceType;
import net.opengis.wps10.InputType;
import net.opengis.wps10.MethodType;
import net.opengis.wps10.Wps10Factory;
import org.apache.commons.io.IOUtils;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.geoserver.ows.Ows11Util;
import org.geoserver.wps.ProcessDismissedException;
import org.geoserver.wps.WPSException;
import org.geoserver.wps.executor.LazyInputMap;
import org.geoserver.wps.executor.RemoteRequestInputProvider;
import org.geoserver.wps.ppio.ComplexPPIO;
import org.geotools.api.util.ProgressListener;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class RemoteRequestInputProviderTest {
    @ClassRule
    public static WireMockClassRule classRule = new WireMockClassRule((Options)WireMockConfiguration.options().dynamicPort().dynamicHttpsPort());
    @Rule
    public WireMockClassRule service = classRule;
    private ProgressListener listener;

    @BeforeClass
    public static void setSocketFactory() throws Exception {
        RemoteRequestInputProvider.setSocketFactory((LayeredConnectionSocketFactory)new SSLConnectionSocketFactory(SSLContextBuilder.create().loadTrustMaterial(null, (TrustStrategy)new TrustEverythingStrategy()).build(), (HostnameVerifier)NoopHostnameVerifier.INSTANCE));
    }

    @Before
    public void setListener() {
        this.listener = (ProgressListener)Mockito.mock(ProgressListener.class);
    }

    @AfterClass
    public static void clearSocketFactory() {
        RemoteRequestInputProvider.setSocketFactory(null);
    }

    @Test
    public void testNullResult() throws Exception {
        InputType input = RemoteRequestInputProviderTest.input(this.file("test.txt"), null, null, null, new String[0]);
        ComplexPPIO ppio = new ComplexPPIO(null, null, null){

            public Object decode(InputStream input) throws Exception {
                return null;
            }

            public void encode(Object value, OutputStream os) {
            }
        };
        Assert.assertNull((Object)this.getValue(input, ppio, 0, 0L));
    }

    @Test
    public void testIncorrectResultType() throws Exception {
        InputType input = RemoteRequestInputProviderTest.input(this.file("test.txt"), null, null, null, new String[0]);
        String message = "Failed to retrieve value for input testInput";
        this.assertException(input, RemoteRequestInputProviderTest.ppio(Number.class, null), 0, 0L, message, IllegalArgumentException.class, new RequestPatternBuilder[0]);
    }

    @Test
    public void testFileUrlValidWithoutMaxSize() throws Exception {
        InputType input = RemoteRequestInputProviderTest.input(this.file("test.txt"), null, null, null, new String[0]);
        this.assertValue(input, RemoteRequestInputProviderTest.ppio(), 0, 0L, "TEST", new RequestPatternBuilder[0]);
    }

    @Test
    public void testFileUrlValidWithMaxSize() throws Exception {
        InputType input = RemoteRequestInputProviderTest.input(this.file("test.txt"), null, null, null, new String[0]);
        this.assertValue(input, RemoteRequestInputProviderTest.ppio(), 0, 100L, "TEST", new RequestPatternBuilder[0]);
    }

    @Test
    public void testFileUrlInvalidTooBig() throws Exception {
        InputType input = RemoteRequestInputProviderTest.input(this.file("test.txt"), null, null, null, new String[0]);
        String message = "Input testInput size 4 exceeds maximum allowed size of 1";
        this.assertException(input, RemoteRequestInputProviderTest.ppio(), 0, 1L, message, null, new RequestPatternBuilder[0]);
    }

    @Test
    public void testFileUrlInvalidMissingFile() throws Exception {
        URL url = new URL(this.file("test.txt").toString().replace("test.txt", "missing.txt"));
        InputType input = RemoteRequestInputProviderTest.input(url, null, null, null, new String[0]);
        String message = "Failed to retrieve value for input testInput";
        this.assertException(input, RemoteRequestInputProviderTest.ppio(), 0, 0L, message, IOException.class, new RequestPatternBuilder[0]);
    }

    @Test
    public void testFileUrlInvalidCanceled() throws Exception {
        Mockito.when((Object)this.listener.isCanceled()).thenReturn((Object)false, (Object[])new Boolean[]{true});
        InputType input = RemoteRequestInputProviderTest.input(this.file("test.txt"), null, null, null, new String[0]);
        String message = "Failed to retrieve value for input testInput";
        this.assertException(input, RemoteRequestInputProviderTest.ppio(), 0, 0L, message, ProcessDismissedException.class, new RequestPatternBuilder[0]);
    }

    @Test
    public void testOtherUrlValidWithoutMaxSize() throws Exception {
        InputType input = RemoteRequestInputProviderTest.input(this.jar("test"), null, null, null, new String[0]);
        this.assertValue(input, RemoteRequestInputProviderTest.ppio(), 0, 0L, "TEST", new RequestPatternBuilder[0]);
    }

    @Test
    public void testOtherUrlValidWithMaxSize() throws Exception {
        InputType input = RemoteRequestInputProviderTest.input(this.jar("test"), null, null, null, new String[0]);
        this.assertValue(input, RemoteRequestInputProviderTest.ppio(), 0, 100L, "TEST", new RequestPatternBuilder[0]);
    }

    @Test
    public void testOtherUrlInvalidTooBig() throws Exception {
        InputType input = RemoteRequestInputProviderTest.input(this.jar("test"), null, null, null, new String[0]);
        String message = "Exceeded maximum input size of 1 bytes while reading input testInput";
        this.assertException(input, RemoteRequestInputProviderTest.ppio(), 0, 1L, message, null, new RequestPatternBuilder[0]);
    }

    @Test
    public void testOtherUrlInvalidMissingFile() throws Exception {
        URL url = new URL(this.jar("test").toString().replace("test.zip", "missing.zip"));
        InputType input = RemoteRequestInputProviderTest.input(url, null, null, null, new String[0]);
        String message = "Failed to retrieve value for input testInput";
        this.assertException(input, RemoteRequestInputProviderTest.ppio(), 0, 0L, message, IOException.class, new RequestPatternBuilder[0]);
    }

    @Test
    public void testOtherUrlInvalidCanceled() throws Exception {
        Mockito.when((Object)this.listener.isCanceled()).thenReturn((Object)false, (Object[])new Boolean[]{true});
        InputType input = RemoteRequestInputProviderTest.input(this.jar("test"), null, null, null, new String[0]);
        String message = "Failed to retrieve value for input testInput";
        this.assertException(input, RemoteRequestInputProviderTest.ppio(), 0, 0L, message, ProcessDismissedException.class, new RequestPatternBuilder[0]);
    }

    @Test
    public void testHttpNoMethodInvalidBadStatus() throws Exception {
        this.doTestHttpInvalidBadStatus(this.http("test"), null, null);
    }

    @Test
    public void testHttpGetInvalidBadStatus() throws Exception {
        this.doTestHttpInvalidBadStatus(this.http("test"), MethodType.GET_LITERAL, null);
    }

    @Test
    public void testHttpPostBodyInvalidBadStatus() throws Exception {
        this.doTestHttpInvalidBadStatus(this.http("test"), MethodType.POST_LITERAL, null);
    }

    @Test
    public void testHttpPostRefFileInvalidBadStatus() throws Exception {
        this.doTestHttpInvalidBadStatus(this.http("test"), MethodType.POST_LITERAL, this.file("foo.txt"));
    }

    @Test
    public void testHttpPostRefOtherInvalidBadStatus() throws Exception {
        this.doTestHttpInvalidBadStatus(this.http("test"), MethodType.POST_LITERAL, this.jar("foo"));
    }

    @Test
    public void testHttpPostRefHttpInvalidBadStatus() throws Exception {
        this.doTestHttpInvalidBadStatus(this.http("test"), MethodType.POST_LITERAL, this.http("foo"));
    }

    @Test
    public void testHttpPostRefHttpsInvalidBadStatus() throws Exception {
        this.doTestHttpInvalidBadStatus(this.http("test"), MethodType.POST_LITERAL, this.https("foo"));
    }

    @Test
    public void testHttpsNoMethodInvalidBadStatus() throws Exception {
        this.doTestHttpInvalidBadStatus(this.https("test"), null, null);
    }

    @Test
    public void testHttpsGetInvalidBadStatus() throws Exception {
        this.doTestHttpInvalidBadStatus(this.https("test"), MethodType.GET_LITERAL, null);
    }

    @Test
    public void testHttpsPostBodyInvalidBadStatus() throws Exception {
        this.doTestHttpInvalidBadStatus(this.https("test"), MethodType.POST_LITERAL, null);
    }

    @Test
    public void testHttpsPostRefFileInvalidBadStatus() throws Exception {
        this.doTestHttpInvalidBadStatus(this.https("test"), MethodType.POST_LITERAL, this.file("foo.txt"));
    }

    @Test
    public void testHttpsPostRefOtherInvalidBadStatus() throws Exception {
        this.doTestHttpInvalidBadStatus(this.https("test"), MethodType.POST_LITERAL, this.jar("foo"));
    }

    @Test
    public void testHttpsPostRefHttpInvalidBadStatus() throws Exception {
        this.doTestHttpInvalidBadStatus(this.https("test"), MethodType.POST_LITERAL, this.http("foo"));
    }

    @Test
    public void testHttpsPostRefHttpsInvalidBadStatus() throws Exception {
        this.doTestHttpInvalidBadStatus(this.https("test"), MethodType.POST_LITERAL, this.https("foo"));
    }

    private void doTestHttpInvalidBadStatus(URL url, MethodType method, URL bodyUrl) throws Exception {
        String auth = "Basic YWxhZGRpbjpvcGVuc2VzYW1l";
        this.stub(WireMock.forbidden(), bodyUrl, WireMock.ok((String)"FOO"));
        InputType input = RemoteRequestInputProviderTest.input(url, method, "FOO", bodyUrl, "Authorization", auth);
        this.assertException(input, RemoteRequestInputProviderTest.ppio(), 0, 0L, "Failed to retrieve value for input testInput", IllegalStateException.class, RemoteRequestInputProviderTest.request(input).withHeader("Authorization", WireMock.equalTo((String)auth)), RemoteRequestInputProviderTest.bodyRequest(input));
    }

    @Test
    public void testHttpNoMethodValidWithoutMaxSize() throws Exception {
        this.doTestHttpValidWithoutMaxSize(this.http("test"), null, null);
    }

    @Test
    public void testHttpGetValidWithoutMaxSize() throws Exception {
        this.doTestHttpValidWithoutMaxSize(this.http("test"), MethodType.GET_LITERAL, null);
    }

    @Test
    public void testHttpPostBodyValidWithoutMaxSize() throws Exception {
        this.doTestHttpValidWithoutMaxSize(this.http("test"), MethodType.POST_LITERAL, null);
    }

    @Test
    public void testHttpPostRefFileValidWithoutMaxSize() throws Exception {
        this.doTestHttpValidWithoutMaxSize(this.http("test"), MethodType.POST_LITERAL, this.file("foo.txt"));
    }

    @Test
    public void testHttpPostRefOtherValidWithoutMaxSize() throws Exception {
        this.doTestHttpValidWithoutMaxSize(this.http("test"), MethodType.POST_LITERAL, this.jar("foo"));
    }

    @Test
    public void testHttpPostRefHttpValidWithoutMaxSize() throws Exception {
        this.doTestHttpValidWithoutMaxSize(this.http("test"), MethodType.POST_LITERAL, this.http("foo"));
    }

    @Test
    public void testHttpPostRefHttpsValidWithoutMaxSize() throws Exception {
        this.doTestHttpValidWithoutMaxSize(this.http("test"), MethodType.POST_LITERAL, this.https("foo"));
    }

    @Test
    public void testHttpsNoMethodValidWithoutMaxSize() throws Exception {
        this.doTestHttpValidWithoutMaxSize(this.https("test"), null, null);
    }

    @Test
    public void testHttpsGetValidWithoutMaxSize() throws Exception {
        this.doTestHttpValidWithoutMaxSize(this.https("test"), MethodType.GET_LITERAL, null);
    }

    @Test
    public void testHttpsPostBodyValidWithoutMaxSize() throws Exception {
        this.doTestHttpValidWithoutMaxSize(this.https("test"), MethodType.POST_LITERAL, null);
    }

    @Test
    public void testHttpsPostRefFileValidWithoutMaxSize() throws Exception {
        this.doTestHttpValidWithoutMaxSize(this.https("test"), MethodType.POST_LITERAL, this.file("foo.txt"));
    }

    @Test
    public void testHttpsPostRefOtherValidWithoutMaxSize() throws Exception {
        this.doTestHttpValidWithoutMaxSize(this.https("test"), MethodType.POST_LITERAL, this.jar("foo"));
    }

    @Test
    public void testHttpsPostRefHttpValidWithoutMaxSize() throws Exception {
        this.doTestHttpValidWithoutMaxSize(this.https("test"), MethodType.POST_LITERAL, this.http("foo"));
    }

    @Test
    public void testHttpsPostRefHttpsValidWithoutMaxSize() throws Exception {
        this.doTestHttpValidWithoutMaxSize(this.https("test"), MethodType.POST_LITERAL, this.https("foo"));
    }

    private void doTestHttpValidWithoutMaxSize(URL url, MethodType method, URL bodyUrl) throws Exception {
        this.stub(WireMock.ok((String)"TEST"), bodyUrl, WireMock.ok((String)"FOO"));
        InputType input = RemoteRequestInputProviderTest.input(url, method, "FOO", bodyUrl, new String[0]);
        this.assertValue(input, RemoteRequestInputProviderTest.ppio(), 0, 0L, "TEST", RemoteRequestInputProviderTest.request(input), RemoteRequestInputProviderTest.bodyRequest(input));
    }

    @Test
    public void testHttpNoMethodValidWithoutContentLength() throws Exception {
        this.doTestHttpValidWithoutContentLength(this.http("test"), null, null);
    }

    @Test
    public void testHttpGetValidWithoutContentLength() throws Exception {
        this.doTestHttpValidWithoutContentLength(this.http("test"), MethodType.GET_LITERAL, null);
    }

    @Test
    public void testHttpPostBodyValidWithoutContentLength() throws Exception {
        this.doTestHttpValidWithoutContentLength(this.http("test"), MethodType.POST_LITERAL, null);
    }

    @Test
    public void testHttpPostRefFileValidWithoutContentLength() throws Exception {
        this.doTestHttpValidWithoutContentLength(this.http("test"), MethodType.POST_LITERAL, this.file("foo.txt"));
    }

    @Test
    public void testHttpPostRefOtherValidWithoutContentLength() throws Exception {
        this.doTestHttpValidWithoutContentLength(this.http("test"), MethodType.POST_LITERAL, this.jar("foo"));
    }

    @Test
    public void testHttpPostRefHttpValidWithoutContentLength() throws Exception {
        this.doTestHttpValidWithoutContentLength(this.http("test"), MethodType.POST_LITERAL, this.http("foo"));
    }

    @Test
    public void testHttpPostRefHttpsValidWithoutContentLength() throws Exception {
        this.doTestHttpValidWithoutContentLength(this.http("test"), MethodType.POST_LITERAL, this.https("foo"));
    }

    @Test
    public void testHttpsNoMethodValidWithoutContentLength() throws Exception {
        this.doTestHttpValidWithoutContentLength(this.https("test"), null, null);
    }

    @Test
    public void testHttpsGetValidWithoutContentLength() throws Exception {
        this.doTestHttpValidWithoutContentLength(this.https("test"), MethodType.GET_LITERAL, null);
    }

    @Test
    public void testHttpsPostBodyValidWithoutContentLength() throws Exception {
        this.doTestHttpValidWithoutContentLength(this.https("test"), MethodType.POST_LITERAL, null);
    }

    @Test
    public void testHttpsPostRefFileValidWithoutContentLength() throws Exception {
        this.doTestHttpValidWithoutContentLength(this.https("test"), MethodType.POST_LITERAL, this.file("foo.txt"));
    }

    @Test
    public void testHttpsPostRefOtherValidWithoutContentLength() throws Exception {
        this.doTestHttpValidWithoutContentLength(this.https("test"), MethodType.POST_LITERAL, this.jar("foo"));
    }

    @Test
    public void testHttpsPostRefHttpValidWithoutContentLength() throws Exception {
        this.doTestHttpValidWithoutContentLength(this.https("test"), MethodType.POST_LITERAL, this.http("foo"));
    }

    @Test
    public void testHttpsPostRefHttpsValidWithoutContentLength() throws Exception {
        this.doTestHttpValidWithoutContentLength(this.https("test"), MethodType.POST_LITERAL, this.https("foo"));
    }

    private void doTestHttpValidWithoutContentLength(URL url, MethodType method, URL bodyUrl) throws Exception {
        this.stub(WireMock.ok((String)"TEST"), bodyUrl, WireMock.ok((String)"FOO"));
        InputType input = RemoteRequestInputProviderTest.input(url, method, "FOO", bodyUrl, new String[0]);
        this.assertValue(input, RemoteRequestInputProviderTest.ppio(), 0, 100L, "TEST", RemoteRequestInputProviderTest.request(input), RemoteRequestInputProviderTest.bodyRequest(input));
    }

    @Test
    public void testHttpNoMethodValidWithMaxSizeAndContentLength() throws Exception {
        this.doTestHttpValidWithMaxSizeAndContentLength(this.http("test"), null, null);
    }

    @Test
    public void testHttpGetValidWithMaxSizeAndContentLength() throws Exception {
        this.doTestHttpValidWithMaxSizeAndContentLength(this.http("test"), MethodType.GET_LITERAL, null);
    }

    @Test
    public void testHttpPostBodyValidWithMaxSizeAndContentLength() throws Exception {
        this.doTestHttpValidWithMaxSizeAndContentLength(this.http("test"), MethodType.POST_LITERAL, null);
    }

    @Test
    public void testHttpPostRefFileValidWithMaxSizeAndContentLength() throws Exception {
        this.doTestHttpValidWithMaxSizeAndContentLength(this.http("test"), MethodType.POST_LITERAL, this.file("foo.txt"));
    }

    @Test
    public void testHttpPostRefOtherValidWithMaxSizeAndContentLength() throws Exception {
        this.doTestHttpValidWithMaxSizeAndContentLength(this.http("test"), MethodType.POST_LITERAL, this.jar("foo"));
    }

    @Test
    public void testHttpPostRefHttpValidWithMaxSizeAndContentLength() throws Exception {
        this.doTestHttpValidWithMaxSizeAndContentLength(this.http("test"), MethodType.POST_LITERAL, this.http("foo"));
    }

    @Test
    public void testHttpPostRefHttpsValidWithMaxSizeAndContentLength() throws Exception {
        this.doTestHttpValidWithMaxSizeAndContentLength(this.http("test"), MethodType.POST_LITERAL, this.https("foo"));
    }

    @Test
    public void testHttpsNoMethodValidWithMaxSizeAndContentLength() throws Exception {
        this.doTestHttpValidWithMaxSizeAndContentLength(this.https("test"), null, null);
    }

    @Test
    public void testHttpsGetValidWithMaxSizeAndContentLength() throws Exception {
        this.doTestHttpValidWithMaxSizeAndContentLength(this.https("test"), MethodType.GET_LITERAL, null);
    }

    @Test
    public void testHttpsPostBodyValidWithMaxSizeAndContentLength() throws Exception {
        this.doTestHttpValidWithMaxSizeAndContentLength(this.https("test"), MethodType.POST_LITERAL, null);
    }

    @Test
    public void testHttpsPostRefFileValidWithMaxSizeAndContentLength() throws Exception {
        this.doTestHttpValidWithMaxSizeAndContentLength(this.https("test"), MethodType.POST_LITERAL, this.file("foo.txt"));
    }

    @Test
    public void testHttpsPostRefOtherValidWithMaxSizeAndContentLength() throws Exception {
        this.doTestHttpValidWithMaxSizeAndContentLength(this.https("test"), MethodType.POST_LITERAL, this.jar("foo"));
    }

    @Test
    public void testHttpsPostRefHttpValidWithMaxSizeAndContentLength() throws Exception {
        this.doTestHttpValidWithMaxSizeAndContentLength(this.https("test"), MethodType.POST_LITERAL, this.http("foo"));
    }

    @Test
    public void testHttpsPostRefHttpsValidWithMaxSizeAndContentLength() throws Exception {
        this.doTestHttpValidWithMaxSizeAndContentLength(this.https("test"), MethodType.POST_LITERAL, this.https("foo"));
    }

    private void doTestHttpValidWithMaxSizeAndContentLength(URL url, MethodType method, URL bodyUrl) throws Exception {
        this.stub(WireMock.ok((String)"TEST").withHeader("Content-Length", new String[]{"4"}), bodyUrl, WireMock.ok((String)"FOO"));
        InputType input = RemoteRequestInputProviderTest.input(url, method, "FOO", bodyUrl, new String[0]);
        this.assertValue(input, RemoteRequestInputProviderTest.ppio(), 0, 100L, "TEST", RemoteRequestInputProviderTest.request(input), RemoteRequestInputProviderTest.bodyRequest(input));
    }

    @Test
    public void testHttpNoMethodInvalidTooBigWithoutContentLength() throws Exception {
        this.doTestHttpInvalidTooBigWithoutContentLength(this.http("test"), null, null);
    }

    @Test
    public void testHttpGetValidInvalidTooBigWithoutContentLength() throws Exception {
        this.doTestHttpInvalidTooBigWithoutContentLength(this.http("test"), MethodType.GET_LITERAL, null);
    }

    @Test
    public void testHttpPostBodyInvalidTooBigWithoutContentLength() throws Exception {
        this.doTestHttpInvalidTooBigWithoutContentLength(this.http("test"), MethodType.POST_LITERAL, null);
    }

    @Test
    public void testHttpPostRefFileInvalidTooBigWithoutContentLength() throws Exception {
        this.doTestHttpInvalidTooBigWithoutContentLength(this.http("test"), MethodType.POST_LITERAL, this.file("foo.txt"));
    }

    @Test
    public void testHttpPostRefOtherInvalidTooBigWithoutContentLength() throws Exception {
        this.doTestHttpInvalidTooBigWithoutContentLength(this.http("test"), MethodType.POST_LITERAL, this.jar("foo"));
    }

    @Test
    public void testHttpPostRefHttpInvalidTooBigWithoutContentLength() throws Exception {
        this.doTestHttpInvalidTooBigWithoutContentLength(this.http("test"), MethodType.POST_LITERAL, this.http("foo"));
    }

    @Test
    public void testHttpPostRefHttpsInvalidTooBigWithoutContentLength() throws Exception {
        this.doTestHttpInvalidTooBigWithoutContentLength(this.http("test"), MethodType.POST_LITERAL, this.https("foo"));
    }

    @Test
    public void testHttpsNoMethodInvalidTooBigWithoutContentLength() throws Exception {
        this.doTestHttpInvalidTooBigWithoutContentLength(this.https("test"), null, null);
    }

    @Test
    public void testHttpsGetValidInvalidTooBigWithoutContentLength() throws Exception {
        this.doTestHttpInvalidTooBigWithoutContentLength(this.https("test"), MethodType.GET_LITERAL, null);
    }

    @Test
    public void testHttpsPostBodyInvalidTooBigWithoutContentLength() throws Exception {
        this.doTestHttpInvalidTooBigWithoutContentLength(this.https("test"), MethodType.POST_LITERAL, null);
    }

    @Test
    public void testHttpsPostRefFileInvalidTooBigWithoutContentLength() throws Exception {
        this.doTestHttpInvalidTooBigWithoutContentLength(this.https("test"), MethodType.POST_LITERAL, this.file("foo.txt"));
    }

    @Test
    public void testHttpsPostRefOtherInvalidTooBigWithoutContentLength() throws Exception {
        this.doTestHttpInvalidTooBigWithoutContentLength(this.https("test"), MethodType.POST_LITERAL, this.jar("foo"));
    }

    @Test
    public void testHttpsPostRefHttpInvalidTooBigWithoutContentLength() throws Exception {
        this.doTestHttpInvalidTooBigWithoutContentLength(this.https("test"), MethodType.POST_LITERAL, this.http("foo"));
    }

    @Test
    public void testHttpsPostRefHttpsInvalidTooBigWithoutContentLength() throws Exception {
        this.doTestHttpInvalidTooBigWithoutContentLength(this.https("test"), MethodType.POST_LITERAL, this.https("foo"));
    }

    private void doTestHttpInvalidTooBigWithoutContentLength(URL url, MethodType method, URL bodyUrl) throws Exception {
        this.stub(WireMock.ok((String)"TEST"), bodyUrl, WireMock.ok((String)"FOO"));
        InputType input = RemoteRequestInputProviderTest.input(url, method, "FOO", bodyUrl, new String[0]);
        String message = "Exceeded maximum input size of 3 bytes while reading input testInput";
        this.assertException(input, RemoteRequestInputProviderTest.ppio(), 0, 3L, message, null, RemoteRequestInputProviderTest.request(input), RemoteRequestInputProviderTest.bodyRequest(input));
    }

    @Test
    public void testHttpNoMethodInvalidTooBigWithContentLength() throws Exception {
        this.doTestHttpInvalidTooBigWithContentLength(this.http("test"), null, null);
    }

    @Test
    public void testHttpGetValidInvalidTooBigWithContentLength() throws Exception {
        this.doTestHttpInvalidTooBigWithContentLength(this.http("test"), MethodType.GET_LITERAL, null);
    }

    @Test
    public void testHttpPostBodyInvalidTooBigWithContentLength() throws Exception {
        this.doTestHttpInvalidTooBigWithContentLength(this.http("test"), MethodType.POST_LITERAL, null);
    }

    @Test
    public void testHttpPostRefFileInvalidTooBigWithContentLength() throws Exception {
        this.doTestHttpInvalidTooBigWithContentLength(this.http("test"), MethodType.POST_LITERAL, this.file("foo.txt"));
    }

    @Test
    public void testHttpPostRefOtherInvalidTooBigWithContentLength() throws Exception {
        this.doTestHttpInvalidTooBigWithContentLength(this.http("test"), MethodType.POST_LITERAL, this.jar("foo"));
    }

    @Test
    public void testHttpPostRefHttpInvalidTooBigWithContentLength() throws Exception {
        this.doTestHttpInvalidTooBigWithContentLength(this.http("test"), MethodType.POST_LITERAL, this.http("foo"));
    }

    @Test
    public void testHttpPostRefHttpsInvalidTooBigWithContentLength() throws Exception {
        this.doTestHttpInvalidTooBigWithContentLength(this.http("test"), MethodType.POST_LITERAL, this.https("foo"));
    }

    @Test
    public void testHttpsNoMethodInvalidTooBigWithContentLength() throws Exception {
        this.doTestHttpInvalidTooBigWithContentLength(this.https("test"), null, null);
    }

    @Test
    public void testHttpsGetValidInvalidTooBigWithContentLength() throws Exception {
        this.doTestHttpInvalidTooBigWithContentLength(this.https("test"), MethodType.GET_LITERAL, null);
    }

    @Test
    public void testHttpsPostBodyInvalidTooBigWithContentLength() throws Exception {
        this.doTestHttpInvalidTooBigWithContentLength(this.https("test"), MethodType.POST_LITERAL, null);
    }

    @Test
    public void testHttpsPostRefFileInvalidTooBigWithContentLength() throws Exception {
        this.doTestHttpInvalidTooBigWithContentLength(this.https("test"), MethodType.POST_LITERAL, this.file("foo.txt"));
    }

    @Test
    public void testHttpsPostRefOtherInvalidTooBigWithContentLength() throws Exception {
        this.doTestHttpInvalidTooBigWithContentLength(this.https("test"), MethodType.POST_LITERAL, this.jar("foo"));
    }

    @Test
    public void testHttpsPostRefHttpInvalidTooBigWithContentLength() throws Exception {
        this.doTestHttpInvalidTooBigWithContentLength(this.https("test"), MethodType.POST_LITERAL, this.http("foo"));
    }

    @Test
    public void testHttpsPostRefHttpsInvalidTooBigWithContentLength() throws Exception {
        this.doTestHttpInvalidTooBigWithContentLength(this.https("test"), MethodType.POST_LITERAL, this.https("foo"));
    }

    private void doTestHttpInvalidTooBigWithContentLength(URL url, MethodType method, URL bodyUrl) throws Exception {
        this.stub(WireMock.ok((String)"TEST").withHeader("Content-Length", new String[]{"4"}), bodyUrl, WireMock.ok((String)"FOO"));
        InputType input = RemoteRequestInputProviderTest.input(url, method, "FOO", bodyUrl, new String[0]);
        String message = "Input testInput size 4 exceeds maximum allowed size of 3 according to HTTP Content-Length response header";
        this.assertException(input, RemoteRequestInputProviderTest.ppio(), 0, 3L, message, null, RemoteRequestInputProviderTest.request(input), RemoteRequestInputProviderTest.bodyRequest(input));
    }

    @Test
    public void testHttpNoMethodInvalidCanceled() throws Exception {
        this.doTestHttpInvalidCanceled(this.http("test"), null, null);
    }

    @Test
    public void testHttpGetValidInvalidCanceled() throws Exception {
        this.doTestHttpInvalidCanceled(this.http("test"), MethodType.GET_LITERAL, null);
    }

    @Test
    public void testHttpPostBodyInvalidCanceled() throws Exception {
        this.doTestHttpInvalidCanceled(this.http("test"), MethodType.POST_LITERAL, null);
    }

    @Test
    public void testHttpPostRefFileInvalidCanceled() throws Exception {
        this.doTestHttpInvalidCanceled(this.http("test"), MethodType.POST_LITERAL, this.file("foo.txt"));
    }

    @Test
    public void testHttpPostRefOtherInvalidCanceled() throws Exception {
        this.doTestHttpInvalidCanceled(this.http("test"), MethodType.POST_LITERAL, this.jar("foo"));
    }

    @Test
    public void testHttpPostRefHttpInvalidCanceled() throws Exception {
        this.doTestHttpInvalidCanceled(this.http("test"), MethodType.POST_LITERAL, this.http("foo"));
    }

    @Test
    public void testHttpPostRefHttpsInvalidCanceled() throws Exception {
        this.doTestHttpInvalidCanceled(this.http("test"), MethodType.POST_LITERAL, this.https("foo"));
    }

    @Test
    public void testHttpsNoMethodInvalidCanceled() throws Exception {
        this.doTestHttpInvalidCanceled(this.https("test"), null, null);
    }

    @Test
    public void testHttpsGetValidInvalidCanceled() throws Exception {
        this.doTestHttpInvalidCanceled(this.https("test"), MethodType.GET_LITERAL, null);
    }

    @Test
    public void testHttpsPostBodyInvalidCanceled() throws Exception {
        this.doTestHttpInvalidCanceled(this.https("test"), MethodType.POST_LITERAL, null);
    }

    @Test
    public void testHttpsPostRefFileInvalidCanceled() throws Exception {
        this.doTestHttpInvalidCanceled(this.https("test"), MethodType.POST_LITERAL, this.file("foo.txt"));
    }

    @Test
    public void testHttpsPostRefOtherInvalidCanceled() throws Exception {
        this.doTestHttpInvalidCanceled(this.https("test"), MethodType.POST_LITERAL, this.jar("foo"));
    }

    @Test
    public void testHttpsPostRefHttpInvalidCanceled() throws Exception {
        this.doTestHttpInvalidCanceled(this.https("test"), MethodType.POST_LITERAL, this.http("foo"));
    }

    @Test
    public void testHttpsPostRefHttpsInvalidCanceled() throws Exception {
        this.doTestHttpInvalidCanceled(this.https("test"), MethodType.POST_LITERAL, this.https("foo"));
    }

    private void doTestHttpInvalidCanceled(URL url, MethodType method, URL bodyUrl) throws Exception {
        Mockito.when((Object)this.listener.isCanceled()).thenReturn((Object)false, (Object[])new Boolean[]{true});
        this.stub(WireMock.ok((String)"TEST"), bodyUrl, WireMock.ok((String)"FOO"));
        InputType input = RemoteRequestInputProviderTest.input(url, method, "FOO", bodyUrl, new String[0]);
        this.assertException(input, RemoteRequestInputProviderTest.ppio(), 0, 3L, "Failed to retrieve value for input testInput", ProcessDismissedException.class, bodyUrl == null ? RemoteRequestInputProviderTest.request(input) : null, RemoteRequestInputProviderTest.bodyRequest(input));
    }

    @Test
    public void testHttpPostInvalidNullBodyAndBodyRef() throws Exception {
        this.doTestHttpPostInvalidNullBodyAndBodyRef(this.http("test"));
    }

    @Test
    public void testHttpsPostInvalidNullBodyAndBodyRef() throws Exception {
        this.doTestHttpPostInvalidNullBodyAndBodyRef(this.https("test"));
    }

    private void doTestHttpPostInvalidNullBodyAndBodyRef(URL url) throws Exception {
        InputType input = RemoteRequestInputProviderTest.input(url, MethodType.POST_LITERAL, null, null, new String[0]);
        input.getReference().setBodyReference(null);
        String message = "A POST request should contain a non empty body";
        this.assertException(input, RemoteRequestInputProviderTest.ppio(), 0, 0L, message, null, new RequestPatternBuilder[0]);
    }

    @Test
    public void testHttpPostInvalidNullBodyAndBodyRefHref() throws Exception {
        this.doTestHttpPostInvalidNullBodyAndBodyRefHref(this.http("test"));
    }

    @Test
    public void testHttpsPostInvalidNullBodyAndBodyRefHref() throws Exception {
        this.doTestHttpPostInvalidNullBodyAndBodyRefHref(this.https("test"));
    }

    private void doTestHttpPostInvalidNullBodyAndBodyRefHref(URL url) throws Exception {
        InputType input = RemoteRequestInputProviderTest.input(url, MethodType.POST_LITERAL, null, null, new String[0]);
        String message = "A POST request should contain a non empty body";
        this.assertException(input, RemoteRequestInputProviderTest.ppio(), 0, 0L, message, null, new RequestPatternBuilder[0]);
    }

    @Test
    public void testHttpPostInvalidBodyType() throws Exception {
        this.doTestHttpPostInvalidBodyType(this.http("test"));
    }

    @Test
    public void testHttpsPostInvalidBodyType() throws Exception {
        this.doTestHttpPostInvalidBodyType(this.https("test"));
    }

    private void doTestHttpPostInvalidBodyType(URL url) throws Exception {
        InputType input = RemoteRequestInputProviderTest.input(url, MethodType.POST_LITERAL, 1, null, new String[0]);
        String message = "The request body should be contained in a CDATA section, otherwise it will get parsed as XML instead of being preserved as is";
        this.assertException(input, RemoteRequestInputProviderTest.ppio(), 0, 0L, message, null, new RequestPatternBuilder[0]);
    }

    private void assertException(InputType input, ComplexPPIO ppio, int timeout, long maxSize, String message, Class<? extends Exception> hidden, RequestPatternBuilder ... requests) throws Exception {
        WPSException e = (WPSException)Assert.assertThrows(WPSException.class, () -> this.getValue(input, ppio, timeout, maxSize));
        Assert.assertEquals((Object)message, (Object)e.getMessage());
        Assert.assertEquals((Object)"NoApplicableCode", (Object)e.getCode());
        Assert.assertEquals((Object)"testInput", (Object)e.getLocator());
        Assert.assertNull((Object)e.getCause());
        ((ProgressListener)Mockito.verify((Object)this.listener)).exceptionOccurred((Throwable)ArgumentMatchers.any((Class)((Class)MoreObjects.firstNonNull(hidden, Exception.class))));
        ((ProgressListener)Mockito.verify((Object)this.listener)).exceptionOccurred((Throwable)ArgumentMatchers.any(WPSException.class));
        Arrays.stream(requests).filter(Objects::nonNull).forEach(arg_0 -> ((WireMockClassRule)this.service).verify(arg_0));
    }

    private void assertValue(InputType input, ComplexPPIO ppio, int timeout, long maxSize, Object expected, RequestPatternBuilder ... requests) throws Exception {
        Assert.assertEquals((Object)expected, (Object)this.getValue(input, ppio, timeout, maxSize));
        Arrays.stream(requests).filter(Objects::nonNull).forEach(arg_0 -> ((WireMockClassRule)this.service).verify(arg_0));
    }

    private Object getValue(InputType input, ComplexPPIO ppio, int timeout, long maxSize) throws Exception {
        HashMap<String, RemoteRequestInputProvider> map = new HashMap<String, RemoteRequestInputProvider>();
        map.put("testInput", new RemoteRequestInputProvider(input, ppio, timeout, maxSize));
        LazyInputMap inputs = new LazyInputMap(map);
        inputs.setListener(this.listener);
        return inputs.get((Object)"testInput");
    }

    private URL file(String file) {
        return this.getClass().getResource(file);
    }

    private URL jar(String name) throws Exception {
        return new URL("jar:" + this.file(name + ".zip") + "!/" + name + ".txt");
    }

    private URL http(String name) throws Exception {
        return new URL("http://localhost:" + this.service.port() + "/" + name);
    }

    private URL https(String name) throws Exception {
        return new URL("https://localhost:" + this.service.httpsPort() + "/" + name);
    }

    private void stub(ResponseDefinitionBuilder response, URL bodyUrl, ResponseDefinitionBuilder bodyResponse) {
        this.service.stubFor(WireMock.any((UrlPattern)WireMock.urlEqualTo((String)"/test")).willReturn(response));
        if (bodyUrl != null && bodyUrl.getProtocol().startsWith("http")) {
            this.service.stubFor(WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/foo")).willReturn(bodyResponse));
        }
    }

    private static RequestPatternBuilder request(InputType input) {
        if (input.getReference().getMethod() != MethodType.POST_LITERAL) {
            return WireMock.getRequestedFor((UrlPattern)WireMock.urlEqualTo((String)"/test"));
        }
        Object mimeType = "text/plain";
        if (input.getReference().getBodyReference().getHref() == null) {
            mimeType = (String)mimeType + "; charset=UTF-8";
        }
        return WireMock.postRequestedFor((UrlPattern)WireMock.urlEqualTo((String)"/test")).withRequestBody((ContentPattern)WireMock.equalTo((String)"FOO")).withHeader("Content-Type", WireMock.equalTo((String)mimeType));
    }

    private static RequestPatternBuilder bodyRequest(InputType input) {
        String bodyHref = input.getReference().getBodyReference().getHref();
        if (bodyHref != null && bodyHref.startsWith("http")) {
            return WireMock.getRequestedFor((UrlPattern)WireMock.urlEqualTo((String)"/foo"));
        }
        return null;
    }

    private static InputType input(URL href, MethodType method, Object body, URL bodyHref, String ... headers) {
        Wps10Factory factory = Wps10Factory.eINSTANCE;
        InputType input = factory.createInputType();
        input.setIdentifier(Ows11Util.code((String)"testInput"));
        InputReferenceType ref = factory.createInputReferenceType();
        ref.setHref(href.toString());
        ref.setMethod(method);
        BodyReferenceType bodyRef = factory.createBodyReferenceType();
        if (bodyHref != null) {
            bodyRef.setHref(bodyHref.toString());
        } else {
            ref.setBody(body);
        }
        ref.setBodyReference(bodyRef);
        for (int i = 1; i < headers.length; i += 2) {
            HeaderType header = factory.createHeaderType();
            header.setKey(headers[i - 1]);
            header.setValue(headers[i]);
            ref.getHeader().add((Object)header);
        }
        input.setReference(ref);
        return input;
    }

    private static ComplexPPIO ppio() {
        return RemoteRequestInputProviderTest.ppio(String.class, "text/plain");
    }

    private static ComplexPPIO ppio(Class<?> type, String mimeType) {
        return new ComplexPPIO(type, type, mimeType){

            public Object decode(InputStream input) throws Exception {
                return IOUtils.toString((InputStream)input, (Charset)StandardCharsets.UTF_8);
            }

            public void encode(Object value, OutputStream os) {
            }
        };
    }
}

