/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wps.gs;

import java.awt.Color;
import java.awt.geom.Point2D;
import java.awt.image.WritableRaster;
import javax.media.jai.RasterFactory;
import org.geoserver.wps.WPSTestSupport;
import org.geoserver.wps.gs.GridCoverage2DRIA;
import org.geotools.api.geometry.Bounds;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.coverage.CoverageFactoryFinder;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridCoverageFactory;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.junit.Assert;
import org.junit.Test;

public class Coverage2RenderedImageAdapterTest
extends WPSTestSupport {
    protected static final double NODATA = 3.0;

    protected static GridCoverage2D createTestCoverage(int width, int height, double envX0, double envY0, double envWidth, double envHeight, CoordinateReferenceSystem crs) {
        GridCoverageFactory factory = CoverageFactoryFinder.getGridCoverageFactory(null);
        WritableRaster raster = RasterFactory.createBandedRaster((int)4, (int)width, (int)height, (int)1, null);
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                if (x < 50 && y < 50) {
                    if (x % 5 == 0) {
                        raster.setSample(x, y, 0, 0);
                        continue;
                    }
                    raster.setSample(x, y, 0, width);
                    continue;
                }
                if (x < 50 && y > height - 50) {
                    if (y % 5 == 0) {
                        raster.setSample(x, y, 0, 0);
                        continue;
                    }
                    raster.setSample(x, y, 0, width);
                    continue;
                }
                if (x > width - 50 && y < 50) {
                    if ((x - y) % 5 == 0) {
                        raster.setSample(x, y, 0, 0);
                        continue;
                    }
                    raster.setSample(x, y, 0, width);
                    continue;
                }
                if (x > width - 50 && y > height - 50) {
                    if ((x + y) % 5 == 0) {
                        raster.setSample(x, y, 0, 0);
                        continue;
                    }
                    raster.setSample(x, y, 0, width);
                    continue;
                }
                if (x % 50 == 0 || y % 50 == 0 || (x - y) % 100 == 0) {
                    raster.setSample(x, y, 0, 0);
                    continue;
                }
                raster.setSample(x, y, 0, x + y);
            }
        }
        Color[] colors = new Color[]{Color.BLUE, Color.CYAN, Color.WHITE, Color.YELLOW, Color.RED};
        return factory.create((CharSequence)"Float coverage", raster, (Bounds)ReferencedEnvelope.rect((double)envX0, (double)envY0, (double)envWidth, (double)envHeight, (CoordinateReferenceSystem)crs), null, null, null, (Color[][])new Color[][]{colors}, null);
    }

    @Test
    public void testSame() throws InterruptedException {
        GridCoverage2D src = Coverage2RenderedImageAdapterTest.createTestCoverage(500, 500, 0.0, 0.0, 10.0, 10.0, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        GridCoverage2D dst = Coverage2RenderedImageAdapterTest.createTestCoverage(500, 500, 0.0, 0.0, 10.0, 10.0, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        GridCoverage2DRIA cria = GridCoverage2DRIA.create((GridCoverage2D)src, (GridCoverage2D)dst, (double)3.0);
        Point2D.Double psrc = new Point2D.Double(2.0, 3.0);
        Point2D pdst = cria.mapSourcePoint((Point2D)psrc, 0);
        Assert.assertEquals((double)2.0, (double)pdst.getX(), (double)0.0);
        Assert.assertEquals((double)3.0, (double)pdst.getY(), (double)0.0);
        psrc = new Point2D.Double(600.0, 600.0);
        pdst = cria.mapSourcePoint((Point2D)psrc, 0);
        Assert.assertNull((Object)pdst);
    }

    @Test
    public void testSameWorldSmallerDstRaster() throws InterruptedException {
        GridCoverage2D src = Coverage2RenderedImageAdapterTest.createTestCoverage(500, 500, 0.0, 0.0, 10.0, 10.0, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        GridCoverage2D dst = Coverage2RenderedImageAdapterTest.createTestCoverage(250, 250, 0.0, 0.0, 10.0, 10.0, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        GridCoverage2DRIA cria = GridCoverage2DRIA.create((GridCoverage2D)dst, (GridCoverage2D)src, (double)3.0);
        Point2D.Double psrc = new Point2D.Double(13.0, 16.0);
        Point2D pdst = cria.mapSourcePoint((Point2D)psrc, 0);
        Assert.assertNotNull((String)("Can't convert " + psrc), (Object)pdst);
        Assert.assertEquals((double)26.0, (double)pdst.getX(), (double)0.0);
        Assert.assertEquals((double)32.0, (double)pdst.getY(), (double)0.0);
        psrc = new Point2D.Double(600.0, 600.0);
        pdst = cria.mapSourcePoint((Point2D)psrc, 0);
        Assert.assertNull((Object)pdst);
    }

    @Test
    public void testSameRasterSmallerWorld() throws InterruptedException {
        GridCoverage2D src = Coverage2RenderedImageAdapterTest.createTestCoverage(500, 500, 0.0, 0.0, 10.0, 10.0, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        GridCoverage2D dst = Coverage2RenderedImageAdapterTest.createTestCoverage(500, 500, 0.0, 0.0, 5.0, 5.0, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        GridCoverage2DRIA cria = GridCoverage2DRIA.create((GridCoverage2D)dst, (GridCoverage2D)src, (double)3.0);
        Point2D.Double psrc = new Point2D.Double(0.0, 0.0);
        Point2D pdst = cria.mapSourcePoint((Point2D)psrc, 0);
        Assert.assertEquals((double)0.0, (double)pdst.getX(), (double)0.0);
        Assert.assertEquals((double)250.0, (double)pdst.getY(), (double)0.0);
        psrc = new Point2D.Double(20.0, 30.0);
        pdst = cria.mapSourcePoint((Point2D)psrc, 0);
        Assert.assertEquals((double)10.0, (double)pdst.getX(), (double)0.0);
        Assert.assertEquals((double)265.0, (double)pdst.getY(), (double)0.0);
    }

    @Test
    public void testSameRasterTranslatedWorld0() throws InterruptedException {
        GridCoverage2D src = Coverage2RenderedImageAdapterTest.createTestCoverage(500, 500, 0.0, 0.0, 5.0, 5.0, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        GridCoverage2D dst = Coverage2RenderedImageAdapterTest.createTestCoverage(500, 500, 2.0, 2.0, 5.0, 5.0, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        GridCoverage2DRIA cria = GridCoverage2DRIA.create((GridCoverage2D)dst, (GridCoverage2D)src, (double)3.0);
        Point2D.Double psrc = new Point2D.Double(0.0, 499.0);
        Point2D pdst = cria.mapSourcePoint((Point2D)psrc, 0);
        Assert.assertNotNull((Object)pdst);
        Assert.assertEquals((double)200.0, (double)pdst.getX(), (double)0.0);
        Assert.assertEquals((double)299.0, (double)pdst.getY(), (double)0.0);
        psrc = new Point2D.Double(0.0, 0.0);
        pdst = cria.mapSourcePoint((Point2D)psrc, 0);
        Assert.assertNull((Object)pdst);
        double val = cria.getData().getSampleFloat(0, 0, 0);
        Assert.assertEquals((String)"Value should be noData", (double)3.0, (double)val, (double)0.0);
    }
}

