/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wps.gs;

import org.geoserver.wps.WPSTestSupport;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.filter.FilterFactory;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.DefaultFeatureCollection;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.process.vector.UnionFeatureCollection;
import org.junit.Assert;
import org.junit.Test;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.impl.CoordinateArraySequence;

public class UnionFeatureCollectionTest
extends WPSTestSupport {
    FilterFactory ff = CommonFactoryFinder.getFilterFactory(null);
    GeometryFactory gf = new GeometryFactory();

    @Test
    public void testExecute() throws Exception {
        int i;
        LinearRing shell;
        int numFeatures;
        SimpleFeatureTypeBuilder tb = new SimpleFeatureTypeBuilder();
        tb.setName("featureType");
        tb.add("geometry", Geometry.class);
        tb.add("integer", Integer.class);
        GeometryFactory gf = new GeometryFactory();
        SimpleFeatureBuilder b = new SimpleFeatureBuilder(tb.buildFeatureType());
        DefaultFeatureCollection features = new DefaultFeatureCollection(null, b.getFeatureType());
        DefaultFeatureCollection secondFeatures = new DefaultFeatureCollection(null, b.getFeatureType());
        Geometry[] firstArrayGeometry = new Geometry[5];
        Geometry[] secondArrayGeometry = new Geometry[5];
        for (numFeatures = 0; numFeatures < 5; ++numFeatures) {
            Coordinate[] firstArray = new Coordinate[5];
            for (int j = 0; j < 4; ++j) {
                firstArray[j] = new Coordinate((double)(j + numFeatures), (double)(j + numFeatures));
            }
            firstArray[4] = new Coordinate((double)(0 + numFeatures), (double)(0 + numFeatures));
            shell = gf.createLinearRing((CoordinateSequence)new CoordinateArraySequence(firstArray));
            b.add((Object)gf.createPolygon(shell, null));
            b.add((Object)0);
            firstArrayGeometry[numFeatures] = gf.createPolygon(shell, null);
            features.add(b.buildFeature("" + numFeatures));
        }
        for (numFeatures = 0; numFeatures < 5; ++numFeatures) {
            Coordinate[] array = new Coordinate[5];
            for (int j = 0; j < 4; ++j) {
                array[j] = new Coordinate((double)(j + numFeatures + 50), (double)(j + numFeatures + 50));
            }
            array[4] = new Coordinate((double)(0 + numFeatures + 50), (double)(0 + numFeatures + 50));
            shell = gf.createLinearRing((CoordinateSequence)new CoordinateArraySequence(array));
            b.add((Object)gf.createPolygon(shell, null));
            b.add((Object)0);
            secondArrayGeometry[numFeatures] = gf.createPolygon(shell, null);
            secondFeatures.add(b.buildFeature("" + numFeatures));
        }
        UnionFeatureCollection process = new UnionFeatureCollection();
        SimpleFeatureCollection output = process.execute((SimpleFeatureCollection)features, (SimpleFeatureCollection)secondFeatures);
        Assert.assertEquals((long)5L, (long)output.size());
        Geometry[] union = new Geometry[10];
        for (i = 0; i < firstArrayGeometry.length; ++i) {
            union[i] = firstArrayGeometry[i];
        }
        for (i = 0; i < secondArrayGeometry.length; ++i) {
            union[i + 5] = secondArrayGeometry[i];
        }
        GeometryCollection unionCollection = new GeometryCollection(union, new GeometryFactory());
        try (SimpleFeatureIterator iterator = output.features();){
            for (int h = 0; h < unionCollection.getNumGeometries(); ++h) {
                Geometry expected = unionCollection.getGeometryN(h);
                SimpleFeature sf = (SimpleFeature)iterator.next();
                Assert.assertTrue((boolean)expected.equals((Geometry)sf.getDefaultGeometry()));
            }
        }
    }
}

