/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wps.ppio;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import net.sf.json.JSONSerializer;
import org.geoserver.config.GeoServer;
import org.geoserver.config.GeoServerInfo;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.wps.WPSTestSupport;
import org.geoserver.wps.ppio.GeoJSONPPIO;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.filter.Filter;
import org.geotools.data.DataUtilities;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.feature.FeatureCollection;
import org.geotools.filter.text.cql2.CQL;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.io.WKTReader;

public class GeoJSONPPIOTest
extends WPSTestSupport {
    private InputStream is;
    static final double EPS = 1.0E-5;

    protected void setUpSpring(List<String> springContextLocations) {
        super.setUpSpring(springContextLocations);
        springContextLocations.add("classpath*:/applicationContext-noargs.xml");
    }

    @Before
    public void prepareInputStream() throws IOException {
        this.is = SystemTestData.class.getResourceAsStream("states.json");
        Assert.assertNotNull((Object)this.is);
    }

    @After
    public void cleanup() throws IOException {
        if (this.is != null) {
            this.is.close();
        }
    }

    @Test
    public void testDecodeGeometries() throws Exception {
        GeoJSONPPIO.Geometries ppio = new GeoJSONPPIO.Geometries(this.getGeoServer());
        String string = "{\"type\":\"Point\",\"coordinates\":[1.123456789,2]}";
        Point point1 = (Point)ppio.decode(string);
        Assert.assertEquals((double)1.123456789, (double)point1.getX(), (double)1.0E-5);
        Assert.assertEquals((double)2.0, (double)point1.getY(), (double)1.0E-5);
        ByteArrayInputStream input = new ByteArrayInputStream(string.getBytes());
        Point point2 = (Point)ppio.decode((InputStream)input);
        Assert.assertEquals((double)1.123456789, (double)point2.getX(), (double)1.0E-5);
        Assert.assertEquals((double)2.0, (double)point2.getY(), (double)1.0E-5);
    }

    @Test
    public void testEncodeGeometries() throws Exception {
        WKTReader reader = new WKTReader();
        Point point = (Point)reader.read("POINT(1.123456789 2.0)");
        GeoServer gs = this.getGeoServer();
        GeoServerInfo global = gs.getGlobal();
        ByteArrayOutputStream os = new ByteArrayOutputStream(1024);
        new GeoJSONPPIO.Geometries(gs).encode((Object)point, (OutputStream)os);
        String output = os.toString();
        Assert.assertEquals((Object)output, (Object)"{\"type\":\"Point\",\"coordinates\":[1.12345679,2]}");
        int dec = global.getSettings().getNumDecimals();
        global.getSettings().setNumDecimals(4);
        this.getGeoServer().save(global);
        ByteArrayOutputStream os2 = new ByteArrayOutputStream(1024);
        new GeoJSONPPIO.Geometries(gs).encode((Object)point, (OutputStream)os2);
        String output2 = os2.toString();
        Assert.assertEquals((Object)output2, (Object)"{\"type\":\"Point\",\"coordinates\":[1.1235,2]}");
        global.getSettings().setNumDecimals(dec);
        this.getGeoServer().save(global);
    }

    @Test
    public void testDecodeInputStream() throws Exception {
        SimpleFeatureCollection states = (SimpleFeatureCollection)new GeoJSONPPIO.FeatureCollections().decode(this.is);
        Assert.assertEquals((String)"Wrong number of states", (long)49L, (long)states.size());
        Assert.assertEquals((String)"Wrong number of columns", (long)23L, (long)((SimpleFeatureType)states.getSchema()).getAttributeCount());
        Filter filter = CQL.toFilter((String)"STATE_NAME = 'Alabama'");
        SimpleFeatureCollection alabama = states.subCollection(filter);
        Assert.assertEquals((String)"Persons", (Object)4040587.0, (Object)((SimpleFeature)DataUtilities.first((FeatureCollection)alabama)).getAttribute("PERSONS"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testEncodeOutputStream() throws Exception {
        SimpleFeatureCollection states = (SimpleFeatureCollection)new GeoJSONPPIO.FeatureCollections().decode(this.is);
        Assert.assertEquals((String)"Wrong number of states", (long)49L, (long)states.size());
        GeoServer gs = this.getGeoServer();
        GeoServerInfo global = gs.getGlobal();
        ByteArrayOutputStream os = new ByteArrayOutputStream(1024);
        new GeoJSONPPIO.FeatureCollections(gs).encode((Object)states, (OutputStream)os);
        String json = os.toString();
        JSONObject fc = (JSONObject)JSONSerializer.toJSON((Object)json);
        JSONArray features = fc.getJSONArray("features");
        JSONObject state0 = features.getJSONObject(0);
        JSONArray state0Ordinates = state0.getJSONObject("geometry").getJSONArray("coordinates").getJSONArray(0).getJSONArray(0);
        Assert.assertEquals((double)-88.087883, (double)state0Ordinates.getJSONArray(1).getDouble(0), (double)1.0E-5);
        Assert.assertEquals((double)-88.311707, (double)state0Ordinates.getJSONArray(2).getDouble(0), (double)1.0E-5);
        Assert.assertEquals((double)37.420292, (double)state0Ordinates.getJSONArray(4).getDouble(1), (double)1.0E-5);
        JSONObject state10 = features.getJSONObject(9);
        JSONObject state10p = state10.getJSONObject("properties");
        Assert.assertEquals((Object)"Missouri", (Object)state10p.getString("STATE_NAME"));
        Assert.assertEquals((Object)"29", (Object)state10p.getString("STATE_FIPS"));
        Assert.assertEquals((Object)"W N Cen", (Object)state10p.getString("SUB_REGION"));
        Assert.assertEquals((Object)"2100.115", (Object)state10p.getString("WATER_KM"));
        Assert.assertEquals((Object)"1961206", (Object)state10p.getString("HOUSHOLD"));
        JSONObject state11 = features.getJSONObject(11);
        JSONObject state11p = state11.getJSONObject("properties");
        Assert.assertEquals((Object)"Oklahoma", (Object)state11p.getString("STATE_NAME"));
        Assert.assertEquals((Object)"40", (Object)state11p.getString("STATE_FIPS"));
        Assert.assertEquals((Object)"W S Cen", (Object)state11p.getString("SUB_REGION"));
        Assert.assertEquals((Object)"3170.998", (Object)state11p.getString("WATER_KM"));
        Assert.assertEquals((Object)"1206135", (Object)state11p.getString("HOUSHOLD"));
        int dec = global.getSettings().getNumDecimals();
        global.getSettings().setNumDecimals(2);
        this.getGeoServer().save(global);
        try {
            ByteArrayOutputStream os2 = new ByteArrayOutputStream(1024);
            new GeoJSONPPIO.FeatureCollections(gs).encode((Object)states, (OutputStream)os2);
            String json2 = os2.toString();
            JSONObject fc2 = (JSONObject)JSONSerializer.toJSON((Object)json2);
            JSONArray features2 = fc2.getJSONArray("features");
            state0 = features2.getJSONObject(0);
            state0Ordinates = state0.getJSONObject("geometry").getJSONArray("coordinates").getJSONArray(0).getJSONArray(0);
            Assert.assertEquals((double)-88.09, (double)state0Ordinates.getJSONArray(1).getDouble(0), (double)1.0E-5);
            Assert.assertEquals((double)-88.31, (double)state0Ordinates.getJSONArray(2).getDouble(0), (double)1.0E-5);
            Assert.assertEquals((double)37.42, (double)state0Ordinates.getJSONArray(4).getDouble(1), (double)1.0E-5);
        }
        finally {
            global.getSettings().setNumDecimals(dec);
            this.getGeoServer().save(global);
        }
    }
}

