/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wps;

import java.io.ByteArrayInputStream;
import java.util.Arrays;
import java.util.Collection;
import org.geoserver.data.test.MockData;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.wcs2_0.WCS2GetCoverageRequestBuilder;
import org.geoserver.wps.WPSTestSupport;
import org.geotools.api.geometry.Position;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.gce.arcgrid.ArcGridFormat;
import org.geotools.geometry.Position2D;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.locationtech.jts.geom.Envelope;
import org.springframework.mock.web.MockHttpServletResponse;

@RunWith(value=Parameterized.class)
public class ExecuteOnCoverageTest
extends WPSTestSupport {
    private final String version;

    @Parameterized.Parameters
    public static Collection<Object[]> getParameters() {
        return Arrays.asList({"1.1.1"}, {"2.0.0"});
    }

    @Override
    protected void onSetUp(SystemTestData testData) throws Exception {
        super.onSetUp(testData);
        this.addWcs11Coverages(testData);
    }

    public ExecuteOnCoverageTest(String version) {
        this.version = version;
    }

    @Test
    public void testCrop() throws Exception {
        String wcsRequest = WCS2GetCoverageRequestBuilder.newBuilder().coverageId(this.getLayerId(MockData.TASMANIA_DEM)).bbox(130.0, 150.0, -44.0, -40.0).asXML(this.version);
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<wps:Execute version=\"1.0.0\" service=\"WPS\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns=\"http://www.opengis.net/wps/1.0.0\" xmlns:wfs=\"http://www.opengis.net/wfs\" xmlns:wps=\"http://www.opengis.net/wps/1.0.0\" xmlns:ows=\"http://www.opengis.net/ows/1.1\" xmlns:gml=\"http://www.opengis.net/gml\" xmlns:ogc=\"http://www.opengis.net/ogc\" xmlns:wcs=\"http://www.opengis.net/wcs/1.1.1\" xmlns:xlink=\"http://www.w3.org/1999/xlink\" xsi:schemaLocation=\"http://www.opengis.net/wps/1.0.0 http://schemas.opengis.net/wps/1.0.0/wpsAll.xsd\">\n  <ows:Identifier>gs:CropCoverage</ows:Identifier>\n  <wps:DataInputs>\n    <wps:Input>\n      <ows:Identifier>coverage</ows:Identifier>\n      <wps:Reference mimeType=\"image/tiff\" xlink:href=\"http://geoserver/wcs\" method=\"POST\">\n        <wps:Body>\n" + wcsRequest + "        </wps:Body>\n      </wps:Reference>\n    </wps:Input>\n    <wps:Input>\n      <ows:Identifier>cropShape</ows:Identifier>\n      <wps:Data>\n        <wps:ComplexData mimeType=\"application/wkt\"><![CDATA[POLYGON((145.5 -41.9, 145.5 -42.1, 145.6 -42, 145.5 -41.9))]]></wps:ComplexData>\n      </wps:Data>\n    </wps:Input>\n  </wps:DataInputs>\n  <wps:ResponseForm>\n    <wps:RawDataOutput mimeType=\"application/arcgrid\">\n      <ows:Identifier>result</ows:Identifier>\n    </wps:RawDataOutput>\n  </wps:ResponseForm>\n</wps:Execute>\n\n";
        MockHttpServletResponse response = this.postAsServletResponse(this.root(), xml);
        try (ByteArrayInputStream is = this.getBinaryInputStream(response);){
            ArcGridFormat format = new ArcGridFormat();
            GridCoverage2D gc = format.getReader((Object)is).read(null);
            Assert.assertTrue((boolean)new Envelope(-145.4, 145.6, -41.8, -42.1).contains((Envelope)new ReferencedEnvelope(gc.getEnvelope())));
            double[] valueInside = (double[])gc.evaluate((Position)new Position2D(145.55, -42.0));
            Assert.assertEquals((double)615.0, (double)valueInside[0], (double)0.0);
            double[] valueOutside = (double[])gc.evaluate((Position)new Position2D(145.57, -41.9));
            Assert.assertEquals((long)55537L, (long)((int)valueOutside[0]));
        }
    }
}

