/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wps;

import java.awt.geom.Point2D;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.CallSite;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.servlet.Filter;
import javax.servlet.http.HttpServletRequest;
import javax.xml.namespace.QName;
import net.opengis.ows11.BoundingBoxType;
import org.apache.commons.codec.binary.Base64;
import org.awaitility.Awaitility;
import org.custommonkey.xmlunit.XMLAssert;
import org.custommonkey.xmlunit.XMLUnit;
import org.custommonkey.xmlunit.XpathEngine;
import org.custommonkey.xmlunit.exceptions.XpathException;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.config.GeoServer;
import org.geoserver.config.GeoServerInfo;
import org.geoserver.config.ServiceInfo;
import org.geoserver.config.SettingsInfo;
import org.geoserver.data.test.MockData;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.ows.HTTPHeadersCollector;
import org.geoserver.ows.util.KvpUtils;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.platform.resource.Resource;
import org.geoserver.test.RemoteOWSTestSupport;
import org.geoserver.wps.MonkeyProcess;
import org.geoserver.wps.WPSInfo;
import org.geoserver.wps.WPSTestSupport;
import org.geoserver.wps.executor.ExecutionStatus;
import org.geoserver.wps.executor.ProcessState;
import org.geoserver.wps.executor.ProcessStatusTracker;
import org.geoserver.wps.resource.ProcessArtifactsStore;
import org.geoserver.wps.resource.WPSResourceManager;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.data.collection.ListFeatureCollection;
import org.geotools.data.geojson.GeoJSONReader;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.gml3.GMLConfiguration;
import org.geotools.ows.v1_1.OWSConfiguration;
import org.geotools.process.ProcessException;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.xsd.Configuration;
import org.geotools.xsd.Parser;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.io.WKTReader;
import org.springframework.context.ApplicationContext;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.w3c.dom.Document;

public class ExecuteTest
extends WPSTestSupport {
    @Override
    protected void onSetUp(SystemTestData testData) throws Exception {
        super.onSetUp(testData);
        testData.addVectorLayer(SystemTestData.PRIMITIVEGEOFEATURE, this.getCatalog());
        String pgf = MockData.PRIMITIVEGEOFEATURE.getLocalPart();
        testData.addVectorLayer(new QName("http://foo.org", pgf, "foo"), new HashMap(), pgf + ".properties", MockData.class, this.getCatalog());
    }

    @Before
    public void oneTimeSetUp() throws Exception {
        WPSInfo wps = (WPSInfo)this.getGeoServer().getService(WPSInfo.class);
        wps.setMaxAsynchronousProcesses(Math.max(2, wps.getMaxAsynchronousProcesses()));
        this.getGeoServer().save((ServiceInfo)wps);
    }

    @Before
    public void setUpInternal() throws Exception {
        MonkeyProcess.clearCommands();
    }

    @Test
    public void testEntityExpansion() throws Exception {
        String xml = "<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?><!DOCTYPE foo [<!ELEMENT foo ANY >\n  <!ENTITY xxe SYSTEM \"FILE:///file/not/there?.XSD\" >]>\n<wps:Execute service='WPS' version='1.0.0' xmlns:wps='http://www.opengis.net/wps/1.0.0' xmlns:ows='http://www.opengis.net/ows/1.1'><ows:Identifier>JTS:buffer</ows:Identifier><wps:DataInputs><wps:Input><ows:Identifier>distance</ows:Identifier><wps:Data><wps:LiteralData>1</wps:LiteralData></wps:Data></wps:Input><wps:Input><ows:Identifier>&xxe;</ows:Identifier><wps:Data><wps:ComplexData><gml:Polygon xmlns:gml='http://www.opengis.net/gml'><gml:exterior><gml:LinearRing><gml:coordinates>1 1 2 1 2 2 1 2 1 1</gml:coordinates></gml:LinearRing></gml:exterior></gml:Polygon></wps:ComplexData></wps:Data></wps:Input></wps:DataInputs><wps:ResponseForm><wps:ResponseDocument storeExecuteResponse='false'><wps:Output><ows:Identifier>result</ows:Identifier></wps:Output></wps:ResponseDocument></wps:ResponseForm></wps:Execute>";
        Document d = this.postAsDOM("wps", xml);
        this.checkValidationErrors(d);
        String text = xp.evaluate("//ows:ExceptionText", d);
        Assert.assertTrue((boolean)text.contains("Entity resolution disallowed for "));
    }

    @Test
    public void testDataInline() throws Exception {
        String xml = "<wps:Execute service='WPS' version='1.0.0' xmlns:wps='http://www.opengis.net/wps/1.0.0' xmlns:ows='http://www.opengis.net/ows/1.1'><ows:Identifier>JTS:buffer</ows:Identifier><wps:DataInputs><wps:Input><ows:Identifier>distance</ows:Identifier><wps:Data><wps:LiteralData>1</wps:LiteralData></wps:Data></wps:Input><wps:Input><ows:Identifier>geom</ows:Identifier><wps:Data><wps:ComplexData><gml:Polygon xmlns:gml='http://www.opengis.net/gml'><gml:exterior><gml:LinearRing><gml:coordinates>1 1 2 1 2 2 1 2 1 1</gml:coordinates></gml:LinearRing></gml:exterior></gml:Polygon></wps:ComplexData></wps:Data></wps:Input></wps:DataInputs><wps:ResponseForm><wps:ResponseDocument storeExecuteResponse='false'><wps:Output><ows:Identifier>result</ows:Identifier></wps:Output></wps:ResponseDocument></wps:ResponseForm></wps:Execute>";
        Document d = this.postAsDOM("wps", xml);
        this.checkValidationErrors(d);
        Assert.assertEquals((Object)"wps:ExecuteResponse", (Object)d.getDocumentElement().getNodeName());
        XMLAssert.assertXpathExists((String)"/wps:ExecuteResponse/wps:Status/wps:ProcessSucceeded", (Document)d);
        XMLAssert.assertXpathExists((String)"/wps:ExecuteResponse/wps:ProcessOutputs/wps:Output/wps:Data/wps:ComplexData/gml:Polygon", (Document)d);
    }

    @Test
    public void testCDataOutput() throws Exception {
        String xml = "<wps:Execute service='WPS' version='1.0.0' xmlns:wps='http://www.opengis.net/wps/1.0.0' xmlns:ows='http://www.opengis.net/ows/1.1'><ows:Identifier>JTS:buffer</ows:Identifier><wps:DataInputs><wps:Input><ows:Identifier>distance</ows:Identifier><wps:Data><wps:LiteralData>1</wps:LiteralData></wps:Data></wps:Input><wps:Input><ows:Identifier>geom</ows:Identifier><wps:Data><wps:ComplexData><gml:Polygon xmlns:gml='http://www.opengis.net/gml'><gml:exterior><gml:LinearRing><gml:coordinates>1 1 2 1 2 2 1 2 1 1</gml:coordinates></gml:LinearRing></gml:exterior></gml:Polygon></wps:ComplexData></wps:Data></wps:Input></wps:DataInputs><wps:ResponseForm><wps:ResponseDocument storeExecuteResponse='false'><wps:Output mimeType=\"application/wkt\"><ows:Identifier>result</ows:Identifier></wps:Output></wps:ResponseDocument></wps:ResponseForm></wps:Execute>";
        Document d = this.postAsDOM("wps", xml);
        this.checkValidationErrors(d);
        Assert.assertEquals((Object)"wps:ExecuteResponse", (Object)d.getDocumentElement().getNodeName());
        XMLAssert.assertXpathExists((String)"/wps:ExecuteResponse/wps:Status/wps:ProcessSucceeded", (Document)d);
        String wkt = xp.evaluate("/wps:ExecuteResponse/wps:ProcessOutputs/wps:Output/wps:Data/wps:ComplexData", d);
        MatcherAssert.assertThat((Object)new WKTReader().read(wkt), (Matcher)CoreMatchers.instanceOf(Polygon.class));
    }

    @Test
    public void testDataInlineRawOutput() throws Exception {
        String xml = "<wps:Execute service='WPS' version='1.0.0' xmlns:wps='http://www.opengis.net/wps/1.0.0' xmlns:ows='http://www.opengis.net/ows/1.1'><ows:Identifier>JTS:buffer</ows:Identifier><wps:DataInputs><wps:Input><ows:Identifier>distance</ows:Identifier><wps:Data><wps:LiteralData>1</wps:LiteralData></wps:Data></wps:Input><wps:Input><ows:Identifier>geom</ows:Identifier><wps:Data><wps:ComplexData><gml:Polygon xmlns:gml='http://www.opengis.net/gml'><gml:exterior><gml:LinearRing><gml:coordinates>1 1 2 1 2 2 1 2 1 1</gml:coordinates></gml:LinearRing></gml:exterior></gml:Polygon></wps:ComplexData></wps:Data></wps:Input></wps:DataInputs><wps:ResponseForm>    <wps:RawDataOutput>        <ows:Identifier>result</ows:Identifier>    </wps:RawDataOutput>  </wps:ResponseForm></wps:Execute>";
        Document d = this.postAsDOM("wps", xml);
        this.checkValidationErrors(d, (Configuration)new GMLConfiguration());
        Assert.assertEquals((Object)"gml:Polygon", (Object)d.getDocumentElement().getNodeName());
    }

    @Test
    public void testWKTInlineRawOutput() throws Exception {
        String xml = "<wps:Execute service='WPS' version='1.0.0' xmlns:wps='http://www.opengis.net/wps/1.0.0' xmlns:ows='http://www.opengis.net/ows/1.1'><ows:Identifier>JTS:buffer</ows:Identifier><wps:DataInputs><wps:Input><ows:Identifier>distance</ows:Identifier><wps:Data><wps:LiteralData>1</wps:LiteralData></wps:Data></wps:Input><wps:Input><ows:Identifier>geom</ows:Identifier><wps:Data><wps:ComplexData mimeType=\"application/wkt\"><![CDATA[POLYGON((1 1, 2 1, 2 2, 1 2, 1 1))]]></wps:ComplexData></wps:Data></wps:Input></wps:DataInputs><wps:ResponseForm>    <wps:RawDataOutput mimeType=\"application/wkt\">        <ows:Identifier>result</ows:Identifier>    </wps:RawDataOutput>  </wps:ResponseForm></wps:Execute>";
        MockHttpServletResponse response = this.postAsServletResponse("wps", xml);
        Assert.assertEquals((Object)"application/wkt", (Object)response.getContentType());
        String cd = response.getHeader("Content-Disposition");
        Assert.assertTrue((boolean)cd.endsWith("filename=result.wkt"));
        Geometry g = new WKTReader().read(response.getContentAsString());
        Assert.assertTrue((boolean)(g instanceof Polygon));
    }

    @Test
    public void testWKTInlineKVPRawOutput() throws Exception {
        String request = "wps?service=WPS&version=1.0.0&request=Execute&Identifier=JTS:buffer&DataInputs=" + this.urlEncode("geom=POLYGON((1 1, 2 1, 2 2, 1 2, 1 1))@mimetype=application/wkt;distance=1") + "&RawDataOutput=" + this.urlEncode("result=@mimetype=application/wkt");
        MockHttpServletResponse response = this.getAsServletResponse(request);
        Assert.assertEquals((Object)"application/wkt", (Object)response.getContentType());
        Geometry g = new WKTReader().read(response.getContentAsString());
        Assert.assertTrue((boolean)(g instanceof Polygon));
    }

    @Test
    public void testFeatureCollectionInline() throws Exception {
        String xml = "<wps:Execute service='WPS' version='1.0.0' xmlns:wps='http://www.opengis.net/wps/1.0.0' xmlns:ows='http://www.opengis.net/ows/1.1'><ows:Identifier>gs:BufferFeatureCollection</ows:Identifier><wps:DataInputs><wps:Input><ows:Identifier>features</ows:Identifier><wps:Data><wps:ComplexData>" + this.readFileIntoString("states-FeatureCollection.xml") + "</wps:ComplexData></wps:Data></wps:Input><wps:Input><ows:Identifier>distance</ows:Identifier><wps:Data><wps:LiteralData>10</wps:LiteralData></wps:Data></wps:Input><wps:Input><ows:Identifier>attributeName</ows:Identifier><wps:Data><wps:LiteralData></wps:LiteralData></wps:Data></wps:Input></wps:DataInputs><wps:ResponseForm><wps:ResponseDocument storeExecuteResponse='false'><wps:Output><ows:Identifier>result</ows:Identifier></wps:Output></wps:ResponseDocument></wps:ResponseForm></wps:Execute>";
        Document d = this.postAsDOM("wps", xml);
        this.checkValidationErrors(d);
        Assert.assertEquals((Object)"wps:ExecuteResponse", (Object)d.getDocumentElement().getNodeName());
        XMLAssert.assertXpathExists((String)"/wps:ExecuteResponse/wps:Status/wps:ProcessSucceeded", (Document)d);
        XMLAssert.assertXpathExists((String)"/wps:ExecuteResponse/wps:ProcessOutputs/wps:Output/wps:Data/wps:ComplexData/wfs:FeatureCollection", (Document)d);
    }

    @Test
    public void testFeatureCollectionInlineWithLocation() throws Exception {
        String xml = "<wps:Execute service='WPS' version='1.0.0' xmlns:wps='http://www.opengis.net/wps/1.0.0' xmlns:ows='http://www.opengis.net/ows/1.1'><ows:Identifier>gs:Nearest</ows:Identifier><wps:DataInputs><wps:Input><ows:Identifier>features</ows:Identifier><wps:Data><wps:ComplexData>" + this.readFileIntoString("places-FeatureCollectionLocation.xml") + "</wps:ComplexData></wps:Data></wps:Input><wps:Input><ows:Identifier>point</ows:Identifier><wps:Data><wps:ComplexData mimeType=\"text/xml; subtype=gml/3.1.1\"><![CDATA[POINT(-96 41)]]></wps:ComplexData></wps:Data></wps:Input><wps:Input><ows:Identifier>crs</ows:Identifier><wps:Data><wps:LiteralData>EPSG:4326</wps:LiteralData></wps:Data></wps:Input></wps:DataInputs><wps:ResponseForm><wps:ResponseDocument storeExecuteResponse='false'><wps:Output><ows:Identifier>result</ows:Identifier></wps:Output></wps:ResponseDocument></wps:ResponseForm></wps:Execute>";
        Document d = this.postAsDOM("wps", xml);
        this.checkValidationErrors(d);
        Assert.assertEquals((Object)"wps:ExecuteResponse", (Object)d.getDocumentElement().getNodeName());
        XMLAssert.assertXpathExists((String)"/wps:ExecuteResponse/wps:Status/wps:ProcessSucceeded", (Document)d);
        XMLAssert.assertXpathExists((String)"/wps:ExecuteResponse/wps:ProcessOutputs/wps:Output/wps:Data/wps:ComplexData/wfs:FeatureCollection", (Document)d);
    }

    @Test
    public void testFeatureCollectionInlineBoundedBy() throws Exception {
        String xml = "<wps:Execute service='WPS' version='1.0.0' xmlns:wps='http://www.opengis.net/wps/1.0.0' xmlns:ows='http://www.opengis.net/ows/1.1'><ows:Identifier>gs:BufferFeatureCollection</ows:Identifier><wps:DataInputs><wps:Input><ows:Identifier>features</ows:Identifier><wps:Data><wps:ComplexData mimeType=\"text/xml; subtype=wfs-collection/1.0\">" + this.readFileIntoString("restricted-FeatureCollection.xml") + "</wps:ComplexData></wps:Data></wps:Input><wps:Input><ows:Identifier>distance</ows:Identifier><wps:Data><wps:LiteralData>1000</wps:LiteralData></wps:Data></wps:Input></wps:DataInputs><wps:ResponseForm><wps:ResponseDocument storeExecuteResponse='false'><wps:Output><ows:Identifier>result</ows:Identifier></wps:Output></wps:ResponseDocument></wps:ResponseForm></wps:Execute>";
        Document d = this.postAsDOM("wps", xml);
        this.checkValidationErrors(d);
        Assert.assertEquals((Object)"wps:ExecuteResponse", (Object)d.getDocumentElement().getNodeName());
        XMLAssert.assertXpathExists((String)"/wps:ExecuteResponse/wps:Status/wps:ProcessSucceeded", (Document)d);
        XMLAssert.assertXpathExists((String)"/wps:ExecuteResponse/wps:ProcessOutputs/wps:Output/wps:Data/wps:ComplexData/wfs:FeatureCollection", (Document)d);
        XMLAssert.assertXpathEvaluatesTo((String)"0", (String)"count(//feature:boundedBy)", (Document)d);
    }

    @Test
    public void testFeatureCollectionInlineKVP() throws Exception {
        String request = "wps?service=WPS&version=1.0.0&request=Execute&Identifier=gs:BufferFeatureCollection&DataInputs=" + this.urlEncode("features=" + this.readFileIntoString("states-FeatureCollection.xml") + "@mimetype=application/wfs-collection-1.1;distance=10") + "&ResponseDocument=" + this.urlEncode("result");
        Document d = this.getAsDOM(request);
        this.checkValidationErrors(d);
        Assert.assertEquals((Object)"wps:ExecuteResponse", (Object)d.getDocumentElement().getNodeName());
        XMLAssert.assertXpathExists((String)"/wps:ExecuteResponse/wps:Status/wps:ProcessSucceeded", (Document)d);
        XMLAssert.assertXpathExists((String)"/wps:ExecuteResponse/wps:ProcessOutputs/wps:Output/wps:Data/wps:ComplexData/wfs:FeatureCollection", (Document)d);
    }

    @Test
    public void testReferenceOutputXML() throws Exception {
        String xml = "<wps:Execute service='WPS' version='1.0.0' xmlns:wps='http://www.opengis.net/wps/1.0.0' xmlns:ows='http://www.opengis.net/ows/1.1'><ows:Identifier>gs:BufferFeatureCollection</ows:Identifier><wps:DataInputs><wps:Input><ows:Identifier>features</ows:Identifier><wps:Data><wps:ComplexData mimeType=\"text/xml; subtype=wfs-collection/1.0\">" + this.readFileIntoString("restricted-FeatureCollection.xml") + "</wps:ComplexData></wps:Data></wps:Input><wps:Input><ows:Identifier>distance</ows:Identifier><wps:Data><wps:LiteralData>1000</wps:LiteralData></wps:Data></wps:Input></wps:DataInputs><wps:ResponseForm><wps:ResponseDocument storeExecuteResponse='false'><wps:Output asReference=\"true\"><ows:Identifier>result</ows:Identifier></wps:Output></wps:ResponseDocument></wps:ResponseForm></wps:Execute>";
        Document d = this.postAsDOM("wps", xml);
        this.checkValidationErrors(d);
        Assert.assertEquals((Object)"wps:ExecuteResponse", (Object)d.getDocumentElement().getNodeName());
        XMLAssert.assertXpathExists((String)"/wps:ExecuteResponse/wps:Status/wps:ProcessSucceeded", (Document)d);
        XMLAssert.assertXpathExists((String)"/wps:ExecuteResponse/wps:ProcessOutputs/wps:Output/wps:Reference", (Document)d);
        XpathEngine xpath = XMLUnit.newXpathEngine();
        String fullLocation = xpath.evaluate("/wps:ExecuteResponse/wps:ProcessOutputs/wps:Output/wps:Reference/@href", d);
        String resourceLocation = fullLocation.substring(fullLocation.indexOf(63) - 3);
        d = this.getAsDOM(resourceLocation);
        XMLAssert.assertXpathExists((String)"wfs:FeatureCollection", (Document)d);
    }

    @Test
    public void testReferenceOutputKVP() throws Exception {
        String request = "wps?service=WPS&version=1.0.0&request=Execute&Identifier=gs:BufferFeatureCollection&DataInputs=" + this.urlEncode("features=" + this.readFileIntoString("states-FeatureCollection.xml") + "@mimetype=application/wfs-collection-1.1;distance=10") + "&ResponseDocument=" + this.urlEncode("result=@asReference=true");
        Document d = this.getAsDOM(request);
        this.checkValidationErrors(d);
        Assert.assertEquals((Object)"wps:ExecuteResponse", (Object)d.getDocumentElement().getNodeName());
        XMLAssert.assertXpathExists((String)"/wps:ExecuteResponse/wps:Status/wps:ProcessSucceeded", (Document)d);
        XMLAssert.assertXpathExists((String)"/wps:ExecuteResponse/wps:ProcessOutputs/wps:Output/wps:Reference", (Document)d);
        XpathEngine xpath = XMLUnit.newXpathEngine();
        String fullLocation = xpath.evaluate("/wps:ExecuteResponse/wps:ProcessOutputs/wps:Output/wps:Reference/@href", d);
        String resourceLocation = fullLocation.substring(fullLocation.indexOf(63) - 3);
        MockHttpServletResponse response = this.getAsServletResponse(resourceLocation);
        Assert.assertEquals((Object)"text/xml; subtype=wfs-collection/1.0", (Object)response.getContentType());
        d = this.dom(new ByteArrayInputStream(response.getContentAsString().getBytes()));
        XMLAssert.assertXpathExists((String)"wfs:FeatureCollection", (Document)d);
    }

    @Test
    public void testFeatureCollectionFileReference() throws Exception {
        this.setRemoteInputDisabled(false);
        URL collectionURL = ((Object)((Object)this)).getClass().getResource("states-FeatureCollection.xml");
        String xml = "<wps:Execute service='WPS' version='1.0.0' xmlns:wps='http://www.opengis.net/wps/1.0.0' xmlns:xlink=\"http://www.w3.org/1999/xlink\" xmlns:ows='http://www.opengis.net/ows/1.1'><ows:Identifier>gs:BufferFeatureCollection</ows:Identifier><wps:DataInputs><wps:Input><ows:Identifier>features</ows:Identifier>  <wps:Reference mimeType=\"text/xml; subtype=wfs-collection/1.1\" xlink:href=\"" + collectionURL.toExternalForm() + "\"/>\n</wps:Input><wps:Input><ows:Identifier>distance</ows:Identifier><wps:Data><wps:LiteralData>10</wps:LiteralData></wps:Data></wps:Input></wps:DataInputs><wps:ResponseForm><wps:ResponseDocument storeExecuteResponse='false'><wps:Output><ows:Identifier>result</ows:Identifier></wps:Output></wps:ResponseDocument></wps:ResponseForm></wps:Execute>";
        Document d = this.postAsDOM("wps", xml);
        this.checkValidationErrors(d);
        Assert.assertEquals((Object)"wps:ExecuteResponse", (Object)d.getDocumentElement().getNodeName());
        XMLAssert.assertXpathExists((String)"/wps:ExecuteResponse/wps:Status/wps:ProcessSucceeded", (Document)d);
        XMLAssert.assertXpathExists((String)"/wps:ExecuteResponse/wps:ProcessOutputs/wps:Output/wps:Data/wps:ComplexData/wfs:FeatureCollection", (Document)d);
    }

    @Test
    public void testFeatureCollectionFileReferenceDisabled() throws Exception {
        this.setRemoteInputDisabled(true);
        URL collectionURL = ((Object)((Object)this)).getClass().getResource("states-FeatureCollection.xml");
        String xml = "<wps:Execute service='WPS' version='1.0.0' xmlns:wps='http://www.opengis.net/wps/1.0.0' xmlns:xlink=\"http://www.w3.org/1999/xlink\" xmlns:ows='http://www.opengis.net/ows/1.1'><ows:Identifier>gs:BufferFeatureCollection</ows:Identifier><wps:DataInputs><wps:Input><ows:Identifier>features</ows:Identifier>  <wps:Reference mimeType=\"text/xml; subtype=wfs-collection/1.1\" xlink:href=\"" + collectionURL.toExternalForm() + "\"/>\n</wps:Input><wps:Input><ows:Identifier>distance</ows:Identifier><wps:Data><wps:LiteralData>10</wps:LiteralData></wps:Data></wps:Input></wps:DataInputs><wps:ResponseForm><wps:ResponseDocument storeExecuteResponse='false'><wps:Output><ows:Identifier>result</ows:Identifier></wps:Output></wps:ResponseDocument></wps:ResponseForm></wps:Execute>";
        Document d = this.postAsDOM("wps", xml);
        this.checkValidationErrors(d);
        Assert.assertEquals((Object)"ows:ExceptionReport", (Object)d.getDocumentElement().getNodeName());
        XMLAssert.assertXpathExists((String)"/ows:ExceptionReport/ows:Exception/ows:ExceptionText", (Document)d);
        XMLAssert.assertXpathEvaluatesTo((String)"Failed to parse process input: features\nRemote complex input references are disabled", (String)"/ows:ExceptionReport/ows:Exception/ows:ExceptionText", (Document)d);
    }

    @Test
    public void testFeatureCollectionFileReferenceError() throws Exception {
        this.setRemoteInputDisabled(false);
        URL collectionURL = ((Object)((Object)this)).getClass().getResource("my-secret.xml");
        String xml = "<wps:Execute service='WPS' version='1.0.0' xmlns:wps='http://www.opengis.net/wps/1.0.0' xmlns:xlink=\"http://www.w3.org/1999/xlink\" xmlns:ows='http://www.opengis.net/ows/1.1'><ows:Identifier>gs:BufferFeatureCollection</ows:Identifier><wps:DataInputs><wps:Input><ows:Identifier>features</ows:Identifier>  <wps:Reference mimeType=\"text/xml; subtype=wfs-collection/1.1\" xlink:href=\"" + collectionURL.toExternalForm() + "\"/>\n</wps:Input><wps:Input><ows:Identifier>distance</ows:Identifier><wps:Data><wps:LiteralData>10</wps:LiteralData></wps:Data></wps:Input></wps:DataInputs><wps:ResponseForm><wps:ResponseDocument storeExecuteResponse='false'><wps:Output><ows:Identifier>result</ows:Identifier></wps:Output></wps:ResponseDocument></wps:ResponseForm></wps:Execute>";
        Document d = this.postAsDOM("wps", xml);
        this.checkValidationErrors(d);
        Assert.assertEquals((Object)"wps:ExecuteResponse", (Object)d.getDocumentElement().getNodeName());
        XMLAssert.assertXpathExists((String)"/wps:ExecuteResponse/wps:Status/wps:ProcessFailed", (Document)d);
        XMLAssert.assertXpathEvaluatesTo((String)"Failed to retrieve value for input features", (String)"/wps:ExecuteResponse/wps:Status/wps:ProcessFailed/ows:ExceptionReport/ows:Exception/ows:ExceptionText", (Document)d);
    }

    @Test
    public void testFeatureCollectionFileReferenceKVP() throws Exception {
        this.setRemoteInputDisabled(false);
        URL collectionURL = ((Object)((Object)this)).getClass().getResource("states-FeatureCollection.xml");
        String request = "wps?service=WPS&version=1.0.0&request=Execute&Identifier=gs:BufferFeatureCollection&DataInputs=" + this.urlEncode("features=@mimetype=application/wfs-collection-1.1@xlink:href=" + collectionURL.toExternalForm() + ";distance=10") + "&ResponseDocument=" + this.urlEncode("result");
        Document d = this.getAsDOM(request);
        this.checkValidationErrors(d);
        Assert.assertEquals((Object)"wps:ExecuteResponse", (Object)d.getDocumentElement().getNodeName());
        XMLAssert.assertXpathExists((String)"/wps:ExecuteResponse/wps:Status/wps:ProcessSucceeded", (Document)d);
        XMLAssert.assertXpathExists((String)"/wps:ExecuteResponse/wps:ProcessOutputs/wps:Output/wps:Data/wps:ComplexData/wfs:FeatureCollection", (Document)d);
    }

    @Test
    public void testFeatureCollectionFileReferenceKVPDisabled() throws Exception {
        this.setRemoteInputDisabled(true);
        URL collectionURL = ((Object)((Object)this)).getClass().getResource("states-FeatureCollection.xml");
        String request = "wps?service=WPS&version=1.0.0&request=Execute&Identifier=gs:BufferFeatureCollection&DataInputs=" + this.urlEncode("features=@mimetype=application/wfs-collection-1.1@xlink:href=" + collectionURL.toExternalForm() + ";distance=10") + "&ResponseDocument=" + this.urlEncode("result");
        Document d = this.getAsDOM(request);
        this.checkValidationErrors(d);
        Assert.assertEquals((Object)"ows:ExceptionReport", (Object)d.getDocumentElement().getNodeName());
        XMLAssert.assertXpathExists((String)"/ows:ExceptionReport/ows:Exception/ows:ExceptionText", (Document)d);
        XMLAssert.assertXpathEvaluatesTo((String)"Failed to parse process input: features\nRemote complex input references are disabled", (String)"/ows:ExceptionReport/ows:Exception/ows:ExceptionText", (Document)d);
    }

    @Test
    public void testFeatureCollectionFileReferenceKVPError() throws Exception {
        this.setRemoteInputDisabled(false);
        URL collectionURL = ((Object)((Object)this)).getClass().getResource("my-secret.xml");
        String request = "wps?service=WPS&version=1.0.0&request=Execute&Identifier=gs:BufferFeatureCollection&DataInputs=" + this.urlEncode("features=@mimetype=application/wfs-collection-1.1@xlink:href=" + collectionURL.toExternalForm() + ";distance=10") + "&ResponseDocument=" + this.urlEncode("result");
        Document d = this.getAsDOM(request);
        this.checkValidationErrors(d);
        Assert.assertEquals((Object)"wps:ExecuteResponse", (Object)d.getDocumentElement().getNodeName());
        XMLAssert.assertXpathExists((String)"/wps:ExecuteResponse/wps:Status/wps:ProcessFailed", (Document)d);
        XMLAssert.assertXpathEvaluatesTo((String)"Failed to retrieve value for input features", (String)"/wps:ExecuteResponse/wps:Status/wps:ProcessFailed/ows:ExceptionReport/ows:Exception/ows:ExceptionText", (Document)d);
    }

    @Test
    public void testInlineGeoJSON() throws Exception {
        String xml = "<wps:Execute service='WPS' version='1.0.0' xmlns:wps='http://www.opengis.net/wps/1.0.0' xmlns:ows='http://www.opengis.net/ows/1.1'><ows:Identifier>gs:BufferFeatureCollection</ows:Identifier><wps:DataInputs><wps:Input><ows:Identifier>features</ows:Identifier><wps:Data><wps:ComplexData mimeType=\"application/json\"><![CDATA[" + this.readFileIntoString("states-FeatureCollection.json") + "]]></wps:ComplexData></wps:Data></wps:Input><wps:Input><ows:Identifier>distance</ows:Identifier><wps:Data><wps:LiteralData>10</wps:LiteralData></wps:Data></wps:Input></wps:DataInputs><wps:ResponseForm><wps:RawDataOutput mimeType=\"application/json\"><ows:Identifier>result</ows:Identifier></wps:RawDataOutput></wps:ResponseForm></wps:Execute>";
        MockHttpServletResponse r = this.postAsServletResponse("wps", xml);
        Assert.assertEquals((Object)"application/json", (Object)r.getContentType());
        try (GeoJSONReader reader = new GeoJSONReader(r.getContentAsString());){
            SimpleFeatureCollection fc = reader.getFeatures();
            Assert.assertEquals((long)2L, (long)fc.size());
        }
    }

    @Test
    public void testInlineShapezip() throws Exception {
        String xml = "<wps:Execute service='WPS' version='1.0.0' xmlns:wps='http://www.opengis.net/wps/1.0.0' xmlns:ows='http://www.opengis.net/ows/1.1'><ows:Identifier>gs:BufferFeatureCollection</ows:Identifier><wps:DataInputs><wps:Input><ows:Identifier>features</ows:Identifier><wps:Data><wps:ComplexData mimeType=\"application/zip\" encoding=\"base64\"><![CDATA[" + this.readFileIntoString("states-zip-base64.txt") + "]]></wps:ComplexData></wps:Data></wps:Input><wps:Input><ows:Identifier>distance</ows:Identifier><wps:Data><wps:LiteralData>10</wps:LiteralData></wps:Data></wps:Input></wps:DataInputs><wps:ResponseForm><wps:RawDataOutput mimeType=\"application/json\"><ows:Identifier>result</ows:Identifier></wps:RawDataOutput></wps:ResponseForm></wps:Execute>";
        MockHttpServletResponse r = this.postAsServletResponse("wps", xml);
        Assert.assertEquals((Object)"application/json", (Object)r.getContentType());
        try (GeoJSONReader reader = new GeoJSONReader(r.getContentAsString());){
            SimpleFeatureCollection fc = reader.getFeatures();
            Assert.assertEquals((long)2L, (long)fc.size());
        }
    }

    @Test
    public void testShapeZip() throws Exception {
        String xml = "<wps:Execute service='WPS' version='1.0.0' xmlns:xlink=\"http://www.w3.org/1999/xlink\" xmlns:wps='http://www.opengis.net/wps/1.0.0' xmlns:wfs='http://www.opengis.net/wfs' xmlns:ows='http://www.opengis.net/ows/1.1'><ows:Identifier>gs:BufferFeatureCollection</ows:Identifier><wps:DataInputs>    <wps:Input>\n<ows:Identifier>features</ows:Identifier><wps:Data><wps:ComplexData>" + this.readFileIntoString("states-FeatureCollection.xml") + "</wps:ComplexData></wps:Data></wps:Input><wps:Input><ows:Identifier>distance</ows:Identifier><wps:Data><wps:LiteralData>10</wps:LiteralData></wps:Data></wps:Input></wps:DataInputs><wps:ResponseForm><wps:RawDataOutput mimeType=\"application/zip\"><ows:Identifier>result</ows:Identifier></wps:RawDataOutput></wps:ResponseForm></wps:Execute>";
        MockHttpServletResponse r = this.postAsServletResponse("wps", xml);
        Assert.assertEquals((Object)"application/zip", (Object)r.getContentType());
        this.checkShapefileIntegrity(new String[]{"states"}, this.getBinaryInputStream(r));
    }

    @Test
    public void testBoundsPost() throws Exception {
        String request = this.streamsBoundsRequest();
        Document dom = this.postAsDOM(this.root(), request);
        this.print(dom);
        this.checkStreamsProcessBounds(dom);
    }

    private void checkStreamsProcessBounds(Document dom) throws XpathException {
        XMLAssert.assertXpathEvaluatesTo((String)"-4.0E-4 -0.0024", (String)"/ows:BoundingBox/ows:LowerCorner", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"0.0036 0.0024", (String)"/ows:BoundingBox/ows:UpperCorner", (Document)dom);
    }

    private String streamsBoundsRequest() {
        return "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<wps:Execute version=\"1.0.0\" service=\"WPS\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns=\"http://www.opengis.net/wps/1.0.0\" xmlns:wfs=\"http://www.opengis.net/wfs\" xmlns:wps=\"http://www.opengis.net/wps/1.0.0\" xmlns:ows=\"http://www.opengis.net/ows/1.1\" xmlns:gml=\"http://www.opengis.net/gml\" xmlns:ogc=\"http://www.opengis.net/ogc\" xmlns:wcs=\"http://www.opengis.net/wcs/1.1.1\" xmlns:xlink=\"http://www.w3.org/1999/xlink\" xsi:schemaLocation=\"http://www.opengis.net/wps/1.0.0 http://schemas.opengis.net/wps/1.0.0/wpsAll.xsd\">\n  <ows:Identifier>gs:Bounds</ows:Identifier>\n  <wps:DataInputs>\n    <wps:Input>\n      <ows:Identifier>features</ows:Identifier>\n      <wps:Reference mimeType=\"text/xml; subtype=wfs-collection/1.0\" xlink:href=\"http://geoserver/wfs\" method=\"POST\">\n        <wps:Body>\n          <wfs:GetFeature service=\"WFS\" version=\"1.0.0\">\n            <wfs:Query typeName=\"cite:Streams\"/>\n          </wfs:GetFeature>\n        </wps:Body>\n      </wps:Reference>\n    </wps:Input>\n  </wps:DataInputs>\n  <wps:ResponseForm>\n    <wps:RawDataOutput>\n      <ows:Identifier>bounds</ows:Identifier>\n    </wps:RawDataOutput>\n  </wps:ResponseForm>\n</wps:Execute>";
    }

    @Test
    public void testBoundsGet() throws Exception {
        String request = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<wps:Execute version=\"1.0.0\" service=\"WPS\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns=\"http://www.opengis.net/wps/1.0.0\" xmlns:wfs=\"http://www.opengis.net/wfs\" xmlns:wps=\"http://www.opengis.net/wps/1.0.0\" xmlns:ows=\"http://www.opengis.net/ows/1.1\" xmlns:gml=\"http://www.opengis.net/gml\" xmlns:ogc=\"http://www.opengis.net/ogc\" xmlns:wcs=\"http://www.opengis.net/wcs/1.1.1\" xmlns:xlink=\"http://www.w3.org/1999/xlink\" xsi:schemaLocation=\"http://www.opengis.net/wps/1.0.0 http://schemas.opengis.net/wps/1.0.0/wpsAll.xsd\">\n  <ows:Identifier>gs:Bounds</ows:Identifier>\n  <wps:DataInputs>\n    <wps:Input>\n      <ows:Identifier>features</ows:Identifier>\n      <wps:Reference mimeType=\"text/xml; subtype=wfs-collection/1.0\" xlink:href=\"http://geoserver/wfs?service=WFS&amp;request=GetFeature&amp;typename=cite:Streams\" method=\"GET\"/>\n    </wps:Input>\n  </wps:DataInputs>\n  <wps:ResponseForm>\n    <wps:RawDataOutput>\n      <ows:Identifier>bounds</ows:Identifier>\n    </wps:RawDataOutput>\n  </wps:ResponseForm>\n</wps:Execute>";
        Document dom = this.postAsDOM(this.root(), request);
        this.checkStreamsProcessBounds(dom);
    }

    @Test
    public void testBoundsIAUGet() throws Exception {
        String request = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<wps:Execute version=\"1.0.0\" service=\"WPS\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns=\"http://www.opengis.net/wps/1.0.0\" xmlns:wfs=\"http://www.opengis.net/wfs\" xmlns:wps=\"http://www.opengis.net/wps/1.0.0\" xmlns:ows=\"http://www.opengis.net/ows/1.1\" xmlns:gml=\"http://www.opengis.net/gml\" xmlns:ogc=\"http://www.opengis.net/ogc\" xmlns:wcs=\"http://www.opengis.net/wcs/1.1.1\" xmlns:xlink=\"http://www.w3.org/1999/xlink\" xsi:schemaLocation=\"http://www.opengis.net/wps/1.0.0 http://schemas.opengis.net/wps/1.0.0/wpsAll.xsd\">\n  <ows:Identifier>gs:Bounds</ows:Identifier>\n  <wps:DataInputs>\n    <wps:Input>\n      <ows:Identifier>features</ows:Identifier>\n      <wps:Reference mimeType=\"text/xml; subtype=wfs-collection/1.0\" xlink:href=\"http://geoserver/wfs?service=WFS&amp;request=GetFeature&amp;typename=iau:MarsPoi\" method=\"GET\"/>\n    </wps:Input>\n  </wps:DataInputs>\n  <wps:ResponseForm>\n    <wps:RawDataOutput>\n      <ows:Identifier>bounds</ows:Identifier>\n    </wps:RawDataOutput>\n  </wps:ResponseForm>\n</wps:Execute>";
        Document dom = this.postAsDOM(this.root(), request);
        XMLAssert.assertXpathEvaluatesTo((String)"IAU:49900", (String)"/ows:BoundingBox/@crs", (Document)dom);
        Point2D lowerCorner = ExecuteTest.parseEnvelopeCorner(dom, "ows:LowerCorner");
        Assert.assertEquals((double)-65.0, (double)lowerCorner.getX(), (double)1.0E-6);
        Assert.assertEquals((double)-86.876, (double)lowerCorner.getY(), (double)1.0E-6);
        Point2D upperCorner = ExecuteTest.parseEnvelopeCorner(dom, "ows:UpperCorner");
        Assert.assertEquals((double)-2.76, (double)upperCorner.getX(), (double)1.0E-6);
        Assert.assertEquals((double)-9.885, (double)upperCorner.getY(), (double)1.0E-6);
    }

    private static Point2D parseEnvelopeCorner(Document dom, String corner) throws XpathException {
        String[] ordinates = xp.evaluate("/ows:BoundingBox/" + corner, dom).split(" ");
        return new Point2D.Double(Double.parseDouble(ordinates[0]), Double.parseDouble(ordinates[1]));
    }

    @Test
    public void testRemoteGetWFS10Layer() throws Exception {
        String request = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<wps:Execute version=\"1.0.0\" service=\"WPS\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns=\"http://www.opengis.net/wps/1.0.0\" xmlns:wfs=\"http://www.opengis.net/wfs\" xmlns:wps=\"http://www.opengis.net/wps/1.0.0\" xmlns:ows=\"http://www.opengis.net/ows/1.1\" xmlns:gml=\"http://www.opengis.net/gml\" xmlns:ogc=\"http://www.opengis.net/ogc\" xmlns:wcs=\"http://www.opengis.net/wcs/1.1.1\" xmlns:xlink=\"http://www.w3.org/1999/xlink\" xsi:schemaLocation=\"http://www.opengis.net/wps/1.0.0 http://schemas.opengis.net/wps/1.0.0/wpsAll.xsd\">\n  <ows:Identifier>gs:Bounds</ows:Identifier>\n  <wps:DataInputs>\n    <wps:Input>\n      <ows:Identifier>features</ows:Identifier>\n      <wps:Reference mimeType=\"text/xml; subtype=wfs-collection/1.0\"  xlink:href=\"http://demo.opengeo.org/geoserver/wfs?request=GetFeature&amp;service=wfs&amp;version=1.0.0&amp;typeName=topp:states&amp;featureid=states.1\" />\n    </wps:Input>\n  </wps:DataInputs>\n  <wps:ResponseForm>\n    <wps:RawDataOutput>\n      <ows:Identifier>bounds</ows:Identifier>\n    </wps:RawDataOutput>\n  </wps:ResponseForm>\n</wps:Execute>";
        this.executeState1BoundsTest(request, "GET WFS 1.0");
    }

    @Test
    public void testRemotePostWFS10Layer() throws Exception {
        String request = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<wps:Execute version=\"1.0.0\" service=\"WPS\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns=\"http://www.opengis.net/wps/1.0.0\" xmlns:wfs=\"http://www.opengis.net/wfs\" xmlns:wps=\"http://www.opengis.net/wps/1.0.0\" xmlns:ows=\"http://www.opengis.net/ows/1.1\" xmlns:gml=\"http://www.opengis.net/gml\" xmlns:ogc=\"http://www.opengis.net/ogc\" xmlns:wcs=\"http://www.opengis.net/wcs/1.1.1\" xmlns:xlink=\"http://www.w3.org/1999/xlink\" xsi:schemaLocation=\"http://www.opengis.net/wps/1.0.0 http://schemas.opengis.net/wps/1.0.0/wpsAll.xsd\">\n  <ows:Identifier>gs:Bounds</ows:Identifier>\n  <wps:DataInputs>\n    <wps:Input>\n      <ows:Identifier>features</ows:Identifier>\n      <wps:Reference mimeType=\"text/xml; subtype=wfs-collection/1.0\"  xlink:href=\"http://demo.opengeo.org/geoserver/wfs\" method=\"POST\">\n         <wps:Body>\n<![CDATA[<wfs:GetFeature service=\"WFS\" version=\"1.0.0\"\n  outputFormat=\"GML2\"\n  xmlns:topp=\"http://www.openplans.org/topp\"\n  xmlns:wfs=\"http://www.opengis.net/wfs\"\n  xmlns:ogc=\"http://www.opengis.net/ogc\"\n  xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n  xsi:schemaLocation=\"http://www.opengis.net/wfs\n                      http://schemas.opengis.net/wfs/1.0.0/WFS-basic.xsd\">\n  <wfs:Query typeName=\"topp:states\">\n    <ogc:Filter>\n       <ogc:FeatureId fid=\"states.1\"/>\n    </ogc:Filter>\n    </wfs:Query>\n</wfs:GetFeature>]]>         </wps:Body>\n      </wps:Reference>\n    </wps:Input>\n  </wps:DataInputs>\n  <wps:ResponseForm>\n    <wps:RawDataOutput>\n      <ows:Identifier>bounds</ows:Identifier>\n    </wps:RawDataOutput>\n  </wps:ResponseForm>\n</wps:Execute>";
        this.executeState1BoundsTest(request, "POST WFS 1.0");
    }

    @Test
    public void testRemoteBodyReferencePostWFS10Layer() throws Exception {
        URL getFeatureURL = ((Object)((Object)this)).getClass().getResource("getFeature.xml");
        String request = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<wps:Execute version=\"1.0.0\" service=\"WPS\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns=\"http://www.opengis.net/wps/1.0.0\" xmlns:wfs=\"http://www.opengis.net/wfs\" xmlns:wps=\"http://www.opengis.net/wps/1.0.0\" xmlns:ows=\"http://www.opengis.net/ows/1.1\" xmlns:gml=\"http://www.opengis.net/gml\" xmlns:ogc=\"http://www.opengis.net/ogc\" xmlns:wcs=\"http://www.opengis.net/wcs/1.1.1\" xmlns:xlink=\"http://www.w3.org/1999/xlink\" xsi:schemaLocation=\"http://www.opengis.net/wps/1.0.0 http://schemas.opengis.net/wps/1.0.0/wpsAll.xsd\">\n  <ows:Identifier>gs:Bounds</ows:Identifier>\n  <wps:DataInputs>\n    <wps:Input>\n      <ows:Identifier>features</ows:Identifier>\n      <wps:Reference mimeType=\"text/xml; subtype=wfs-collection/1.0\"  xlink:href=\"http://demo.opengeo.org/geoserver/wfs\" method=\"POST\">\n         <wps:BodyReference xlink:href=\"" + getFeatureURL.toExternalForm() + "\"/>\n      </wps:Reference>\n    </wps:Input>\n  </wps:DataInputs>\n  <wps:ResponseForm>\n    <wps:RawDataOutput>\n      <ows:Identifier>bounds</ows:Identifier>\n    </wps:RawDataOutput>\n  </wps:ResponseForm>\n</wps:Execute>";
        this.executeState1BoundsTest(request, "POST WFS 1.0");
    }

    @Test
    public void testRemoteGetWFS11Layer() throws Exception {
        String request = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<wps:Execute version=\"1.0.0\" service=\"WPS\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns=\"http://www.opengis.net/wps/1.0.0\" xmlns:wfs=\"http://www.opengis.net/wfs\" xmlns:wps=\"http://www.opengis.net/wps/1.0.0\" xmlns:ows=\"http://www.opengis.net/ows/1.1\" xmlns:gml=\"http://www.opengis.net/gml\" xmlns:ogc=\"http://www.opengis.net/ogc\" xmlns:wcs=\"http://www.opengis.net/wcs/1.1.1\" xmlns:xlink=\"http://www.w3.org/1999/xlink\" xsi:schemaLocation=\"http://www.opengis.net/wps/1.0.0 http://schemas.opengis.net/wps/1.0.0/wpsAll.xsd\">\n  <ows:Identifier>gs:Bounds</ows:Identifier>\n  <wps:DataInputs>\n    <wps:Input>\n      <ows:Identifier>features</ows:Identifier>\n      <wps:Reference mimeType=\"text/xml; subtype=wfs-collection/1.1\"  xlink:href=\"http://demo.opengeo.org/geoserver/wfs?request=GetFeature&amp;service=wfs&amp;version=1.1&amp;typeName=topp:states&amp;featureid=states.1\" />\n    </wps:Input>\n  </wps:DataInputs>\n  <wps:ResponseForm>\n    <wps:RawDataOutput>\n      <ows:Identifier>bounds</ows:Identifier>\n    </wps:RawDataOutput>\n  </wps:ResponseForm>\n</wps:Execute>";
        this.executeState1BoundsTest(request, "GET WFS 1.1");
    }

    @Test
    public void testRemotePostWFS11Layer() throws Exception {
        String request = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<wps:Execute version=\"1.0.0\" service=\"WPS\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns=\"http://www.opengis.net/wps/1.0.0\" xmlns:wfs=\"http://www.opengis.net/wfs\" xmlns:wps=\"http://www.opengis.net/wps/1.0.0\" xmlns:ows=\"http://www.opengis.net/ows/1.1\" xmlns:gml=\"http://www.opengis.net/gml\" xmlns:ogc=\"http://www.opengis.net/ogc\" xmlns:wcs=\"http://www.opengis.net/wcs/1.1.1\" xmlns:xlink=\"http://www.w3.org/1999/xlink\" xsi:schemaLocation=\"http://www.opengis.net/wps/1.0.0 http://schemas.opengis.net/wps/1.0.0/wpsAll.xsd\">\n  <ows:Identifier>gs:Bounds</ows:Identifier>\n  <wps:DataInputs>\n    <wps:Input>\n      <ows:Identifier>features</ows:Identifier>\n      <wps:Reference mimeType=\"text/xml; subtype=wfs-collection/1.1\"  xlink:href=\"http://demo.opengeo.org/geoserver/wfs\" method=\"POST\">\n         <wps:Body>\n<![CDATA[<wfs:GetFeature service=\"WFS\" version=\"1.1.0\"\n  xmlns:topp=\"http://www.openplans.org/topp\"\n  xmlns:wfs=\"http://www.opengis.net/wfs\"\n  xmlns:ogc=\"http://www.opengis.net/ogc\"\n  xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n  xsi:schemaLocation=\"http://www.opengis.net/wfs\n                      http://schemas.opengis.net/wfs/1.1.0/wfs.xsd\">\n  <wfs:Query typeName=\"topp:states\">\n    <ogc:Filter>\n       <ogc:FeatureId fid=\"states.1\"/>\n    </ogc:Filter>\n    </wfs:Query>\n</wfs:GetFeature>]]>         </wps:Body>\n      </wps:Reference>\n    </wps:Input>\n  </wps:DataInputs>\n  <wps:ResponseForm>\n    <wps:RawDataOutput>\n      <ows:Identifier>bounds</ows:Identifier>\n    </wps:RawDataOutput>\n  </wps:ResponseForm>\n</wps:Execute>";
        this.executeState1BoundsTest(request, "POST WFS 1.1");
    }

    @Test
    public void testProcessChaining() throws Exception {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<wps:Execute version=\"1.0.0\" service=\"WPS\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns=\"http://www.opengis.net/wps/1.0.0\" xmlns:wfs=\"http://www.opengis.net/wfs\" xmlns:wps=\"http://www.opengis.net/wps/1.0.0\" xmlns:ows=\"http://www.opengis.net/ows/1.1\" xmlns:gml=\"http://www.opengis.net/gml\" xmlns:ogc=\"http://www.opengis.net/ogc\" xmlns:wcs=\"http://www.opengis.net/wcs/1.1.1\" xmlns:xlink=\"http://www.w3.org/1999/xlink\" xsi:schemaLocation=\"http://www.opengis.net/wps/1.0.0 http://schemas.opengis.net/wps/1.0.0/wpsAll.xsd\">\n  <ows:Identifier>JTS:area</ows:Identifier>\n  <wps:DataInputs>\n    <wps:Input>\n      <ows:Identifier>geom</ows:Identifier>\n      <wps:Reference mimeType=\"text/xml; subtype=gml/3.1.1\" xlink:href=\"http://geoserver/wps\" method=\"POST\">\n        <wps:Execute>\n          <ows:Identifier>JTS:buffer</ows:Identifier>\n          <wps:DataInputs>\n            <wps:Input>\n              <ows:Identifier>geom</ows:Identifier>\n              <wps:Data>\n                <wps:ComplexData mimeType=\"application/wkt\"><![CDATA[POINT(0 0)]]></wps:ComplexData>\n              </wps:Data>\n            </wps:Input>\n            <wps:Input>\n              <ows:Identifier>distance</ows:Identifier>\n              <wps:Data>\n                <wps:LiteralData>10</wps:LiteralData>\n              </wps:Data>\n            </wps:Input>\n          </wps:DataInputs>\n          <wps:ResponseForm>\n            <wps:RawDataOutput mimeType=\"text/xml; subtype=gml/3.1.1\">\n              <ows:Identifier>result</ows:Identifier>\n            </wps:RawDataOutput>\n          </wps:ResponseForm>\n        </wps:Execute>\n      </wps:Reference>\n    </wps:Input>\n  </wps:DataInputs>\n  <wps:ResponseForm>\n    <wps:RawDataOutput>\n      <ows:Identifier>result</ows:Identifier>\n    </wps:RawDataOutput>\n  </wps:ResponseForm>\n</wps:Execute>";
        MockHttpServletResponse resp = this.postAsServletResponse(this.root(), xml);
        Assert.assertEquals((Object)"text/plain", (Object)resp.getContentType());
        Assert.assertTrue((boolean)resp.getContentAsString().matches("312\\..*"));
    }

    @Test
    public void testNoResponseForm() throws Exception {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><wps:Execute xmlns:xs=\"http://www.w3.org/2001/XMLSchema\" xmlns:wps=\"http://www.opengis.net/wps/1.0.0\" xmlns:ows=\"http://www.opengis.net/ows/1.1\" xmlns:xlink=\"http://www.w3.org/1999/xlink\" service=\"WPS\" version=\"1.0.0\">\n  <ows:Identifier>JTS:area</ows:Identifier>\n  <wps:DataInputs>\n    <wps:Input>\n      <ows:Identifier>geom</ows:Identifier>\n      <wps:Reference xlink:href=\"http://geoserver/wps\" method=\"POST\" mimeType=\"application/xml\">\n        <wps:Execute service=\"WPS\" version=\"1.0.0\">\n          <ows:Identifier>JTS:union</ows:Identifier>\n          <wps:DataInputs>\n            <wps:Input>\n              <ows:Identifier>geom</ows:Identifier>\n              <wps:Data>\n                <wps:ComplexData mimeType=\"application/wkt\"><![CDATA[POLYGON((20 10, 30 0, 40 10, 30 20, 20 10))]]></wps:ComplexData>\n              </wps:Data>\n            </wps:Input>\n            <wps:Input>\n              <ows:Identifier>geom</ows:Identifier>\n              <wps:Data>\n                <wps:ComplexData mimeType=\"application/wkt\"><![CDATA[POLYGON((2 1, 3 0, 4 1, 3 2, 2 1))]]></wps:ComplexData>\n              </wps:Data>\n            </wps:Input>\n          </wps:DataInputs>\n        </wps:Execute>\n\n      </wps:Reference>\n    </wps:Input>\n  </wps:DataInputs>\n</wps:Execute>";
        Document dom = this.postAsDOM(this.root(), xml);
        this.print(dom);
    }

    @Test
    public void testProcessChainingKVP() throws Exception {
        String nested = "http://geoserver/wps?service=WPS&version=1.0.0&request=Execute&Identifier=JTS:buffer&DataInputs=" + this.urlEncode("geom=POINT(0 0)@mimetype=application/wkt;distance=10") + "&RawDataOutput=result";
        String request = "wps?service=WPS&version=1.0.0&request=Execute&Identifier=JTS:area&DataInputs=" + this.urlEncode("geom=@href=" + nested) + "&RawDataOutput=result";
        MockHttpServletResponse resp = this.getAsServletResponse(request);
        Assert.assertEquals((Object)"text/plain", (Object)resp.getContentType());
        Assert.assertTrue((boolean)resp.getContentAsString().matches("312\\..*"));
    }

    @Test
    public void testProcessFailure() throws Exception {
        MonkeyProcess.exception("x1", new ProcessException("Sorry dude, things went pear shaped..."), false);
        String request = "wps?service=WPS&version=1.0.0&request=Execute&Identifier=gs:Monkey&DataInputs=" + this.urlEncode("id=x1");
        Document dom = this.getAsDOM(request);
        this.checkValidationErrors(dom);
        this.print(dom);
        XMLAssert.assertXpathExists((String)"//wps:ProcessFailed", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"Process failed during execution\nSorry dude, things went pear shaped...", (String)"//wps:ProcessFailed/ows:ExceptionReport/ows:Exception/ows:ExceptionText", (Document)dom);
    }

    @Test
    public void testStoredNoStatus() throws Exception {
        String request = "wps?service=WPS&version=1.0.0&request=Execute&Identifier=gs:Monkey&storeExecuteResponse=true&DataInputs=" + this.urlEncode("id=x2");
        Document dom = this.getAsDOM(request);
        String fullStatusLocation = this.getFullStatusLocation(dom);
        String statusLocation = fullStatusLocation.substring(fullStatusLocation.indexOf(63) - 3);
        MonkeyProcess.progress("x2", 50.0f, true);
        dom = this.getAsDOM(statusLocation);
        this.print(dom);
        XMLAssert.assertXpathExists((String)"//wps:ProcessStarted", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"26", (String)"//wps:ProcessStarted/@percentCompleted", (Document)dom);
        ListFeatureCollection fc = this.collectionOfThings();
        MonkeyProcess.exit("x2", (SimpleFeatureCollection)fc, true);
        dom = this.waitForProcessEnd(statusLocation, 60L);
        XMLAssert.assertXpathExists((String)"//wps:ProcessSucceeded", (Document)dom);
    }

    @Test
    public void testStoredWithStatus() throws Exception {
        String statusLocation = this.submitMonkey("x3");
        MonkeyProcess.progress("x3", 10.0f, true);
        Document dom = this.getAsDOM(statusLocation);
        this.print(dom);
        XMLAssert.assertXpathExists((String)"//wps:ProcessStarted", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"6", (String)"//wps:ProcessStarted/@percentCompleted", (Document)dom);
        MonkeyProcess.progress("x3", 50.0f, true);
        dom = this.getAsDOM(statusLocation);
        XMLAssert.assertXpathExists((String)"//wps:ProcessStarted", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"26", (String)"//wps:ProcessStarted/@percentCompleted", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"Currently at 10.0", (String)"//wps:ProcessStarted", (Document)dom);
        MonkeyProcess.exit("x3", (SimpleFeatureCollection)this.collectionOfThings(), true);
        dom = this.waitForProcessEnd(statusLocation, 60L);
        XMLAssert.assertXpathExists((String)"//wps:ProcessSucceeded", (Document)dom);
    }

    @Test
    public void testChainedProgress() throws Exception {
        String request = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<wps:Execute version=\"1.0.0\" service=\"WPS\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns=\"http://www.opengis.net/wps/1.0.0\" xmlns:wfs=\"http://www.opengis.net/wfs\" xmlns:wps=\"http://www.opengis.net/wps/1.0.0\" xmlns:ows=\"http://www.opengis.net/ows/1.1\" xmlns:gml=\"http://www.opengis.net/gml\" xmlns:ogc=\"http://www.opengis.net/ogc\" xmlns:wcs=\"http://www.opengis.net/wcs/1.1.1\" xmlns:xlink=\"http://www.w3.org/1999/xlink\" xsi:schemaLocation=\"http://www.opengis.net/wps/1.0.0 http://schemas.opengis.net/wps/1.0.0/wpsAll.xsd\">\n  <ows:Identifier>gs:CollectGeometries</ows:Identifier>\n  <wps:DataInputs>\n    <wps:Input>\n      <ows:Identifier>features</ows:Identifier>\n      <wps:Reference mimeType=\"text/xml; subtype=wfs-collection/1.0\" xlink:href=\"http://geoserver/wps\" method=\"POST\">\n        <wps:Body>\n          <wps:Execute version=\"1.0.0\" service=\"WPS\">\n            <ows:Identifier>gs:Monkey</ows:Identifier>\n            <wps:DataInputs>\n              <wps:Input>\n                <ows:Identifier>id</ows:Identifier>\n                <wps:Data>\n                  <wps:LiteralData>chained-monkey</wps:LiteralData>\n                </wps:Data>\n              </wps:Input>\n            </wps:DataInputs>\n            <wps:ResponseForm>\n              <wps:RawDataOutput mimeType=\"text/xml; subtype=gml/3.1.1\">\n                <ows:Identifier>result</ows:Identifier>\n              </wps:RawDataOutput>\n            </wps:ResponseForm>\n          </wps:Execute>\n        </wps:Body>\n      </wps:Reference>\n    </wps:Input>\n  </wps:DataInputs>\n  <wps:ResponseForm>\n<wps:ResponseDocument status=\"true\" storeExecuteResponse=\"true\"><wps:Output asReference=\"true\"><ows:Identifier>result</ows:Identifier></wps:Output></wps:ResponseDocument>  </wps:ResponseForm>\n</wps:Execute>";
        Document dom = this.postAsDOM("wfs", request);
        String statusLocation = this.getStatusLocation(dom);
        MonkeyProcess.progress("chained-monkey", 10.0f, true);
        dom = this.getAsDOM(statusLocation);
        XMLAssert.assertXpathExists((String)"//wps:ProcessStarted", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"3", (String)"//wps:ProcessStarted/@percentCompleted", (Document)dom);
        MonkeyProcess.progress("chained-monkey", 50.0f, true);
        dom = this.getAsDOM(statusLocation);
        XMLAssert.assertXpathExists((String)"//wps:ProcessStarted", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"17", (String)"//wps:ProcessStarted/@percentCompleted", (Document)dom);
        MonkeyProcess.exit("chained-monkey", (SimpleFeatureCollection)this.collectionOfThings(), true);
        this.waitForProcessEnd(statusLocation, 60L);
    }

    @Test
    public void testTripleChainedProgress() throws Exception {
        String request = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<wps:Execute version=\"1.0.0\" service=\"WPS\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns=\"http://www.opengis.net/wps/1.0.0\" xmlns:wfs=\"http://www.opengis.net/wfs\" xmlns:wps=\"http://www.opengis.net/wps/1.0.0\" xmlns:ows=\"http://www.opengis.net/ows/1.1\" xmlns:gml=\"http://www.opengis.net/gml\" xmlns:ogc=\"http://www.opengis.net/ogc\" xmlns:wcs=\"http://www.opengis.net/wcs/1.1.1\" xmlns:xlink=\"http://www.w3.org/1999/xlink\" xsi:schemaLocation=\"http://www.opengis.net/wps/1.0.0 http://schemas.opengis.net/wps/1.0.0/wpsAll.xsd\">\n  <ows:Identifier>gs:Monkey</ows:Identifier>\n  <wps:DataInputs>\n    <wps:Input>\n       <ows:Identifier>id</ows:Identifier>\n       <wps:Data>\n           <wps:LiteralData>m1</wps:LiteralData>\n       </wps:Data>\n    </wps:Input>\n    <wps:Input>\n      <ows:Identifier>fc</ows:Identifier>\n      <wps:Reference mimeType=\"text/xml; subtype=wfs-collection/1.0\" xlink:href=\"http://geoserver/wps\" method=\"POST\">\n        <wps:Body>\n          <wps:Execute version=\"1.0.0\" service=\"WPS\">\n            <ows:Identifier>gs:Monkey</ows:Identifier>\n            <wps:DataInputs>\n              <wps:Input>\n                <ows:Identifier>id</ows:Identifier>\n                <wps:Data>\n                  <wps:LiteralData>m2</wps:LiteralData>\n                </wps:Data>\n              </wps:Input>\n              <wps:Input>\n                <ows:Identifier>fc</ows:Identifier>\n                <wps:Reference mimeType=\"text/xml; subtype=wfs-collection/1.0\" xlink:href=\"http://geoserver/wps\" method=\"POST\">\n                  <wps:Body>\n                    <wps:Execute version=\"1.0.0\" service=\"WPS\">\n                      <ows:Identifier>gs:Monkey</ows:Identifier>\n                      <wps:DataInputs>\n                        <wps:Input>\n                          <ows:Identifier>id</ows:Identifier>\n                          <wps:Data>\n                            <wps:LiteralData>m3</wps:LiteralData>\n                          </wps:Data>\n                        </wps:Input>\n                      </wps:DataInputs>\n                      <wps:ResponseForm>\n                        <wps:RawDataOutput mimeType=\"text/xml; subtype=gml/3.1.1\">\n                          <ows:Identifier>result</ows:Identifier>\n                        </wps:RawDataOutput>\n                      </wps:ResponseForm>\n                    </wps:Execute>\n                  </wps:Body>\n                </wps:Reference>\n              </wps:Input>\n              <wps:Input>\n                <ows:Identifier>extra</ows:Identifier>\n                <wps:Data>\n                  <wps:LiteralData>extra value</wps:LiteralData>\n                </wps:Data>\n              </wps:Input>\n            </wps:DataInputs>\n            <wps:ResponseForm>\n              <wps:RawDataOutput mimeType=\"text/xml; subtype=gml/3.1.1\">\n                <ows:Identifier>result</ows:Identifier>\n              </wps:RawDataOutput>\n            </wps:ResponseForm>\n          </wps:Execute>\n        </wps:Body>\n      </wps:Reference>\n    </wps:Input>\n  </wps:DataInputs>\n  <wps:ResponseForm>\n  <wps:ResponseDocument status=\"true\" storeExecuteResponse=\"true\">     <wps:Output asReference=\"true\">       <ows:Identifier>result</ows:Identifier>     </wps:Output>   </wps:ResponseDocument>  </wps:ResponseForm>\n</wps:Execute>";
        Document dom = this.postAsDOM("wfs", request);
        String statusLocation = this.getStatusLocation(dom);
        MonkeyProcess.progress("m3", 50.0f, true);
        this.assertProgress(statusLocation, "13");
        MonkeyProcess.exit("m3", (SimpleFeatureCollection)this.collectionOfThings(), true);
        this.assertProgress(statusLocation, "25");
        MonkeyProcess.progress("m2", 50.0f, true);
        this.assertProgress(statusLocation, "38");
        MonkeyProcess.exit("m2", (SimpleFeatureCollection)this.collectionOfThings(), true);
        this.assertProgress(statusLocation, "50");
        MonkeyProcess.progress("m1", 100.0f, true);
        this.assertProgress(statusLocation, "75");
        MonkeyProcess.exit("m1", (SimpleFeatureCollection)this.collectionOfThings(), true);
        this.waitForProcessEnd(statusLocation, 60L);
    }

    @Test
    public void testAsynchFailEncode() throws Exception {
        String statusLocation = this.submitMonkey("x5");
        MonkeyProcess.exit("x5", (SimpleFeatureCollection)this.bombOutCollection(), true);
        Document dom = this.waitForProcessEnd(statusLocation, 60L);
        XMLAssert.assertXpathExists((String)"//wps:ProcessFailed", (Document)dom);
    }

    @Test
    public void testDismissDuringEncoding() throws Exception {
        String statusLocation = this.submitMonkey("x3");
        Map kvp = KvpUtils.parseQueryString((String)statusLocation);
        String executionId = (String)kvp.get("executionId");
        MonkeyProcess.progress("x3", 100.0f, true);
        Document dom = this.getAsDOM(statusLocation);
        XMLAssert.assertXpathExists((String)"//wps:ProcessStarted", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"50", (String)"//wps:ProcessStarted/@percentCompleted", (Document)dom);
        final AtomicBoolean returnFlag = new AtomicBoolean(false);
        SimpleFeatureType featureType = this.buildSampleFeatureType();
        ListFeatureCollection fc = new ListFeatureCollection(featureType){

            public SimpleFeatureIterator features() {
                while (!returnFlag.get()) {
                    try {
                        Thread.sleep(20L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                return super.features();
            }

            protected Iterator<SimpleFeature> openIterator() {
                while (!returnFlag.get()) {
                    try {
                        Thread.sleep(20L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                return super.openIterator();
            }
        };
        MonkeyProcess.exit("x3", (SimpleFeatureCollection)fc, true);
        ProcessStatusTracker statusTracker = (ProcessStatusTracker)GeoServerExtensions.bean(ProcessStatusTracker.class, (ApplicationContext)applicationContext);
        dom = this.getAsDOM("wps?service=WPS&version=1.0.0&request=Dismiss&executionId=" + executionId);
        XMLAssert.assertXpathExists((String)"//wps:ProcessFailed", (Document)dom);
        ExecutionStatus status = statusTracker.getStatus(executionId);
        Assert.assertTrue((status == null || ProcessState.DISMISSING.equals((Object)status.getPhase()) ? 1 : 0) != 0);
        returnFlag.set(true);
        Awaitility.await().atMost(20L, TimeUnit.SECONDS).until(() -> statusTracker.getStatus(executionId) == null);
        WPSResourceManager resources = (WPSResourceManager)GeoServerExtensions.bean(WPSResourceManager.class, (ApplicationContext)applicationContext);
        ProcessArtifactsStore artifactsStore = resources.getArtifactsStore();
        List executionResources = artifactsStore.listExecutionResourcess();
        for (Resource r : executionResources) {
            Assert.assertNotEquals((Object)executionId, (Object)r.name());
        }
    }

    @Test
    public void testDismissDuringExecution() throws Exception {
        String statusLocation = this.submitMonkey("x3");
        Map kvp = KvpUtils.parseQueryString((String)statusLocation);
        String executionId = (String)kvp.get("executionId");
        MonkeyProcess.progress("x3", 10.0f, true);
        Document dom = this.getAsDOM(statusLocation);
        XMLAssert.assertXpathExists((String)"//wps:ProcessStarted", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"6", (String)"//wps:ProcessStarted/@percentCompleted", (Document)dom);
        ProcessStatusTracker statusTracker = (ProcessStatusTracker)GeoServerExtensions.bean(ProcessStatusTracker.class, (ApplicationContext)applicationContext);
        dom = this.getAsDOM("wps?service=WPS&version=1.0.0&request=Dismiss&executionId=" + executionId);
        this.print(dom);
        XMLAssert.assertXpathExists((String)"//wps:ProcessFailed", (Document)dom);
        ExecutionStatus status = statusTracker.getStatus(executionId);
        Assert.assertEquals((Object)ProcessState.DISMISSING, (Object)status.getPhase());
        dom = this.getAsDOM("wps?service=WPS&version=1.0.0&request=Dismiss&executionId=" + executionId);
        this.print(dom);
        this.checkOws11Exception(dom);
        status = statusTracker.getStatus(executionId);
        Assert.assertEquals((Object)ProcessState.DISMISSING, (Object)status.getPhase());
        dom = this.getAsDOM(statusLocation);
        this.checkOws11Exception(dom);
        MonkeyProcess.progress("x3", 50.0f, true);
        while (status != null && status.getPhase() == ProcessState.DISMISSING) {
            Thread.sleep(50L);
            status = statusTracker.getStatus(executionId);
            if (status == null) continue;
            Assert.assertEquals((Object)ProcessState.DISMISSING, (Object)status.getPhase());
        }
        WPSResourceManager resources = (WPSResourceManager)GeoServerExtensions.bean(WPSResourceManager.class, (ApplicationContext)applicationContext);
        ProcessArtifactsStore artifactsStore = resources.getArtifactsStore();
        List executionResources = artifactsStore.listExecutionResourcess();
        for (Resource r : executionResources) {
            Assert.assertNotEquals((Object)executionId, (Object)r.name());
        }
    }

    @Test
    public void testDismissAfterCompletion() throws Exception {
        String statusLocation = this.submitMonkey("x3");
        Map kvp = KvpUtils.parseQueryString((String)statusLocation);
        String executionId = (String)kvp.get("executionId");
        MonkeyProcess.exit("x3", (SimpleFeatureCollection)this.collectionOfThings(), true);
        Document dom = this.waitForProcessEnd(statusLocation, 60L);
        XMLAssert.assertXpathExists((String)"//wps:ProcessSucceeded", (Document)dom);
        ProcessStatusTracker statusTracker = (ProcessStatusTracker)GeoServerExtensions.bean(ProcessStatusTracker.class, (ApplicationContext)applicationContext);
        ExecutionStatus status = statusTracker.getStatus(executionId);
        Assert.assertEquals((Object)ProcessState.SUCCEEDED, (Object)status.getPhase());
        WPSResourceManager resources = (WPSResourceManager)GeoServerExtensions.bean(WPSResourceManager.class, (ApplicationContext)applicationContext);
        Resource resource = resources.getStoredResponse(executionId);
        Assert.assertEquals((Object)Resource.Type.RESOURCE, (Object)resource.getType());
        dom = this.getAsDOM("wps?service=WPS&version=1.0.0&request=Dismiss&executionId=" + executionId);
        XMLAssert.assertXpathExists((String)"//wps:ProcessFailed", (Document)dom);
        status = statusTracker.getStatus(executionId);
        Assert.assertNull((Object)status);
        ProcessArtifactsStore artifactsStore = resources.getArtifactsStore();
        List executionResources = artifactsStore.listExecutionResourcess();
        for (Resource r : executionResources) {
            Assert.assertNotEquals((Object)executionId, (Object)r.name());
        }
    }

    @Test
    public void testConcurrentRequests() throws Exception {
        String statusLocation1 = this.submitMonkey("one");
        String statusLocation2 = this.submitMonkey("two");
        MonkeyProcess.progress("one", 10.0f, true);
        MonkeyProcess.progress("two", 10.0f, true);
        this.assertProgress(statusLocation1, "6");
        this.assertProgress(statusLocation2, "6");
        MonkeyProcess.exit("one", (SimpleFeatureCollection)this.collectionOfThings(), true);
        MonkeyProcess.exit("two", (SimpleFeatureCollection)this.collectionOfThings(), true);
        Document dom = this.waitForProcessEnd(statusLocation1, 60L);
        XMLAssert.assertXpathExists((String)"//wps:ProcessSucceeded", (Document)dom);
        dom = this.waitForProcessEnd(statusLocation2, 60L);
        XMLAssert.assertXpathExists((String)"//wps:ProcessSucceeded", (Document)dom);
    }

    @Test
    public void testInlineGetFeatureNameClash() throws Exception {
        Assert.assertNotNull((Object)this.getCatalog().getLayerByName("foo:PrimitiveGeoFeature"));
        Assert.assertNotNull((Object)this.getCatalog().getLayerByName("sf:PrimitiveGeoFeature"));
        String request = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<wps:Execute version=\"1.0.0\" service=\"WPS\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns=\"http://www.opengis.net/wps/1.0.0\" xmlns:wfs=\"http://www.opengis.net/wfs\" xmlns:wps=\"http://www.opengis.net/wps/1.0.0\" xmlns:ows=\"http://www.opengis.net/ows/1.1\" xmlns:gml=\"http://www.opengis.net/gml\" xmlns:ogc=\"http://www.opengis.net/ogc\" xmlns:wcs=\"http://www.opengis.net/wcs/1.1.1\" xmlns:xlink=\"http://www.w3.org/1999/xlink\" xsi:schemaLocation=\"http://www.opengis.net/wps/1.0.0 http://schemas.opengis.net/wps/1.0.0/wpsAll.xsd\">\n  <ows:Identifier>gs:Bounds</ows:Identifier>\n  <wps:DataInputs>\n    <wps:Input>\n      <ows:Identifier>features</ows:Identifier>\n      <wps:Reference mimeType=\"text/xml; subtype=wfs-collection/1.0\" xlink:href=\"http://geoserver/wfs\" method=\"POST\">\n        <wps:Body>\n          <wfs:GetFeature service=\"WFS\" version=\"1.0.0\" xmlns:foo='http://foo.org'>\n            <wfs:Query typeName=\"foo:PrimitiveGeoFeature\"/>\n          </wfs:GetFeature>\n        </wps:Body>\n      </wps:Reference>\n    </wps:Input>\n  </wps:DataInputs>\n  <wps:ResponseForm>\n    <wps:RawDataOutput>\n      <ows:Identifier>bounds</ows:Identifier>\n    </wps:RawDataOutput>\n  </wps:ResponseForm>\n</wps:Execute>";
        Document dom = this.postAsDOM(this.root(), request);
        Assert.assertEquals((Object)"ows:BoundingBox", (Object)dom.getDocumentElement().getNodeName());
    }

    @Test
    public void testChooseOutputSynchronous() throws Exception {
        String xml = "<wps:Execute service='WPS' version='1.0.0' xmlns:wps='http://www.opengis.net/wps/1.0.0' xmlns:ows='http://www.opengis.net/ows/1.1'><ows:Identifier>gs:MultiRaw</ows:Identifier><wps:DataInputs><wps:Input><ows:Identifier>id</ows:Identifier><wps:Data><wps:LiteralData>1234</wps:LiteralData></wps:Data></wps:Input></wps:DataInputs><wps:ResponseForm><wps:ResponseDocument storeExecuteResponse='false'><wps:Output><ows:Identifier>${output}</ows:Identifier></wps:Output></wps:ResponseDocument></wps:ResponseForm></wps:Execute>";
        Document d = this.postAsDOM("wps", xml.replace("${output}", "literal"));
        this.checkValidationErrors(d);
        Assert.assertEquals((Object)"wps:ExecuteResponse", (Object)d.getDocumentElement().getNodeName());
        XMLAssert.assertXpathExists((String)"/wps:ExecuteResponse/wps:Status/wps:ProcessSucceeded", (Document)d);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//wps:Output)", (Document)d);
        XMLAssert.assertXpathEvaluatesTo((String)"1234", (String)"/wps:ExecuteResponse/wps:ProcessOutputs/wps:Output[ows:Identifier='literal']/wps:Data/wps:LiteralData", (Document)d);
        d = this.postAsDOM("wps", xml.replace("${output}", "text"));
        this.checkValidationErrors(d);
        Assert.assertEquals((Object)"wps:ExecuteResponse", (Object)d.getDocumentElement().getNodeName());
        XMLAssert.assertXpathExists((String)"/wps:ExecuteResponse/wps:Status/wps:ProcessSucceeded", (Document)d);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//wps:Output)", (Document)d);
        XMLAssert.assertXpathEvaluatesTo((String)"base64", (String)"/wps:ExecuteResponse/wps:ProcessOutputs/wps:Output[ows:Identifier='text']/wps:Data/wps:ComplexData/@encoding", (Document)d);
        String value = xp.evaluate("/wps:ExecuteResponse/wps:ProcessOutputs/wps:Output[ows:Identifier='text']/wps:Data/wps:ComplexData", d);
        Assert.assertEquals((Object)"This is the raw text", (Object)new String(Base64.decodeBase64((String)value)));
        d = this.postAsDOM("wps", xml.replace("${output}", "binary"));
        this.checkValidationErrors(d);
        Assert.assertEquals((Object)"wps:ExecuteResponse", (Object)d.getDocumentElement().getNodeName());
        XMLAssert.assertXpathExists((String)"/wps:ExecuteResponse/wps:Status/wps:ProcessSucceeded", (Document)d);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//wps:Output)", (Document)d);
        XMLAssert.assertXpathEvaluatesTo((String)"base64", (String)"/wps:ExecuteResponse/wps:ProcessOutputs/wps:Output[ows:Identifier='binary']/wps:Data/wps:ComplexData/@encoding", (Document)d);
        value = xp.evaluate("/wps:ExecuteResponse/wps:ProcessOutputs/wps:Output[ows:Identifier='binary']/wps:Data/wps:ComplexData", d);
        Assert.assertArrayEquals((byte[])new byte[100], (byte[])Base64.decodeBase64((String)value));
    }

    @Test
    public void testRawFileExtension() throws Exception {
        String xml = "<wps:Execute service='WPS' version='1.0.0' xmlns:wps='http://www.opengis.net/wps/1.0.0' xmlns:ows='http://www.opengis.net/ows/1.1'><ows:Identifier>gs:MultiRaw</ows:Identifier><wps:DataInputs><wps:Input><ows:Identifier>id</ows:Identifier><wps:Data><wps:LiteralData>1234</wps:LiteralData></wps:Data></wps:Input></wps:DataInputs><wps:ResponseForm><wps:ResponseDocument storeExecuteResponse='false'><wps:Output asReference=\"true\"><ows:Identifier>${output}</ows:Identifier></wps:Output></wps:ResponseDocument></wps:ResponseForm></wps:Execute>";
        Document d = this.postAsDOM("wps", xml.replace("${output}", "text"));
        this.checkValidationErrors(d);
        Assert.assertEquals((Object)"wps:ExecuteResponse", (Object)d.getDocumentElement().getNodeName());
        XMLAssert.assertXpathExists((String)"/wps:ExecuteResponse/wps:Status/wps:ProcessSucceeded", (Document)d);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//wps:Output)", (Document)d);
        String reference = xp.evaluate("/wps:ExecuteResponse/wps:ProcessOutputs/wps:Output[ows:Identifier='text']/wps:Reference/@href", d);
        Map kvp = KvpUtils.parseQueryString((String)reference);
        Assert.assertEquals((Object)"text.txt", kvp.get("outputId"));
    }

    @Test
    public void testChooseOutputAsynchronous() throws Exception {
        String xml = "<wps:Execute service='WPS' version='1.0.0' xmlns:wps='http://www.opengis.net/wps/1.0.0' xmlns:ows='http://www.opengis.net/ows/1.1'><ows:Identifier>gs:MultiRaw</ows:Identifier><wps:DataInputs><wps:Input><ows:Identifier>id</ows:Identifier><wps:Data><wps:LiteralData>1234</wps:LiteralData></wps:Data></wps:Input></wps:DataInputs><wps:ResponseForm><wps:ResponseDocument storeExecuteResponse='true' status='true'><wps:Output><ows:Identifier>${output}</ows:Identifier></wps:Output></wps:ResponseDocument></wps:ResponseForm></wps:Execute>";
        Document d = this.submitAsynchronous(xml.replace("${output}", "literal"), 60L);
        this.checkValidationErrors(d);
        Assert.assertEquals((Object)"wps:ExecuteResponse", (Object)d.getDocumentElement().getNodeName());
        XMLAssert.assertXpathExists((String)"/wps:ExecuteResponse/wps:Status/wps:ProcessSucceeded", (Document)d);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//wps:Output)", (Document)d);
        XMLAssert.assertXpathEvaluatesTo((String)"1234", (String)"/wps:ExecuteResponse/wps:ProcessOutputs/wps:Output[ows:Identifier='literal']/wps:Data/wps:LiteralData", (Document)d);
        d = this.submitAsynchronous(xml.replace("${output}", "text"), 60L);
        this.checkValidationErrors(d);
        Assert.assertEquals((Object)"wps:ExecuteResponse", (Object)d.getDocumentElement().getNodeName());
        XMLAssert.assertXpathExists((String)"/wps:ExecuteResponse/wps:Status/wps:ProcessSucceeded", (Document)d);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//wps:Output)", (Document)d);
        XMLAssert.assertXpathEvaluatesTo((String)"base64", (String)"/wps:ExecuteResponse/wps:ProcessOutputs/wps:Output[ows:Identifier='text']/wps:Data/wps:ComplexData/@encoding", (Document)d);
        String value = xp.evaluate("/wps:ExecuteResponse/wps:ProcessOutputs/wps:Output[ows:Identifier='text']/wps:Data/wps:ComplexData", d);
        Assert.assertEquals((Object)"This is the raw text", (Object)new String(Base64.decodeBase64((String)value)));
        d = this.submitAsynchronous(xml.replace("${output}", "binary"), 60L);
        this.checkValidationErrors(d);
        Assert.assertEquals((Object)"wps:ExecuteResponse", (Object)d.getDocumentElement().getNodeName());
        XMLAssert.assertXpathExists((String)"/wps:ExecuteResponse/wps:Status/wps:ProcessSucceeded", (Document)d);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//wps:Output)", (Document)d);
        XMLAssert.assertXpathEvaluatesTo((String)"base64", (String)"/wps:ExecuteResponse/wps:ProcessOutputs/wps:Output[ows:Identifier='binary']/wps:Data/wps:ComplexData/@encoding", (Document)d);
        value = xp.evaluate("/wps:ExecuteResponse/wps:ProcessOutputs/wps:Output[ows:Identifier='binary']/wps:Data/wps:ComplexData", d);
        Assert.assertArrayEquals((byte[])new byte[100], (byte[])Base64.decodeBase64((String)value));
    }

    @Test
    public void testMultiOutputProcess() throws Exception {
        String xml = "<wps:Execute service='WPS' version='1.0.0' xmlns:wfs='http://www.opengis.net/wfs' xmlns:wps='http://www.opengis.net/wps/1.0.0' xmlns:xlink='http://www.w3.org/1999/xlink' xmlns:ows='http://www.opengis.net/ows/1.1'><ows:Identifier>gs:MultiOutputEcho</ows:Identifier><wps:DataInputs><wps:Input><ows:Identifier>text</ows:Identifier><wps:Reference mimeType='text/xml' xlink:href='http://geoserver/wps' method='POST'><wps:Body><wps:Execute service='WPS' version='1.0.0' xmlns:wps='http://www.opengis.net/wps/1.0.0' xmlns:ows='http://www.opengis.net/ows/1.1'><ows:Identifier>gs:MultiRaw</ows:Identifier><wps:DataInputs><wps:Input><ows:Identifier>id</ows:Identifier><wps:Data><wps:LiteralData>1234</wps:LiteralData></wps:Data></wps:Input></wps:DataInputs><wps:ResponseForm><wps:ResponseDocument storeExecuteResponse='true' status='true'><wps:Output><ows:Identifier>literal</ows:Identifier></wps:Output></wps:ResponseDocument></wps:ResponseForm></wps:Execute></wps:Body></wps:Reference></wps:Input></wps:DataInputs><wps:ResponseForm><wps:ResponseDocument><wps:Output><ows:Identifier>result</ows:Identifier></wps:Output></wps:ResponseDocument></wps:ResponseForm></wps:Execute>";
        Document d = this.postAsDOM("wps", xml);
        this.checkValidationErrors(d);
        Assert.assertEquals((Object)"wps:ExecuteResponse", (Object)d.getDocumentElement().getNodeName());
        XMLAssert.assertXpathExists((String)"/wps:ExecuteResponse/wps:Status/wps:ProcessSucceeded", (Document)d);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//wps:Output)", (Document)d);
        XMLAssert.assertXpathEvaluatesTo((String)"Echo='1234'", (String)"/wps:ExecuteResponse/wps:ProcessOutputs/wps:Output[ows:Identifier='result']/wps:Data/wps:LiteralData", (Document)d);
    }

    @Test
    public void testWrongOutputIdentifierRawOutput() throws Exception {
        String responseFormContents = "    <wps:RawDataOutput>\n      <ows:Identifier>fooBar</ows:Identifier>\n    </wps:RawDataOutput>\n";
        String request = this.buildGetBoundsRequest(responseFormContents);
        Document dom = this.postAsDOM(this.root(), request);
        String message = this.checkOws11Exception(dom, "InvalidParameterValue", "RawDataOutput");
        MatcherAssert.assertThat((Object)message, (Matcher)CoreMatchers.containsString((String)"fooBar"));
    }

    @Test
    public void testWrongOutputIdentifierDocumentOutputAsynch() throws Exception {
        String responseFormContents = "<wps:ResponseDocument storeExecuteResponse='true' status='true'><wps:Output><ows:Identifier>fooBar</ows:Identifier></wps:Output></wps:ResponseDocument>";
        String request = this.buildGetBoundsRequest(responseFormContents);
        Document dom = this.postAsDOM(this.root(), request);
        String message = this.checkOws11Exception(dom, "InvalidParameterValue", "ResponseDocument");
        MatcherAssert.assertThat((Object)message, (Matcher)CoreMatchers.containsString((String)"fooBar"));
    }

    @Test
    public void testWrongOutputIdentifierDocumentOutputSynch() throws Exception {
        String responseFormContents = "<wps:ResponseDocument><wps:Output><ows:Identifier>fooBar</ows:Identifier></wps:Output></wps:ResponseDocument>";
        String request = this.buildGetBoundsRequest(responseFormContents);
        Document dom = this.postAsDOM(this.root(), request);
        String message = this.checkOws11Exception(dom, "InvalidParameterValue", "ResponseDocument");
        MatcherAssert.assertThat((Object)message, (Matcher)CoreMatchers.containsString((String)"fooBar"));
    }

    public String buildGetBoundsRequest(String responseFormContents) {
        return "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<wps:Execute version=\"1.0.0\" service=\"WPS\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns=\"http://www.opengis.net/wps/1.0.0\" xmlns:wfs=\"http://www.opengis.net/wfs\" xmlns:wps=\"http://www.opengis.net/wps/1.0.0\" xmlns:ows=\"http://www.opengis.net/ows/1.1\" xmlns:gml=\"http://www.opengis.net/gml\" xmlns:ogc=\"http://www.opengis.net/ogc\" xmlns:wcs=\"http://www.opengis.net/wcs/1.1.1\" xmlns:xlink=\"http://www.w3.org/1999/xlink\" xsi:schemaLocation=\"http://www.opengis.net/wps/1.0.0 http://schemas.opengis.net/wps/1.0.0/wpsAll.xsd\">\n  <ows:Identifier>gs:Bounds</ows:Identifier>\n  <wps:DataInputs>\n    <wps:Input>\n      <ows:Identifier>features</ows:Identifier>\n      <wps:Reference mimeType=\"text/xml; subtype=wfs-collection/1.0\" xlink:href=\"http://geoserver/wfs?service=WFS&amp;request=GetFeature&amp;typename=cite:Streams\" method=\"GET\"/>\n    </wps:Input>\n  </wps:DataInputs>\n  <wps:ResponseForm>\n" + responseFormContents + "  </wps:ResponseForm>\n</wps:Execute>";
    }

    private void assertProgress(String statusLocation, String progress) throws Exception {
        XpathEngine xp = XMLUnit.newXpathEngine();
        Awaitility.await().atMost(5L, TimeUnit.SECONDS).until(() -> {
            Document dom = this.getAsDOM(statusLocation);
            String path = "//wps:ProcessStarted/@percentCompleted";
            return progress.equals(xp.evaluate(path, dom));
        });
    }

    private String submitMonkey(String id) throws Exception, XpathException {
        String request = "wps?service=WPS&version=1.0.0&request=Execute&Identifier=gs:Monkey&storeExecuteResponse=true&status=true&DataInputs=" + this.urlEncode("id=" + id);
        Document dom = this.getAsDOM(request);
        return this.getStatusLocation(dom);
    }

    private String getStatusLocation(Document dom) throws XpathException {
        String fullStatusLocation = this.getFullStatusLocation(dom);
        String statusLocation = fullStatusLocation.substring(fullStatusLocation.indexOf(63) - 3);
        return statusLocation;
    }

    private String getFullStatusLocation(Document dom) throws XpathException {
        XMLAssert.assertXpathExists((String)"//wps:ProcessAccepted", (Document)dom);
        XpathEngine xpath = XMLUnit.newXpathEngine();
        return xpath.evaluate("//wps:ExecuteResponse/@statusLocation", dom);
    }

    private ListFeatureCollection collectionOfThings() {
        SimpleFeatureType featureType = this.buildSampleFeatureType();
        ListFeatureCollection fc = new ListFeatureCollection(featureType);
        return fc;
    }

    private SimpleFeatureType buildSampleFeatureType() {
        SimpleFeatureTypeBuilder tb = new SimpleFeatureTypeBuilder();
        tb.add("name", String.class);
        tb.add("location", Point.class, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        tb.setName("thing");
        SimpleFeatureType featureType = tb.buildFeatureType();
        return featureType;
    }

    private ListFeatureCollection bombOutCollection() {
        SimpleFeatureType featureType = this.buildSampleFeatureType();
        ListFeatureCollection fc = new ListFeatureCollection(featureType){

            public SimpleFeatureIterator features() {
                throw new RuntimeException("Toasted!");
            }

            protected Iterator<SimpleFeature> openIterator() {
                throw new RuntimeException("Toasted!");
            }
        };
        return fc;
    }

    void executeState1BoundsTest(String request, String id) throws Exception {
        if (!RemoteOWSTestSupport.isRemoteWMSStatesAvailable((Logger)LOGGER)) {
            LOGGER.warning("Remote OWS tests disabled, skipping test with " + id + " reference source");
            return;
        }
        MockHttpServletResponse resp = this.postAsServletResponse(this.root(), request);
        ReferencedEnvelope re = this.toEnvelope(resp.getContentAsString());
        Assert.assertEquals((double)-91.516129, (double)re.getMinX(), (double)0.001);
        Assert.assertEquals((double)36.986771, (double)re.getMinY(), (double)0.001);
        Assert.assertEquals((double)-87.507889, (double)re.getMaxX(), (double)0.001);
        Assert.assertEquals((double)42.509361, (double)re.getMaxY(), (double)0.001);
    }

    ReferencedEnvelope toEnvelope(String xml) throws Exception {
        Parser p = new Parser((Configuration)new OWSConfiguration());
        Object parsed = p.parse((InputStream)new ByteArrayInputStream(xml.getBytes()));
        Assert.assertTrue((boolean)(parsed instanceof BoundingBoxType));
        BoundingBoxType box = (BoundingBoxType)parsed;
        ReferencedEnvelope re = box.getCrs() != null ? new ReferencedEnvelope(CRS.decode((String)box.getCrs())) : new ReferencedEnvelope();
        re.expandToInclude(((Double)box.getLowerCorner().get(0)).doubleValue(), ((Double)box.getLowerCorner().get(1)).doubleValue());
        re.expandToInclude(((Double)box.getUpperCorner().get(0)).doubleValue(), ((Double)box.getUpperCorner().get(1)).doubleValue());
        return re;
    }

    String urlEncode(String string) throws Exception {
        return URLEncoder.encode(string, "ASCII");
    }

    private void checkShapefileIntegrity(String[] typeNames, InputStream in) throws IOException {
        ZipInputStream zis = new ZipInputStream(in);
        ZipEntry entry = null;
        String[] extensions = new String[]{".shp", ".shx", ".dbf", ".prj", ".cst"};
        HashSet<CallSite> names = new HashSet<CallSite>();
        for (String name : typeNames) {
            for (String extension : extensions) {
                names.add((CallSite)((Object)(name + extension)));
            }
        }
        while ((entry = zis.getNextEntry()) != null) {
            String name = entry.getName();
            Assert.assertTrue((String)("Missing " + name), (boolean)names.contains(name));
            names.remove(name);
            zis.closeEntry();
        }
        zis.close();
    }

    @Test
    public void testDisableLayerService() throws Exception {
        this.disableWPSOnStreams();
        String request = this.streamsBoundsRequest();
        Document dom = this.postAsDOM(this.root(), request);
        this.print(dom);
        XMLAssert.assertXpathExists((String)"//wps:Status/wps:ProcessFailed", (Document)dom);
        this.enableWPSOnStreams();
    }

    @Test
    public void testEnableLayerService() throws Exception {
        this.enableWPSOnStreams();
        String request = this.streamsBoundsRequest();
        Document dom = this.postAsDOM(this.root(), request);
        this.print(dom);
        this.checkStreamsProcessBounds(dom);
    }

    private void disableWPSOnStreams() {
        String layerName = "cite:Streams";
        LayerInfo linfo = this.getCatalog().getLayerByName(layerName);
        ResourceInfo ri = linfo.getResource();
        ri.setServiceConfiguration(true);
        ri.setDisabledServices(new ArrayList<String>(Arrays.asList("WPS")));
        this.getCatalog().save(ri);
        this.getCatalog().save(linfo);
    }

    private void enableWPSOnStreams() {
        String layerName = "cite:Streams";
        LayerInfo linfo = this.getCatalog().getLayerByName(layerName);
        ResourceInfo ri = linfo.getResource();
        ri.setServiceConfiguration(false);
        ri.setDisabledServices(new ArrayList());
        this.getCatalog().save(ri);
        this.getCatalog().save(linfo);
    }

    @Test
    public void testBacklinksProxyHeaders() throws Exception {
        GeoServer gs = this.getGeoServer();
        GeoServerInfo gsInfo = gs.getGlobal();
        SettingsInfo settings = gsInfo.getSettings();
        settings.setUseHeadersProxyURL(Boolean.valueOf(true));
        settings.setProxyBaseUrl("${X-Forwarded-Proto}://${X-Forwarded-Host}/geoserver");
        gs.save(gsInfo);
        String wpsRequest = "wps?service=WPS&version=1.0.0&request=Execute&Identifier=gs:Monkey&storeExecuteResponse=true&status=true&storeExecuteResponse=true&DataInputs=" + this.urlEncode("id=proxyHeaders") + "&ResponseDocument=" + this.urlEncode("result=@asReference=true");
        MockHttpServletRequest hreq = this.createRequest(wpsRequest);
        hreq.setMethod("GET");
        hreq.setContent(new byte[0]);
        hreq.addHeader("X-Forwarded-Proto", (Object)"https");
        hreq.addHeader("X-Forwarded-Host", (Object)"mycompany.com");
        MockHttpServletResponse response = this.dispatch((HttpServletRequest)hreq, null);
        ByteArrayInputStream responseContent = new ByteArrayInputStream(response.getContentAsString().getBytes());
        Document dom = this.dom(responseContent, true);
        String fullStatusLocation = this.getFullStatusLocation(dom);
        String statusLocation = fullStatusLocation.substring(fullStatusLocation.indexOf(63) - 3);
        MatcherAssert.assertThat((Object)fullStatusLocation, (Matcher)CoreMatchers.startsWith((String)"https://mycompany.com/geoserver"));
        hreq.removeHeader("X-Forwarded-Proto");
        hreq.removeHeader("X-Forwarded-Host");
        MonkeyProcess.exit("proxyHeaders", (SimpleFeatureCollection)this.collectionOfThings(), true);
        dom = this.waitForProcessEnd(statusLocation, 60L);
        XMLAssert.assertXpathExists((String)"//wps:ProcessSucceeded", (Document)dom);
        XpathEngine xpath = XMLUnit.newXpathEngine();
        fullStatusLocation = xpath.evaluate("//wps:ExecuteResponse/@statusLocation", dom);
        MatcherAssert.assertThat((Object)fullStatusLocation, (Matcher)CoreMatchers.startsWith((String)"https://mycompany.com/geoserver"));
        String reference = xpath.evaluate("//wps:ExecuteResponse/wps:ProcessOutputs/wps:Output/wps:Reference/@href", dom);
        MatcherAssert.assertThat((Object)reference, (Matcher)CoreMatchers.startsWith((String)"https://mycompany.com/geoserver"));
    }

    protected List<Filter> getFilters() {
        return Arrays.asList(new HTTPHeadersCollector());
    }

    private void setRemoteInputDisabled(boolean enabled) {
        WPSInfo wps = (WPSInfo)this.getGeoServer().getService(WPSInfo.class);
        if (wps.isRemoteInputDisabled() != enabled) {
            wps.setRemoteInputDisabled(enabled);
            this.getGeoServer().save((ServiceInfo)wps);
        }
    }
}

