/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wps;

import com.github.tomakehurst.wiremock.WireMockServer;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.core.Options;
import com.github.tomakehurst.wiremock.core.WireMockConfiguration;
import com.github.tomakehurst.wiremock.matching.UrlPattern;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import org.apache.commons.io.IOUtils;
import org.custommonkey.xmlunit.XMLAssert;
import org.geoserver.security.urlchecks.AbstractURLCheck;
import org.geoserver.security.urlchecks.GeoServerURLChecker;
import org.geoserver.security.urlchecks.RegexURLCheck;
import org.geoserver.security.urlchecks.URLCheckDAO;
import org.geoserver.wps.WPSTestSupport;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.w3c.dom.Document;

public class ExecuteURLCheckTest
extends WPSTestSupport {
    private static final boolean debugMode = false;
    private static final String STATES_COLLECTION = "states-FeatureCollection.xml";
    private static WireMockServer service;
    private static String statesGMLURL;

    @BeforeClass
    public static void beforeClass() throws Exception {
        WireMockConfiguration config = WireMockConfiguration.wireMockConfig().dynamicPort();
        service = new WireMockServer((Options)config);
        service.start();
        String statesResource = ExecuteURLCheckTest.getResourceAsString(STATES_COLLECTION);
        statesGMLURL = service.baseUrl() + "/states-FeatureCollection.xml";
        service.stubFor(WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/states-FeatureCollection.xml")).willReturn(WireMock.aResponse().withStatus(200).withHeader("Content-Type", new String[]{"text/xml"}).withBody(statesResource)));
    }

    private static String getResourceAsString(String resource) throws IOException {
        try (InputStream is = ExecuteURLCheckTest.class.getResourceAsStream(resource);){
            String string = IOUtils.toString((InputStream)is, (Charset)StandardCharsets.UTF_8);
            return string;
        }
    }

    @AfterClass
    public static void afterClass() throws Exception {
        service.stop();
    }

    @Before
    public void setup() throws Exception {
        Assert.assertNotNull((Object)applicationContext.getBean(GeoServerURLChecker.class));
        URLCheckDAO dao = (URLCheckDAO)applicationContext.getBean(URLCheckDAO.class);
        dao.saveChecks(Collections.emptyList());
    }

    @Test
    public void testRemoteInputAllowed() throws Exception {
        URLCheckDAO dao = (URLCheckDAO)applicationContext.getBean(URLCheckDAO.class);
        dao.save((AbstractURLCheck)new RegexURLCheck("pointStyle", "Just the point style", "^" + statesGMLURL + "$"));
        String request = this.buildGetBoundsRequest();
        Document dom = this.postAsDOM(this.root(), request);
        XMLAssert.assertXpathEvaluatesTo((String)"0.0 0.0", (String)"//ows:BoundingBox/ows:LowerCorner", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"5.0 5.0", (String)"//ows:BoundingBox/ows:UpperCorner", (Document)dom);
    }

    @Test
    public void testRemoteInputDisallowed() throws Exception {
        URLCheckDAO dao = (URLCheckDAO)applicationContext.getBean(URLCheckDAO.class);
        dao.save((AbstractURLCheck)new RegexURLCheck("deny", "Won't match", "^abcd$"));
        String request = this.buildGetBoundsRequest();
        Document dom = this.postAsDOM(this.root(), request);
        String message = this.checkOws11Exception(dom, "InvalidParameterValue", "features");
        MatcherAssert.assertThat((Object)message, (Matcher)CoreMatchers.containsString((String)statesGMLURL));
    }

    public String buildGetBoundsRequest() {
        return "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<wps:Execute version=\"1.0.0\" service=\"WPS\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns=\"http://www.opengis.net/wps/1.0.0\" xmlns:wfs=\"http://www.opengis.net/wfs\" xmlns:wps=\"http://www.opengis.net/wps/1.0.0\" xmlns:ows=\"http://www.opengis.net/ows/1.1\" xmlns:gml=\"http://www.opengis.net/gml\" xmlns:ogc=\"http://www.opengis.net/ogc\" xmlns:wcs=\"http://www.opengis.net/wcs/1.1.1\" xmlns:xlink=\"http://www.w3.org/1999/xlink\" xsi:schemaLocation=\"http://www.opengis.net/wps/1.0.0 http://schemas.opengis.net/wps/1.0.0/wpsAll.xsd\">\n  <ows:Identifier>gs:Bounds</ows:Identifier>\n  <wps:DataInputs>\n    <wps:Input>\n      <ows:Identifier>features</ows:Identifier>\n      <wps:Reference mimeType=\"text/xml; subtype=wfs-collection/1.1\" xlink:href=\"" + statesGMLURL + "\" method=\"GET\"/>\n    </wps:Input>\n  </wps:DataInputs>\n  <wps:ResponseForm>\n    <wps:RawDataOutput>\n      <ows:Identifier>bounds</ows:Identifier>\n    </wps:RawDataOutput>\n  </wps:ResponseForm>\n</wps:Execute>";
    }
}

