/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wps;

import org.custommonkey.xmlunit.XMLAssert;
import org.custommonkey.xmlunit.XMLUnit;
import org.custommonkey.xmlunit.XpathEngine;
import org.geoserver.config.GeoServer;
import org.geoserver.config.ServiceInfo;
import org.geoserver.data.test.MockData;
import org.geoserver.wps.WPSInfo;
import org.geoserver.wps.WPSTestSupport;
import org.junit.Assert;
import org.junit.Test;
import org.w3c.dom.Document;

public class GetCapabilitiesTest
extends WPSTestSupport {
    @Test
    public void testGetBasic() throws Exception {
        Document d = this.getAsDOM("wps?service=wps&request=getcapabilities");
        this.basicCapabilitiesTest(d, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetDisabledService() throws Exception {
        GeoServer gs = this.getGeoServer();
        WPSInfo info = (WPSInfo)gs.getService(WPSInfo.class);
        try {
            info.setEnabled(false);
            gs.save((ServiceInfo)info);
            Document dom = this.getAsDOM("wps?service=wps&request=getcapabilities");
            this.checkOws10Exception(dom);
        }
        finally {
            info.setEnabled(true);
            gs.save((ServiceInfo)info);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInvalidWPSConfig() throws Exception {
        GeoServer gs = this.getGeoServer();
        WPSInfo wpsInfo = (WPSInfo)gs.getService(WPSInfo.class);
        gs.getFacade().remove((ServiceInfo)wpsInfo);
        try {
            Document dom = this.getAsDOM("wps?service=wps&request=getcapabilities");
            this.checkOws11Exception(dom);
        }
        finally {
            gs.getFacade().add((ServiceInfo)wpsInfo);
        }
    }

    @Test
    public void testGetBasicWorkspaceQualified() throws Exception {
        Document d = this.getAsDOM(MockData.CITE_PREFIX + "/ows?service=wps&request=getcapabilities");
        this.basicCapabilitiesTest(d, MockData.CITE_PREFIX);
        d = this.getAsDOM(MockData.CITE_PREFIX + "/wps?service=wps&request=getcapabilities");
        this.basicCapabilitiesTest(d, MockData.CITE_PREFIX);
    }

    @Test
    public void testProcesseListSorted() throws Exception {
        Document d = this.getAsDOM("wps?service=wps&request=getcapabilities");
        XpathEngine xpath = XMLUnit.newXpathEngine();
        int count = Integer.valueOf(xpath.evaluate("count(wps:Process)", d));
        String previous = null;
        for (int i = 1; i <= count; ++i) {
            String curr = xpath.evaluate("(//wps:Process)[" + i + "]/ows:Identifier)", d);
            if (previous != null) {
                Assert.assertTrue((curr.compareTo(previous) >= 0 ? 1 : 0) != 0);
            }
            previous = curr;
        }
    }

    @Test
    public void testPostBasic() throws Exception {
        String request = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><wps:GetCapabilities service=\"WPS\" xmlns:ows=\"http://www.opengis.net/ows/1.1\" xmlns:wps=\"http://www.opengis.net/wps/1.0.0\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"/>";
        Document d = this.postAsDOM(this.root(), request);
        this.basicCapabilitiesTest(d, null);
    }

    @Test
    public void testBasicGetAcceptVersions() throws Exception {
        Document d = this.getAsDOM("wps?service=wps&request=getcapabilities&AcceptVersions=1.0.0");
        this.basicCapabilitiesTest(d, null);
    }

    @Test
    public void testBasicGetLanguage() throws Exception {
        Document d = this.getAsDOM("wps?service=wps&request=getcapabilities&Language=en-US");
        this.basicCapabilitiesTest(d, null, "Language=en-US");
    }

    @Test
    public void testBasicPostAcceptVersions() throws Exception {
        String request = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><wps:GetCapabilities service=\"WPS\" xmlns:ows=\"http://www.opengis.net/ows/1.1\" xmlns:wps=\"http://www.opengis.net/wps/1.0.0\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><ows:AcceptVersions><ows:Version>1.0.0</ows:Version></ows:AcceptVersions></wps:GetCapabilities>";
        Document d = this.postAsDOM(this.root(), request);
        this.basicCapabilitiesTest(d, null);
    }

    @Test
    public void testBasicPostLanguage() throws Exception {
        String request = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><wps:GetCapabilities service=\"WPS\" xmlns:ows=\"http://www.opengis.net/ows/1.1\" language=\"en-US\" xmlns:wps=\"http://www.opengis.net/wps/1.0.0\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"/>";
        Document d = this.postAsDOM(this.root(), request);
        this.basicCapabilitiesTest(d, null);
    }

    private void basicCapabilitiesTest(Document d, String workspace) throws Exception {
        this.basicCapabilitiesTest(d, workspace, null);
    }

    private void basicCapabilitiesTest(Document d, String workspace, String language) throws Exception {
        String[] operations;
        this.checkValidationErrors(d);
        XMLAssert.assertXpathEvaluatesTo((String)"http://www.opengis.net/wps/1.0.0 http://schemas.opengis.net/wps/1.0.0/wpsAll.xsd", (String)"/wps:Capabilities/@xsi:schemaLocation", (Document)d);
        Assert.assertEquals((Object)"wps:Capabilities", (Object)d.getDocumentElement().getNodeName());
        int np = d.getElementsByTagName("wps:Process").getLength();
        Assert.assertTrue((np > 0 ? 1 : 0) != 0);
        Object expectedOperationUrl = "http://localhost:8080/geoserver/wps";
        if (workspace != null) {
            expectedOperationUrl = "http://localhost:8080/geoserver/" + workspace + "/wps";
        }
        if (language != null) {
            expectedOperationUrl = (String)expectedOperationUrl + "?" + language;
        }
        for (String operation : operations = new String[]{"GetCapabilities", "DescribeProcess", "Execute"}) {
            String getPath = "//ows:Operation[@name='" + operation + "']/ows:DCP/ows:HTTP/ows:Get/@xlink:href";
            XMLAssert.assertXpathEvaluatesTo((String)expectedOperationUrl, (String)getPath, (Document)d);
            String postPath = "//ows:Operation[@name='" + operation + "']/ows:DCP/ows:HTTP/ows:Post/@xlink:href";
            XMLAssert.assertXpathEvaluatesTo((String)expectedOperationUrl, (String)postPath, (Document)d);
        }
    }

    @Test
    public void testUnsupportedVersionHighPost() throws Exception {
        String request = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><wps:GetCapabilities service=\"WPS\" xmlns:ows=\"http://www.opengis.net/ows/1.1\" xmlns:wps=\"http://www.opengis.net/wps/1.0.0\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">  <ows:AcceptVersions>    <ows:Version>9.9.9</ows:Version>  </ows:AcceptVersions></wps:GetCapabilities>";
        Document dom = this.postAsDOM(this.root(), request);
        this.checkValidationErrors(dom);
        this.checkOws11Exception(dom, "VersionNegotiationFailed");
    }

    @Test
    public void testUnsupportedVersionLowPost() throws Exception {
        String request = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><wps:GetCapabilities service=\"WPS\" xmlns:ows=\"http://www.opengis.net/ows/1.1\" xmlns:wps=\"http://www.opengis.net/wps/1.0.0\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">  <ows:AcceptVersions>    <ows:Version>0.0.9</ows:Version>  </ows:AcceptVersions></wps:GetCapabilities>";
        Document dom = this.postAsDOM(this.root(), request);
        this.checkValidationErrors(dom);
        this.checkOws11Exception(dom, "VersionNegotiationFailed");
    }

    @Test
    public void testUnsupportedVersionGet() throws Exception {
        Document dom = this.getAsDOM(this.root() + "request=GetCapabilities&service=WPS&acceptVersions=9.9.9,8.8.8");
        this.checkValidationErrors(dom);
        this.checkOws11Exception(dom, "VersionNegotiationFailed");
    }

    @Test
    public void testSupportedVersionGet() throws Exception {
        Document dom = this.getAsDOM(this.root() + "request=GetCapabilities&service=WPS&acceptVersions=0.5.0,1.0.0");
        Assert.assertEquals((Object)"wps:Capabilities", (Object)dom.getFirstChild().getNodeName());
    }

    @Test
    public void testSupportedVersionPost() throws Exception {
        String request = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><wps:GetCapabilities service=\"WPS\" xmlns:ows=\"http://www.opengis.net/ows/1.1\" xmlns:wps=\"http://www.opengis.net/wps/1.0.0\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">  <ows:AcceptVersions>    <ows:Version>0.5.0</ows:Version>    <ows:Version>1.0.0</ows:Version>  </ows:AcceptVersions></wps:GetCapabilities>";
        Document dom = this.postAsDOM(this.root(), request);
        Assert.assertEquals((Object)"wps:Capabilities", (Object)dom.getFirstChild().getNodeName());
    }
}

