/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wps;

import java.io.ByteArrayInputStream;
import org.custommonkey.xmlunit.XMLAssert;
import org.geoserver.ows.util.ResponseUtils;
import org.geoserver.wps.WPSTestSupport;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.mock.web.MockHttpServletResponse;
import org.w3c.dom.Document;

public class GetExecutionResultTest
extends WPSTestSupport {
    @Test
    public void testGetExecutionResultWithoutMime() throws Exception {
        String request = this.getGetExecutionResultHref();
        request = request.substring(0, request.indexOf("&mimetype="));
        MockHttpServletResponse response = this.getAsServletResponse(request);
        Assert.assertEquals((Object)"text/csv", (Object)response.getContentType());
        Assert.assertEquals((Object)"inline; filename=result.csv", (Object)response.getHeader("Content-Disposition"));
        Assert.assertEquals((Object)"foo", (Object)response.getContentAsString().trim());
    }

    @Test
    public void testGetExecutionResultWithDecodedMime() throws Exception {
        String request = this.getGetExecutionResultHref();
        MockHttpServletResponse response = this.getAsServletResponse(request);
        Assert.assertEquals((Object)"text/csv", (Object)response.getContentType());
        Assert.assertEquals((Object)"inline; filename=result.csv", (Object)response.getHeader("Content-Disposition"));
        Assert.assertEquals((Object)"foo", (Object)response.getContentAsString().trim());
    }

    @Test
    public void testGetExecutionResultWithEncodedMime() throws Exception {
        String request = this.getGetExecutionResultHref();
        request = request.replace("text/csv", "text%2Fcsv");
        MockHttpServletResponse response = this.getAsServletResponse(request);
        Assert.assertEquals((Object)"text/csv", (Object)response.getContentType());
        Assert.assertEquals((Object)"inline; filename=result.csv", (Object)response.getHeader("Content-Disposition"));
        Assert.assertEquals((Object)"foo", (Object)response.getContentAsString().trim());
    }

    @Test
    public void testGetExecutionResultWithInvalidMime() throws Exception {
        String request = this.getGetExecutionResultHref();
        request = request.replace("text/csv", "text/html");
        MockHttpServletResponse response = this.getAsServletResponse(request);
        Assert.assertEquals((Object)"application/xml", (Object)response.getContentType());
        Assert.assertNull((Object)response.getHeader("Content-Disposition"));
        Document dom = this.dom(new ByteArrayInputStream(response.getContentAsByteArray()));
        XMLAssert.assertXpathExists((String)"/ows:ExceptionReport/ows:Exception/ows:ExceptionText", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"Requested mime type does not match the output resource mime type", (String)"/ows:ExceptionReport/ows:Exception/ows:ExceptionText", (Document)dom);
    }

    private String getGetExecutionResultHref() throws Exception {
        String request = "wps?service=WPS&version=1.0.0&request=Execute&Identifier=vec:Reproject&DataInputs=features=foo@mimetype=text/csv&ResponseDocument=result=@asReference=true@mimetype=text/csv";
        String expression = "/wps:ExecuteResponse/wps:ProcessOutputs/wps:Output/wps:Reference/@href";
        Document dom = this.getAsDOM(request);
        XMLAssert.assertXpathExists((String)expression, (Document)dom);
        Object href = xp.evaluate(expression, dom);
        href = "wps" + ResponseUtils.urlDecode((String)((String)href).substring(((String)href).indexOf("?")));
        MatcherAssert.assertThat((Object)href, (Matcher)CoreMatchers.endsWith((String)"&mimetype=text/csv"));
        return href;
    }
}

