/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wps;

import java.io.File;
import java.net.URLEncoder;
import org.apache.commons.io.FileUtils;
import org.custommonkey.xmlunit.XMLAssert;
import org.custommonkey.xmlunit.XMLUnit;
import org.custommonkey.xmlunit.XpathEngine;
import org.custommonkey.xmlunit.exceptions.XpathException;
import org.geoserver.config.ServiceInfo;
import org.geoserver.data.test.MockData;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.wps.MonkeyProcess;
import org.geoserver.wps.ProcessGroupInfoImpl;
import org.geoserver.wps.ProcessInfoImpl;
import org.geoserver.wps.WPSInfo;
import org.geoserver.wps.WPSTestSupport;
import org.geoserver.wps.validator.MaxSizeValidator;
import org.geoserver.wps.validator.MultiplicityValidator;
import org.geoserver.wps.validator.NumberRangeValidator;
import org.geotools.api.feature.type.Name;
import org.geotools.feature.NameImpl;
import org.geotools.process.geometry.GeometryProcessFactory;
import org.geotools.process.raster.RasterProcessFactory;
import org.geotools.util.NumberRange;
import org.geotools.util.URLs;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.w3c.dom.Document;

public class InputLimitsTest
extends WPSTestSupport {
    @Override
    protected void setUpTestData(SystemTestData testData) throws Exception {
        testData.setUpSecurity();
    }

    @Before
    public void setUpInternal() throws Exception {
        MonkeyProcess.clearCommands();
    }

    @Before
    public void resetExecutionTimes() throws Exception {
        WPSInfo wps = (WPSInfo)this.getGeoServer().getService(WPSInfo.class);
        wps.setMaxSynchronousExecutionTime(0);
        wps.setMaxAsynchronousExecutionTime(0);
        wps.setMaxSynchronousTotalTime(Integer.valueOf(0));
        wps.setMaxAsynchronousTotalTime(Integer.valueOf(0));
        wps.setMaxAsynchronousProcesses(0);
        wps.setMaxSynchronousProcesses(0);
        this.getGeoServer().save((ServiceInfo)wps);
    }

    @Override
    protected void onSetUp(SystemTestData testData) throws Exception {
        super.onSetUp(testData);
        this.addWcs11Coverages(testData);
        WPSInfo wps = (WPSInfo)this.getGeoServer().getService(WPSInfo.class);
        wps.setMaxComplexInputSize(10);
        ProcessGroupInfoImpl geoGroup = new ProcessGroupInfoImpl();
        geoGroup.setFactoryClass(GeometryProcessFactory.class);
        geoGroup.setEnabled(true);
        wps.getProcessGroups().add(geoGroup);
        ProcessInfoImpl buffer = new ProcessInfoImpl();
        buffer.setEnabled(Boolean.valueOf(true));
        buffer.setName((Name)new NameImpl("geo", "buffer"));
        buffer.getValidators().put((Object)"geom", (Object)new MaxSizeValidator(1));
        buffer.getValidators().put((Object)"distance", (Object)new NumberRangeValidator(new NumberRange(Double.class, (Number)0.0, (Number)100.0)));
        buffer.getValidators().put((Object)"quadrantSegments", (Object)new NumberRangeValidator(new NumberRange(Integer.class, (Number)2, (Number)20)));
        geoGroup.getFilteredProcesses().add(buffer);
        ProcessInfoImpl simplify = new ProcessInfoImpl();
        simplify.setEnabled(Boolean.valueOf(true));
        simplify.setName((Name)new NameImpl("geo", "simplify"));
        simplify.getValidators().put((Object)"distance", (Object)new NumberRangeValidator(new NumberRange(Double.class, null, (Number)100.0)));
        geoGroup.getFilteredProcesses().add(simplify);
        ProcessInfoImpl densify = new ProcessInfoImpl();
        densify.setEnabled(Boolean.valueOf(true));
        densify.setName((Name)new NameImpl("geo", "densify"));
        densify.getValidators().put((Object)"distance", (Object)new NumberRangeValidator(new NumberRange(Double.class, (Number)0.0, null)));
        geoGroup.getFilteredProcesses().add(densify);
        ProcessGroupInfoImpl rasterGroup = new ProcessGroupInfoImpl();
        rasterGroup.setFactoryClass(RasterProcessFactory.class);
        rasterGroup.setEnabled(true);
        wps.getProcessGroups().add(rasterGroup);
        ProcessInfoImpl contour = new ProcessInfoImpl();
        contour.setEnabled(Boolean.valueOf(true));
        contour.setName((Name)new NameImpl("ras", "Contour"));
        contour.getValidators().put((Object)"data", (Object)new MaxSizeValidator(1));
        contour.getValidators().put((Object)"levels", (Object)new NumberRangeValidator(new NumberRange(Double.class, (Number)-8000.0, (Number)8000.0)));
        contour.getValidators().put((Object)"levels", (Object)new MultiplicityValidator(3));
        rasterGroup.getFilteredProcesses().add(contour);
        this.getGeoServer().save((ServiceInfo)wps);
    }

    @Test
    public void testDescribeBuffer() throws Exception {
        Document d = this.getAsDOM(this.root() + "service=wps&request=describeprocess&identifier=geo:buffer");
        this.checkValidationErrors(d);
        XMLAssert.assertXpathExists((String)"/wps:ProcessDescriptions", (Document)d);
        String base = "/wps:ProcessDescriptions/ProcessDescription/DataInputs";
        XMLAssert.assertXpathExists((String)(base + "/Input[1]"), (Document)d);
        XMLAssert.assertXpathEvaluatesTo((String)"geom", (String)(base + "/Input[1]/ows:Identifier"), (Document)d);
        XMLAssert.assertXpathExists((String)(base + "/Input[1]/ComplexData"), (Document)d);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)(base + "/Input[1]/ComplexData/@maximumMegabytes"), (Document)d);
        XMLAssert.assertXpathExists((String)(base + "/Input[2]"), (Document)d);
        XMLAssert.assertXpathEvaluatesTo((String)"distance", (String)(base + "/Input[2]/ows:Identifier"), (Document)d);
        XMLAssert.assertXpathExists((String)(base + "/Input[2]/LiteralData"), (Document)d);
        XMLAssert.assertXpathEvaluatesTo((String)"closed", (String)(base + "/Input[2]/LiteralData/ows:AllowedValues/ows:Range/@ows:rangeClosure"), (Document)d);
        XMLAssert.assertXpathEvaluatesTo((String)"0.0", (String)(base + "/Input[2]/LiteralData/ows:AllowedValues/ows:Range/ows:MinimumValue"), (Document)d);
        XMLAssert.assertXpathEvaluatesTo((String)"100.0", (String)(base + "/Input[2]/LiteralData/ows:AllowedValues/ows:Range/ows:MaximumValue"), (Document)d);
        XMLAssert.assertXpathExists((String)(base + "/Input[3]"), (Document)d);
        XMLAssert.assertXpathEvaluatesTo((String)"quadrantSegments", (String)(base + "/Input[3]/ows:Identifier"), (Document)d);
        XMLAssert.assertXpathExists((String)(base + "/Input[3]/LiteralData"), (Document)d);
        XMLAssert.assertXpathEvaluatesTo((String)"closed", (String)(base + "/Input[3]/LiteralData/ows:AllowedValues/ows:Range/@ows:rangeClosure"), (Document)d);
        XMLAssert.assertXpathEvaluatesTo((String)"2", (String)(base + "/Input[3]/LiteralData/ows:AllowedValues/ows:Range/ows:MinimumValue"), (Document)d);
        XMLAssert.assertXpathEvaluatesTo((String)"20", (String)(base + "/Input[3]/LiteralData/ows:AllowedValues/ows:Range/ows:MaximumValue"), (Document)d);
    }

    @Test
    public void testDescribeSimplify() throws Exception {
        Document d = this.getAsDOM(this.root() + "service=wps&request=describeprocess&identifier=geo:simplify");
        this.checkValidationErrors(d);
        XMLAssert.assertXpathExists((String)"/wps:ProcessDescriptions", (Document)d);
        String base = "/wps:ProcessDescriptions/ProcessDescription/DataInputs";
        XMLAssert.assertXpathExists((String)(base + "/Input[1]"), (Document)d);
        XMLAssert.assertXpathEvaluatesTo((String)"geom", (String)(base + "/Input[1]/ows:Identifier"), (Document)d);
        XMLAssert.assertXpathExists((String)(base + "/Input[1]/ComplexData"), (Document)d);
        XMLAssert.assertXpathEvaluatesTo((String)"10", (String)(base + "/Input[1]/ComplexData/@maximumMegabytes"), (Document)d);
        XMLAssert.assertXpathExists((String)(base + "/Input[2]"), (Document)d);
        XMLAssert.assertXpathEvaluatesTo((String)"distance", (String)(base + "/Input[2]/ows:Identifier"), (Document)d);
        XMLAssert.assertXpathExists((String)(base + "/Input[2]/LiteralData"), (Document)d);
        XMLAssert.assertXpathEvaluatesTo((String)"open-closed", (String)(base + "/Input[2]/LiteralData/ows:AllowedValues/ows:Range/@ows:rangeClosure"), (Document)d);
        XMLAssert.assertXpathNotExists((String)(base + "/Input[2]/LiteralData/ows:AllowedValues/ows:Range/ows:MinimumValue"), (Document)d);
        XMLAssert.assertXpathEvaluatesTo((String)"100.0", (String)(base + "/Input[2]/LiteralData/ows:AllowedValues/ows:Range/ows:MaximumValue"), (Document)d);
    }

    @Test
    public void testDescribeDensify() throws Exception {
        Document d = this.getAsDOM(this.root() + "service=wps&request=describeprocess&identifier=geo:densify");
        this.checkValidationErrors(d);
        XMLAssert.assertXpathExists((String)"/wps:ProcessDescriptions", (Document)d);
        String base = "/wps:ProcessDescriptions/ProcessDescription/DataInputs";
        XMLAssert.assertXpathExists((String)(base + "/Input[1]"), (Document)d);
        XMLAssert.assertXpathEvaluatesTo((String)"geom", (String)(base + "/Input[1]/ows:Identifier"), (Document)d);
        XMLAssert.assertXpathExists((String)(base + "/Input[1]/ComplexData"), (Document)d);
        XMLAssert.assertXpathEvaluatesTo((String)"10", (String)(base + "/Input[1]/ComplexData/@maximumMegabytes"), (Document)d);
        XMLAssert.assertXpathExists((String)(base + "/Input[2]"), (Document)d);
        XMLAssert.assertXpathEvaluatesTo((String)"distance", (String)(base + "/Input[2]/ows:Identifier"), (Document)d);
        XMLAssert.assertXpathExists((String)(base + "/Input[2]/LiteralData"), (Document)d);
        XMLAssert.assertXpathEvaluatesTo((String)"closed-open", (String)(base + "/Input[2]/LiteralData/ows:AllowedValues/ows:Range/@ows:rangeClosure"), (Document)d);
        XMLAssert.assertXpathEvaluatesTo((String)"0.0", (String)(base + "/Input[2]/LiteralData/ows:AllowedValues/ows:Range/ows:MinimumValue"), (Document)d);
        XMLAssert.assertXpathNotExists((String)(base + "/Input[2]/LiteralData/ows:AllowedValues/ows:Range/ows:MaximumValue"), (Document)d);
    }

    @Test
    public void testDescribeArea() throws Exception {
        Document d = this.getAsDOM(this.root() + "service=wps&request=describeprocess&identifier=geo:area");
        this.checkValidationErrors(d);
        XMLAssert.assertXpathExists((String)"/wps:ProcessDescriptions", (Document)d);
        String base = "/wps:ProcessDescriptions/ProcessDescription/DataInputs";
        XMLAssert.assertXpathExists((String)(base + "/Input[1]"), (Document)d);
        XMLAssert.assertXpathEvaluatesTo((String)"geom", (String)(base + "/Input[1]/ows:Identifier"), (Document)d);
        XMLAssert.assertXpathExists((String)(base + "/Input[1]/ComplexData"), (Document)d);
        XMLAssert.assertXpathEvaluatesTo((String)"10", (String)(base + "/Input[1]/ComplexData/@maximumMegabytes"), (Document)d);
    }

    @Test
    public void testDescribeContour() throws Exception {
        Document d = this.getAsDOM(this.root() + "service=wps&request=describeprocess&identifier=ras:Contour");
        this.checkValidationErrors(d);
        XMLAssert.assertXpathExists((String)"/wps:ProcessDescriptions", (Document)d);
        String base = "/wps:ProcessDescriptions/ProcessDescription/DataInputs";
        XMLAssert.assertXpathExists((String)(base + "/Input[1]"), (Document)d);
        XMLAssert.assertXpathEvaluatesTo((String)"data", (String)(base + "/Input[1]/ows:Identifier"), (Document)d);
        XMLAssert.assertXpathExists((String)(base + "/Input[1]/ComplexData"), (Document)d);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)(base + "/Input[1]/ComplexData/@maximumMegabytes"), (Document)d);
        XMLAssert.assertXpathExists((String)(base + "/Input[3]"), (Document)d);
        XMLAssert.assertXpathEvaluatesTo((String)"levels", (String)(base + "/Input[3]/ows:Identifier"), (Document)d);
        XMLAssert.assertXpathEvaluatesTo((String)"0", (String)(base + "/Input[3]/@minOccurs"), (Document)d);
        XMLAssert.assertXpathEvaluatesTo((String)"3", (String)(base + "/Input[3]/@maxOccurs"), (Document)d);
        XMLAssert.assertXpathExists((String)(base + "/Input[3]/LiteralData"), (Document)d);
        XMLAssert.assertXpathEvaluatesTo((String)"closed", (String)(base + "/Input[3]/LiteralData/ows:AllowedValues/ows:Range/@ows:rangeClosure"), (Document)d);
        XMLAssert.assertXpathEvaluatesTo((String)"-8000.0", (String)(base + "/Input[3]/LiteralData/ows:AllowedValues/ows:Range/ows:MinimumValue"), (Document)d);
        XMLAssert.assertXpathEvaluatesTo((String)"8000.0", (String)(base + "/Input[3]/LiteralData/ows:AllowedValues/ows:Range/ows:MaximumValue"), (Document)d);
        XMLAssert.assertXpathExists((String)(base + "/Input[7]"), (Document)d);
        XMLAssert.assertXpathEvaluatesTo((String)"roi", (String)(base + "/Input[7]/ows:Identifier"), (Document)d);
        XMLAssert.assertXpathExists((String)(base + "/Input[7]/ComplexData"), (Document)d);
        XMLAssert.assertXpathEvaluatesTo((String)"10", (String)(base + "/Input[7]/ComplexData/@maximumMegabytes"), (Document)d);
    }

    @Test
    public void testBufferLargeInlineGeometry() throws Exception {
        String wkt = this.buildLineString(65537);
        String xml = "<wps:Execute service='WPS' version='1.0.0' xmlns:wps='http://www.opengis.net/wps/1.0.0' xmlns:ows='http://www.opengis.net/ows/1.1'><ows:Identifier>geo:buffer</ows:Identifier><wps:DataInputs><wps:Input><ows:Identifier>distance</ows:Identifier><wps:Data><wps:LiteralData>1</wps:LiteralData></wps:Data></wps:Input><wps:Input><ows:Identifier>geom</ows:Identifier><wps:Data><wps:ComplexData mimeType=\"application/wkt\"><![CDATA[" + wkt + "]]></wps:ComplexData></wps:Data></wps:Input></wps:DataInputs><wps:ResponseForm><wps:ResponseDocument storeExecuteResponse='false'><wps:Output><ows:Identifier>result</ows:Identifier></wps:Output></wps:ResponseDocument></wps:ResponseForm></wps:Execute>";
        Document dom = this.postAsDOM("wps", xml);
        XMLAssert.assertXpathExists((String)"//wps:Status/wps:ProcessFailed", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"geom", (String)"//wps:Status/wps:ProcessFailed/ows:ExceptionReport/ows:Exception/@locator", (Document)dom);
        String message = xp.evaluate("//wps:Status/wps:ProcessFailed/ows:ExceptionReport/ows:Exception/ows:ExceptionText", dom);
        Assert.assertTrue((boolean)message.contains("exceeds the maximum allowed"));
        Assert.assertTrue((boolean)message.contains("geom"));
    }

    @Test
    public void testBufferLargeFileReferenceGeometry() throws Exception {
        String wkt = this.buildLineString(85534);
        File tmp = this.getResourceLoader().find("tmp");
        File wktDataFile = new File(tmp, "line.wkt");
        FileUtils.writeStringToFile((File)wktDataFile, (String)wkt, (String)"UTF-8");
        String xml = "<wps:Execute service='WPS' version='1.0.0' xmlns:wps='http://www.opengis.net/wps/1.0.0' xmlns:xlink=\"http://www.w3.org/1999/xlink\" xmlns:ows='http://www.opengis.net/ows/1.1'><ows:Identifier>geo:buffer</ows:Identifier><wps:DataInputs><wps:Input><ows:Identifier>distance</ows:Identifier><wps:Data><wps:LiteralData>1</wps:LiteralData></wps:Data></wps:Input><wps:Input><ows:Identifier>geom</ows:Identifier>  <wps:Reference mimeType=\"application/wkt\" xlink:href=\"" + URLs.fileToUrl((File)wktDataFile) + "\"/>\n</wps:Input></wps:DataInputs><wps:ResponseForm><wps:ResponseDocument storeExecuteResponse='false'><wps:Output><ows:Identifier>result</ows:Identifier></wps:Output></wps:ResponseDocument></wps:ResponseForm></wps:Execute>";
        Document dom = this.postAsDOM("wps", xml);
        XMLAssert.assertXpathExists((String)"//wps:Status/wps:ProcessFailed", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"geom", (String)"//wps:Status/wps:ProcessFailed/ows:ExceptionReport/ows:Exception/@locator", (Document)dom);
        String message = xp.evaluate("//wps:Status/wps:ProcessFailed/ows:ExceptionReport/ows:Exception/ows:ExceptionText", dom);
        Assert.assertTrue((boolean)message.contains("exceeds maximum allowed size"));
        Assert.assertTrue((boolean)message.contains("geom"));
    }

    @Test
    public void testBufferLargeDistance() throws Exception {
        String wkt = this.buildLineString(10);
        String xml = "<wps:Execute service='WPS' version='1.0.0' xmlns:wps='http://www.opengis.net/wps/1.0.0' xmlns:ows='http://www.opengis.net/ows/1.1'><ows:Identifier>geo:buffer</ows:Identifier><wps:DataInputs><wps:Input><ows:Identifier>distance</ows:Identifier><wps:Data><wps:LiteralData>200</wps:LiteralData></wps:Data></wps:Input><wps:Input><ows:Identifier>geom</ows:Identifier><wps:Data><wps:ComplexData mimeType=\"application/wkt\"><![CDATA[" + wkt + "]]></wps:ComplexData></wps:Data></wps:Input></wps:DataInputs><wps:ResponseForm><wps:ResponseDocument storeExecuteResponse='false'><wps:Output><ows:Identifier>result</ows:Identifier></wps:Output></wps:ResponseDocument></wps:ResponseForm></wps:Execute>";
        Document dom = this.postAsDOM("wps", xml);
        XMLAssert.assertXpathExists((String)"//wps:Status/wps:ProcessFailed", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"distance", (String)"//wps:Status/wps:ProcessFailed/ows:ExceptionReport/ows:Exception/@locator", (Document)dom);
        String message = xp.evaluate("//wps:Status/wps:ProcessFailed/ows:ExceptionReport/ows:Exception/ows:ExceptionText", dom);
        Assert.assertTrue((boolean)message.contains("distance"));
        Assert.assertTrue((boolean)message.contains("Value 200.0 is out of the valid range [0.0, 100.0]"));
    }

    private String buildLineString(int coordinateCount) {
        StringBuilder sb = new StringBuilder("LINESTRING(");
        for (int i = 0; i < coordinateCount; ++i) {
            sb.append(i).append(" ").append(i);
            if (i >= coordinateCount - 1) continue;
            sb.append(", ");
        }
        sb.append(")");
        String wkt = sb.toString();
        return wkt;
    }

    @Test
    public void testCountourTooManyLevels() throws Exception {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<wps:Execute version=\"1.0.0\" service=\"WPS\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns=\"http://www.opengis.net/wps/1.0.0\" xmlns:wfs=\"http://www.opengis.net/wfs\" xmlns:wps=\"http://www.opengis.net/wps/1.0.0\" xmlns:ows=\"http://www.opengis.net/ows/1.1\" xmlns:gml=\"http://www.opengis.net/gml\" xmlns:ogc=\"http://www.opengis.net/ogc\" xmlns:wcs=\"http://www.opengis.net/wcs/1.1.1\" xmlns:xlink=\"http://www.w3.org/1999/xlink\" xsi:schemaLocation=\"http://www.opengis.net/wps/1.0.0 http://schemas.opengis.net/wps/1.0.0/wpsAll.xsd\">\n  <ows:Identifier>ras:Contour</ows:Identifier>\n  <wps:DataInputs>\n    <wps:Input>\n      <ows:Identifier>data</ows:Identifier>\n      <wps:Reference mimeType=\"image/tiff\" xlink:href=\"http://geoserver/wcs\" method=\"POST\">\n        <wps:Body>\n          <wcs:GetCoverage service=\"WCS\" version=\"1.1.1\">\n            <ows:Identifier>" + this.getLayerId(MockData.TASMANIA_DEM) + "</ows:Identifier>\n            <wcs:DomainSubset>\n              <gml:BoundingBox crs=\"http://www.opengis.net/gml/srs/epsg.xml#4326\">\n                <ows:LowerCorner>-180 -90</ows:LowerCorner>\n                <ows:UpperCorner>180 90</ows:UpperCorner>\n              </gml:BoundingBox>\n            </wcs:DomainSubset>\n            <wcs:Output format=\"image/tiff\"/>\n          </wcs:GetCoverage>\n        </wps:Body>\n      </wps:Reference>\n    </wps:Input>\n    <wps:Input>\n      <ows:Identifier>levels</ows:Identifier>\n      <wps:Data>\n        <wps:LiteralData>0</wps:LiteralData>\n      </wps:Data>\n    </wps:Input>\n    <wps:Input>\n      <ows:Identifier>levels</ows:Identifier>\n      <wps:Data>\n        <wps:LiteralData>10</wps:LiteralData>\n      </wps:Data>\n    </wps:Input>\n    <wps:Input>\n      <ows:Identifier>levels</ows:Identifier>\n      <wps:Data>\n        <wps:LiteralData>20</wps:LiteralData>\n      </wps:Data>\n    </wps:Input>\n    <wps:Input>\n      <ows:Identifier>levels</ows:Identifier>\n      <wps:Data>\n        <wps:LiteralData>30</wps:LiteralData>\n      </wps:Data>\n    </wps:Input>\n  </wps:DataInputs>\n  <wps:ResponseForm>\n    <wps:RawDataOutput mimeType=\"text/xml; subtype=wfs-collection/1.0\">\n      <ows:Identifier>result</ows:Identifier>\n    </wps:RawDataOutput>\n  </wps:ResponseForm>\n</wps:Execute>";
        Document dom = this.postAsDOM("wps", xml);
        XMLAssert.assertXpathExists((String)"//wps:Status/wps:ProcessFailed", (Document)dom);
        XMLAssert.assertXpathExists((String)"//wps:Status/wps:ProcessFailed", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"levels", (String)"//wps:Status/wps:ProcessFailed/ows:ExceptionReport/ows:Exception/@locator", (Document)dom);
        String message = xp.evaluate("//wps:Status/wps:ProcessFailed/ows:ExceptionReport/ows:Exception/ows:ExceptionText", dom);
        Assert.assertTrue((boolean)message.contains("levels"));
        Assert.assertTrue((boolean)message.contains("Too many values"));
    }

    @Test
    public void testCountourLevelsOutOfRange() throws Exception {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<wps:Execute version=\"1.0.0\" service=\"WPS\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns=\"http://www.opengis.net/wps/1.0.0\" xmlns:wfs=\"http://www.opengis.net/wfs\" xmlns:wps=\"http://www.opengis.net/wps/1.0.0\" xmlns:ows=\"http://www.opengis.net/ows/1.1\" xmlns:gml=\"http://www.opengis.net/gml\" xmlns:ogc=\"http://www.opengis.net/ogc\" xmlns:wcs=\"http://www.opengis.net/wcs/1.1.1\" xmlns:xlink=\"http://www.w3.org/1999/xlink\" xsi:schemaLocation=\"http://www.opengis.net/wps/1.0.0 http://schemas.opengis.net/wps/1.0.0/wpsAll.xsd\">\n  <ows:Identifier>ras:Contour</ows:Identifier>\n  <wps:DataInputs>\n    <wps:Input>\n      <ows:Identifier>data</ows:Identifier>\n      <wps:Reference mimeType=\"image/tiff\" xlink:href=\"http://geoserver/wcs\" method=\"POST\">\n        <wps:Body>\n          <wcs:GetCoverage service=\"WCS\" version=\"1.1.1\">\n            <ows:Identifier>" + this.getLayerId(MockData.TASMANIA_DEM) + "</ows:Identifier>\n            <wcs:DomainSubset>\n              <gml:BoundingBox crs=\"http://www.opengis.net/gml/srs/epsg.xml#4326\">\n                <ows:LowerCorner>-180 -90</ows:LowerCorner>\n                <ows:UpperCorner>180 90</ows:UpperCorner>\n              </gml:BoundingBox>\n            </wcs:DomainSubset>\n            <wcs:Output format=\"image/tiff\"/>\n          </wcs:GetCoverage>\n        </wps:Body>\n      </wps:Reference>\n    </wps:Input>\n    <wps:Input>\n      <ows:Identifier>levels</ows:Identifier>\n      <wps:Data>\n        <wps:LiteralData>10000</wps:LiteralData>\n      </wps:Data>\n    </wps:Input>\n  </wps:DataInputs>\n  <wps:ResponseForm>\n    <wps:RawDataOutput mimeType=\"text/xml; subtype=wfs-collection/1.0\">\n      <ows:Identifier>result</ows:Identifier>\n    </wps:RawDataOutput>\n  </wps:ResponseForm>\n</wps:Execute>";
        Document dom = this.postAsDOM("wps", xml);
        XMLAssert.assertXpathExists((String)"//wps:Status/wps:ProcessFailed", (Document)dom);
        XMLAssert.assertXpathExists((String)"//wps:Status/wps:ProcessFailed", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"levels", (String)"//wps:Status/wps:ProcessFailed/ows:ExceptionReport/ows:Exception/@locator", (Document)dom);
        String message = xp.evaluate("//wps:Status/wps:ProcessFailed/ows:ExceptionReport/ows:Exception/ows:ExceptionText", dom);
        Assert.assertTrue((boolean)message.contains("levels"));
        Assert.assertTrue((boolean)message.contains(" Value 10000.0 is out of the valid range [-8000.0, 8000.0]"));
    }

    @Test
    @Ignore
    public void testAsyncExecutionLimit() throws Exception {
        WPSInfo wps = (WPSInfo)this.getGeoServer().getService(WPSInfo.class);
        wps.setMaxAsynchronousExecutionTime(2);
        wps.setMaxAsynchronousTotalTime(Integer.valueOf(3));
        this.getGeoServer().save((ServiceInfo)wps);
        String statusLocation = this.submitAsynchronousRequest("wps?service=WPS&version=1.0.0&request=Execute&Identifier=gs:Monkey&storeExecuteResponse=true&status=true&DataInputs=" + this.urlEncode("id=x1"));
        this.waitForProcessStart(statusLocation, 10L);
        MonkeyProcess.wait("x1", 2500L);
        MonkeyProcess.progress("x1", 54.0f, false);
        Document response3 = this.waitForProcessEnd(statusLocation, 10L);
        XMLAssert.assertXpathExists((String)"//ows:ExceptionText[contains(., 'maxExecutionTime 2 seconds, maxTotalTime 3 seconds')]", (Document)response3);
    }

    @Test
    @Ignore
    public void testAsyncTotalLimit() throws Exception {
        WPSInfo wps = (WPSInfo)this.getGeoServer().getService(WPSInfo.class);
        wps.setMaxAsynchronousExecutionTime(2);
        wps.setMaxAsynchronousTotalTime(Integer.valueOf(3));
        wps.setMaxAsynchronousProcesses(1);
        this.getGeoServer().save((ServiceInfo)wps);
        String statusLocationX1 = this.submitAsynchronousRequest("wps?service=WPS&version=1.0.0&request=Execute&Identifier=gs:Monkey&storeExecuteResponse=true&status=true&DataInputs=" + this.urlEncode("id=x1"));
        String statusLocationX2 = this.submitAsynchronousRequest("wps?service=WPS&version=1.0.0&request=Execute&Identifier=gs:Monkey&storeExecuteResponse=true&status=true&DataInputs=" + this.urlEncode("id=x2"));
        String statusLocationX3 = this.submitAsynchronousRequest("wps?service=WPS&version=1.0.0&request=Execute&Identifier=gs:Monkey&storeExecuteResponse=true&status=true&DataInputs=" + this.urlEncode("id=x3"));
        MonkeyProcess.wait("x1", 1100L);
        MonkeyProcess.wait("x2", 1100L);
        MonkeyProcess.wait("x3", 1100L);
        MonkeyProcess.exit("x1", null, false);
        MonkeyProcess.exit("x2", null, false);
        MonkeyProcess.progress("x3", 54.0f, false);
        Document response1 = this.waitForProcessEnd(statusLocationX1, 10L);
        XMLAssert.assertXpathExists((String)"//wps:ProcessSucceeded", (Document)response1);
        Document response2 = this.waitForProcessEnd(statusLocationX2, 10L);
        XMLAssert.assertXpathExists((String)"//wps:ProcessSucceeded", (Document)response2);
        Document response3 = this.waitForProcessEnd(statusLocationX3, 10L);
        XMLAssert.assertXpathExists((String)"//ows:ExceptionText[contains(., 'maxExecutionTime 2 seconds, maxTotalTime 3 seconds')]", (Document)response3);
    }

    @Test
    @Ignore
    public void testSyncExecutionLimits() throws Exception {
        WPSInfo wps = (WPSInfo)this.getGeoServer().getService(WPSInfo.class);
        wps.setMaxSynchronousExecutionTime(1);
        wps.setMaxSynchronousTotalTime(Integer.valueOf(2));
        this.getGeoServer().save((ServiceInfo)wps);
        MonkeyProcess.wait("x1", 1100L);
        MonkeyProcess.progress("x1", 54.0f, false);
        Document result = this.getAsDOM("wps?service=WPS&version=1.0.0&request=Execute&Identifier=gs:Monkey&DataInputs=" + this.urlEncode("id=x1"));
        XMLAssert.assertXpathExists((String)"//ows:ExceptionText[contains(., 'maxExecutionTime 1 seconds, maxTotalTime 2 seconds')]", (Document)result);
    }

    @Test
    public void testSyncTotalLimit() throws Exception {
        WPSInfo wps = (WPSInfo)this.getGeoServer().getService(WPSInfo.class);
        wps.setMaxSynchronousTotalTime(Integer.valueOf(1));
        this.getGeoServer().save((ServiceInfo)wps);
        MonkeyProcess.wait("x1", 1100L);
        MonkeyProcess.progress("x1", 54.0f, false);
        Document result = this.getAsDOM("wps?service=WPS&version=1.0.0&request=Execute&Identifier=gs:Monkey&DataInputs=" + this.urlEncode("id=x1"));
        XMLAssert.assertXpathExists((String)"//ows:ExceptionText[contains(., 'maxTotalTime 1 seconds')]", (Document)result);
    }

    String urlEncode(String string) throws Exception {
        return URLEncoder.encode(string, "ASCII");
    }

    private String submitAsynchronousRequest(String request) throws Exception {
        Document response = this.getAsDOM(request);
        return this.getStatusLocation(response);
    }

    private String getStatusLocation(Document dom) throws XpathException {
        XpathEngine xpath = XMLUnit.newXpathEngine();
        String fullStatusLocation = xpath.evaluate("//wps:ExecuteResponse/@statusLocation", dom);
        return fullStatusLocation.substring(fullStatusLocation.indexOf(63) - 3);
    }
}

