/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wps;

import java.io.IOException;
import java.io.InputStream;
import org.geoserver.wps.process.RawData;
import org.geotools.api.util.InternationalString;
import org.geotools.process.ProcessFactory;
import org.geotools.process.factory.AnnotatedBeanProcessFactory;
import org.geotools.process.factory.DescribeParameter;
import org.geotools.process.factory.DescribeProcess;
import org.geotools.process.factory.DescribeResult;
import org.geotools.util.SimpleInternationalString;

@DescribeProcess(title="Raw", description="Process used to test raw inputs and outputs")
public class RawProcess {
    @DescribeResult(name="result", description="Output raster", meta={"mimeTypes=application/json,text/xml", "chosenMimeType=outputMimeType"})
    public RawData execute(final @DescribeParameter(name="data", description="Input features", meta={"mimeTypes=application/json,text/xml"}) RawData input, final @DescribeParameter(name="outputMimeType", min=0) String outputMimeType, @DescribeParameter(name="returnNull", min=0, defaultValue="false") boolean returnNull) {
        if (returnNull) {
            return null;
        }
        return new RawData(){

            public String getMimeType() {
                return outputMimeType;
            }

            public InputStream getInputStream() throws IOException {
                return input.getInputStream();
            }

            public String getFileExtension() {
                return "bin";
            }
        };
    }

    static final ProcessFactory getFactory() {
        return new AnnotatedBeanProcessFactory((InternationalString)new SimpleInternationalString("Raw data process"), "gs", new Class[]{RawProcess.class});
    }
}

