/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wps.gs;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URL;
import net.opengis.wfs.FeatureCollectionType;
import org.custommonkey.xmlunit.XMLAssert;
import org.geoserver.wps.WPSTestSupport;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.feature.FeatureCollection;
import org.geotools.wfs.v1_0.WFSConfiguration_1_0;
import org.geotools.xsd.Configuration;
import org.geotools.xsd.Parser;
import org.junit.Assert;
import org.junit.Test;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.springframework.mock.web.MockHttpServletResponse;
import org.w3c.dom.Document;

public class ClipProcessTest
extends WPSTestSupport {
    @Override
    protected String getFeatureNamespace() {
        return "http://geoserver.org/iau";
    }

    @Test
    public void testClipRectangle() throws Exception {
        String xml = "<wps:Execute service='WPS' version='1.0.0' xmlns:wps='http://www.opengis.net/wps/1.0.0' xmlns:ows='http://www.opengis.net/ows/1.1'><ows:Identifier>gs:RectangularClip</ows:Identifier><wps:DataInputs><wps:Input><ows:Identifier>features</ows:Identifier><wps:Data><wps:ComplexData>" + this.readFileIntoString("illinois.xml") + "</wps:ComplexData></wps:Data></wps:Input><wps:Input><ows:Identifier>clip</ows:Identifier><wps:Data><ows:BoundingBox><ows:LowerCorner>-100 40</ows:LowerCorner><ows:UpperCorner>-90 45</ows:UpperCorner></ows:BoundingBox></wps:Data></wps:Input></wps:DataInputs><wps:ResponseForm><wps:RawDataOutput><ows:Identifier>result</ows:Identifier></wps:RawDataOutput></wps:ResponseForm></wps:Execute>";
        MockHttpServletResponse response = this.postAsServletResponse(this.root(), xml);
        Parser p = new Parser((Configuration)new WFSConfiguration_1_0());
        FeatureCollectionType fct = (FeatureCollectionType)p.parse((InputStream)new ByteArrayInputStream(response.getContentAsString().getBytes()));
        FeatureCollection fc = (FeatureCollection)fct.getFeature().get(0);
        Assert.assertEquals((long)1L, (long)fc.size());
        SimpleFeature sf = (SimpleFeature)fc.features().next();
        Geometry simplified = (Geometry)sf.getDefaultGeometry();
        Assert.assertTrue((boolean)new Envelope(-100.0, -90.0, 40.0, 45.0).contains(simplified.getEnvelopeInternal()));
    }

    @Test
    public void testClipIAU() throws Exception {
        String xml = "<wps:Execute service='WPS' version='1.0.0' xmlns:wps='http://www.opengis.net/wps/1.0.0' xmlns:ows='http://www.opengis.net/ows/1.1' xmlns:wfs=\"http://www.opengis.net/wfs\" xmlns:xlink=\"http://www.w3.org/1999/xlink\"><ows:Identifier>gs:RectangularClip</ows:Identifier><wps:DataInputs><wps:Input><ows:Identifier>features</ows:Identifier>  <wps:Reference mimeType=\"text/xml; subtype=wfs-collection/1.0\" xlink:href=\"http://geoserver/wfs\" method=\"POST\">\n    <wps:Body>\n      <wfs:GetFeature service=\"WFS\" version=\"1.0.0\">\n        <wfs:Query typeName=\"iau:MarsPoi\"/>\n      </wfs:GetFeature>\n    </wps:Body>\n  </wps:Reference>\n</wps:Input><wps:Input><ows:Identifier>clip</ows:Identifier><wps:Data><ows:BoundingBox crs=\"IAU:49900\"><ows:LowerCorner>-37 -40</ows:LowerCorner><ows:UpperCorner>-36 -20</ows:UpperCorner></ows:BoundingBox></wps:Data></wps:Input></wps:DataInputs><wps:ResponseForm><wps:ResponseDocument storeExecuteResponse='false' lineage='true'><wps:Output><ows:Identifier>result</ows:Identifier></wps:Output></wps:ResponseDocument></wps:ResponseForm></wps:Execute>";
        Document dom = this.postAsDOM(this.root(), xml);
        this.print(dom);
        Assert.assertEquals((Object)"2", (Object)xp.evaluate("count(//feature:MarsPoi)", dom));
        Assert.assertEquals((Object)"Blunck", (Object)xp.evaluate("(//feature:MarsPoi/gml:name)[1]", dom));
        Assert.assertEquals((Object)"Martynov", (Object)xp.evaluate("(//feature:MarsPoi/gml:name)[2]", dom));
        Assert.assertEquals((Object)"http://www.opengis.net/gml/srs/iau.xml#49900", (Object)xp.evaluate("/wps:ExecuteResponse/wps:ProcessOutputs/wps:Output/wps:Data/wps:ComplexData/wfs:FeatureCollection/gml:boundedBy/gml:Box/@srsName", dom));
    }

    @Test
    public void testFeatureCollectionIAU() throws Exception {
        URL collectionURL = ((Object)((Object)this)).getClass().getResource("../mars-poi-FeatureCollection.xml");
        String xml = "<wps:Execute service='WPS' version='1.0.0' xmlns:wps='http://www.opengis.net/wps/1.0.0' xmlns:xlink=\"http://www.w3.org/1999/xlink\" xmlns:ows='http://www.opengis.net/ows/1.1'><ows:Identifier>gs:RectangularClip</ows:Identifier><wps:DataInputs><wps:Input><ows:Identifier>features</ows:Identifier>  <wps:Reference mimeType=\"text/xml; subtype=wfs-collection/1.1\" xlink:href=\"" + collectionURL.toExternalForm() + "\"/>\n</wps:Input><wps:Input><ows:Identifier>clip</ows:Identifier><wps:Data><ows:BoundingBox crs=\"IAU:49900\"><ows:LowerCorner>-37 -28</ows:LowerCorner><ows:UpperCorner>-35 -26</ows:UpperCorner></ows:BoundingBox></wps:Data></wps:Input></wps:DataInputs><wps:ResponseForm><wps:ResponseDocument storeExecuteResponse='false'><wps:Output><ows:Identifier>result</ows:Identifier></wps:Output></wps:ResponseDocument></wps:ResponseForm></wps:Execute>";
        Document d = this.postAsDOM("wps", xml);
        this.print(d);
        this.checkValidationErrors(d);
        Assert.assertEquals((Object)"wps:ExecuteResponse", (Object)d.getDocumentElement().getNodeName());
        XMLAssert.assertXpathExists((String)"/wps:ExecuteResponse/wps:Status/wps:ProcessSucceeded", (Document)d);
        XMLAssert.assertXpathExists((String)"/wps:ExecuteResponse/wps:ProcessOutputs/wps:Output/wps:Data/wps:ComplexData/wfs:FeatureCollection", (Document)d);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//gml:featureMember)", (Document)d);
        XMLAssert.assertXpathEvaluatesTo((String)"Blunck", (String)"//gml:featureMember//gml:name", (Document)d);
    }

    protected String getLogConfiguration() {
        return "DEFAULT_LOGGING";
    }
}

