/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wps.gs;

import java.io.IOException;
import org.geoserver.catalog.CoverageInfo;
import org.geoserver.wps.gs.BaseRasterToVectorTest;
import org.geotools.api.coverage.Coverage;
import org.geotools.api.coverage.grid.GridCoverage;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.geometry.Bounds;
import org.geotools.api.util.ProgressListener;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.processing.Operations;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.data.util.NullProgressListener;
import org.geotools.geometry.GeneralBounds;
import org.geotools.process.raster.ContourProcess;
import org.geotools.util.factory.GeoTools;
import org.junit.Assert;
import org.junit.Test;

public class ContourProcessTest
extends BaseRasterToVectorTest {
    @Test
    public void testProcessStandaloneBasicValues() throws Exception {
        GridCoverage2D gc = this.extractCoverageSubset();
        double[] levels = new double[]{1500.0, 1700.0};
        ContourProcess process = new ContourProcess();
        SimpleFeatureCollection fc = process.execute(gc, Integer.valueOf(0), levels, null, Boolean.valueOf(false), Boolean.valueOf(false), null, (ProgressListener)new NullProgressListener());
        Assert.assertNotNull((Object)fc);
        Assert.assertTrue((fc.size() > 0 ? 1 : 0) != 0);
        try (SimpleFeatureIterator fi = fc.features();){
            while (fi.hasNext()) {
                SimpleFeature sf = (SimpleFeature)fi.next();
                Double value = (Double)sf.getAttribute("value");
                Assert.assertTrue((value == 1500.0 || value == 1700.0 ? 1 : 0) != 0);
            }
        }
    }

    private GridCoverage2D extractCoverageSubset() throws IOException {
        CoverageInfo dem = this.getCatalog().getCoverageByName(DEM.getLocalPart());
        GridCoverage2D gc = (GridCoverage2D)dem.getGridCoverage(null, GeoTools.getDefaultHints());
        Bounds fullEnvelope = gc.getEnvelope();
        GeneralBounds subset = new GeneralBounds(fullEnvelope.getCoordinateReferenceSystem());
        double minX = fullEnvelope.getMinimum(0);
        double minY = fullEnvelope.getMinimum(1);
        double offsetX = fullEnvelope.getSpan(0) / 5.0;
        double offsetY = fullEnvelope.getSpan(1) / 5.0;
        subset.setEnvelope(new double[]{minX + offsetX, minY + offsetY, minX + offsetX * 2.0, minY + offsetY * 2.0});
        gc = (GridCoverage2D)new Operations(null).crop((Coverage)gc, (Bounds)subset);
        this.scheduleForDisposal((GridCoverage)gc);
        return gc;
    }

    @Test
    public void testProcessStandaloneBasicInterval() throws Exception {
        GridCoverage2D gc = this.extractCoverageSubset();
        double step = 100.0;
        ContourProcess process = new ContourProcess();
        SimpleFeatureCollection fc = process.execute(gc, Integer.valueOf(0), null, Double.valueOf(100.0), Boolean.valueOf(false), Boolean.valueOf(false), null, (ProgressListener)new NullProgressListener());
        Assert.assertNotNull((Object)fc);
        Assert.assertTrue((fc.size() > 0 ? 1 : 0) != 0);
        try (SimpleFeatureIterator fi = fc.features();){
            while (fi.hasNext()) {
                SimpleFeature sf = (SimpleFeature)fi.next();
                Double value = (Double)sf.getAttribute("value");
                Assert.assertTrue((value > 0.0 ? 1 : 0) != 0);
            }
        }
    }
}

