/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wps.gs;

import com.google.common.collect.Ordering;
import java.util.ArrayList;
import java.util.Map;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import net.sf.json.JSONSerializer;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CatalogBuilder;
import org.geoserver.catalog.DataStoreInfo;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.StoreInfo;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.data.test.CiteTestData;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.wps.WPSTestSupport;
import org.geotools.api.data.DataStore;
import org.geotools.api.data.FeatureSource;
import org.geotools.api.data.SimpleFeatureSource;
import org.geotools.api.data.SimpleFeatureStore;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.feature.type.FeatureType;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.junit.Assert;
import org.junit.Test;

public class H2PagedUniqueTest
extends WPSTestSupport {
    static final String FIELD_NAME = "NAME";

    @Override
    protected void setUpInternal(SystemTestData data) throws Exception {
        super.setUpInternal(data);
        Catalog cat = this.getCatalog();
        WorkspaceInfo ws = cat.getWorkspaceByName(CiteTestData.CITE_PREFIX);
        DataStoreInfo h2 = cat.getFactory().createDataStore();
        h2.setName("h2forests");
        h2.setWorkspace(ws);
        h2.setEnabled(true);
        Map params = h2.getConnectionParameters();
        params.put("dbtype", "h2");
        params.put("database", ((SystemTestData)this.getTestData()).getDataDirectoryRoot().getAbsolutePath() + "/h2forests");
        cat.add((StoreInfo)h2);
        DataStore ds = (DataStore)h2.getDataStore(null);
        SimpleFeatureSource src = this.getFeatureSource(SystemTestData.FORESTS);
        SimpleFeatureTypeBuilder tb = new SimpleFeatureTypeBuilder();
        tb.init((SimpleFeatureType)src.getSchema());
        ds.createSchema((FeatureType)tb.buildFeatureType());
        SimpleFeatureStore store = (SimpleFeatureStore)ds.getFeatureSource(SystemTestData.FORESTS.getLocalPart());
        store.addFeatures((FeatureCollection)src.getFeatures());
        CatalogBuilder cb = new CatalogBuilder(cat);
        cb.setWorkspace(ws);
        cb.setStore((StoreInfo)h2);
        FeatureTypeInfo ft = cb.buildFeatureType((FeatureSource)store);
        ft.setEnabled(true);
        cat.add((ResourceInfo)ft);
        LayerInfo layer = cb.buildLayer(ft);
        layer.setEnabled(true);
        layer.setAdvertised(true);
        cat.add(layer);
    }

    @Test
    public void testH2DescOrder() throws Exception {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<wps:Execute service=\"WPS\" version=\"1.0.0\"\n    xmlns=\"http://www.opengis.net/wps/1.0.0\"\n    xmlns:wps=\"http://www.opengis.net/wps/1.0.0\"\n    xmlns:ows=\"http://www.opengis.net/ows/1.1\"\n    xmlns:wfs=\"http://www.opengis.net/wfs\"\n    xmlns:ogc=\"http://www.opengis.net/ogc\"\n    xmlns:xlink=\"http://www.w3.org/1999/xlink\"\n    xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n    xsi:schemaLocation=\"http://www.opengis.net/wps/1.0.0 http://schemas.opengis.net/wps/1.0.0/wpsAll.xsd\">\n  <ows:Identifier>gs:PagedUnique</ows:Identifier>\n  <wps:DataInputs>\n    <wps:Input>\n      <ows:Identifier>features</ows:Identifier>\n      <wps:Reference mimeType=\"text/xml\"\n                     xlink:href=\"http://geoserver/wfs\"\n                     method=\"POST\">\n        <wps:Body>\n          <wfs:GetFeature service=\"WFS\" version=\"1.0.0\" outputFormat=\"GML2\">\n            <wfs:Query typeName=\"" + CiteTestData.CITE_PREFIX + ":Forests\">\n              <ogc:SortBy>\n                <ogc:SortProperty>\n                  <ogc:PropertyName>NAME</ogc:PropertyName>\n                  <ogc:SortOrder>DESC</ogc:SortOrder>\n                </ogc:SortProperty>\n              </ogc:SortBy>\n            </wfs:Query>\n          </wfs:GetFeature>\n        </wps:Body>\n      </wps:Reference>\n    </wps:Input>\n    <wps:Input>\n      <ows:Identifier>fieldName</ows:Identifier>\n      <wps:Data>\n        <wps:LiteralData>NAME</wps:LiteralData>\n      </wps:Data>\n    </wps:Input>\n    <wps:Input>\n      <ows:Identifier>startIndex</ows:Identifier>\n      <wps:Data>\n        <wps:LiteralData>0</wps:LiteralData>\n      </wps:Data>\n    </wps:Input>\n    <wps:Input>\n      <ows:Identifier>maxFeatures</ows:Identifier>\n      <wps:Data>\n        <wps:LiteralData>100</wps:LiteralData>\n      </wps:Data>\n    </wps:Input>\n  </wps:DataInputs>\n  <wps:ResponseForm>\n    <wps:RawDataOutput mimeType=\"application/json\">\n      <ows:Identifier>result</ows:Identifier>\n    </wps:RawDataOutput>\n  </wps:ResponseForm>\n</wps:Execute>";
        String jsonString = this.string(this.post(this.root(), xml));
        JSONObject json = (JSONObject)JSONSerializer.toJSON((Object)jsonString);
        JSONArray values = json.getJSONArray("values");
        ArrayList<String> list = new ArrayList<String>();
        for (Object o : values) {
            list.add((String)o);
        }
        Assert.assertTrue((String)"Values should be in descending order", (boolean)Ordering.natural().reverse().isOrdered(list));
    }
}

