/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wps.gs;

import java.io.IOException;
import java.util.NoSuchElementException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.commons.lang3.function.Failable;
import org.geoserver.catalog.CoverageInfo;
import org.geoserver.catalog.CoverageStoreInfo;
import org.geoserver.catalog.DataStoreInfo;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.threadlocals.ThreadLocalsTransfer;
import org.geoserver.wps.WPSTestSupport;
import org.geoserver.wps.gs.Coverage2RenderedImageAdapterTest;
import org.geoserver.wps.gs.ImportProcess;
import org.geotools.api.data.Query;
import org.geotools.api.data.SimpleFeatureSource;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.FilterFactory;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.referencing.FactoryException;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.api.util.InternationalString;
import org.geotools.api.util.ProgressListener;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.data.DataUtilities;
import org.geotools.data.crs.ForceCoordinateSystemFeatureResults;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.data.util.DefaultProgressListener;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.collection.DecoratingSimpleFeatureCollection;
import org.geotools.feature.collection.DecoratingSimpleFeatureIterator;
import org.geotools.process.ProcessException;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.util.SimpleInternationalString;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.After;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;

public class ImportProcessTest
extends WPSTestSupport {
    @Before
    public void login() {
        this.login("admin", "geoserver", new String[]{"ROLE_ADMINISTRATOR"});
    }

    @After
    public void removeNewLayers() {
        this.removeLayer(SystemTestData.CITE_PREFIX, "Buildings2");
        this.removeLayer(SystemTestData.CITE_PREFIX, "Buildings4");
        this.removeLayer(SystemTestData.CITE_PREFIX, "Buildings5");
        this.removeLayer(SystemTestData.CITE_PREFIX, "Buildings6");
        this.removeLayer(SystemTestData.CITE_PREFIX, "Buildings7");
        this.removeLayer(SystemTestData.CITE_PREFIX, "Buildings8");
        this.removeLayer(SystemTestData.CITE_PREFIX, "BuildingsCancelled");
        this.removeStore(SystemTestData.CITE_PREFIX, SystemTestData.CITE_PREFIX + "data");
        this.removeStore(SystemTestData.CITE_PREFIX, SystemTestData.CITE_PREFIX + "raster");
        this.removeStore(SystemTestData.IAU_PREFIX, SystemTestData.IAU_PREFIX + "marsCoverageStore");
        this.removeStore(SystemTestData.IAU_PREFIX, SystemTestData.IAU_PREFIX + "marsCoverageStore2");
    }

    @Test
    public void testImportBuildings() throws Exception {
        FeatureTypeInfo ti = this.getCatalog().getFeatureTypeByName(this.getLayerId(SystemTestData.BUILDINGS));
        SimpleFeatureCollection rawSource = (SimpleFeatureCollection)ti.getFeatureSource(null, null).getFeatures();
        ForceCoordinateSystemFeatureResults forced = new ForceCoordinateSystemFeatureResults((FeatureCollection)rawSource, CRS.decode((String)"EPSG:4326"));
        ImportProcess importer = new ImportProcess(this.getCatalog());
        String result = importer.execute((SimpleFeatureCollection)forced, null, SystemTestData.CITE_PREFIX, SystemTestData.CITE_PREFIX, "Buildings2", null, null, null, null);
        this.checkBuildings(result, "Buildings2");
    }

    @Test
    public void testImportBuildingsProgress() throws Exception {
        FeatureTypeInfo ti = this.getCatalog().getFeatureTypeByName(this.getLayerId(SystemTestData.BUILDINGS));
        SimpleFeatureCollection rawSource = (SimpleFeatureCollection)ti.getFeatureSource(null, null).getFeatures();
        ForceCoordinateSystemFeatureResults forced = new ForceCoordinateSystemFeatureResults((FeatureCollection)rawSource, CRS.decode((String)"EPSG:4326"));
        ImportProcess importer = new ImportProcess(this.getCatalog());
        DefaultProgressListener testProgressListener = new DefaultProgressListener(){
            float previousProgress = 0.0f;

            public void progress(float percent) {
                super.progress(percent);
                Assert.assertTrue((percent >= this.previousProgress ? 1 : 0) != 0);
                this.previousProgress = percent;
            }
        };
        String result = importer.execute((SimpleFeatureCollection)forced, null, SystemTestData.CITE_PREFIX, SystemTestData.CITE_PREFIX, "Buildings6", null, null, null, (ProgressListener)testProgressListener);
        Assert.assertEquals((float)100.0f, (float)testProgressListener.getProgress(), (float)0.0f);
        this.checkBuildings(result, "Buildings6");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testImportBuildingsCancellation() throws Exception {
        Assume.assumeFalse((System.getProperty("macos-github-build") != null ? 1 : 0) != 0);
        FeatureTypeInfo ti = this.getCatalog().getFeatureTypeByName(this.getLayerId(SystemTestData.BUILDINGS));
        SimpleFeatureCollection rawSource = (SimpleFeatureCollection)ti.getFeatureSource(null, null).getFeatures();
        final CountDownLatch latch = new CountDownLatch(1);
        DecoratingSimpleFeatureCollection testFeatureCollection = new DecoratingSimpleFeatureCollection(rawSource){

            public SimpleFeatureIterator features() {
                return new DecoratingSimpleFeatureIterator(super.features()){

                    public SimpleFeature next() throws NoSuchElementException {
                        Failable.run(() -> latch.await());
                        return (SimpleFeature)super.next();
                    }
                };
            }
        };
        ImportProcess importer = new ImportProcess(this.getCatalog());
        DefaultProgressListener listener = new DefaultProgressListener();
        ThreadLocalsTransfer transfer = new ThreadLocalsTransfer();
        ExecutorService executor = Executors.newCachedThreadPool();
        try {
            Future<?> future = executor.submit(() -> ImportProcessTest.lambda$testImportBuildingsCancellation$0(transfer, importer, (SimpleFeatureCollection)testFeatureCollection, listener));
            listener.setTask((InternationalString)new SimpleInternationalString("Test message"));
            listener.setCanceled(true);
            latch.countDown();
            try {
                future.get();
                Assert.fail((String)"Should have failed with an exception");
            }
            catch (ExecutionException e) {
                MatcherAssert.assertThat((Object)e.getCause(), (Matcher)CoreMatchers.instanceOf(ProcessException.class));
                Assert.assertEquals((Object)"Test message", (Object)e.getCause().getMessage());
            }
        }
        finally {
            executor.shutdown();
        }
    }

    @Test
    public void testImportBuildingsForceCRS() throws Exception {
        FeatureTypeInfo ti = this.getCatalog().getFeatureTypeByName(this.getLayerId(SystemTestData.BUILDINGS));
        SimpleFeatureCollection rawSource = (SimpleFeatureCollection)ti.getFeatureSource(null, null).getFeatures();
        ImportProcess importer = new ImportProcess(this.getCatalog());
        String result = importer.execute(rawSource, null, SystemTestData.CITE_PREFIX, SystemTestData.CITE_PREFIX, "Buildings3", CRS.decode((String)"EPSG:4326"), null, null, null);
        this.checkBuildings(result, "Buildings3");
    }

    private void checkBuildings(String result, String expected) throws IOException {
        Assert.assertEquals((Object)(SystemTestData.CITE_PREFIX + ":" + expected), (Object)result);
        LayerInfo layer = this.getCatalog().getLayerByName(result);
        Assert.assertNotNull((Object)layer);
        Assert.assertEquals((Object)"polygon", (Object)layer.getDefaultStyle().getName());
        FeatureTypeInfo fti = (FeatureTypeInfo)layer.getResource();
        Assert.assertEquals((Object)"EPSG:4326", (Object)fti.getSRS());
        SimpleFeatureSource fs = (SimpleFeatureSource)fti.getFeatureSource(null, null);
        Assert.assertEquals((long)2L, (long)fs.getCount(Query.ALL));
        FilterFactory ff = CommonFactoryFinder.getFilterFactory(null);
        SimpleFeature f = (SimpleFeature)DataUtilities.first((FeatureCollection)fs.getFeatures((Filter)ff.equals((Expression)ff.property("FID"), (Expression)ff.literal((Object)"113"))));
        Assert.assertEquals((Object)"113", (Object)f.getAttribute("FID"));
        Assert.assertEquals((Object)"123 Main Street", (Object)f.getAttribute("ADDRESS"));
        f = (SimpleFeature)DataUtilities.first((FeatureCollection)fs.getFeatures((Filter)ff.equals((Expression)ff.property("FID"), (Expression)ff.literal((Object)"114"))));
        Assert.assertEquals((Object)"114", (Object)f.getAttribute("FID"));
        Assert.assertEquals((Object)"215 Main Street", (Object)f.getAttribute("ADDRESS"));
    }

    @Test
    public void testCreateCoverageStore() throws Exception {
        String storeName = SystemTestData.CITE_PREFIX + "raster";
        GridCoverage2D sampleCoverage = Coverage2RenderedImageAdapterTest.createTestCoverage(500, 500, 0.0, 0.0, 10.0, 10.0, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        CoverageStoreInfo storeInfo = catalog.getCoverageStoreByName(storeName);
        Assert.assertNull((String)("Store already exists " + storeInfo), (Object)storeInfo);
        ImportProcess importer = new ImportProcess(this.getCatalog());
        String result = importer.execute(null, sampleCoverage, SystemTestData.CITE_PREFIX, storeName, "Buildings4", CRS.decode((String)"EPSG:4326"), null, null, null);
        Assert.assertEquals((Object)result, (Object)(SystemTestData.CITE_PREFIX + ":Buildings4"));
    }

    @Test
    public void testCreateCoverageStoreIAU() throws Exception {
        this.testCreateCoverageStoreIAU("marsCoverage", CRS.decode((String)"IAU:49900"));
        this.testCreateCoverageStoreIAU("marsCoverage2", null);
    }

    private void testCreateCoverageStoreIAU(String name, CoordinateReferenceSystem crs) throws FactoryException {
        String storeName = SystemTestData.IAU_PREFIX + name + "Store";
        CoordinateReferenceSystem marsGeographic = CRS.decode((String)"IAU:49900");
        GridCoverage2D sampleCoverage = Coverage2RenderedImageAdapterTest.createTestCoverage(500, 500, 0.0, 0.0, 10.0, 10.0, marsGeographic);
        CoverageStoreInfo storeInfo = catalog.getCoverageStoreByName(storeName);
        Assert.assertNull((String)("Store already exists " + storeInfo), (Object)storeInfo);
        ImportProcess importer = new ImportProcess(this.getCatalog());
        String result = importer.execute(null, sampleCoverage, SystemTestData.IAU_PREFIX, storeName, name, null, null, null, null);
        Assert.assertEquals((Object)result, (Object)(SystemTestData.IAU_PREFIX + ":" + name));
        CoverageInfo ci = this.getCatalog().getCoverageByName("iau:" + name);
        Assert.assertNotNull((Object)ci);
        Assert.assertTrue((boolean)CRS.equalsIgnoreMetadata((Object)marsGeographic, (Object)ci.getCRS()));
        Assert.assertTrue((boolean)CRS.equalsIgnoreMetadata((Object)marsGeographic, (Object)ci.getNativeCRS()));
    }

    @Test
    public void testCreateCoverageStoreAccessDenied() throws Exception {
        this.logout();
        String storeName = SystemTestData.CITE_PREFIX + "raster";
        GridCoverage2D sampleCoverage = Coverage2RenderedImageAdapterTest.createTestCoverage(500, 500, 0.0, 0.0, 10.0, 10.0, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        CoverageStoreInfo storeInfo = catalog.getCoverageStoreByName(storeName);
        Assert.assertNull((String)("Store already exists " + storeInfo), (Object)storeInfo);
        ImportProcess importer = new ImportProcess(this.getCatalog());
        ProcessException exception = (ProcessException)Assert.assertThrows(ProcessException.class, () -> importer.execute(null, sampleCoverage, SystemTestData.CITE_PREFIX, storeName, "Buildings7", CRS.decode((String)"EPSG:4326"), null, null, null));
        Assert.assertEquals((Object)"Operation unallowed with the current privileges", (Object)exception.getMessage());
    }

    @Test
    public void testCreateDataStore() throws Exception {
        FeatureTypeInfo ti = this.getCatalog().getFeatureTypeByName(this.getLayerId(SystemTestData.BUILDINGS));
        SimpleFeatureCollection rawSource = (SimpleFeatureCollection)ti.getFeatureSource(null, null).getFeatures();
        ForceCoordinateSystemFeatureResults sampleData = new ForceCoordinateSystemFeatureResults((FeatureCollection)rawSource, CRS.decode((String)"EPSG:4326"));
        String storeName = SystemTestData.CITE_PREFIX + "data";
        DataStoreInfo storeInfo = catalog.getDataStoreByName(storeName);
        Assert.assertNull((String)("Store already exists " + storeInfo), (Object)storeInfo);
        ImportProcess importer = new ImportProcess(this.getCatalog());
        String result = importer.execute((SimpleFeatureCollection)sampleData, null, SystemTestData.CITE_PREFIX, storeName, "Buildings5", CRS.decode((String)"EPSG:4326"), null, null, null);
        Assert.assertEquals((Object)result, (Object)(SystemTestData.CITE_PREFIX + ":Buildings5"));
    }

    @Test
    public void testCreateDataStoreAccessDenied() throws Exception {
        this.logout();
        FeatureTypeInfo ti = this.getCatalog().getFeatureTypeByName(this.getLayerId(SystemTestData.BUILDINGS));
        SimpleFeatureCollection rawSource = (SimpleFeatureCollection)ti.getFeatureSource(null, null).getFeatures();
        ForceCoordinateSystemFeatureResults sampleData = new ForceCoordinateSystemFeatureResults((FeatureCollection)rawSource, CRS.decode((String)"EPSG:4326"));
        String storeName = SystemTestData.CITE_PREFIX + "data";
        DataStoreInfo storeInfo = catalog.getDataStoreByName(storeName);
        Assert.assertNull((String)("Store already exists " + storeInfo), (Object)storeInfo);
        ImportProcess importer = new ImportProcess(this.getCatalog());
        ProcessException exception = (ProcessException)Assert.assertThrows(ProcessException.class, () -> importer.execute((SimpleFeatureCollection)sampleData, null, SystemTestData.CITE_PREFIX, storeName, "Buildings8", CRS.decode((String)"EPSG:4326"), null, null, null));
        Assert.assertEquals((Object)"Operation unallowed with the current privileges", (Object)exception.getMessage());
    }

    @Test
    public void testImportVectorMarsPOI() throws Exception {
        FeatureTypeInfo ti = this.getCatalog().getFeatureTypeByName(this.getLayerId(SystemTestData.MARS_POI));
        SimpleFeatureCollection rawSource = (SimpleFeatureCollection)ti.getFeatureSource(null, null).getFeatures();
        ImportProcess importer = new ImportProcess(this.getCatalog());
        String result = importer.execute(rawSource, null, SystemTestData.IAU_PREFIX, SystemTestData.IAU_PREFIX, "poi2", CRS.decode((String)"IAU:49900"), null, null, null);
        Assert.assertEquals((Object)"iau:poi2", (Object)result);
        LayerInfo layer = this.getCatalog().getLayerByName(result);
        Assert.assertNotNull((Object)layer);
        Assert.assertEquals((Object)"point", (Object)layer.getDefaultStyle().getName());
        FeatureTypeInfo fti = (FeatureTypeInfo)layer.getResource();
        Assert.assertEquals((Object)"IAU:49900", (Object)fti.getSRS());
        SimpleFeatureSource fs = (SimpleFeatureSource)fti.getFeatureSource(null, null);
        Assert.assertEquals((long)4L, (long)fs.getCount(Query.ALL));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static /* synthetic */ void lambda$testImportBuildingsCancellation$0(ThreadLocalsTransfer transfer, ImportProcess importer, SimpleFeatureCollection testFeatureCollection, DefaultProgressListener listener) {
        transfer.apply();
        try {
            importer.execute(testFeatureCollection, null, SystemTestData.CITE_PREFIX, SystemTestData.CITE_PREFIX, "BuildingsCancelled", null, null, null, (ProgressListener)listener);
        }
        finally {
            transfer.cleanup();
        }
    }
}

