/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wps.gs;

import org.geoserver.wps.WPSTestSupport;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.filter.FilterFactory;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.DefaultFeatureCollection;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.process.vector.InclusionFeatureCollection;
import org.junit.Assert;
import org.junit.Test;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;

public class InclusionFeatureCollectionTest
extends WPSTestSupport {
    FilterFactory ff = CommonFactoryFinder.getFilterFactory(null);
    GeometryFactory gf = new GeometryFactory();

    @Test
    public void testExecute() throws Exception {
        int numFeatures;
        SimpleFeatureTypeBuilder tb = new SimpleFeatureTypeBuilder();
        tb.setName("featureType");
        tb.add("geometry", Geometry.class);
        tb.add("integer", Integer.class);
        GeometryFactory gf = new GeometryFactory();
        SimpleFeatureBuilder b = new SimpleFeatureBuilder(tb.buildFeatureType());
        DefaultFeatureCollection features = new DefaultFeatureCollection(null, b.getFeatureType());
        DefaultFeatureCollection secondFeatures = new DefaultFeatureCollection(null, b.getFeatureType());
        Coordinate[] firstArray = new Coordinate[5];
        for (numFeatures = 0; numFeatures < 1; ++numFeatures) {
            firstArray[0] = new Coordinate(0.0, 0.0);
            firstArray[1] = new Coordinate(1.0, 0.0);
            firstArray[2] = new Coordinate(1.0, 1.0);
            firstArray[3] = new Coordinate(0.0, 1.0);
            firstArray[4] = new Coordinate(0.0, 0.0);
            LinearRing shell = gf.createLinearRing(firstArray);
            b.add((Object)gf.createPolygon(shell, null));
            b.add((Object)0);
            features.add(b.buildFeature("" + numFeatures));
        }
        for (numFeatures = 0; numFeatures < 1; ++numFeatures) {
            Coordinate[] array = new Coordinate[]{new Coordinate(firstArray[0].x - 1.0, firstArray[0].y - 1.0), new Coordinate(firstArray[1].x + 1.0, firstArray[1].y - 1.0), new Coordinate(firstArray[2].x + 1.0, firstArray[2].y + 1.0), new Coordinate(firstArray[3].x - 1.0, firstArray[3].y + 1.0), new Coordinate(firstArray[0].x - 1.0, firstArray[0].y - 1.0)};
            LinearRing shell = gf.createLinearRing(array);
            b.add((Object)gf.createPolygon(shell, null));
            b.add((Object)0);
            secondFeatures.add(b.buildFeature("" + numFeatures));
        }
        InclusionFeatureCollection process = new InclusionFeatureCollection();
        SimpleFeatureCollection output = process.execute((SimpleFeatureCollection)features, (SimpleFeatureCollection)secondFeatures);
        Assert.assertEquals((long)1L, (long)output.size());
        try (SimpleFeatureIterator iterator = output.features();){
            Geometry expected = (Geometry)((SimpleFeature)features.features().next()).getDefaultGeometry();
            SimpleFeature sf = (SimpleFeature)iterator.next();
            Assert.assertTrue((boolean)expected.equals((Geometry)sf.getDefaultGeometry()));
        }
    }

    @Test
    public void testExecute1() throws Exception {
        SimpleFeatureTypeBuilder tb = new SimpleFeatureTypeBuilder();
        tb.setName("featureType");
        tb.add("geometry", Geometry.class);
        tb.add("integer", Integer.class);
        GeometryFactory gf = new GeometryFactory();
        SimpleFeatureBuilder b = new SimpleFeatureBuilder(tb.buildFeatureType());
        DefaultFeatureCollection features = new DefaultFeatureCollection(null, b.getFeatureType());
        DefaultFeatureCollection secondFeatures = new DefaultFeatureCollection(null, b.getFeatureType());
        Coordinate[] firstArray = new Coordinate[5];
        for (int numFeatures = 0; numFeatures < 1; ++numFeatures) {
            firstArray[0] = new Coordinate(0.0, 0.0);
            firstArray[1] = new Coordinate(1.0, 0.0);
            firstArray[2] = new Coordinate(1.0, 1.0);
            firstArray[3] = new Coordinate(0.0, 1.0);
            firstArray[4] = new Coordinate(0.0, 0.0);
            LinearRing shell = gf.createLinearRing(firstArray);
            b.add((Object)gf.createPolygon(shell, null));
            b.add((Object)0);
            secondFeatures.add(b.buildFeature("" + numFeatures));
        }
        Coordinate centre = ((Polygon)((SimpleFeature)secondFeatures.features().next()).getDefaultGeometry()).getCentroid().getCoordinate();
        Point p = gf.createPoint(centre);
        b.add((Object)p);
        b.add((Object)0);
        features.add(b.buildFeature("0"));
        InclusionFeatureCollection process = new InclusionFeatureCollection();
        SimpleFeatureCollection output = process.execute((SimpleFeatureCollection)features, (SimpleFeatureCollection)secondFeatures);
        Assert.assertEquals((long)1L, (long)output.size());
        try (SimpleFeatureIterator iterator = output.features();){
            Geometry expected = (Geometry)((SimpleFeature)features.features().next()).getDefaultGeometry();
            SimpleFeature sf = (SimpleFeature)iterator.next();
            Assert.assertTrue((boolean)expected.equals((Geometry)sf.getDefaultGeometry()));
        }
    }
}

