/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wps.gs;

import java.util.List;
import org.geoserver.wps.gs.BaseRasterToVectorTest;
import org.geotools.api.coverage.grid.GridCoverage;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.util.ProgressListener;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.data.util.NullProgressListener;
import org.geotools.process.raster.PolygonExtractionProcess;
import org.geotools.util.factory.GeoTools;
import org.jaitools.numeric.Range;
import org.junit.Assert;
import org.junit.Test;

public class PolygonExtractionProcessTest
extends BaseRasterToVectorTest {
    @Test
    public void testProcessStandaloneBasic() throws Exception {
        GridCoverage2D gc = (GridCoverage2D)this.getCatalog().getCoverageByName(DEM.getLocalPart()).getGridCoverage(null, GeoTools.getDefaultHints());
        this.scheduleForDisposal((GridCoverage)gc);
        PolygonExtractionProcess process = new PolygonExtractionProcess();
        SimpleFeatureCollection fc = process.execute(gc, Integer.valueOf(0), Boolean.valueOf(true), null, null, List.of(new Range((Number)0.0, true, (Number)1000.0, false), new Range((Number)1000.0, true, (Number)2000.0, false)), (ProgressListener)new NullProgressListener());
        Assert.assertNotNull((Object)fc);
        Assert.assertTrue((fc.size() > 0 ? 1 : 0) != 0);
        try (SimpleFeatureIterator fi = fc.features();){
            while (fi.hasNext()) {
                SimpleFeature sf = (SimpleFeature)fi.next();
                Double value = (Double)sf.getAttribute("value");
                Assert.assertTrue((value > 0.0 && value < 8.0 ? 1 : 0) != 0);
            }
        }
    }
}

