/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wps.gs;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import net.opengis.wfs.FeatureCollectionType;
import org.geoserver.wps.WPSTestSupport;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.feature.FeatureCollection;
import org.geotools.wfs.v1_0.WFSConfiguration_1_0;
import org.geotools.xsd.Configuration;
import org.geotools.xsd.Parser;
import org.junit.Assert;
import org.junit.Test;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.springframework.mock.web.MockHttpServletResponse;

public class SimplifyProcessTest
extends WPSTestSupport {
    @Test
    public void testSimplify() throws Exception {
        String xml = "<wps:Execute service='WPS' version='1.0.0' xmlns:wps='http://www.opengis.net/wps/1.0.0' xmlns:ows='http://www.opengis.net/ows/1.1'><ows:Identifier>gs:Simplify</ows:Identifier><wps:DataInputs><wps:Input><ows:Identifier>features</ows:Identifier><wps:Data><wps:ComplexData>" + this.readFileIntoString("illinois.xml") + "</wps:ComplexData></wps:Data></wps:Input><wps:Input><ows:Identifier>distance</ows:Identifier><wps:Data><wps:LiteralData>10</wps:LiteralData></wps:Data></wps:Input><wps:Input><ows:Identifier>preserveTopology</ows:Identifier><wps:Data><wps:LiteralData>true</wps:LiteralData></wps:Data></wps:Input></wps:DataInputs><wps:ResponseForm><wps:RawDataOutput><ows:Identifier>result</ows:Identifier></wps:RawDataOutput></wps:ResponseForm></wps:Execute>";
        MockHttpServletResponse response = this.postAsServletResponse(this.root(), xml);
        Parser p = new Parser((Configuration)new WFSConfiguration_1_0());
        FeatureCollectionType fct = (FeatureCollectionType)p.parse((InputStream)new ByteArrayInputStream(response.getContentAsString().getBytes()));
        FeatureCollection fc = (FeatureCollection)fct.getFeature().get(0);
        Assert.assertEquals((long)1L, (long)fc.size());
        SimpleFeature sf = (SimpleFeature)fc.features().next();
        Geometry simplified = (Geometry)sf.getDefaultGeometry();
        Assert.assertTrue((boolean)new Envelope(-92.0, -87.0, 37.0, 43.0).contains(simplified.getEnvelopeInternal()));
        Assert.assertEquals((long)4L, (long)simplified.getNumPoints());
    }
}

