/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wps.gs;

import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.custommonkey.xmlunit.XMLAssert;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CatalogBuilder;
import org.geoserver.catalog.DataStoreInfo;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.StoreInfo;
import org.geoserver.data.test.MockData;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.logging.TestAppender;
import org.geoserver.wps.WPSTestSupport;
import org.geotools.api.data.DataStore;
import org.geotools.api.data.FeatureSource;
import org.geotools.api.data.SimpleFeatureSource;
import org.geotools.api.data.SimpleFeatureStore;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.feature.type.FeatureType;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.jdbc.JDBCDataStore;
import org.geotools.util.logging.Logging;
import org.junit.Test;
import org.w3c.dom.Document;

public class UniqueProcessTest
extends WPSTestSupport {
    @Override
    protected void onSetUp(SystemTestData testData) throws Exception {
        super.onSetUp(testData);
        Catalog cat = this.getCatalog();
        DataStoreInfo ds = cat.getFactory().createDataStore();
        ds.setName("h2");
        ds.setWorkspace(cat.getDefaultWorkspace());
        ds.setEnabled(true);
        Map params = ds.getConnectionParameters();
        params.put("dbtype", "h2");
        params.put("database", ((SystemTestData)this.getTestData()).getDataDirectoryRoot().getAbsolutePath() + "/h2");
        cat.add((StoreInfo)ds);
        SimpleFeatureSource fs3 = this.getFeatureSource(SystemTestData.PRIMITIVEGEOFEATURE);
        DataStore store = (DataStore)ds.getDataStore(null);
        SimpleFeatureTypeBuilder tb = new SimpleFeatureTypeBuilder();
        tb.init((SimpleFeatureType)fs3.getSchema());
        tb.remove("surfaceProperty");
        tb.remove("curveProperty");
        tb.remove("uriProperty");
        store.createSchema((FeatureType)tb.buildFeatureType());
        SimpleFeatureStore targetFeatureStore = (SimpleFeatureStore)store.getFeatureSource(SystemTestData.PRIMITIVEGEOFEATURE.getLocalPart());
        targetFeatureStore.addFeatures((FeatureCollection)fs3.getFeatures());
        CatalogBuilder cb = new CatalogBuilder(cat);
        cb.setStore((StoreInfo)ds);
        FeatureTypeInfo ft = cb.buildFeatureType((FeatureSource)targetFeatureStore);
        cat.add((ResourceInfo)ft);
    }

    @Test
    public void testUnique() throws Exception {
        String xml = this.getUniqueRequest(this.getLayerId(MockData.PRIMITIVEGEOFEATURE));
        Document doc = this.postAsDOM(this.root(), xml);
        XMLAssert.assertXpathEvaluatesTo((String)"5", (String)"count(//gml:value)", (Document)doc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUniqueDatabaseDelegation() throws Exception {
        Logger logger = Logging.getLogger(JDBCDataStore.class);
        Level previousLevel = logger.getLevel();
        logger.info("hello world");
        try (TestAppender appender = TestAppender.createAppender((String)"testAutoCodeLogsErrors", null);){
            appender.startRecording("org.geotools.jdbc");
            logger.setLevel(Level.FINE);
            logger.fine("this is fine");
            String xml = this.getUniqueRequest("gs:PrimitiveGeoFeature");
            Document doc = this.postAsDOM(this.root(), xml);
            XMLAssert.assertXpathEvaluatesTo((String)"5", (String)"count(//gml:value)", (Document)doc);
            appender.assertTrue("Function has not been delegated to database, could not find select distinct in the logs", "SELECT distinct(\"intProperty\")");
            appender.stopRecording("org.geotools.jdbc");
        }
        finally {
            logger.setLevel(previousLevel);
        }
    }

    public String getUniqueRequest(String layerId) {
        return "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<wps:Execute version=\"1.0.0\" service=\"WPS\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns=\"http://www.opengis.net/wps/1.0.0\" xmlns:wfs=\"http://www.opengis.net/wfs\" xmlns:wps=\"http://www.opengis.net/wps/1.0.0\" xmlns:ows=\"http://www.opengis.net/ows/1.1\" xmlns:gml=\"http://www.opengis.net/gml\" xmlns:ogc=\"http://www.opengis.net/ogc\" xmlns:wcs=\"http://www.opengis.net/wcs/1.1.1\" xmlns:xlink=\"http://www.w3.org/1999/xlink\" xsi:schemaLocation=\"http://www.opengis.net/wps/1.0.0 http://schemas.opengis.net/wps/1.0.0/wpsAll.xsd\">\n  <ows:Identifier>gs:Unique</ows:Identifier>\n  <wps:DataInputs>\n    <wps:Input>\n      <ows:Identifier>features</ows:Identifier>\n      <wps:Reference mimeType=\"text/xml; subtype=wfs-collection/1.0\" xlink:href=\"http://geoserver/wfs\" method=\"POST\">\n        <wps:Body>\n          <wfs:GetFeature service=\"WFS\" version=\"1.0.0\" outputFormat=\"GML2\">\n            <wfs:Query typeName=\"" + layerId + "\"/>\n          </wfs:GetFeature>\n        </wps:Body>\n      </wps:Reference>\n    </wps:Input>\n    <wps:Input>\n      <ows:Identifier>attribute</ows:Identifier>\n      <wps:Data>\n        <wps:LiteralData>intProperty</wps:LiteralData>\n      </wps:Data>\n    </wps:Input>\n  </wps:DataInputs>\n  <wps:ResponseForm>\n    <wps:RawDataOutput>\n      <ows:Identifier>result</ows:Identifier>\n    </wps:RawDataOutput>\n  </wps:ResponseForm>\n</wps:Execute>";
    }
}

