/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wps.jts;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.geoserver.wps.WPSTestSupport;
import org.geoserver.wps.process.GeoServerProcessors;
import org.geotools.api.data.Parameter;
import org.geotools.api.feature.type.Name;
import org.geotools.api.util.InternationalString;
import org.geotools.data.collection.ListFeatureCollection;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.NameImpl;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.process.Process;
import org.geotools.process.ProcessException;
import org.geotools.process.ProcessFactory;
import org.geotools.process.factory.AnnotatedBeanProcessFactory;
import org.geotools.process.vector.BoundsProcess;
import org.geotools.process.vector.NearestProcess;
import org.geotools.process.vector.SnapProcess;
import org.geotools.util.SimpleInternationalString;
import org.geotools.util.factory.FactoryIteratorProvider;
import org.geotools.util.factory.GeoTools;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class BeanProcessFactoryTest
extends WPSTestSupport {
    BeanProcessFactory factory;

    @Before
    public void setUp() throws Exception {
        this.factory = new BeanProcessFactory();
        GeoTools.addFactoryIteratorProvider((FactoryIteratorProvider)new FactoryIteratorProvider(){

            public <T> Iterator<T> iterator(Class<T> category) {
                if (ProcessFactory.class.isAssignableFrom(category)) {
                    return Collections.singletonList(BeanProcessFactoryTest.this.factory).iterator();
                }
                return null;
            }
        });
    }

    @Test
    public void testNames() {
        Set names = this.factory.getNames();
        Assert.assertFalse((boolean)names.isEmpty());
        Assert.assertTrue((boolean)names.contains(new NameImpl("bean", "Bounds")));
    }

    @Test
    public void testDescribeBounds() {
        NameImpl boundsName = new NameImpl("bean", "Bounds");
        InternationalString desc = this.factory.getDescription((Name)boundsName);
        Assert.assertNotNull((Object)desc);
        Map params = this.factory.getParameterInfo((Name)boundsName);
        Assert.assertEquals((long)1L, (long)params.size());
        Parameter features = (Parameter)params.get("features");
        Assert.assertEquals(FeatureCollection.class, (Object)features.type);
        Assert.assertTrue((boolean)features.required);
        Map result = this.factory.getResultInfo((Name)boundsName, null);
        Assert.assertEquals((long)1L, (long)result.size());
        Parameter bounds = (Parameter)result.get("bounds");
        Assert.assertEquals(ReferencedEnvelope.class, (Object)bounds.type);
    }

    @Test
    public void testExecuteBounds() throws ProcessException {
        SimpleFeatureTypeBuilder tb = new SimpleFeatureTypeBuilder();
        tb.setName("test");
        final ReferencedEnvelope re = new ReferencedEnvelope(-10.0, 10.0, -10.0, 10.0, null);
        ListFeatureCollection fc = new ListFeatureCollection(tb.buildFeatureType()){

            public synchronized ReferencedEnvelope getBounds() {
                return re;
            }
        };
        Process p = this.factory.create((Name)new NameImpl("bean", "Bounds"));
        HashMap<String, 2> inputs = new HashMap<String, 2>();
        inputs.put("features", fc);
        Map result = p.execute(inputs, null);
        Assert.assertEquals((long)1L, (long)result.size());
        ReferencedEnvelope computed = (ReferencedEnvelope)result.get("bounds");
        Assert.assertEquals((Object)re, (Object)computed);
    }

    @Test
    public void testSPI() throws Exception {
        NameImpl boundsName = new NameImpl("bean", "Bounds");
        ProcessFactory factory = GeoServerProcessors.createProcessFactory((Name)boundsName, (boolean)false);
        Assert.assertNotNull((Object)factory);
        Process buffer = GeoServerProcessors.createProcess((Name)boundsName);
        Assert.assertNotNull((Object)buffer);
    }

    public class BeanProcessFactory
    extends AnnotatedBeanProcessFactory {
        public BeanProcessFactory() {
            super((InternationalString)new SimpleInternationalString("Some bean based processes custom processes"), "bean", new Class[]{BoundsProcess.class, NearestProcess.class, SnapProcess.class});
        }
    }
}

