/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wps.ppio;

import java.util.Collections;
import java.util.List;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.platform.GeoServerExtensionsHelper;
import org.geoserver.wps.ppio.PPIOFactory;
import org.geoserver.wps.ppio.ProcessParameterIO;
import org.geotools.api.data.Parameter;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.GenericApplicationContext;

public class ProcessParameterIOTest {
    private static ProcessParameterIO testPPIO = new ProcessParameterIO(TestType.class, TestType.class, "testPPIO"){};
    private static GenericApplicationContext context = new GenericApplicationContext();

    @BeforeClass
    public static void initAppContext() {
        PPIOFactory testPPIOFactory = () -> Collections.singletonList(testPPIO);
        context.getBeanFactory().registerSingleton("testPPIOFactory", (Object)testPPIOFactory);
        context.refresh();
        new GeoServerExtensions().setApplicationContext((ApplicationContext)context);
    }

    @AfterClass
    public static void destroyAppContext() {
        GeoServerExtensionsHelper.init(null);
    }

    @Test
    public void testFindAllWithNullContext() {
        List matches = ProcessParameterIO.findAll((Parameter)new Parameter("testPPIO", TestType.class), null);
        Assert.assertEquals((long)1L, (long)matches.size());
        Assert.assertSame((Object)testPPIO, matches.get(0));
    }

    @Test
    public void testFindAllWithSameContext() {
        List matches = ProcessParameterIO.findAll((Parameter)new Parameter("testPPIO", TestType.class), (ApplicationContext)context);
        Assert.assertEquals((long)1L, (long)matches.size());
        Assert.assertSame((Object)testPPIO, matches.get(0));
    }

    @Test
    public void testFindAllWithDifferentContext() {
        try (GenericApplicationContext myContext = new GenericApplicationContext();){
            myContext.refresh();
            List matches = ProcessParameterIO.findAll((Parameter)new Parameter("testPPIO", TestType.class), (ApplicationContext)myContext);
            Assert.assertEquals((long)0L, (long)matches.size());
        }
    }

    public static class TestType {
    }
}

