/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wps.process;

import org.custommonkey.xmlunit.XMLAssert;
import org.geoserver.data.test.MockData;
import org.geoserver.wps.WPSTestSupport;
import org.junit.Assert;
import org.junit.Test;
import org.w3c.dom.Document;

public abstract class AbstractProcessFilterTest
extends WPSTestSupport {
    @Test
    public void testCapabilitesFiltering() throws Exception {
        Document d = this.getAsDOM("wps?service=wps&request=getcapabilities");
        XMLAssert.assertXpathEvaluatesTo((String)"0", (String)"count(//wps:Process[ows:Identifier = 'gs:Unique'])", (Document)d);
        XMLAssert.assertXpathEvaluatesTo((String)"0", (String)"count(//wps:Process[ows:Identifier = 'JTS:intersects'])", (Document)d);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//wps:Process[ows:Identifier = 'JTS:buffer'])", (Document)d);
    }

    @Test
    public void testDescribeProcessFiltering() throws Exception {
        Document d = this.getAsDOM(this.root() + "service=wps&request=describeprocess&identifier=JTS:buffer");
        XMLAssert.assertXpathExists((String)"/wps:ProcessDescriptions", (Document)d);
        d = this.getAsDOM(this.root() + "service=wps&request=describeprocess&identifier=JTS:intersection");
        this.checkOws11Exception(d);
        XMLAssert.assertXpathEvaluatesTo((String)"No such process: JTS:intersection", (String)"//ows:ExceptionText", (Document)d);
        d = this.getAsDOM(this.root() + "service=wps&request=describeprocess&identifier=gs:Unique");
        this.checkOws11Exception(d);
        XMLAssert.assertXpathEvaluatesTo((String)"No such process: gs:Unique", (String)"//ows:ExceptionText", (Document)d);
    }

    @Test
    public void testExecuteFilteringAllow() throws Exception {
        String xml = "<wps:Execute service='WPS' version='1.0.0' xmlns:wps='http://www.opengis.net/wps/1.0.0' xmlns:ows='http://www.opengis.net/ows/1.1'><ows:Identifier>JTS:buffer</ows:Identifier><wps:DataInputs><wps:Input><ows:Identifier>distance</ows:Identifier><wps:Data><wps:LiteralData>1</wps:LiteralData></wps:Data></wps:Input><wps:Input><ows:Identifier>geom</ows:Identifier><wps:Data><wps:ComplexData><gml:Polygon xmlns:gml='http://www.opengis.net/gml'><gml:exterior><gml:LinearRing><gml:coordinates>1 1 2 1 2 2 1 2 1 1</gml:coordinates></gml:LinearRing></gml:exterior></gml:Polygon></wps:ComplexData></wps:Data></wps:Input></wps:DataInputs><wps:ResponseForm><wps:ResponseDocument storeExecuteResponse='false'><wps:Output><ows:Identifier>result</ows:Identifier></wps:Output></wps:ResponseDocument></wps:ResponseForm></wps:Execute>";
        Document d = this.postAsDOM("wps", xml);
        this.checkValidationErrors(d);
        Assert.assertEquals((Object)"wps:ExecuteResponse", (Object)d.getDocumentElement().getNodeName());
        XMLAssert.assertXpathExists((String)"/wps:ExecuteResponse/wps:Status/wps:ProcessSucceeded", (Document)d);
        XMLAssert.assertXpathExists((String)"/wps:ExecuteResponse/wps:ProcessOutputs/wps:Output/wps:Data/wps:ComplexData/gml:Polygon", (Document)d);
    }

    @Test
    public void testExecuteFilteringDeny() throws Exception {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<wps:Execute version=\"1.0.0\" service=\"WPS\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns=\"http://www.opengis.net/wps/1.0.0\" xmlns:wfs=\"http://www.opengis.net/wfs\" xmlns:wps=\"http://www.opengis.net/wps/1.0.0\" xmlns:ows=\"http://www.opengis.net/ows/1.1\" xmlns:gml=\"http://www.opengis.net/gml\" xmlns:ogc=\"http://www.opengis.net/ogc\" xmlns:wcs=\"http://www.opengis.net/wcs/1.1.1\" xmlns:xlink=\"http://www.w3.org/1999/xlink\" xsi:schemaLocation=\"http://www.opengis.net/wps/1.0.0 http://schemas.opengis.net/wps/1.0.0/wpsAll.xsd\">\n  <ows:Identifier>gs:Unique</ows:Identifier>\n  <wps:DataInputs>\n    <wps:Input>\n      <ows:Identifier>features</ows:Identifier>\n      <wps:Reference mimeType=\"text/xml; subtype=wfs-collection/1.0\" xlink:href=\"http://geoserver/wfs\" method=\"POST\">\n        <wps:Body>\n          <wfs:GetFeature service=\"WFS\" version=\"1.0.0\" outputFormat=\"GML2\">\n            <wfs:Query typeName=\"" + this.getLayerId(MockData.PRIMITIVEGEOFEATURE) + "\"/>\n          </wfs:GetFeature>\n        </wps:Body>\n      </wps:Reference>\n    </wps:Input>\n    <wps:Input>\n      <ows:Identifier>attribute</ows:Identifier>\n      <wps:Data>\n        <wps:LiteralData>intProperty</wps:LiteralData>\n      </wps:Data>\n    </wps:Input>\n  </wps:DataInputs>\n  <wps:ResponseForm>\n    <wps:RawDataOutput>\n      <ows:Identifier>result</ows:Identifier>\n    </wps:RawDataOutput>\n  </wps:ResponseForm>\n</wps:Execute>";
        Document doc = this.postAsDOM(this.root(), xml);
        this.checkOws11Exception(doc);
        XMLAssert.assertXpathEvaluatesTo((String)"Unknown process gs:Unique", (String)"//ows:ExceptionText", (Document)doc);
    }
}

