/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wps.resource;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.easymock.EasyMock;
import org.geoserver.wcs.CoverageCleanerCallback;
import org.geoserver.wps.ProcessEvent;
import org.geoserver.wps.ProcessListener;
import org.geoserver.wps.executor.ExecutionStatus;
import org.geoserver.wps.executor.ProcessState;
import org.geoserver.wps.resource.CoverageResourceListener;
import org.geoserver.wps.resource.WPSResource;
import org.geoserver.wps.resource.WPSResourceManager;
import org.geotools.api.feature.type.Name;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.feature.NameImpl;
import org.junit.Before;
import org.junit.Test;

public class CoverageResourceListenerTest {
    private WPSResourceManager resourceManager;
    private ProcessListener listener;
    private ExecutionStatus status;
    private Map<String, Object> inputs;

    @Before
    public void setUp() {
        this.resourceManager = (WPSResourceManager)EasyMock.createMock(WPSResourceManager.class);
        this.listener = new CoverageResourceListener(this.resourceManager, new CoverageCleanerCallback());
        this.status = new ExecutionStatus((Name)new NameImpl("gs", "TestProcess"), UUID.randomUUID().toString(), false);
        this.status.setPhase(ProcessState.RUNNING);
        this.inputs = new HashMap<String, Object>();
        this.inputs.put("coverageA", null);
        this.inputs.put("coverageB", null);
        this.inputs.put("string", null);
        this.inputs.put("integer", null);
    }

    @Test
    public void testCheckInputWhenSucceeded() {
        this.resourceManager.addResource((WPSResource)EasyMock.anyObject());
        EasyMock.expectLastCall().times(2);
        EasyMock.replay((Object[])new Object[]{this.resourceManager});
        this.listener.progress(new ProcessEvent(this.status, this.inputs));
        this.inputs.put("coverageA", EasyMock.createMock(GridCoverage2D.class));
        this.listener.progress(new ProcessEvent(this.status, this.inputs));
        this.inputs.put("coverageB", EasyMock.createMock(GridCoverage2D.class));
        this.listener.progress(new ProcessEvent(this.status, this.inputs));
        this.inputs.put("string", "testString");
        this.listener.progress(new ProcessEvent(this.status, this.inputs));
        this.inputs.put("integer", 1);
        this.listener.progress(new ProcessEvent(this.status, this.inputs));
        this.listener.progress(new ProcessEvent(this.status, this.inputs));
        this.status.setPhase(ProcessState.SUCCEEDED);
        this.listener.succeeded(new ProcessEvent(this.status, this.inputs));
        EasyMock.verify((Object[])new Object[]{this.resourceManager});
    }

    @Test
    public void testCheckInputWhenFailed() {
        this.resourceManager.addResource((WPSResource)EasyMock.anyObject());
        EasyMock.expectLastCall().once();
        EasyMock.replay((Object[])new Object[]{this.resourceManager});
        this.listener.progress(new ProcessEvent(this.status, this.inputs));
        this.inputs.put("coverageA", EasyMock.createMock(GridCoverage2D.class));
        this.listener.progress(new ProcessEvent(this.status, this.inputs));
        this.status.setPhase(ProcessState.FAILED);
        this.listener.failed(new ProcessEvent(this.status, this.inputs));
        EasyMock.verify((Object[])new Object[]{this.resourceManager});
    }
}

