/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wps;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.opengis.wps10.ComplexDataType;
import net.opengis.wps10.DataType;
import net.opengis.wps10.InputReferenceType;
import net.opengis.wps10.InputType;
import net.opengis.wps10.LiteralDataType;
import org.geoserver.wps.WPSException;
import org.geoserver.wps.transmute.ComplexTransmuter;
import org.geoserver.wps.transmute.DoubleTransmuter;
import org.geoserver.wps.transmute.GML2LineStringTransmuter;
import org.geoserver.wps.transmute.GML2LinearRingTransmuter;
import org.geoserver.wps.transmute.GML2MultiLineStringTransmuter;
import org.geoserver.wps.transmute.GML2MultiPointTransmuter;
import org.geoserver.wps.transmute.GML2MultiPolygonTransmuter;
import org.geoserver.wps.transmute.GML2PointTransmuter;
import org.geoserver.wps.transmute.GML2PolygonTransmuter;
import org.geoserver.wps.transmute.LiteralTransmuter;
import org.geoserver.wps.transmute.Transmuter;
import org.geotools.api.data.Parameter;
import org.geotools.api.feature.type.Name;
import org.geotools.process.ProcessFactory;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;

public class DataTransformer {
    private List<Transmuter> transmuters = new ArrayList<Transmuter>();
    private Map<Class<?>, Transmuter> defaultTransmuters = new HashMap();
    private Map<String, Parameter<?>> inputParameters;
    private String urlBase = null;

    public DataTransformer(String urlBase) {
        this.urlBase = urlBase;
        this.defaultTransmuters.put(Double.class, new DoubleTransmuter());
        this.defaultTransmuters.put(MultiPolygon.class, new GML2MultiPolygonTransmuter());
        this.defaultTransmuters.put(Polygon.class, new GML2PolygonTransmuter());
        this.defaultTransmuters.put(Geometry.class, new GML2PolygonTransmuter());
        this.defaultTransmuters.put(MultiPoint.class, new GML2MultiPointTransmuter());
        this.defaultTransmuters.put(Point.class, new GML2PointTransmuter());
        this.defaultTransmuters.put(LinearRing.class, new GML2LinearRingTransmuter());
        this.defaultTransmuters.put(LineString.class, new GML2LineStringTransmuter());
        this.defaultTransmuters.put(MultiLineString.class, new GML2MultiLineStringTransmuter());
        this.transmuters.addAll(this.defaultTransmuters.values());
    }

    public Map<String, Object> decodeInputs(List<InputType> inputs, Map<String, Parameter<?>> parameters) {
        HashMap<String, Object> inputMap = new HashMap<String, Object>();
        this.inputParameters = parameters;
        for (InputType input : inputs) {
            String identifier = input.getIdentifier().getValue();
            Object decoded = null;
            if (null != input.getData()) {
                decoded = this.decodeInputData(input);
            }
            if (null != input.getReference()) {
                decoded = this.decodeReferenceData(identifier, input.getReference());
            }
            if (inputMap.containsKey(identifier)) {
                List<Object> list;
                if (inputMap.get(identifier) instanceof List) {
                    list = (List)inputMap.get(identifier);
                    list.add(decoded);
                    continue;
                }
                list = new ArrayList();
                list.add(inputMap.get(identifier));
                inputMap.put(identifier, list);
                continue;
            }
            inputMap.put(identifier, decoded);
        }
        return inputMap;
    }

    private Object decodeReferenceData(String identifier, InputReferenceType reference) {
        Object data = null;
        URL url = null;
        Parameter<?> param = this.inputParameters.get(identifier);
        ComplexTransmuter transmuter = (ComplexTransmuter)this.getDefaultTransmuter(param.type);
        try {
            url = new URL(reference.getHref());
        }
        catch (MalformedURLException e) {
            throw new WPSException("NoApplicableCode", "Malformed parameter URL.");
        }
        try {
            data = transmuter.decode(url.openStream());
        }
        catch (IOException e) {
            throw new WPSException("NoApplicableCode", "IOException.");
        }
        return data;
    }

    private Object decodeInputData(InputType input) {
        Object output = null;
        DataType data = input.getData();
        String parameterName = input.getIdentifier().getValue();
        Parameter<?> parameter = this.inputParameters.get(parameterName);
        try {
            if (null != data.getLiteralData()) {
                output = this.decodeLiteralData(data.getLiteralData(), parameter.type);
            }
            if (null != data.getComplexData()) {
                output = this.decodeComplexData(data.getComplexData(), parameter.type);
            }
        }
        catch (Exception e) {
            throw new WPSException("InvalidParameterValue", parameterName);
        }
        if (null != data.getBoundingBoxData()) {
            throw new WPSException("NoApplicableCode", "Unimplemented");
        }
        return output;
    }

    private Object decodeComplexData(ComplexDataType input, Class<?> type) {
        Object data = input.getData().get(0);
        return data;
    }

    private Object decodeLiteralData(LiteralDataType input, Class<?> type) {
        LiteralTransmuter transmuter = (LiteralTransmuter)this.getDefaultTransmuter(type);
        Object data = transmuter.decode(input.getValue());
        return data;
    }

    public ComplexTransmuter getComplexTransmuter(Class<?> type, String schema) {
        for (Transmuter transmuter : this.transmuters) {
            if (!(transmuter instanceof ComplexTransmuter) || !((ComplexTransmuter)transmuter).getSchema(this.urlBase).equalsIgnoreCase(schema) || type != transmuter.getType()) continue;
            return (ComplexTransmuter)transmuter;
        }
        throw new WPSException("NoApplicableCode", "Could not find ComplexTransmuter for '" + schema + "'.");
    }

    public Transmuter getDefaultTransmuter(Class<?> type) {
        Transmuter transmuter = this.defaultTransmuters.get(type);
        if (null == transmuter) {
            throw new WPSException("NoApplicableCode", "No default transmuter registered for type " + type.toString() + "'.");
        }
        return transmuter;
    }

    public boolean isTransmutable(ProcessFactory pf, Name name) {
        for (Parameter param : pf.getParameterInfo(name).values()) {
            try {
                this.getDefaultTransmuter(param.type);
            }
            catch (Exception e) {
                return false;
            }
        }
        for (Parameter param : pf.getResultInfo(name, null).values()) {
            try {
                this.getDefaultTransmuter(param.type);
            }
            catch (Exception e) {
                return false;
            }
        }
        return true;
    }
}

