/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wps;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.opengis.wps10.DescribeProcessType;
import net.opengis.wps10.ExecuteResponseType;
import net.opengis.wps10.ExecuteType;
import net.opengis.wps10.GetCapabilitiesType;
import net.opengis.wps10.ProcessDescriptionsType;
import net.opengis.wps10.WPSCapabilitiesType;
import org.geoserver.config.GeoServer;
import org.geoserver.platform.resource.Resource;
import org.geoserver.wps.DescribeProcess;
import org.geoserver.wps.Dismiss;
import org.geoserver.wps.DismissType;
import org.geoserver.wps.Execute;
import org.geoserver.wps.Executions;
import org.geoserver.wps.GetCapabilities;
import org.geoserver.wps.GetExecutionResultType;
import org.geoserver.wps.GetExecutionStatusType;
import org.geoserver.wps.GetExecutionsType;
import org.geoserver.wps.GetResult;
import org.geoserver.wps.GetSchema;
import org.geoserver.wps.GetStatus;
import org.geoserver.wps.WPSException;
import org.geoserver.wps.WPSInfo;
import org.geoserver.wps.WebProcessingService;
import org.geoserver.wps.executor.ProcessStatusTracker;
import org.geoserver.wps.executor.WPSExecutionManager;
import org.geoserver.wps.resource.WPSResourceManager;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class DefaultWebProcessingService
implements WebProcessingService,
ApplicationContextAware {
    protected GeoServer gs;
    protected ApplicationContext context;
    protected WPSExecutionManager executionManager;
    protected WPSResourceManager resources;
    private ProcessStatusTracker tracker;

    public DefaultWebProcessingService(GeoServer gs, WPSExecutionManager executionManager, WPSResourceManager resources, ProcessStatusTracker tracker) {
        this.gs = gs;
        this.executionManager = executionManager;
        this.resources = resources;
        this.tracker = tracker;
    }

    @Override
    public WPSInfo getServiceInfo() {
        return (WPSInfo)this.gs.getService(WPSInfo.class);
    }

    @Override
    public WPSCapabilitiesType getCapabilities(GetCapabilitiesType request) throws WPSException {
        return new GetCapabilities(this.getServiceInfo(), this.context).run(request);
    }

    @Override
    public ProcessDescriptionsType describeProcess(DescribeProcessType request) throws WPSException {
        return new DescribeProcess(this.getServiceInfo(), this.context).run(request);
    }

    @Override
    public ExecuteResponseType execute(ExecuteType request) throws WPSException {
        return new Execute(this.executionManager, this.context).run(request);
    }

    @Override
    public void getSchema(HttpServletRequest request, HttpServletResponse response) throws WPSException {
        new GetSchema(this.getServiceInfo()).run(request, response);
    }

    public void setApplicationContext(ApplicationContext context) throws BeansException {
        this.context = context;
    }

    @Override
    public Object getExecutionStatus(GetExecutionStatusType request) throws WPSException {
        return new GetStatus(this.tracker, this.resources, this.context).run(request);
    }

    @Override
    public Resource getExecutionResult(GetExecutionResultType request) throws WPSException {
        return new GetResult(this.resources).run(request);
    }

    @Override
    public ExecuteResponseType dismiss(DismissType request) throws WPSException {
        return new Dismiss(this.executionManager, this.tracker, this.resources, this.context).run(request);
    }

    @Override
    public Object getExecutions(GetExecutionsType request) throws WPSException {
        return new Executions(this.gs, this.tracker, this.resources, this.context).run(request);
    }
}

