/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wps;

import java.math.BigInteger;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.opengis.ows11.AllowedValuesType;
import net.opengis.ows11.CodeType;
import net.opengis.ows11.Ows11Factory;
import net.opengis.ows11.RangeClosureType;
import net.opengis.ows11.RangeType;
import net.opengis.ows11.ValueType;
import net.opengis.wps10.CRSsType;
import net.opengis.wps10.ComplexDataDescriptionType;
import net.opengis.wps10.DataInputsType;
import net.opengis.wps10.DefaultType;
import net.opengis.wps10.DescribeProcessType;
import net.opengis.wps10.InputDescriptionType;
import net.opengis.wps10.LiteralInputType;
import net.opengis.wps10.LiteralOutputType;
import net.opengis.wps10.OutputDescriptionType;
import net.opengis.wps10.ProcessDescriptionType;
import net.opengis.wps10.ProcessDescriptionsType;
import net.opengis.wps10.ProcessOutputsType;
import net.opengis.wps10.SupportedCRSsType;
import net.opengis.wps10.SupportedComplexDataInputType;
import net.opengis.wps10.SupportedComplexDataType;
import net.opengis.wps10.Wps10Factory;
import org.geoserver.ows.Ows11Util;
import org.geoserver.wfs.xml.XSProfile;
import org.geoserver.wps.WPSException;
import org.geoserver.wps.WPSInfo;
import org.geoserver.wps.ppio.BinaryPPIO;
import org.geoserver.wps.ppio.BoundingBoxPPIO;
import org.geoserver.wps.ppio.ComplexPPIO;
import org.geoserver.wps.ppio.LiteralPPIO;
import org.geoserver.wps.ppio.ProcessParameterIO;
import org.geoserver.wps.ppio.RawDataPPIO;
import org.geoserver.wps.process.AbstractRawData;
import org.geoserver.wps.process.GeoServerProcessors;
import org.geoserver.wps.validator.MaxSizeValidator;
import org.geotools.api.data.Parameter;
import org.geotools.api.feature.type.Name;
import org.geotools.api.util.InternationalString;
import org.geotools.process.ProcessFactory;
import org.geotools.util.logging.Logging;
import org.springframework.context.ApplicationContext;

public class DescribeProcess {
    static final Logger LOGGER = Logging.getLogger(DescribeProcess.class);
    WPSInfo wps;
    ApplicationContext context;
    Locale locale;
    XSProfile xsp;
    Wps10Factory wpsf = Wps10Factory.eINSTANCE;
    Ows11Factory owsf = Ows11Factory.eINSTANCE;
    static final Map<Class<?>, Class<?>> PRIMITIVE_TO_WRAPPER = new HashMap();

    public DescribeProcess(WPSInfo wps, ApplicationContext context) {
        this.wps = wps;
        this.context = context;
        this.locale = Locale.getDefault();
        this.xsp = new XSProfile();
    }

    public ProcessDescriptionsType run(DescribeProcessType request) {
        ProcessDescriptionsType pds = this.wpsf.createProcessDescriptionsType();
        pds.setLang("en");
        for (Object o : request.getIdentifier()) {
            CodeType id = (CodeType)o;
            this.processDescription(id, pds);
        }
        return pds;
    }

    void processDescription(CodeType id, ProcessDescriptionsType pds) {
        Name name = Ows11Util.name((CodeType)id);
        ProcessFactory pf = GeoServerProcessors.createProcessFactory(name, true);
        if (pf == null || pf.create(name) == null) {
            throw new WPSException("No such process: " + id.getValue());
        }
        ProcessDescriptionType pd = this.wpsf.createProcessDescriptionType();
        pds.getProcessDescription().add((Object)pd);
        pd.setProcessVersion("1.0.0");
        pd.setIdentifier(Ows11Util.code((String)id.getValue()));
        pd.setTitle(Ows11Util.languageString((InternationalString)pf.getTitle(name)));
        pd.setAbstract(Ows11Util.languageString((InternationalString)pf.getDescription(name)));
        pd.setStatusSupported(true);
        pd.setStoreSupported(true);
        DataInputsType inputs = this.wpsf.createDataInputsType();
        pd.setDataInputs(inputs);
        this.dataInputs(inputs, pf, name);
        ProcessOutputsType outputs = this.wpsf.createProcessOutputsType();
        pd.setProcessOutputs(outputs);
        this.processOutputs(outputs, pf, name);
    }

    void dataInputs(DataInputsType inputs, ProcessFactory pf, Name name) {
        Collection<String> outputMimeParameters = AbstractRawData.getOutputMimeParameters(name, pf).values();
        for (Parameter p : pf.getParameterInfo(name).values()) {
            int maxSize;
            if (outputMimeParameters.contains(p.key)) continue;
            InputDescriptionType input = this.wpsf.createInputDescriptionType();
            inputs.getInput().add((Object)input);
            input.setIdentifier(Ows11Util.code((String)p.key));
            input.setTitle(Ows11Util.languageString((InternationalString)p.title));
            input.setAbstract(Ows11Util.languageString((InternationalString)p.description));
            input.setMaxOccurs(p.maxOccurs == -1 ? BigInteger.valueOf(Long.MAX_VALUE) : BigInteger.valueOf(p.maxOccurs));
            input.setMinOccurs(BigInteger.valueOf(p.minOccurs));
            List<ProcessParameterIO> ppios = ProcessParameterIO.findDecoder(p, this.context);
            if (ppios.isEmpty()) {
                throw new WPSException("Could not find process parameter for type " + p.key + "," + p.type);
            }
            if (ppios.get(0) instanceof LiteralPPIO) {
                LiteralPPIO lppio = (LiteralPPIO)ppios.get(0);
                LiteralInputType literal = this.wpsf.createLiteralInputType();
                input.setLiteralData(literal);
                if (!String.class.equals(lppio.getType())) {
                    Name typeName;
                    Class<?> type = lppio.getType();
                    if (PRIMITIVE_TO_WRAPPER.containsKey(type)) {
                        type = PRIMITIVE_TO_WRAPPER.get(type);
                    }
                    if ((typeName = this.xsp.name(type)) != null) {
                        literal.setDataType(Ows11Util.type((String)("xs:" + typeName.getLocalPart())));
                    }
                }
                if (p.metadata.get("options") != null) {
                    List options = (List)p.metadata.get("options");
                    Object[] optionsArray = options.toArray(new Object[options.size()]);
                    this.addAllowedValues(literal, optionsArray);
                } else if (lppio.getType().isEnum()) {
                    Object[] enumValues = lppio.getType().getEnumConstants();
                    this.addAllowedValues(literal, enumValues);
                } else {
                    Object min = p.metadata.get("min");
                    Object max = p.metadata.get("max");
                    this.addAllowedValues(literal, min, max);
                }
                try {
                    if (p.sample == null) continue;
                    literal.setDefaultValue(lppio.encode(p.sample));
                }
                catch (Exception e) {
                    LOGGER.log(Level.WARNING, "Failed to fill the default value for input " + p.key + " of process " + name, e);
                }
                continue;
            }
            if (ppios.get(0) instanceof BoundingBoxPPIO) {
                input.setBoundingBoxData(this.buildSupportedCRSType());
                continue;
            }
            SupportedComplexDataInputType complex = this.wpsf.createSupportedComplexDataInputType();
            input.setComplexData(complex);
            if (p.metadata.get(MaxSizeValidator.PARAMETER_KEY) instanceof Number && (maxSize = ((Number)p.metadata.get(MaxSizeValidator.PARAMETER_KEY)).intValue()) > 0) {
                complex.setMaximumMegabytes(BigInteger.valueOf(maxSize));
            }
            complex.setSupported(this.wpsf.createComplexDataCombinationsType());
            for (ProcessParameterIO ppio : ppios) {
                ComplexPPIO cppio = (ComplexPPIO)ppio;
                ComplexDataDescriptionType format = null;
                if (ppio instanceof RawDataPPIO) {
                    String[] mimeTypes;
                    for (String mimeType : mimeTypes = AbstractRawData.getMimeTypes(p)) {
                        ComplexDataDescriptionType ddt = this.wpsf.createComplexDataDescriptionType();
                        ddt.setMimeType(mimeType);
                        if (!(mimeType.contains("json") || mimeType.contains("text") || mimeType.contains("xml") || mimeType.contains("gml"))) {
                            ddt.setEncoding("base64");
                        }
                        complex.getSupported().getFormat().add((Object)ddt);
                        if (format != null) continue;
                        format = ddt;
                    }
                } else {
                    format = this.wpsf.createComplexDataDescriptionType();
                    format.setMimeType(cppio.getMimeType());
                    if (cppio instanceof BinaryPPIO) {
                        format.setEncoding("base64");
                    }
                    complex.getSupported().getFormat().add((Object)format);
                }
                if (complex.getDefault() != null) continue;
                ComplexDataDescriptionType def = this.wpsf.createComplexDataDescriptionType();
                def.setMimeType(format.getMimeType());
                complex.setDefault(this.wpsf.createComplexDataCombinationType());
                complex.getDefault().setFormat(def);
            }
        }
    }

    private void addAllowedValues(LiteralInputType literal, Object[] values) {
        AllowedValuesType allowed = this.owsf.createAllowedValuesType();
        for (Object value : values) {
            ValueType vt = this.owsf.createValueType();
            vt.setValue(value.toString());
            allowed.getValue().add((Object)vt);
        }
        literal.setAllowedValues(allowed);
    }

    private void addAllowedValues(LiteralInputType literal, Object min, Object max) {
        if (min == null && max == null) {
            literal.setAnyValue(this.owsf.createAnyValueType());
        } else {
            AllowedValuesType allowed = this.owsf.createAllowedValuesType();
            RangeType range = this.owsf.createRangeType();
            if (min != null) {
                ValueType minValue = this.owsf.createValueType();
                minValue.setValue(min.toString());
                range.setMinimumValue(minValue);
            }
            if (max != null) {
                ValueType maxValue = this.owsf.createValueType();
                maxValue.setValue(max.toString());
                range.setMaximumValue(maxValue);
            }
            RangeClosureType rangeClosure = min == null ? RangeClosureType.OPEN_CLOSED_LITERAL : (max == null ? RangeClosureType.CLOSED_OPEN_LITERAL : RangeClosureType.CLOSED_LITERAL);
            range.setRangeClosure(rangeClosure);
            allowed.getRange().add((Object)range);
            literal.setAllowedValues(allowed);
        }
    }

    private SupportedCRSsType buildSupportedCRSType() {
        SupportedCRSsType supportedCRS = this.wpsf.createSupportedCRSsType();
        DefaultType def = this.wpsf.createDefaultType();
        def.setCRS("EPSG:4326");
        supportedCRS.setDefault(def);
        CRSsType crss = this.wpsf.createCRSsType();
        crss.setCRS("EPSG:4326");
        supportedCRS.setSupported(crss);
        return supportedCRS;
    }

    void processOutputs(ProcessOutputsType outputs, ProcessFactory pf, Name name) {
        Map outs = pf.getResultInfo(name, null);
        for (Parameter p : outs.values()) {
            OutputDescriptionType output = this.wpsf.createOutputDescriptionType();
            outputs.getOutput().add((Object)output);
            output.setIdentifier(Ows11Util.code((String)p.key));
            output.setTitle(Ows11Util.languageString((InternationalString)p.title));
            List<ProcessParameterIO> ppios = ProcessParameterIO.findEncoder(p, this.context);
            if (ppios.isEmpty()) {
                throw new WPSException("Could not find process parameter for type " + p.key + "," + p.type);
            }
            if (ppios.get(0) instanceof LiteralPPIO) {
                Name typeName;
                LiteralPPIO lppio = (LiteralPPIO)ppios.get(0);
                LiteralOutputType literal = this.wpsf.createLiteralOutputType();
                output.setLiteralOutput(literal);
                if (String.class.equals(lppio.getType())) continue;
                Class<?> type = lppio.getType();
                if (PRIMITIVE_TO_WRAPPER.containsKey(type)) {
                    type = PRIMITIVE_TO_WRAPPER.get(type);
                }
                if ((typeName = this.xsp.name(type)) == null) continue;
                literal.setDataType(Ows11Util.type((String)typeName.getLocalPart()));
                continue;
            }
            if (ppios.get(0) instanceof BoundingBoxPPIO) {
                output.setBoundingBoxOutput(this.buildSupportedCRSType());
                continue;
            }
            SupportedComplexDataType complex = this.wpsf.createSupportedComplexDataType();
            output.setComplexOutput(complex);
            complex.setSupported(this.wpsf.createComplexDataCombinationsType());
            for (ProcessParameterIO ppio : ppios) {
                ComplexPPIO cppio = (ComplexPPIO)ppio;
                ComplexDataDescriptionType format = null;
                if (ppio instanceof RawDataPPIO) {
                    String[] mimeTypes;
                    for (String mimeType : mimeTypes = AbstractRawData.getMimeTypes(p)) {
                        ComplexDataDescriptionType ddt = this.wpsf.createComplexDataDescriptionType();
                        ddt.setMimeType(mimeType);
                        complex.getSupported().getFormat().add((Object)ddt);
                        if (format != null) continue;
                        format = ddt;
                    }
                } else {
                    format = this.wpsf.createComplexDataDescriptionType();
                    format.setMimeType(cppio.getMimeType());
                    complex.getSupported().getFormat().add((Object)format);
                }
                if (complex.getDefault() != null) continue;
                ComplexDataDescriptionType def = this.wpsf.createComplexDataDescriptionType();
                def.setMimeType(format.getMimeType());
                complex.setDefault(this.wpsf.createComplexDataCombinationType());
                complex.getDefault().setFormat(def);
            }
        }
    }

    static {
        PRIMITIVE_TO_WRAPPER.put(Byte.TYPE, Byte.class);
        PRIMITIVE_TO_WRAPPER.put(Short.TYPE, Short.class);
        PRIMITIVE_TO_WRAPPER.put(Integer.TYPE, Integer.class);
        PRIMITIVE_TO_WRAPPER.put(Long.TYPE, Long.class);
        PRIMITIVE_TO_WRAPPER.put(Float.TYPE, Float.class);
        PRIMITIVE_TO_WRAPPER.put(Double.TYPE, Double.class);
        PRIMITIVE_TO_WRAPPER.put(Boolean.TYPE, Boolean.class);
    }
}

