/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wps;

import java.util.Locale;
import net.opengis.ows11.CodeType;
import net.opengis.wps10.DescribeProcessType;
import org.geoserver.ows.Ows11Util;
import org.geoserver.wps.DataTransformer;
import org.geoserver.wps.WPSException;
import org.geoserver.wps.WPSInfo;
import org.geoserver.wps.process.GeoServerProcessors;
import org.geoserver.wps.transmute.ComplexTransmuter;
import org.geoserver.wps.transmute.LiteralTransmuter;
import org.geoserver.wps.transmute.Transmuter;
import org.geotools.api.data.Parameter;
import org.geotools.api.feature.type.Name;
import org.geotools.process.ProcessFactory;
import org.geotools.xml.transform.TransformerBase;
import org.geotools.xml.transform.Translator;
import org.xml.sax.ContentHandler;
import org.xml.sax.helpers.AttributesImpl;

public abstract class DescribeProcessTransformer
extends TransformerBase {
    protected WPSInfo wps;
    protected static final String WPS_URI = "http://www.opengis.net/wps";
    protected static final String XSI_URI = "http://www.w3.org/2001/XMLSchema-instance";

    public DescribeProcessTransformer(WPSInfo wps) {
        this.wps = wps;
    }

    public static class WPS1_0
    extends DescribeProcessTransformer {
        public WPS1_0(WPSInfo wps) {
            super(wps);
        }

        public Translator createTranslator(ContentHandler handler) {
            return new DescribeProcessTranslator1_0(handler);
        }

        public class DescribeProcessTranslator1_0
        extends TransformerBase.TranslatorSupport {
            public DescribeProcessType request;
            private Locale locale;
            private DataTransformer dataTransformer;

            public DescribeProcessTranslator1_0(ContentHandler handler) {
                super(handler, null, null);
            }

            public void encode(Object object) throws IllegalArgumentException {
                this.request = (DescribeProcessType)object;
                this.locale = null == this.request.getLanguage() ? new Locale("en-CA") : new Locale(this.request.getLanguage());
                this.dataTransformer = new DataTransformer(this.request.getBaseUrl());
                AttributesImpl attrs = new AttributesImpl();
                attrs.addAttribute("", "xmlns:xsi", "xmlns:xsi", "", DescribeProcessTransformer.XSI_URI);
                attrs.addAttribute("", "xmlns", "xmlns", "", DescribeProcessTransformer.WPS_URI);
                attrs.addAttribute("", "xmlns:wps", "xmlns:wps", "", DescribeProcessTransformer.WPS_URI);
                attrs.addAttribute("", "xmlns:ows", "xmlns:ows", "", "http://www.opengis.net/ows");
                attrs.addAttribute("", "version", "version", "", "1.0.0");
                attrs.addAttribute("", "xsi:schemaLocation", "xsi:schemaLocation", "", "http://www.opengis.net/wps/1.0.0 ../wpsDescribeProcess_request.xsd");
                this.start("wps:ProcessDescriptions", attrs);
                if (null == this.request.getIdentifier() || this.request.getIdentifier().isEmpty()) {
                    throw new WPSException("Invalid identifier", "No identifier present");
                }
                for (Object identifier : this.request.getIdentifier()) {
                    CodeType ct = (CodeType)identifier;
                    this.processDescription(Ows11Util.name((CodeType)ct));
                }
                this.end("wps:ProcessDescriptions");
            }

            private void processDescription(Name identifier) {
                if ("all".equalsIgnoreCase(identifier.getLocalPart()) && identifier.getNamespaceURI() == null) {
                    this.processDescriptionAll();
                    return;
                }
                ProcessFactory pf = GeoServerProcessors.createProcessFactory(identifier, false);
                if (null == pf) {
                    throw new WPSException("Invalid identifier", "InvalidParameterValue");
                }
                if (!this.dataTransformer.isTransmutable(pf, identifier)) {
                    throw new WPSException("Invalid identifier", "InvalidParameterValue");
                }
                this.processDescription(pf, identifier);
            }

            private void processDescription(ProcessFactory pf, Name identifier) {
                AttributesImpl attributes = new AttributesImpl();
                attributes.addAttribute("", "wps:processVersion", "wps:processVersion", "", pf.getVersion(identifier));
                attributes.addAttribute("", "statusSupported", "statusSupported", "", Boolean.toString(pf.supportsProgress(identifier)));
                this.start("ProcessDescription", attributes);
                this.element("ows:Identifier", identifier.getURI());
                this.element("ows:Title", pf.getTitle(identifier).toString(this.locale));
                this.element("ows:Abstract", pf.getDescription(identifier).toString(this.locale));
                this.dataInputs(pf, identifier);
                this.processOutputs(pf, identifier);
                this.end("ProcessDescription");
            }

            private void processDescriptionAll() {
                for (ProcessFactory pf : GeoServerProcessors.getProcessFactories()) {
                    for (Name processName : pf.getNames()) {
                        if (!this.dataTransformer.isTransmutable(pf, processName)) continue;
                        this.processDescription(pf, processName);
                    }
                }
            }

            private void dataInputs(ProcessFactory pf, Name processName) {
                this.start("DataInputs");
                for (Parameter inputIdentifier : pf.getParameterInfo(processName).values()) {
                    AttributesImpl attributes = new AttributesImpl();
                    int maxOccurs = inputIdentifier.maxOccurs;
                    if (-1 == maxOccurs) {
                        maxOccurs = Integer.MAX_VALUE;
                    }
                    attributes.addAttribute("", "minOccurs", "minOccurs", "", "" + inputIdentifier.minOccurs);
                    attributes.addAttribute("", "maxOccurs", "maxOccurs", "", "" + maxOccurs);
                    this.start("Input", attributes);
                    this.element("ows:Identifier", inputIdentifier.key);
                    this.element("ows:Title", inputIdentifier.title.toString(this.locale));
                    this.element("ows:Abstract", inputIdentifier.description.toString(this.locale));
                    Transmuter transmuter = this.dataTransformer.getDefaultTransmuter(inputIdentifier.type);
                    if (transmuter instanceof ComplexTransmuter) {
                        this.start("ComplexData");
                        this.complexParameter((ComplexTransmuter)transmuter);
                        this.end("ComplexData");
                    } else {
                        this.literalData((LiteralTransmuter)transmuter);
                    }
                    this.end("Input");
                }
                this.end("DataInputs");
            }

            private void processOutputs(ProcessFactory pf, Name processName) {
                this.start("ProcessOutputs");
                for (Parameter outputIdentifier : pf.getResultInfo(processName, null).values()) {
                    this.start("Output");
                    this.element("ows:Identifier", outputIdentifier.key);
                    this.element("ows:Title", outputIdentifier.title.toString(this.locale));
                    this.element("ows:Abstract", outputIdentifier.description.toString(this.locale));
                    Transmuter transmuter = this.dataTransformer.getDefaultTransmuter(outputIdentifier.type);
                    if (transmuter instanceof ComplexTransmuter) {
                        this.start("ComplexOutput");
                        this.complexParameter((ComplexTransmuter)transmuter);
                        this.end("ComplexOutput");
                    } else {
                        this.literalData((LiteralTransmuter)transmuter);
                    }
                    this.end("Output");
                }
                this.end("ProcessOutputs");
            }

            private void literalData(LiteralTransmuter transmuter) {
                AttributesImpl attributes = new AttributesImpl();
                attributes.addAttribute("", "ows:reference", "ows:reference", "", transmuter.getEncodedType());
                this.start("LiteralData");
                this.start("ows:DataType", attributes);
                this.end("ows:DataType");
                this.end("LiteralData");
            }

            private void complexParameter(ComplexTransmuter transmuter) {
                this.start("Default");
                this.format(transmuter);
                this.end("Default");
                this.start("Supported");
                this.format(transmuter);
                this.end("Supported");
            }

            private void format(ComplexTransmuter transmuter) {
                this.start("Format");
                this.element("MimeType", transmuter.getMimeType());
                this.element("Schema", transmuter.getSchema(this.request.getBaseUrl()));
                this.end("Format");
            }
        }
    }
}

