/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wps;

import net.opengis.wps10.ExecuteResponseType;
import org.geoserver.wps.DismissType;
import org.geoserver.wps.StatusResponseBuilder;
import org.geoserver.wps.UnknownExecutionIdException;
import org.geoserver.wps.WPSException;
import org.geoserver.wps.executor.ExecutionStatus;
import org.geoserver.wps.executor.ProcessState;
import org.geoserver.wps.executor.ProcessStatusTracker;
import org.geoserver.wps.executor.WPSExecutionManager;
import org.geoserver.wps.resource.WPSResourceManager;
import org.springframework.context.ApplicationContext;

public class Dismiss {
    private ProcessStatusTracker statusTracker;
    private WPSResourceManager resources;
    private ApplicationContext ctx;
    private WPSExecutionManager executionManager;

    public Dismiss(WPSExecutionManager executionManager, ProcessStatusTracker statusTracker, WPSResourceManager resources, ApplicationContext ctx) {
        this.executionManager = executionManager;
        this.statusTracker = statusTracker;
        this.resources = resources;
        this.ctx = ctx;
    }

    public ExecuteResponseType run(DismissType request) {
        String executionId = request.getExecutionId();
        ExecutionStatus status = this.statusTracker.getStatus(executionId);
        if (status == null) {
            throw new UnknownExecutionIdException(executionId);
        }
        if (status.getPhase() == ProcessState.DISMISSING) {
            throw new UnknownExecutionIdException(executionId);
        }
        this.executionManager.cancel(executionId);
        ExecutionStatus cancelledStatus = new ExecutionStatus(status);
        cancelledStatus.setPhase(ProcessState.FAILED);
        cancelledStatus.setException((Throwable)((Object)new WPSException("The process execution has been dismissed")));
        return new StatusResponseBuilder(this.resources, this.ctx).buildStatusResponse(cancelledStatus);
    }
}

