/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wps;

import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import net.opengis.ows11.KeywordsType;
import net.opengis.ows11.OperationType;
import net.opengis.ows11.OperationsMetadataType;
import net.opengis.ows11.Ows11Factory;
import net.opengis.ows11.ResponsiblePartySubsetType;
import net.opengis.ows11.ServiceIdentificationType;
import net.opengis.ows11.ServiceProviderType;
import net.opengis.wps10.DefaultType2;
import net.opengis.wps10.GetCapabilitiesType;
import net.opengis.wps10.LanguagesType;
import net.opengis.wps10.LanguagesType1;
import net.opengis.wps10.ProcessBriefType;
import net.opengis.wps10.ProcessOfferingsType;
import net.opengis.wps10.WPSCapabilitiesType;
import net.opengis.wps10.Wps10Factory;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.geoserver.config.SettingsInfo;
import org.geoserver.ows.Ows11Util;
import org.geoserver.platform.ServiceException;
import org.geoserver.wps.WPSException;
import org.geoserver.wps.WPSInfo;
import org.geoserver.wps.process.GeoServerProcessors;
import org.geotools.api.feature.type.Name;
import org.geotools.api.util.InternationalString;
import org.geotools.process.ProcessFactory;
import org.geotools.util.logging.Logging;
import org.springframework.context.ApplicationContext;

public class GetCapabilities {
    public WPSInfo wps;
    ApplicationContext context;
    static final Logger LOGGER = Logging.getLogger(GetCapabilities.class);

    public GetCapabilities(WPSInfo wps, ApplicationContext context) {
        this.wps = wps;
        this.context = context;
    }

    public WPSCapabilitiesType run(GetCapabilitiesType request) throws WPSException {
        Wps10Factory wpsf = Wps10Factory.eINSTANCE;
        Ows11Factory owsf = Ows11Factory.eINSTANCE;
        WPSCapabilitiesType caps = wpsf.createWPSCapabilitiesType();
        caps.setVersion("1.0.0");
        caps.setLang("en");
        ServiceIdentificationType si = owsf.createServiceIdentificationType();
        caps.setServiceIdentification(si);
        if (this.wps == null) {
            throw new ServiceException("WPS config not loaded. Check logs for details.");
        }
        si.getTitle().add((Object)Ows11Util.languageString((String)this.wps.getTitle()));
        si.getAbstract().add((Object)Ows11Util.languageString((String)this.wps.getAbstract()));
        KeywordsType kw = Ows11Util.keywords((List)this.wps.keywordValues());
        if (kw != null) {
            si.getKeywords().add((Object)kw);
        }
        si.setServiceType(Ows11Util.code((String)"WPS"));
        si.setServiceTypeVersion("1.0.0");
        si.setFees(this.wps.getFees());
        if (this.wps.getAccessConstraints() != null) {
            si.setAccessConstraints(this.wps.getAccessConstraints());
        }
        ServiceProviderType sp = owsf.createServiceProviderType();
        caps.setServiceProvider(sp);
        SettingsInfo settings = this.wps.getGeoServer().getSettings();
        if (settings.getContact().getContactOrganization() != null) {
            sp.setProviderName(settings.getContact().getContactOrganization());
        } else {
            sp.setProviderName("GeoServer");
        }
        sp.setProviderSite(owsf.createOnlineResourceType());
        sp.getProviderSite().setHref(settings.getContact().getOnlineResource());
        sp.setServiceContact(this.responsibleParty(settings, owsf));
        OperationsMetadataType om = owsf.createOperationsMetadataType();
        caps.setOperationsMetadata(om);
        OperationType gco = owsf.createOperationType();
        gco.setName("GetCapabilities");
        gco.getDCP().add((Object)Ows11Util.dcp((String)"wps", (EObject)request));
        om.getOperation().add((Object)gco);
        OperationType dpo = owsf.createOperationType();
        dpo.setName("DescribeProcess");
        dpo.getDCP().add((Object)Ows11Util.dcp((String)"wps", (EObject)request));
        om.getOperation().add((Object)dpo);
        OperationType eo = owsf.createOperationType();
        eo.setName("Execute");
        eo.getDCP().add((Object)Ows11Util.dcp((String)"wps", (EObject)request));
        om.getOperation().add((Object)eo);
        ProcessOfferingsType po = wpsf.createProcessOfferingsType();
        caps.setProcessOfferings(po);
        Set<ProcessFactory> pfs = GeoServerProcessors.getProcessFactories();
        for (ProcessFactory pf : pfs) {
            for (Name name : pf.getNames()) {
                ProcessBriefType p = wpsf.createProcessBriefType();
                p.setProcessVersion(pf.getVersion(name));
                po.getProcess().add((Object)p);
                p.setIdentifier(Ows11Util.code((Name)name));
                p.setTitle(Ows11Util.languageString((InternationalString)pf.getTitle(name)));
                p.setAbstract(Ows11Util.languageString((InternationalString)pf.getDescription(name)));
            }
        }
        ECollections.sort((EList)po.getProcess(), (o1, o2) -> {
            ProcessBriefType pb1 = (ProcessBriefType)o1;
            ProcessBriefType pb2 = (ProcessBriefType)o2;
            String id1 = pb1.getIdentifier().getValue();
            String id2 = pb2.getIdentifier().getValue();
            return id1.compareTo(id2);
        });
        LanguagesType1 languages = wpsf.createLanguagesType1();
        caps.setLanguages(languages);
        DefaultType2 defaultLanguage = wpsf.createDefaultType2();
        languages.setDefault(defaultLanguage);
        defaultLanguage.setLanguage("en-US");
        LanguagesType supportedLanguages = wpsf.createLanguagesType();
        languages.setSupported(supportedLanguages);
        supportedLanguages.getLanguage().add((Object)"en-US");
        return caps;
    }

    ResponsiblePartySubsetType responsibleParty(SettingsInfo settings, Ows11Factory f) {
        ResponsiblePartySubsetType rp = f.createResponsiblePartySubsetType();
        return rp;
    }
}

